/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.auximage;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointErrors;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.Timer;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImage;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageCodeObserver;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageProvider;
import com.oracle.svm.enterprise.core.auximage.d;
import com.oracle.svm.enterprise.core.auximage.f;
import com.oracle.svm.enterprise.core.auximage.j;
import com.oracle.svm.enterprise.core.auximage.v;
import com.oracle.svm.enterprise.core.auximage.w;
import java.io.File;
import java.util.concurrent.ThreadLocalRandom;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class AuxiliaryImageLoader {
    private static final CGlobalData<WordPointer> bq = CGlobalDataFactory.createWord((WordBase)AuxiliaryImageLoader.x());
    private static Pointer br;
    private static UnsignedWord bs;
    private static Pointer bt;
    private static Pointer bu;
    private static volatile f bv;

    private static WordBase x() {
        long l2;
        while ((l2 = ThreadLocalRandom.current().nextLong()) == 0L) {
        }
        return Word.signed((long)l2);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static ComparableWord getPrimaryImageId() {
        return (ComparableWord)((WordPointer)bq.get()).read();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setAuxImageReservedSpace(Pointer pointer, UnsignedWord unsignedWord) {
        VMError.guarantee((br.isNull() && bs.equal((UnsignedWord)Word.zero()) ? 1 : 0) != 0);
        br = pointer;
        bs = unsignedWord;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setAuxImageLocation(Pointer pointer, Pointer pointer2, UnsignedWord unsignedWord) {
        VMError.guarantee((pointer.isNull() == pointer2.isNull() && bt.isNull() == bu.isNull() ? 1 : 0) != 0, (String)"sanity");
        VMError.guarantee((bt.isNull() || pointer.isNull() ? 1 : 0) != 0, (String)"Cannot replace a loaded image in-place");
        bt = pointer;
        bu = pointer2;
        AuxiliaryImageLoader.a(unsignedWord);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void a(UnsignedWord unsignedWord) {
        Object object;
        f f2 = null;
        ImageHeapInfo imageHeapInfo = null;
        if (bt.isNonNull()) {
            object = KnownIntrinsics.heapBase().add(unsignedWord);
            f2 = (f)object.toObject();
            imageHeapInfo = f2.bA;
        }
        bv = f2;
        object = d.singleton();
        object.bj = imageHeapInfo;
        object.bk = true;
    }

    public static AuxiliaryImage load(File file) {
        b b2 = new b(file.getPath());
        b2.enqueue();
        if (b2.by != null) {
            throw b2.by;
        }
        AuxiliaryImageLoader.B();
        return AuxiliaryImageLoader.getLoaded();
    }

    public static AuxiliaryImage getLoaded() {
        f f2 = bv;
        if (f2 == null) {
            throw new IllegalStateException("No auxiliary image has been loaded.");
        }
        return f2.bz;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static f y() {
        return bv;
    }

    public static boolean hasLoaded() {
        return bv != null;
    }

    static void z() {
        AuxiliaryImageLoader.A();
        AuxiliaryImageLoader.B();
    }

    private static void A() {
        f f2 = bv;
        if (f2 != null) {
            if (v.isSupportedInCurrentImage()) {
                if (f2.bB.length > 0) {
                    a a2 = new a(f2);
                    a2.enqueue();
                }
            } else assert (f2.bB.length == 0) : "No runtime compilation, where does the compiled code come from?";
        }
    }

    private static void B() {
        assert (!VMOperation.isInProgressAtSafepoint());
        f f2 = bv;
        if (f2 != null && v.isSupportedInCurrentImage() && f2.bB.length > 0) {
            for (AuxiliaryImageCodeObserver auxiliaryImageCodeObserver : f2.bD) {
                auxiliaryImageCodeObserver.afterAllAuxiliaryImageCodeInstalled();
            }
        }
    }

    private AuxiliaryImageLoader() {
    }

    private static final class b
    extends JavaVMOperation {
        private final String bx;
        private RuntimeException by;

        b(String string) {
            super(VMOperationInfos.get(b.class, (String)"Load auxiliary image", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT));
            this.bx = string;
        }

        protected void operate() {
            try {
                this.C();
            }
            catch (RuntimeException runtimeException) {
                this.by = runtimeException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void C() {
            if (bv != null) {
                throw new IllegalStateException("An auxiliary image is already loaded.");
            }
            if (br.isNull() || bs.belowOrEqual(0)) {
                throw new IllegalStateException("No space was reserved for loading an auxiliary image during isolate creation");
            }
            try (Timer timer = j.ce.ch.start();){
                WordPointer wordPointer = (WordPointer)UnsafeStackValue.get(WordPointer.class);
                WordPointer wordPointer2 = (WordPointer)UnsafeStackValue.get(WordPointer.class);
                try (CTypeConversion.CCharPointerHolder cCharPointerHolder = CTypeConversion.toCString((CharSequence)this.bx);){
                    try (Object object = j.ce.cf.start();){
                        int n2 = AuxiliaryImageProvider.get().loadAuxiliaryImage(br, bs, cCharPointerHolder.get(), wordPointer, wordPointer2);
                        if (n2 != 0) {
                            throw new RuntimeException("Auxiliary image could not be loaded: " + CEntryPointErrors.getDescription((int)n2));
                        }
                    }
                    object = j.ce.cg.start();
                    try {
                        AuxiliaryImageLoader.A();
                    }
                    finally {
                        if (object != null) {
                            object.close();
                        }
                    }
                    object = d.singleton();
                    VMError.guarantee((bt.isNonNull() && bu.isNonNull() && bv != null && object.bj != null && object.bk ? 1 : 0) != 0);
                }
            }
            finally {
                j.K();
            }
        }
    }

    private static class a
    extends JavaVMOperation {
        private final f bw;

        a(f f2) {
            super(VMOperationInfos.get(a.class, (String)"Install auxiliary image persisted code", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT));
            this.bw = f2;
        }

        protected void operate() {
            try {
                w.a(this.bw);
            }
            catch (Throwable throwable) {
                throw VMError.shouldNotReachHere((String)"Persisted code cache installation failed.", (Throwable)throwable);
            }
        }
    }
}

