/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.auximage;

import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageObjectReplacer;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImagePersistenceCancelledException;
import com.oracle.svm.enterprise.core.auximage.g;
import com.oracle.svm.enterprise.core.auximage.h;
import com.oracle.svm.enterprise.core.auximage.m;
import com.oracle.svm.enterprise.core.auximage.o;
import com.oracle.svm.enterprise.core.auximage.p;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.c.type.WordPointer;

public final class AuxiliaryImageBuilder {
    private final Map<Class<?>, Object> aN = new ConcurrentHashMap();
    private final List<AuxiliaryImageObjectReplacer> aO = new ArrayList<AuxiliaryImageObjectReplacer>();
    private h aP = new p();
    private long aQ = -1L;

    public <T> void add(Class<T> clazz, T t2) {
        AuxiliaryImageBuilder.a(clazz);
        AuxiliaryImageBuilder.a(clazz, t2);
        Object object = this.aN.putIfAbsent(clazz, t2);
        if (object != null) {
            throw new IllegalArgumentException("Must not overwrite existing key: " + clazz.getTypeName() + System.lineSeparator() + "Existing value: " + String.valueOf(object) + System.lineSeparator() + "New value: " + String.valueOf(t2));
        }
    }

    public <T> T lookup(Class<T> clazz) {
        AuxiliaryImageBuilder.a(clazz);
        Object object = this.aN.get(clazz);
        if (object == null) {
            throw new RuntimeException("Does not contain key: " + clazz.getTypeName());
        }
        return clazz.cast(object);
    }

    public boolean contains(Class<?> clazz) {
        AuxiliaryImageBuilder.a(clazz);
        return this.aN.containsKey(clazz);
    }

    public void registerObjectReplacer(AuxiliaryImageObjectReplacer auxiliaryImageObjectReplacer) {
        Objects.requireNonNull(auxiliaryImageObjectReplacer, "replacer");
        this.aO.add(auxiliaryImageObjectReplacer);
    }

    public void enableControlMemoryWord(WordPointer wordPointer) {
        if (wordPointer.isNull()) {
            throw new IllegalArgumentException("Control word address must not be null.");
        }
        this.aP = new o(wordPointer);
    }

    public void setMaximumAllowedAuxiliaryImageSize(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Maximum allowed auxiliary image size must be positive.");
        }
        this.aQ = l2;
    }

    public ByteBuffer persist() throws AuxiliaryImagePersistenceCancelledException {
        m m2 = new m(new IdentityHashMap(this.aN));
        return g.a(m2, this.aO, this.aP, this.aQ);
    }

    private static <T> void a(Class<T> clazz) {
        Objects.requireNonNull(clazz, "key");
    }

    private static <T> void a(Class<T> clazz, T t2) {
        if (t2 == null) {
            throw new NullPointerException("'null' value not allowed for key: " + clazz.getTypeName());
        }
        if (g.isInPrimaryImageHeap(t2)) {
            throw new RuntimeException("Image heap object not allowed: key: " + clazz.getTypeName() + "\nValue: " + String.valueOf(t2));
        }
    }
}

