/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core;

import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.enterprise.core.aq;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class au
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(aq.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String string) {
        switch (this.getContainer().unprefixed(string)) {
            case "AOTPriorityInline": {
                return OptionDescriptor.create((String)"AOTPriorityInline", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable use of priority inlining during AOT compilation.", (Object)this.getContainer(), aq.AOTPriorityInline, (String)"AOTPriorityInline", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AuxiliaryImageBytes": {
                return OptionDescriptor.create((String)"AuxiliaryImageBytes", (OptionType)OptionType.Expert, Long.class, (String)"Size in bytes of the auxiliary image.", (Object)this.getContainer(), aq.AuxiliaryImageBytes, (String)"AuxiliaryImageBytes", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AuxiliaryImagePath": {
                return OptionDescriptor.create((String)"AuxiliaryImagePath", (OptionType)OptionType.Expert, String.class, (String)"Path to the auxiliary image.", (Object)this.getContainer(), aq.AuxiliaryImagePath, (String)"AuxiliaryImagePath", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CopyPrimitiveElementArrays": {
                return OptionDescriptor.create((String)"CopyPrimitiveElementArrays", (OptionType)OptionType.Expert, Boolean.class, (String)"Return copies of primitive element arrays when referencing them from native code.", (Object)this.getContainer(), aq.CopyPrimitiveElementArrays, (String)"CopyPrimitiveElementArrays", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "GraalOS": {
                return OptionDescriptor.create((String)"GraalOS", (OptionType)OptionType.User, Boolean.class, (String)"Compile the application for GraalOS.", (Object)this.getContainer(), aq.GraalOS, (String)"GraalOS", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxRuntimeCodeOffset": {
                return OptionDescriptor.create((String)"MaxRuntimeCodeOffset", (OptionType)OptionType.Expert, Integer.class, (String)"The maximum number words to randomly offset the entry of runtime installed methods. Use this option for less predictable entry points.", (Object)this.getContainer(), aq.MaxRuntimeCodeOffset, (String)"MaxRuntimeCodeOffset", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ObjectInlining": {
                return OptionDescriptor.create((String)"ObjectInlining", (OptionType)OptionType.Debug, Boolean.class, (String)"Deprectated, has no effect.", (Object)this.getContainer(), aq.ObjectInlining, (String)"ObjectInlining", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"");
            }
            case "ObjectInliningConfigurationFiles": {
                return OptionDescriptor.create((String)"ObjectInliningConfigurationFiles", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Paths.class, (String)"Deprectated, has no effect.", (Object)this.getContainer(), aq.ObjectInliningConfigurationFiles, (String)"ObjectInliningConfigurationFiles", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"");
            }
            case "ObjectInliningConfigurationResources": {
                return OptionDescriptor.create((String)"ObjectInliningConfigurationResources", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Deprectated, has no effect.", (Object)this.getContainer(), aq.ObjectInliningConfigurationResources, (String)"ObjectInliningConfigurationResources", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"");
            }
            case "OptionalIdentityHashCodes": {
                return OptionDescriptor.create((String)"OptionalIdentityHashCodes", (OptionType)OptionType.Expert, Boolean.class, (String)"Allocate memory for identity hash codes only for those objects that need it.", (Object)this.getContainer(), aq.OptionalIdentityHashCodes, (String)"OptionalIdentityHashCodes", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ProtectionKeys": {
                return OptionDescriptor.create((String)"ProtectionKeys", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable support for Memory Protection Keys", (Object)this.getContainer(), aq.ProtectionKeys, (String)"ProtectionKeys", (OptionStability)OptionStability.STABLE, (boolean)false, (String)"");
            }
            case "ReservedAuxiliaryImageBytes": {
                return OptionDescriptor.create((String)"ReservedAuxiliaryImageBytes", (OptionType)OptionType.Debug, Long.class, (String)"Size in bytes of an address space to reserve for auxiliary images.", (Object)this.getContainer(), aq.ReservedAuxiliaryImageBytes, (String)"ReservedAuxiliaryImageBytes", (OptionStability)OptionStability.STABLE, (boolean)false, (String)"");
            }
            case "SafepointCheckInEpilogue": {
                return OptionDescriptor.create((String)"SafepointCheckInEpilogue", (OptionType)OptionType.Debug, Boolean.class, (String)"Check for safepoints in method epilogue", (Object)this.getContainer(), aq.SafepointCheckInEpilogue, (String)"SafepointCheckInEpilogue", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StackOverflowCheckInPrologue": {
                return OptionDescriptor.create((String)"StackOverflowCheckInPrologue", (OptionType)OptionType.Debug, Boolean.class, (String)"Check for stack overflow in method prologue", (Object)this.getContainer(), aq.StackOverflowCheckInPrologue, (String)"StackOverflowCheckInPrologue", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseCompressedReferenceShift": {
                return OptionDescriptor.create((String)"UseCompressedReferenceShift", (OptionType)OptionType.Debug, Boolean.class, (String)"Use bit-shifting to enlarge the address range with narrow references.", (Object)this.getContainer(), aq.UseCompressedReferenceShift, (String)"UseCompressedReferenceShift", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseCompressedReferences": {
                return OptionDescriptor.create((String)"UseCompressedReferences", (OptionType)OptionType.Debug, Boolean.class, (String)"Use compressed references (32-bit instead of 64-bit references to Java objects).", (Object)this.getContainer(), aq.UseCompressedReferences, (String)"UseCompressedReferences", (OptionStability)OptionStability.STABLE, (boolean)false, (String)"");
            }
            case "UseMethodChecks": {
                return OptionDescriptor.create((String)"UseMethodChecks", (OptionType)OptionType.Debug, Boolean.class, (String)"Perform method-based checks during inlining.", (Object)this.getContainer(), aq.UseMethodChecks, (String)"UseMethodChecks", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 17;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return au.this.get("AOTPriorityInline");
                    }
                    case 1: {
                        return au.this.get("AuxiliaryImageBytes");
                    }
                    case 2: {
                        return au.this.get("AuxiliaryImagePath");
                    }
                    case 3: {
                        return au.this.get("CopyPrimitiveElementArrays");
                    }
                    case 4: {
                        return au.this.get("GraalOS");
                    }
                    case 5: {
                        return au.this.get("MaxRuntimeCodeOffset");
                    }
                    case 6: {
                        return au.this.get("ObjectInlining");
                    }
                    case 7: {
                        return au.this.get("ObjectInliningConfigurationFiles");
                    }
                    case 8: {
                        return au.this.get("ObjectInliningConfigurationResources");
                    }
                    case 9: {
                        return au.this.get("OptionalIdentityHashCodes");
                    }
                    case 10: {
                        return au.this.get("ProtectionKeys");
                    }
                    case 11: {
                        return au.this.get("ReservedAuxiliaryImageBytes");
                    }
                    case 12: {
                        return au.this.get("SafepointCheckInEpilogue");
                    }
                    case 13: {
                        return au.this.get("StackOverflowCheckInPrologue");
                    }
                    case 14: {
                        return au.this.get("UseCompressedReferenceShift");
                    }
                    case 15: {
                        return au.this.get("UseCompressedReferences");
                    }
                    case 16: {
                        return au.this.get("UseMethodChecks");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

