/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.amd64;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.graal.meta.SharedConstantReflectionProvider;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.enterprise.core.amd64.e;
import com.oracle.svm.enterprise.core.amd64.i;
import jdk.graal.compiler.core.amd64.AMD64AddressNode;
import jdk.graal.compiler.core.common.type.CompressibleConstant;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;

class AMD64ImageHeapAddressOptimizationPhase
extends BasePhase<CoreProviders> {
    AMD64ImageHeapAddressOptimizationPhase() {
    }

    static boolean m() {
        return (Boolean)a.OptInlineImageHeapConstants.getValue() != false && (Boolean)SubstrateOptions.SpawnIsolates.getValue() != false && !SubstrateOptions.useLLVMBackend();
    }

    static boolean a(CompressibleConstant compressibleConstant, ConstantReflectionProvider constantReflectionProvider) {
        if (!AMD64ImageHeapAddressOptimizationPhase.m()) {
            return false;
        }
        if (SubstrateUtil.HOSTED) {
            return true;
        }
        return ((SharedConstantReflectionProvider)constantReflectionProvider).getImageHeapOffset((JavaConstant)compressibleConstant) != 0;
    }

    protected void run(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        ConstantReflectionProvider constantReflectionProvider = coreProviders.getConstantReflection();
        for (AMD64AddressNode aMD64AddressNode : structuredGraph.getNodes().filter(AMD64AddressNode.class)) {
            ValueNode valueNode = aMD64AddressNode.getBase();
            if (valueNode == null || !valueNode.isJavaConstant() || !(valueNode.asJavaConstant() instanceof SubstrateObjectConstant)) continue;
            SubstrateObjectConstant substrateObjectConstant = (SubstrateObjectConstant)valueNode.asJavaConstant();
            if (i.q() && aMD64AddressNode.getIndex() != null || !AMD64ImageHeapAddressOptimizationPhase.a((CompressibleConstant)substrateObjectConstant, constantReflectionProvider)) continue;
            e e2 = new e(substrateObjectConstant, aMD64AddressNode.getIndex(), aMD64AddressNode.getScale(), aMD64AddressNode.getDisplacement());
            aMD64AddressNode.replaceAndDelete(structuredGraph.unique((Node)e2));
            if (!valueNode.hasNoUsages()) continue;
            valueNode.safeDelete();
        }
    }

    public static class a {
        public static final HostedOptionKey<Boolean> OptInlineImageHeapConstants = new HostedOptionKey((Object)true);
    }
}

