/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.amd64;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.graal.nodes.CInterfaceReadNode;
import com.oracle.svm.core.graal.nodes.ReadReservedRegisterFixedNode;
import com.oracle.svm.core.graal.nodes.ReadReservedRegisterFloatingNode;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.enterprise.core.EnterpriseAddressRangeCommittedMemoryProvider;
import com.oracle.svm.enterprise.core.amd64.h;
import com.oracle.svm.enterprise.core.amd64.i;
import jdk.graal.compiler.core.amd64.AMD64AddressNode;
import jdk.graal.compiler.core.amd64.AMD64CompressAddressLowering;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.PrefetchAllocateNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.ValueAnchorNode;
import jdk.graal.compiler.nodes.memory.FixedAccessNode;
import jdk.graal.compiler.nodes.memory.WriteNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.common.AddressLoweringByNodePhase;
import jdk.graal.compiler.replacements.gc.WriteBarrierSnippets;
import jdk.graal.compiler.replacements.nodes.ZeroMemoryNode;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.Register;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.UnsignedWord;

public class AMD64AddressLoweringAndMaskingByNodePhase
extends AddressLoweringByNodePhase {
    private final AddressLoweringByNodePhase.AddressLowering V;
    private final Register W;

    public AMD64AddressLoweringAndMaskingByNodePhase(AddressLoweringByNodePhase.AddressLowering addressLowering) {
        super(addressLowering);
        this.V = addressLowering;
        this.W = ReservedRegisters.singleton().getHeapBaseRegister();
    }

    protected void run(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        if (!i.q()) {
            super.run(structuredGraph, coreProviders);
            return;
        }
        this.a(structuredGraph);
    }

    private static long k() {
        EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider = (EnterpriseAddressRangeCommittedMemoryProvider)((Object)ImageSingletons.lookup(CommittedMemoryProvider.class));
        UnsignedWord unsignedWord = enterpriseAddressRangeCommittedMemoryProvider.getReservedAddressSpaceSize();
        GraalError.guarantee((boolean)CodeUtil.isPowerOf2((long)unsignedWord.rawValue()), (String)"MemoryMaskingAndFencing only available if the Isolate reserved address space is a power of two.");
        return unsignedWord.rawValue() - 1L;
    }

    private void a(StructuredGraph structuredGraph) {
        long l2 = AMD64AddressLoweringAndMaskingByNodePhase.k();
        for (Node node : structuredGraph.getNodes()) {
            if (!(node instanceof OffsetAddressNode)) continue;
            OffsetAddressNode offsetAddressNode = (OffsetAddressNode)node;
            AddressNode addressNode = this.V.lower(offsetAddressNode.getBase(), offsetAddressNode.getOffset());
            GraalError.guarantee((boolean)(addressNode instanceof AMD64AddressNode), (String)"Node %s lowered to unexpected node: %s", (Object)node, (Object)addressNode);
            AMD64AddressNode aMD64AddressNode = (AMD64AddressNode)addressNode;
            if (!this.b(aMD64AddressNode)) {
                node.replaceAtUsages((Node)aMD64AddressNode);
                GraphUtil.killWithUnusedFloatingInputs((Node)node);
                continue;
            }
            boolean bl2 = this.a(aMD64AddressNode);
            for (Node node2 : node.usages().snapshot()) {
                FixedAccessNode fixedAccessNode;
                block7: {
                    block6: {
                        if (!(node2 instanceof FixedAccessNode)) break block6;
                        fixedAccessNode = (FixedAccessNode)node2;
                        if (AMD64AddressLoweringAndMaskingByNodePhase.b(node2)) break block7;
                    }
                    node2.replaceAllInputs(node, (Node)aMD64AddressNode);
                    continue;
                }
                boolean bl3 = bl2 || AMD64AddressLoweringAndMaskingByNodePhase.a(node2);
                ValueAnchorNode valueAnchorNode = (ValueAnchorNode)structuredGraph.addWithoutUnique((Node)new ValueAnchorNode());
                h h2 = (h)structuredGraph.addWithoutUnique((Node)new h(aMD64AddressNode.getBase(), aMD64AddressNode.getIndex(), (ValueNode)structuredGraph.unique((Node)new AMD64CompressAddressLowering.HeapBaseNode(this.W)), l2, aMD64AddressNode.getDisplacement(), aMD64AddressNode.getScale(), bl3, valueAnchorNode));
                structuredGraph.addBeforeFixed((FixedNode)fixedAccessNode, (FixedWithNextNode)valueAnchorNode);
                node2.replaceAllInputs(node, (Node)h2);
            }
        }
    }

    private boolean a(AMD64AddressNode aMD64AddressNode) {
        return this.a(aMD64AddressNode.getBase()) || this.b(aMD64AddressNode.getBase());
    }

    private static boolean a(Node node) {
        FixedAccessNode fixedAccessNode;
        if (node instanceof CInterfaceReadNode) {
            return true;
        }
        return node instanceof FixedAccessNode && ((fixedAccessNode = (FixedAccessNode)node).getLocationIdentity().equals(NamedLocationIdentity.OFF_HEAP_LOCATION) || fixedAccessNode.getLocationIdentity().equals(WriteBarrierSnippets.GC_CARD_LOCATION));
    }

    private boolean b(AMD64AddressNode aMD64AddressNode) {
        ValueNode valueNode = aMD64AddressNode.getBase();
        if (valueNode instanceof ReadReservedRegisterFloatingNode) {
            ReadReservedRegisterFloatingNode readReservedRegisterFloatingNode = (ReadReservedRegisterFloatingNode)valueNode;
            if (readReservedRegisterFloatingNode.getRegister().equals((Object)this.W)) {
                return true;
            }
            return aMD64AddressNode.getIndex() != null;
        }
        valueNode = aMD64AddressNode.getBase();
        if (valueNode instanceof ReadReservedRegisterFixedNode) {
            ReadReservedRegisterFixedNode readReservedRegisterFixedNode = (ReadReservedRegisterFixedNode)valueNode;
            if (readReservedRegisterFixedNode.getRegister().equals((Object)this.W)) {
                return true;
            }
            return aMD64AddressNode.getIndex() != null;
        }
        return true;
    }

    private static boolean b(Node node) {
        if (node instanceof WriteNode) {
            return false;
        }
        if (node instanceof PrefetchAllocateNode) {
            return false;
        }
        if (node instanceof ZeroMemoryNode) {
            return false;
        }
        return node instanceof FixedNode;
    }

    private boolean a(ValueNode valueNode) {
        ReadReservedRegisterFloatingNode readReservedRegisterFloatingNode;
        return valueNode instanceof ReadReservedRegisterFloatingNode && !(readReservedRegisterFloatingNode = (ReadReservedRegisterFloatingNode)valueNode).getRegister().equals((Object)this.W);
    }

    private boolean b(ValueNode valueNode) {
        ReadReservedRegisterFixedNode readReservedRegisterFixedNode;
        return valueNode instanceof ReadReservedRegisterFixedNode && !(readReservedRegisterFixedNode = (ReadReservedRegisterFixedNode)valueNode).getRegister().equals((Object)this.W);
    }
}

