/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core;

import com.oracle.svm.core.IsolateArgumentAccess;
import com.oracle.svm.core.IsolateArgumentParser;
import com.oracle.svm.core.IsolateArguments;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AddressRangeCommittedMemoryProvider;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.OutOfMemoryUtil;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.aq;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageLoader;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageProvider;
import com.oracle.svm.enterprise.core.g;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class EnterpriseAddressRangeCommittedMemoryProvider
extends AddressRangeCommittedMemoryProvider {
    private static final OutOfMemoryError d = new OutOfMemoryError("Could not allocate an aligned heap chunk because the heap address space is exhausted. Consider re-building the image with compressed references disabled ('-H:-UseCompressedReferences').");
    private static final OutOfMemoryError e = new OutOfMemoryError("Could not allocate an unaligned heap chunk because the heap address space is exhausted. Consider re-building the image with compressed references disabled ('-H:-UseCompressedReferences').");

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public EnterpriseAddressRangeCommittedMemoryProvider() {
    }

    @Uninterruptible(reason="Still being initialized.")
    protected int getCollectedHeapBegin(IsolateArguments isolateArguments, Pointer pointer, UnsignedWord unsignedWord, Pointer pointer2, WordPointer wordPointer) {
        Pointer pointer3 = PointerUtils.roundUp((PointerBase)pointer2, (UnsignedWord)this.getGranularity());
        UnsignedWord unsignedWord2 = unsignedWord.subtract((UnsignedWord)pointer3.subtract((UnsignedWord)pointer));
        UnsignedWord unsignedWord3 = Word.unsigned((long)IsolateArgumentAccess.readLong((IsolateArguments)isolateArguments, (int)IsolateArgumentParser.getOptionIndex(aq.AuxiliaryImageBytes)));
        if (unsignedWord3.equal((UnsignedWord)Word.zero())) {
            unsignedWord3 = aq.getReservedAuxiliaryImageBytes();
        }
        if (unsignedWord3.aboveThan(0)) {
            if (unsignedWord3.aboveThan(unsignedWord2)) {
                return 17;
            }
            unsignedWord2 = unsignedWord3;
        }
        Pointer pointer4 = pointer2;
        CCharPointer cCharPointer = IsolateArgumentAccess.readCCharPointer((IsolateArguments)isolateArguments, (int)IsolateArgumentParser.getOptionIndex(aq.AuxiliaryImagePath));
        if (cCharPointer.isNonNull()) {
            WordPointer wordPointer2 = (WordPointer)StackValue.get(WordPointer.class);
            WordPointer wordPointer3 = (WordPointer)StackValue.get(WordPointer.class);
            int n2 = AuxiliaryImageProvider.get().loadAuxiliaryImage(pointer3, unsignedWord2, cCharPointer, wordPointer2, wordPointer3);
            if (n2 != 0) {
                return n2;
            }
            pointer4 = (Pointer)wordPointer3.read();
        }
        if (unsignedWord3.aboveThan(0)) {
            AuxiliaryImageLoader.setAuxImageReservedSpace(pointer3, unsignedWord3);
            pointer4 = pointer3.add(unsignedWord3);
        }
        pointer4 = PointerUtils.roundUp((PointerBase)pointer4, (UnsignedWord)this.getGranularity());
        wordPointer.write((WordBase)pointer4);
        return 0;
    }

    @Uninterruptible(reason="Still being initialized.")
    protected Pointer reserveHeapMemory0(UnsignedWord unsignedWord, UnsignedWord unsignedWord2, IsolateArguments isolateArguments) {
        if (ImageSingletons.contains(g.class)) {
            return g.singleton().a(unsignedWord, unsignedWord2);
        }
        return super.reserveHeapMemory0(unsignedWord, unsignedWord2, isolateArguments);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected UnsignedWord sizeOfFreeListNode() {
        return SizeOf.unsigned(EnterpriseFreeListNode.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean areUnalignedChunksZeroed() {
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected OutOfMemoryError reportAlignedChunkAllocationFailed(int n2) {
        if (aq.useCompressedReferences() && n2 == 1) {
            throw OutOfMemoryUtil.reportOutOfMemoryError((OutOfMemoryError)d);
        }
        throw super.reportAlignedChunkAllocationFailed(n2);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected OutOfMemoryError reportUnalignedChunkAllocationFailed(int n2) {
        if (aq.useCompressedReferences() && n2 == 1) {
            throw OutOfMemoryUtil.reportOutOfMemoryError((OutOfMemoryError)e);
        }
        throw super.reportUnalignedChunkAllocationFailed(n2);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void uncommit(AddressRangeCommittedMemoryProvider.FreeListNode freeListNode, Pointer pointer, UnsignedWord unsignedWord) {
        this.a(EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode), pointer, pointer.add(unsignedWord));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected AddressRangeCommittedMemoryProvider.FreeListNode createNodeWhenSplitting(AddressRangeCommittedMemoryProvider.FreeListNode freeListNode, Pointer pointer, UnsignedWord unsignedWord) {
        AddressRangeCommittedMemoryProvider.FreeListNode freeListNode2 = super.createNodeWhenSplitting(freeListNode, pointer, unsignedWord);
        this.a(EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode2), EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode).getCommittedStart(), EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode).getCommittedEnd());
        return freeListNode2;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void mergeNodes(AddressRangeCommittedMemoryProvider.FreeListNode freeListNode, AddressRangeCommittedMemoryProvider.FreeListNode freeListNode2) {
        super.mergeNodes(freeListNode, freeListNode2);
        this.a(EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode), EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode2).getCommittedStart(), EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode2).getCommittedEnd());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void trimBounds(AddressRangeCommittedMemoryProvider.FreeListNode freeListNode, Pointer pointer, UnsignedWord unsignedWord) {
        super.trimBounds(freeListNode, pointer, unsignedWord);
        this.a(EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void a(EnterpriseFreeListNode enterpriseFreeListNode, Pointer pointer, Pointer pointer2) {
        assert (enterpriseFreeListNode.getCommittedStart().isNull() == enterpriseFreeListNode.getCommittedEnd().isNull());
        assert (pointer.isNull() == pointer2.isNull());
        if (pointer.isNull()) {
            return;
        }
        assert (pointer.aboveOrEqual((UnsignedWord)this.collectedHeapBegin));
        assert (pointer.belowThan((UnsignedWord)pointer2));
        assert (PointerUtils.isAMultiple((PointerBase)pointer, (UnsignedWord)this.getGranularity()));
        assert (PointerUtils.isAMultiple((PointerBase)pointer2, (UnsignedWord)this.getGranularity()));
        assert (pointer2.subtract((UnsignedWord)pointer).belowOrEqual(this.collectedHeapSize));
        Pointer pointer3 = EnterpriseAddressRangeCommittedMemoryProvider.getNodeEnd((AddressRangeCommittedMemoryProvider.FreeListNode)enterpriseFreeListNode);
        if (pointer.aboveOrEqual((UnsignedWord)pointer3) || pointer2.belowOrEqual((UnsignedWord)enterpriseFreeListNode.getStart())) {
            return;
        }
        Pointer pointer4 = (Pointer)PointerUtils.max((PointerBase)pointer, (PointerBase)enterpriseFreeListNode.getStart());
        Pointer pointer5 = (Pointer)PointerUtils.min((PointerBase)pointer2, (PointerBase)pointer3);
        if (enterpriseFreeListNode.getCommittedStart().isNull() || pointer4.belowThan((UnsignedWord)enterpriseFreeListNode.getCommittedStart())) {
            enterpriseFreeListNode.setCommittedStart(pointer4);
        }
        if (enterpriseFreeListNode.getCommittedEnd().isNull() || pointer5.aboveThan((UnsignedWord)enterpriseFreeListNode.getCommittedEnd())) {
            enterpriseFreeListNode.setCommittedEnd(pointer5);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void a(EnterpriseFreeListNode enterpriseFreeListNode) {
        Pointer pointer = enterpriseFreeListNode.getCommittedStart();
        Pointer pointer2 = enterpriseFreeListNode.getCommittedEnd();
        if (pointer.isNonNull()) {
            enterpriseFreeListNode.setCommittedStart((Pointer)Word.nullPointer());
            enterpriseFreeListNode.setCommittedEnd((Pointer)Word.nullPointer());
            this.a(enterpriseFreeListNode, pointer, pointer2);
        }
    }

    protected void uncommitUnusedMemory0() {
        AddressRangeCommittedMemoryProvider.FreeListNode freeListNode = this.unusedListHead;
        while (freeListNode.isNonNull()) {
            EnterpriseFreeListNode enterpriseFreeListNode = EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode);
            Pointer pointer = enterpriseFreeListNode.getCommittedStart();
            if (pointer.isNonNull()) {
                assert (pointer.aboveOrEqual((UnsignedWord)enterpriseFreeListNode.getStart()) && enterpriseFreeListNode.getCommittedEnd().belowOrEqual((UnsignedWord)EnterpriseAddressRangeCommittedMemoryProvider.getNodeEnd((AddressRangeCommittedMemoryProvider.FreeListNode)enterpriseFreeListNode)));
                Pointer pointer2 = enterpriseFreeListNode.getCommittedEnd().subtract((UnsignedWord)pointer);
                if (VirtualMemoryProvider.get().uncommit((PointerBase)pointer, (UnsignedWord)pointer2) != 0) {
                    Log.log().string("Uncommitting ").unsigned((WordBase)pointer2).string(" bytes of unused memory at ").hex((WordBase)pointer).string(" failed. nodeStart=").zhex((WordBase)enterpriseFreeListNode.getStart()).string(", nodeEnd=").zhex((WordBase)EnterpriseAddressRangeCommittedMemoryProvider.getNodeEnd((AddressRangeCommittedMemoryProvider.FreeListNode)enterpriseFreeListNode)).newline();
                    throw VMError.shouldNotReachHere((String)"Uncommitting memory failed.");
                }
                enterpriseFreeListNode.setCommittedStart((Pointer)Word.nullPointer());
                enterpriseFreeListNode.setCommittedEnd((Pointer)Word.nullPointer());
            }
            freeListNode = freeListNode.getUnusedNext();
        }
        if (((Boolean)SubstrateGCOptions.VerifyHeap.getValue()).booleanValue()) {
            this.verifyFreeList();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static EnterpriseFreeListNode a(AddressRangeCommittedMemoryProvider.FreeListNode freeListNode) {
        return (EnterpriseFreeListNode)freeListNode;
    }

    @RawStructure
    protected static interface EnterpriseFreeListNode
    extends AddressRangeCommittedMemoryProvider.FreeListNode {
        @RawField
        public Pointer getCommittedStart();

        @RawField
        public void setCommittedStart(Pointer var1);

        @RawField
        public Pointer getCommittedEnd();

        @RawField
        public void setCommittedEnd(Pointer var1);
    }

    public static final class a {
        public static void b(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider, Pointer pointer, UnsignedWord unsignedWord, Pointer pointer2) {
            enterpriseAddressRangeCommittedMemoryProvider.initializeFields(pointer, unsignedWord, pointer2);
        }

        public static void o(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider) {
            VMError.guarantee((enterpriseAddressRangeCommittedMemoryProvider.unusedListCount == 1L ? 1 : 0) != 0, (String)"more than one unused node");
            VMError.guarantee((enterpriseAddressRangeCommittedMemoryProvider.allocListCount == 1L ? 1 : 0) != 0, (String)"more than one alloc node");
            VMError.guarantee((enterpriseAddressRangeCommittedMemoryProvider.allocListHead == enterpriseAddressRangeCommittedMemoryProvider.unusedListHead ? 1 : 0) != 0, (String)"different nodes");
            VMError.guarantee((boolean)enterpriseAddressRangeCommittedMemoryProvider.unusedListHead.getStart().equal((UnsignedWord)enterpriseAddressRangeCommittedMemoryProvider.collectedHeapBegin), (String)"begin is incorrect");
            VMError.guarantee((boolean)enterpriseAddressRangeCommittedMemoryProvider.unusedListHead.getSize().equal(enterpriseAddressRangeCommittedMemoryProvider.collectedHeapSize), (String)"size is incorrect");
            VMError.guarantee((boolean)EnterpriseAddressRangeCommittedMemoryProvider.a(enterpriseAddressRangeCommittedMemoryProvider.unusedListHead).getCommittedStart().isNull(), (String)"committed start is incorrect");
            VMError.guarantee((boolean)EnterpriseAddressRangeCommittedMemoryProvider.a(enterpriseAddressRangeCommittedMemoryProvider.unusedListHead).getCommittedEnd().isNull(), (String)"committed end is incorrect");
        }

        public static void p(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider) {
            VMError.guarantee((enterpriseAddressRangeCommittedMemoryProvider.unusedListCount == 0L ? 1 : 0) != 0, (String)"there must not be any nodes left");
            VMError.guarantee((enterpriseAddressRangeCommittedMemoryProvider.allocListCount == 0L ? 1 : 0) != 0, (String)"there must not be any nodes left");
            VMError.guarantee((boolean)enterpriseAddressRangeCommittedMemoryProvider.allocListHead.isNull(), (String)"must be null");
            VMError.guarantee((boolean)enterpriseAddressRangeCommittedMemoryProvider.unusedListHead.isNull(), (String)"must be null");
        }

        public static Pointer a(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider, UnsignedWord unsignedWord, UnsignedWord unsignedWord2) {
            WordPointer wordPointer = (WordPointer)UnsafeStackValue.get(WordPointer.class);
            enterpriseAddressRangeCommittedMemoryProvider.allocateInHeapAddressSpace(unsignedWord, unsignedWord2, wordPointer);
            return (Pointer)wordPointer.read();
        }

        public static void b(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider, Pointer pointer, UnsignedWord unsignedWord) {
            enterpriseAddressRangeCommittedMemoryProvider.freeInHeapAddressSpace(pointer, unsignedWord);
        }

        public static void q(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider) {
            enterpriseAddressRangeCommittedMemoryProvider.uncommitUnusedMemory0();
        }
    }
}

