/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shaded.org.capnproto;

import com.oracle.svm.shaded.org.capnproto.BufferedInputStream;
import com.oracle.svm.shaded.org.capnproto.DecodeException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public final class PackedInputStream
implements ReadableByteChannel {
    final BufferedInputStream inner;

    public PackedInputStream(BufferedInputStream input) {
        this.inner = input;
    }

    @Override
    public int read(ByteBuffer outBuf) throws IOException {
        int len = outBuf.remaining();
        if (len == 0) {
            return 0;
        }
        if (len % 8 != 0) {
            throw new DecodeException("PackedInputStream reads must be word-aligned");
        }
        int outPtr = outBuf.position();
        int outEnd = outPtr + len;
        ByteBuffer inBuf = this.inner.getReadBuffer();
        while (true) {
            byte tag = 0;
            if (inBuf.remaining() < 10) {
                if (outBuf.remaining() == 0) {
                    return len;
                }
                if (inBuf.remaining() == 0) {
                    inBuf = this.inner.getReadBuffer();
                    continue;
                }
                tag = inBuf.get();
                for (int i = 0; i < 8; ++i) {
                    if ((tag & 1 << i) != 0) {
                        if (inBuf.remaining() == 0) {
                            inBuf = this.inner.getReadBuffer();
                        }
                        outBuf.put(inBuf.get());
                        continue;
                    }
                    outBuf.put((byte)0);
                }
                if (inBuf.remaining() == 0 && (tag == 0 || tag == -1)) {
                    inBuf = this.inner.getReadBuffer();
                }
            } else {
                tag = inBuf.get();
                for (int n = 0; n < 8; ++n) {
                    boolean isNonzero = (tag & 1 << n) != 0;
                    outBuf.put((byte)(inBuf.get() & (isNonzero ? -1 : 0)));
                    inBuf.position(inBuf.position() + (isNonzero ? 0 : -1));
                }
            }
            if (tag == 0) {
                if (inBuf.remaining() == 0) {
                    throw new DecodeException("Should always have non-empty buffer here.");
                }
                runLength = (0xFF & inBuf.get()) * 8;
                if (runLength > outEnd - outPtr) {
                    throw new DecodeException("Packed input did not end cleanly on a segment boundary");
                }
                for (int i = 0; i < runLength; ++i) {
                    outBuf.put((byte)0);
                }
            } else if (tag == -1) {
                runLength = (0xFF & inBuf.get()) * 8;
                if (inBuf.remaining() >= runLength) {
                    ByteBuffer slice = inBuf.slice();
                    slice.limit(runLength);
                    outBuf.put(slice);
                    inBuf.position(inBuf.position() + runLength);
                } else {
                    outBuf.put(inBuf);
                    ByteBuffer slice = outBuf.slice();
                    slice.limit(runLength -= inBuf.remaining());
                    this.inner.read(slice);
                    outBuf.position(outBuf.position() + runLength);
                    if (outBuf.remaining() == 0) {
                        return len;
                    }
                    inBuf = this.inner.getReadBuffer();
                    continue;
                }
            }
            if (outBuf.remaining() == 0) break;
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this.inner.close();
    }

    @Override
    public boolean isOpen() {
        return this.inner.isOpen();
    }
}

