/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign.phases;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.nodes.ClusterNode;
import com.oracle.svm.core.nodes.foreign.MemoryArenaValidInScopeNode;
import com.oracle.svm.core.nodes.foreign.ScopedMemExceptionHandlerClusterNode;
import com.oracle.svm.core.nodes.foreign.ScopedMethodNode;
import com.oracle.svm.hosted.foreign.ForeignFunctionsFeature;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.CFGLoop;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.NodeStack;
import jdk.graal.compiler.graph.Position;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.GuardPhiNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.SafepointNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.MemoryPhiNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.RecursivePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.graph.ReentrantBlockIterator;
import jdk.graal.compiler.phases.tiers.MidTierContext;
import jdk.internal.foreign.MemorySessionImpl;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.word.LocationIdentity;

public class SubstrateOptimizeSharedArenaAccessPhase
extends BasePhase<MidTierContext>
implements RecursivePhase {
    final CanonicalizerPhase canonicalizer;
    public static final boolean LOG_SHARED_ARENAS = false;
    public static final boolean RUN_SHARED_ARENA_SCHEDULE_VERIFICATION = false;
    public static final boolean ONLY_DUPLICATE_DUMP_METHODS = false;
    public static final boolean DUMP_LARGE_NODE_SETS = false;
    public static final boolean VERIFY_NO_DOMINATED_CALLS = true;
    private static final int MAX_CLUSTER_ITERATIONS = 8;

    public SubstrateOptimizeSharedArenaAccessPhase(CanonicalizerPhase canonicalizer) {
        this.canonicalizer = canonicalizer;
    }

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny((Optional[])new Optional[]{BasePhase.NotApplicable.unlessRunAfter((BasePhase)this, (GraphState.StageFlag)GraphState.StageFlag.SAFEPOINTS_INSERTION, (GraphState)graphState)});
    }

    public boolean shouldApply(StructuredGraph graph) {
        return graph.getNodes().filter(MemoryArenaValidInScopeNode.class).count() > 0 || graph.getNodes().filter(ScopedMethodNode.class).count() > 0;
    }

    private static void visitUntilCluster(NodeBitMap inCluster, Node start) {
        NodeBitMap visited = start.graph().createNodeBitMap();
        SubstrateOptimizeSharedArenaAccessPhase.visitUntilCluster(inCluster, start, visited, "");
    }

    private static void visitUntilCluster(NodeBitMap inCluster, Node start, NodeBitMap visited, String p) {
        PhiNode phi;
        if (visited.isMarkedAndGrow(start)) {
            return;
        }
        if (inCluster.isMarkedAndGrow(start)) {
            return;
        }
        if (start instanceof PhiNode && !inCluster.contains((Node)(phi = (PhiNode)start).merge())) {
            assert (!inCluster.isMarked((Node)phi)) : "Must not mark phi if merge is not part of the cluster " + String.valueOf(phi);
            visited.mark((Node)phi);
            return;
        }
        visited.mark(start);
        boolean inputsInCluster = false;
        Object inputIn = null;
        for (Node input : start.inputs()) {
            SubstrateOptimizeSharedArenaAccessPhase.visitUntilCluster(inCluster, input, visited, null);
            boolean inputInCluster = inCluster.isMarkedAndGrow(input);
            inputsInCluster = inputInCluster || inputsInCluster;
        }
        if (inputsInCluster) {
            inCluster.markAndGrow(start);
        }
    }

    private static void scheduleVerify(StructuredGraph graph) {
    }

    protected void run(StructuredGraph graph, MidTierContext context) {
        SubstrateOptimizeSharedArenaAccessPhase.scheduleVerify(graph);
        this.cleanupClusterNodes(graph, context, SubstrateOptimizeSharedArenaAccessPhase.insertSessionChecks(graph, context));
    }

    private static EconomicSet<DominatedCall> insertSessionChecks(StructuredGraph graph, MidTierContext context) {
        EconomicSet calls;
        ControlFlowGraph cfg = ControlFlowGraph.newBuilder((StructuredGraph)graph).backendBlocks(true).connectBlocks(true).computeFrequency(true).computeLoops(true).computeDominators(true).computePostdominators(true).build();
        EconomicMap<Node, List<ScopedAccess>> sugaredGraph = SubstrateOptimizeSharedArenaAccessPhase.enumerateScopedAccesses(cfg, context, (EconomicSet<DominatedCall>)(calls = EconomicSet.create()));
        if (sugaredGraph != null) {
            ReentrantBlockIterator.apply((ReentrantBlockIterator.BlockIteratorClosure)new MinimalSessionChecks(graph, sugaredGraph, cfg, (EconomicSet<DominatedCall>)calls), (HIRBlock)cfg.getStartBlock());
        }
        return calls;
    }

    private void cleanupClusterNodes(StructuredGraph graph, MidTierContext context, EconomicSet<DominatedCall> calls) {
        for (MemoryArenaValidInScopeNode scopeNode : graph.getNodes().filter(MemoryArenaValidInScopeNode.class).snapshot()) {
            scopeNode.delete(0);
        }
        for (Node n : graph.getNodes()) {
            if (!(n instanceof ClusterNode)) continue;
            ClusterNode clusterNode = (ClusterNode)n;
            clusterNode.delete();
        }
        this.canonicalizer.apply(graph, (Object)context);
        SubstrateOptimizeSharedArenaAccessPhase.scheduleVerify(graph);
        if (calls != null) {
            for (DominatedCall call : calls) {
                if (!call.invoke.isAlive()) continue;
                throw GraalError.shouldNotReachHere((String)("After inserting all session checks call " + String.valueOf(call.invoke) + " was not inlined and could access a session"));
            }
        }
    }

    private static EconomicMap<Node, List<ScopedAccess>> enumerateScopedAccesses(final ControlFlowGraph cfg, MidTierContext context, final EconomicSet<DominatedCall> dominatedCalls) {
        final EconomicMap nodeAccesses = EconomicMap.create();
        ResolvedJavaType memorySessionType = context.getMetaAccess().lookupJavaType(MemorySessionImpl.class);
        assert (memorySessionType != null);
        ControlFlowGraph.RecursiveVisitor<Integer> visitor = new ControlFlowGraph.RecursiveVisitor<Integer>(){
            final Deque<ReachingDefScope> defs = new ArrayDeque<ReachingDefScope>();
            final Deque<ScopedMethodNode> scopes = new ArrayDeque<ScopedMethodNode>();
            final Deque<Runnable> actions = new ArrayDeque<Runnable>();

            public Integer enter(HIRBlock b) {
                int newDominatingValues = 0;
                int newScopesToPop = 0;
                final ArrayDeque<ScopedMethodNode> scopesToRepush = new ArrayDeque<ScopedMethodNode>();
                for (FixedNode f : b.getNodes()) {
                    if (f instanceof MemoryArenaValidInScopeNode) {
                        MemoryArenaValidInScopeNode mas = (MemoryArenaValidInScopeNode)f;
                        this.defs.push(new ReachingDefScope(mas));
                        ++newDominatingValues;
                        continue;
                    }
                    if (f instanceof ScopedMethodNode) {
                        ScopedMethodNode scope = (ScopedMethodNode)f;
                        if (scope.getType() == ScopedMethodNode.Type.START) {
                            this.scopes.push(scope);
                            ++newScopesToPop;
                            continue;
                        }
                        if (scope.getType() == ScopedMethodNode.Type.END) {
                            ScopedMethodNode start = this.scopes.pop();
                            scopesToRepush.push(start);
                            assert (scope.getStart() == start) : Assertions.errorMessage((Object[])new Object[]{"Must match", start, scope, scope.getStart()});
                            continue;
                        }
                        throw GraalError.shouldNotReachHere((String)("Unknown type " + String.valueOf(scope.getType())));
                    }
                    this.processNode(f);
                }
                final int finalNewDominatingValues = newDominatingValues;
                final int finalNewScopesToPop = newScopesToPop;
                this.actions.push(new Runnable(){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        int i;
                        for (i = 0; i < finalNewDominatingValues; ++i) {
                            this.this$0.defs.pop();
                        }
                        for (i = 0; i < finalNewScopesToPop; ++i) {
                            this.this$0.scopes.pop();
                        }
                        for (i = 0; i < scopesToRepush.size(); ++i) {
                            this.this$0.scopes.push((ScopedMethodNode)scopesToRepush.pop());
                        }
                    }
                });
                return 1;
            }

            private void processNode(FixedNode f) {
                block11: {
                    block10: {
                        Object i;
                        if (!this.scopes.isEmpty() && f instanceof Invoke && (i = (Invoke)f).getTargetMethod() != null && this.calleeMightUseArena(i.getTargetMethod()) && !this.defs.isEmpty()) {
                            dominatedCalls.add((Object)new DominatedCall(this.defs.peek().defNode, (Invoke)i));
                        }
                        if (f instanceof ClusterNode) {
                            return;
                        }
                        for (ReachingDefScope existingDef : this.defs) {
                            if (!existingDef.isPartOfCluster((Node)f)) continue;
                            return;
                        }
                        if (!(f instanceof SafepointNode)) break block10;
                        SafepointNode safepoint = (SafepointNode)f;
                        for (ReachingDefScope existingDef : this.defs) {
                            for (Node scopeAssociatedVal : existingDef.defNode.inputs()) {
                                EconomicSet<CFGLoop<HIRBlock>> allLoopsToCheck = this.visitEveryLoopHeaderInBetween(existingDef, (FixedNode)safepoint);
                                if (allLoopsToCheck != null) {
                                    for (CFGLoop loop : allLoopsToCheck) {
                                        LoopBeginNode lb = (LoopBeginNode)((HIRBlock)loop.getHeader()).getBeginNode();
                                        this.cacheSafepointPosition(existingDef, (ValueNode)scopeAssociatedVal, (FixedNode)lb);
                                    }
                                }
                                this.cacheSafepointPosition(existingDef, (ValueNode)scopeAssociatedVal, f);
                            }
                        }
                        break block11;
                    }
                    if (!(f instanceof MemoryAccess)) break block11;
                    for (ReachingDefScope existingDef : this.defs) {
                        block5: for (Node scopeAssociatedVal : existingDef.defNode.inputs()) {
                            for (Node input : f.inputs()) {
                                if (!1.visitInputsUntil(scopeAssociatedVal, input)) continue;
                                this.cacheAccessPosition(existingDef, (ValueNode)scopeAssociatedVal, f);
                                continue block5;
                            }
                        }
                    }
                }
            }

            private void cacheAccessPosition(ReachingDefScope existingDef, ValueNode scopeAssociatedVal, FixedNode f) {
                ArrayList<ScopedMemoryAccess> existingAccesses = (ArrayList<ScopedMemoryAccess>)nodeAccesses.get((Object)f);
                if (existingAccesses == null) {
                    existingAccesses = new ArrayList<ScopedMemoryAccess>();
                }
                existingAccesses.add(new ScopedMemoryAccess(scopeAssociatedVal, existingDef));
                nodeAccesses.put((Object)f, existingAccesses);
            }

            private void cacheSafepointPosition(ReachingDefScope existingDef, ValueNode scopeAssociatedVal, FixedNode f) {
                ArrayList<ScopedSafepoint> existingAccesses = (ArrayList<ScopedSafepoint>)nodeAccesses.get((Object)f);
                if (existingAccesses == null) {
                    existingAccesses = new ArrayList<ScopedSafepoint>();
                    nodeAccesses.put((Object)f, existingAccesses);
                }
                existingAccesses.add(new ScopedSafepoint(scopeAssociatedVal, existingDef.defNode));
            }

            private boolean calleeMightUseArena(ResolvedJavaMethod targetMethod) {
                if (Uninterruptible.Utils.isUninterruptible((AnnotatedElement)targetMethod)) {
                    return false;
                }
                if (ForeignFunctionsFeature.singleton().getNeverAccessesSharedArena().contains((Object)((HostedType)targetMethod.getDeclaringClass()).getWrapped())) {
                    return false;
                }
                return !ForeignFunctionsFeature.singleton().getNeverAccessesSharedArenaMethods().contains((Object)((HostedMethod)targetMethod).getWrapped());
            }

            private static boolean visitInputsUntil(Node key, Node start) {
                NodeStack toProcess = new NodeStack();
                toProcess.push(start);
                NodeBitMap visited = start.graph().createNodeBitMap();
                while (!toProcess.isEmpty()) {
                    Node cur = toProcess.pop();
                    if (visited.isMarked(cur)) continue;
                    visited.mark(cur);
                    if (cur instanceof FixedNode) continue;
                    if (cur == key) {
                        return true;
                    }
                    for (Node input : cur.inputs()) {
                        toProcess.push(input);
                    }
                }
                return false;
            }

            private EconomicSet<CFGLoop<HIRBlock>> visitEveryLoopHeaderInBetween(ReachingDefScope def, FixedNode usage) {
                FixedNode cur = (FixedNode)usage.predecessor();
                NodeBitMap processedNodes = cfg.graph.createNodeBitMap();
                EconomicSet loopsToCheck = null;
                block0: while (cur != def.defNode && cur != null) {
                    HIRBlock currentBlock = cfg.blockFor((Node)cur);
                    for (FixedNode f : GraphUtil.predecessorIterable((FixedNode)cur)) {
                        if (processedNodes.isMarked((Node)f)) continue;
                        CFGLoop cfgLoop = cfg.blockFor((Node)f).getLoop();
                        if (cfgLoop != null) {
                            if (loopsToCheck == null) {
                                loopsToCheck = EconomicSet.create();
                            }
                            loopsToCheck.add((Object)cfgLoop);
                        }
                        if (f == def.defNode) break block0;
                        if (f == currentBlock.getBeginNode()) {
                            cur = ((HIRBlock)currentBlock.getDominator()).getEndNode();
                            continue block0;
                        }
                        processedNodes.mark((Node)f);
                    }
                }
                return loopsToCheck;
            }

            public void exit(HIRBlock b, Integer pushedForBlock) {
                for (int i = 0; i < pushedForBlock; ++i) {
                    this.actions.pop().run();
                }
            }
        };
        cfg.visitDominatorTreeDefault((ControlFlowGraph.RecursiveVisitor)visitor);
        return nodeAccesses.size() > 0 ? nodeAccesses : null;
    }

    private static void duplicateCheckValidStateRaw(StructuredGraph graph, ReachingDefScope def, FixedNode fixedUsage, EconomicSet<DominatedCall> calls) {
        SessionStateRawGraphCluster cluster = SessionStateRawGraphCluster.build(def.defNode);
        if (cluster == null) {
            graph.getDebug().dump(5, (Object)graph, "Aborting %s with usage %s because cluster is null", (Object)def, (Object)fixedUsage);
            return;
        }
        Iterator it = calls.iterator();
        while (it.hasNext()) {
            if (!cluster.clusterNodes.contains((Node)((DominatedCall)it.next()).invoke.asNode())) continue;
            it.remove();
        }
        if (cluster.clusterNodes.isMarked((Node)fixedUsage)) {
            return;
        }
        EconomicMap duplicates = graph.addDuplicates((Iterable)cluster.clusterNodes, (Graph)graph, cluster.clusterNodes.count(), null, false);
        graph.getDebug().dump(5, (Object)graph, "After duplicating cluster at %s %s", (Object)def.defNode, (Object)fixedUsage);
        ScopedMemExceptionHandlerClusterNode.ExceptionPathNode exceptionPath = cluster.clusterExceptionEnd;
        FixedNode exceptionPathNext = exceptionPath.next();
        MergeNode mergeException = (MergeNode)graph.add((Node)new MergeNode());
        EndNode exceptionPathNewEnd = (EndNode)graph.add((Node)new EndNode());
        EndNode exceptionPathOldEnd = (EndNode)graph.add((Node)new EndNode());
        ScopedMemExceptionHandlerClusterNode.ExceptionPathNode epn = cluster.clusterExceptionEnd;
        graph.getDebug().dump(5, (Object)graph, "Before creating new exception phi for old val %s", (Object)epn);
        exceptionPath.setNext(null);
        exceptionPath.setNext((FixedNode)exceptionPathOldEnd);
        mergeException.addForwardEnd(exceptionPathOldEnd);
        mergeException.addForwardEnd(exceptionPathNewEnd);
        mergeException.setNext(exceptionPathNext);
        ((FixedWithNextNode)duplicates.get((Object)cluster.clusterExceptionEnd)).setNext((FixedNode)exceptionPathNewEnd);
        graph.getDebug().dump(5, (Object)graph, "After merging exception CF path in %s", (Object)mergeException);
        assert (fixedUsage instanceof FixedWithNextNode) : Assertions.errorMessage((Object[])new Object[]{"Must be a fixed node we can hang a check into", fixedUsage});
        FixedWithNextNode insertPoint = (FixedWithNextNode)fixedUsage.asFixedNode();
        FixedNode insertPointNext = insertPoint.next();
        insertPoint.setNext(null);
        FixedNode duplicateClusterEntry = (FixedNode)duplicates.get((Object)cluster.firstClusterNode);
        insertPoint.setNext(duplicateClusterEntry);
        graph.getDebug().dump(5, (Object)graph, "After hanging check into regular CF %s", (Object)insertPoint);
        Node nonExceptionEndDuplicate = (Node)duplicates.get((Object)cluster.clusterNonExceptionEnd);
        ((FixedWithNextNode)nonExceptionEndDuplicate).setNext(insertPointNext);
        graph.getDebug().dump(5, (Object)graph, "After going back into after check for regular cf %s", (Object)insertPointNext);
        EconomicMap createdPhis = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        for (Node clusterNode : cluster.clusterNodes) {
            List clusterNodeUsages = clusterNode.usages().snapshot();
            graph.getDebug().dump(5, (Object)graph, "Processing cluster node %s with usages %s", (Object)clusterNode, (Object)clusterNodeUsages);
            for (Node usage : clusterNodeUsages) {
                if (cluster.clusterNodes.isMarked(usage)) continue;
                for (Position p : usage.inputPositions()) {
                    Node input = p.get(usage);
                    if (input != clusterNode) continue;
                    PhiKey key = new PhiKey(input, p.getInputType());
                    PhiNode phi = SubstrateOptimizeSharedArenaAccessPhase.useOrCreatePhi(graph, input, p, (EconomicMap<PhiKey, PhiNode>)createdPhis, cluster.clusterNodes, mergeException, key, usage, (EconomicMap<Node, Node>)duplicates);
                    graph.getDebug().dump(5, (Object)graph, "Usage %s of %s outside of cluster", (Object)usage, (Object)input);
                    graph.getDebug().dump(5, (Object)graph, "Before setting input %s of %s to %s", (Object)input, (Object)usage, (Object)phi);
                    p.set(usage, (Node)phi);
                    graph.getDebug().dump(5, (Object)graph, "Setting input %s of %s to %s", (Object)input, (Object)usage, (Object)phi);
                }
            }
        }
        graph.getDebug().dump(5, (Object)graph, "After creating phis at %s", (Object)mergeException);
        for (Node n : duplicates.getValues()) {
            if (!(n instanceof ClusterNode)) continue;
            ClusterNode c = (ClusterNode)n;
            c.delete();
        }
        graph.getDebug().dump(5, (Object)graph, "After deleting leftover clusters");
    }

    private static PhiNode useOrCreatePhi(StructuredGraph graph, Node input, Position p, EconomicMap<PhiKey, PhiNode> createdPhis, NodeBitMap clusterNodes, MergeNode merge, PhiKey key, Node usage, EconomicMap<Node, Node> duplicates) {
        PhiNode phi = (PhiNode)createdPhis.get((Object)key);
        if (phi == null) {
            phi = switch (p.getInputType()) {
                case InputType.Value -> (ValuePhiNode)graph.addWithoutUnique((Node)new ValuePhiNode(((ValueNode)input).stamp(NodeView.DEFAULT).unrestricted(), (AbstractMergeNode)merge));
                case InputType.Memory -> (MemoryPhiNode)graph.addWithoutUnique((Node)new MemoryPhiNode((AbstractMergeNode)merge, SubstrateOptimizeSharedArenaAccessPhase.getLocationIdentity(input)));
                case InputType.Guard -> (GuardPhiNode)graph.addWithoutUnique((Node)new GuardPhiNode((AbstractMergeNode)merge));
                default -> throw GraalError.shouldNotReachHere((String)String.format("Unexpected edge type %s from %s to %s, [cluster nodes %s]", p.getInputType(), input, usage, clusterNodes));
            };
            createdPhis.put((Object)key, (Object)phi);
            phi.addInput((ValueNode)input);
            phi.addInput((ValueNode)duplicates.get((Object)input));
            graph.getDebug().dump(5, (Object)graph, "Created phi %s for original cluster node %s", (Object)phi, (Object)input);
        }
        return phi;
    }

    private static LocationIdentity getLocationIdentity(Node node) {
        if (node instanceof MemoryPhiNode) {
            return ((MemoryPhiNode)node).getLocationIdentity();
        }
        if (node instanceof MemoryAccess) {
            return ((MemoryAccess)node).getLocationIdentity();
        }
        if (MemoryKill.isSingleMemoryKill((Node)node)) {
            return ((SingleMemoryKill)node).getKilledLocationIdentity();
        }
        if (MemoryKill.isMultiMemoryKill((Node)node)) {
            return LocationIdentity.any();
        }
        throw GraalError.shouldNotReachHere((String)("unexpected node as part of memory graph: " + String.valueOf(node)));
    }

    static class MinimalSessionChecks
    extends ReentrantBlockIterator.BlockIteratorClosure<NodeBitMap> {
        private final StructuredGraph graph;
        private final EconomicMap<Node, List<ScopedAccess>> sugaredGraph;
        private final ControlFlowGraph cfg;
        private final EconomicSet<DominatedCall> calls;

        MinimalSessionChecks(StructuredGraph graph, EconomicMap<Node, List<ScopedAccess>> sugaredGraph, ControlFlowGraph cfg, EconomicSet<DominatedCall> calls) {
            this.graph = graph;
            this.sugaredGraph = sugaredGraph;
            this.cfg = cfg;
            this.calls = calls;
        }

        protected NodeBitMap processBlock(HIRBlock block, NodeBitMap currentState) {
            NodeBitMap effectiveCurrentState = currentState;
            for (FixedNode f : block.getNodes()) {
                List accesses = (List)this.sugaredGraph.get((Object)f);
                if (accesses == null) continue;
                for (ScopedAccess access : accesses) {
                    if (!(access instanceof ScopedSafepoint)) continue;
                    ScopedSafepoint se = (ScopedSafepoint)access;
                    if (effectiveCurrentState == null) {
                        effectiveCurrentState = this.graph.createNodeBitMap();
                    }
                    effectiveCurrentState.mark((Node)se.arenaNode);
                }
                for (ScopedAccess access : accesses) {
                    if (access instanceof ScopedSafepoint) continue;
                    ScopedMemoryAccess sma = (ScopedMemoryAccess)access;
                    if (effectiveCurrentState == null) {
                        effectiveCurrentState = this.graph.createNodeBitMap();
                        continue;
                    }
                    if (!effectiveCurrentState.isMarked((Node)sma.scope.defNode)) continue;
                    effectiveCurrentState.clear((Node)sma.scope.defNode);
                    SubstrateOptimizeSharedArenaAccessPhase.duplicateCheckValidStateRaw(this.graph, sma.scope, (FixedNode)f.predecessor(), this.calls);
                    GraalError.guarantee((boolean)this.cfg.blockFor((Node)sma.scope.defNode).dominates((BasicBlock)this.cfg.blockFor((Node)f)), (String)"%s must dominate %s", (Object)sma.scope.defNode, (Object)f);
                    SubstrateOptimizeSharedArenaAccessPhase.scheduleVerify(this.graph);
                }
            }
            return effectiveCurrentState;
        }

        protected NodeBitMap merge(HIRBlock merge, List<NodeBitMap> states) {
            NodeBitMap resultMap = null;
            for (NodeBitMap other : states) {
                if (other == null) continue;
                if (resultMap == null) {
                    resultMap = other.copy();
                    continue;
                }
                resultMap.markAll((Iterable)other);
            }
            return resultMap;
        }

        protected NodeBitMap getInitialState() {
            return null;
        }

        protected NodeBitMap cloneState(NodeBitMap oldState) {
            return oldState == null ? null : oldState.copy();
        }
    }

    record DominatedCall(MemoryArenaValidInScopeNode defNode, Invoke invoke) {
    }

    private static class ReachingDefScope {
        private final MemoryArenaValidInScopeNode defNode;
        private SessionStateRawGraphCluster defCluster;

        ReachingDefScope(MemoryArenaValidInScopeNode defNode) {
            this.defNode = defNode;
        }

        private boolean isPartOfCluster(Node n) {
            if (this.defCluster == null) {
                this.defCluster = SessionStateRawGraphCluster.build(this.defNode);
            }
            if (this.defCluster == null) {
                return false;
            }
            return this.defCluster.clusterNodes.contains(n);
        }
    }

    static class SessionStateRawGraphCluster {
        MemoryArenaValidInScopeNode scopeStart;
        ScopedMemExceptionHandlerClusterNode.ClusterBeginNode clusterBegin;
        FixedNode firstClusterNode;
        ScopedMemExceptionHandlerClusterNode.ExceptionPathNode clusterExceptionEnd;
        ScopedMemExceptionHandlerClusterNode.RegularPathNode clusterNonExceptionEnd;
        ScopedMemExceptionHandlerClusterNode.ExceptionInputNode session;
        NodeBitMap clusterNodes;

        SessionStateRawGraphCluster() {
        }

        private boolean validForBuilding() {
            assert (this.scopeStart != null) : Assertions.errorMessage((Object[])new Object[]{"Must not be null"});
            assert (this.clusterBegin != null) : Assertions.errorMessage((Object[])new Object[]{"Must not be null", this.scopeStart});
            assert (this.clusterExceptionEnd != null) : Assertions.errorMessage((Object[])new Object[]{"Must not be null", this.scopeStart});
            assert (this.clusterNonExceptionEnd != null) : Assertions.errorMessage((Object[])new Object[]{"Must not be null", this.scopeStart});
            return true;
        }

        private boolean isNullSessionOrNeverClosedArena() {
            return this.scopeStart != null && this.clusterBegin != null && this.clusterNonExceptionEnd != null && this.clusterExceptionEnd == null;
        }

        static SessionStateRawGraphCluster build(MemoryArenaValidInScopeNode arenaNode) {
            SessionStateRawGraphCluster cluster = new SessionStateRawGraphCluster();
            for (Node usage : arenaNode.usages()) {
                if (usage instanceof ScopedMemExceptionHandlerClusterNode.ClusterBeginNode) {
                    ScopedMemExceptionHandlerClusterNode.ClusterBeginNode clusterBegin = (ScopedMemExceptionHandlerClusterNode.ClusterBeginNode)usage;
                    assert (cluster.clusterBegin == null);
                    cluster.clusterBegin = clusterBegin;
                    continue;
                }
                if (usage instanceof ScopedMemExceptionHandlerClusterNode.RegularPathNode) {
                    ScopedMemExceptionHandlerClusterNode.RegularPathNode clusterNonExceptionEnd = (ScopedMemExceptionHandlerClusterNode.RegularPathNode)usage;
                    assert (cluster.clusterNonExceptionEnd == null);
                    cluster.clusterNonExceptionEnd = clusterNonExceptionEnd;
                    continue;
                }
                if (usage instanceof ScopedMemExceptionHandlerClusterNode.ExceptionPathNode) {
                    ScopedMemExceptionHandlerClusterNode.ExceptionPathNode clusterExceptionEnd = (ScopedMemExceptionHandlerClusterNode.ExceptionPathNode)usage;
                    assert (cluster.clusterExceptionEnd == null);
                    cluster.clusterExceptionEnd = clusterExceptionEnd;
                    continue;
                }
                if (!(usage instanceof ScopedMemExceptionHandlerClusterNode.ExceptionInputNode)) continue;
                ScopedMemExceptionHandlerClusterNode.ExceptionInputNode clusterInput = (ScopedMemExceptionHandlerClusterNode.ExceptionInputNode)usage;
                assert (cluster.session == null);
                cluster.session = clusterInput;
            }
            cluster.scopeStart = arenaNode;
            if (cluster.isNullSessionOrNeverClosedArena()) {
                return null;
            }
            assert (cluster.validForBuilding());
            cluster.collectNodes();
            return cluster;
        }

        private void collectNodes() {
            assert (this.clusterNodes == null);
            StructuredGraph graph = this.scopeStart.graph();
            this.clusterNodes = graph.createNodeBitMap();
            this.clusterNodes.mark((Node)this.clusterBegin);
            NodeStack toProcess = new NodeStack();
            toProcess.push((Node)this.clusterExceptionEnd);
            toProcess.push((Node)this.clusterNonExceptionEnd);
            this.firstClusterNode = this.clusterBegin;
            ScopedMemExceptionHandlerClusterNode.ClusterBeginNode f = this.clusterBegin;
            while (!(f.predecessor() instanceof IfNode)) {
                this.clusterNodes.mark((Node)f);
                this.firstClusterNode = f;
                SessionStateRawGraphCluster.ensureUniqueStates((Node)f);
                f = (FixedNode)f.predecessor();
            }
            while (!toProcess.isEmpty()) {
                Node cur = toProcess.pop();
                if (this.clusterNodes.isMarked(cur)) continue;
                this.clusterNodes.mark(cur);
                for (Node pred : cur.cfgPredecessors()) {
                    toProcess.push(pred);
                }
                SessionStateRawGraphCluster.ensureUniqueStates(cur);
            }
            graph.getDebug().dump(5, (Object)graph, "After duplicating states for collection of cluster");
            toProcess.push((Node)this.clusterExceptionEnd);
            toProcess.push((Node)this.clusterNonExceptionEnd);
            this.clusterNodes.mark((Node)this.session);
            this.clusterNodes.mark((Node)this.scopeStart);
            boolean change = true;
            int iterations = 0;
            while (change) {
                change = false;
                int before = this.clusterNodes.count();
                while (!toProcess.isEmpty()) {
                    Node cur = toProcess.pop();
                    if (cur == this.firstClusterNode || cur == this.scopeStart) continue;
                    for (Node pred : cur.cfgPredecessors()) {
                        toProcess.push(pred);
                    }
                    for (Object input : cur.inputs()) {
                        SubstrateOptimizeSharedArenaAccessPhase.visitUntilCluster(this.clusterNodes, (Node)input);
                    }
                    if (cur instanceof MergeNode) {
                        Object input;
                        MergeNode m = (MergeNode)cur;
                        input = m.phis().iterator();
                        while (input.hasNext()) {
                            PhiNode phi = (PhiNode)input.next();
                            this.clusterNodes.checkAndMarkInc((Node)phi);
                            for (Node input2 : phi.inputs()) {
                                SubstrateOptimizeSharedArenaAccessPhase.visitUntilCluster(this.clusterNodes, input2);
                            }
                        }
                    }
                    for (Position p : cur.inputPositions()) {
                        Node input = p.get(cur);
                        if (input == null || p.getInputType() != InputType.State && p.getInputType() != InputType.Extension) continue;
                        this.clusterNodes.mark(input);
                        for (Node assocInput : input.inputs()) {
                            SubstrateOptimizeSharedArenaAccessPhase.visitUntilCluster(this.clusterNodes, assocInput);
                        }
                    }
                }
                boolean bl = change = this.clusterNodes.count() > before;
                if (iterations++ <= 8) continue;
                throw GraalError.shouldNotReachHere((String)"Cluster nodes not stabilizing");
            }
            this.clusterNodes.clear((Node)this.scopeStart);
        }

        private static void ensureUniqueStates(Node cur) {
            for (Position p : cur.inputPositions()) {
                Node input = p.get(cur);
                if (input == null || p.getInputType() != InputType.State) continue;
                FrameState fs = (FrameState)input;
                p.set(cur, (Node)fs.duplicateWithVirtualState());
            }
        }
    }

    private static class PhiKey {
        Node input;
        InputType type;

        PhiKey(Node input, InputType type) {
            this.input = input;
            this.type = type;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PhiKey) {
                return this.input == ((PhiKey)obj).input && this.type == ((PhiKey)obj).type;
            }
            return false;
        }

        public int hashCode() {
            return this.input.hashCode() * this.type.hashCode();
        }
    }

    static class ScopedMemoryAccess
    extends ScopedAccess {
        final ReachingDefScope scope;

        ScopedMemoryAccess(ValueNode session, ReachingDefScope scope) {
            super(session);
            this.scope = scope;
        }
    }

    static class ScopedSafepoint
    extends ScopedAccess {
        final MemoryArenaValidInScopeNode arenaNode;

        ScopedSafepoint(ValueNode session, MemoryArenaValidInScopeNode arenaNode) {
            super(session);
            this.arenaNode = arenaNode;
        }
    }

    static class ScopedAccess {
        protected final ValueNode session;

        ScopedAccess(ValueNode session) {
            this.session = session;
        }
    }
}

