/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.configure.ConfigurationParser;
import com.oracle.svm.core.ForeignSupport;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.code.FactoryMethodHolder;
import com.oracle.svm.core.code.FactoryThrowMethodHolder;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.foreign.AbiUtils;
import com.oracle.svm.core.foreign.ForeignAPIPredicates;
import com.oracle.svm.core.foreign.ForeignFunctionsRuntime;
import com.oracle.svm.core.foreign.JavaEntryPointInfo;
import com.oracle.svm.core.foreign.NativeEntryPointInfo;
import com.oracle.svm.core.foreign.RuntimeSystemLookup;
import com.oracle.svm.core.foreign.SubstrateMappedMemoryUtils;
import com.oracle.svm.core.foreign.Target_java_nio_MappedMemoryUtils;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.jdk.VectorAPIEnabled;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.SharedArenaSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.foreign.DowncallStub;
import com.oracle.svm.hosted.foreign.ForeignFunctionsConfigurationParser;
import com.oracle.svm.hosted.foreign.LowLevelUpcallStub;
import com.oracle.svm.hosted.foreign.StronglyTypedRuntimeForeignAccessSupport;
import com.oracle.svm.hosted.foreign.UpcallStub;
import com.oracle.svm.hosted.foreign.phases.SubstrateOptimizeSharedArenaAccessPhase;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.FileDescriptor;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.IterativeConditionalEliminationPhase;
import jdk.graal.compiler.phases.tiers.MidTierContext;
import jdk.internal.foreign.AbstractMemorySegmentImpl;
import jdk.internal.foreign.MemorySessionImpl;
import jdk.internal.foreign.abi.AbstractLinker;
import jdk.internal.foreign.abi.LinkerOptions;
import jdk.internal.foreign.abi.SharedUtils;
import jdk.internal.misc.ScopedMemoryAccess;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeForeignAccessSupport;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.HOSTED_ONLY.class})
public class ForeignFunctionsFeature
implements InternalFeature {
    private static final Map<String, String[]> REQUIRES_CONCEALED = Map.of("jdk.internal.vm.ci", new String[]{"jdk.vm.ci.code", "jdk.vm.ci.meta", "jdk.vm.ci.amd64", "jdk.vm.ci.aarch64"}, "java.base", new String[]{"jdk.internal.access.foreign", "jdk.internal.misc", "jdk.internal.util", "jdk.internal.foreign", "jdk.internal.foreign.abi", "jdk.internal.foreign.abi.aarch64", "jdk.internal.foreign.abi.aarch64.macos", "jdk.internal.foreign.abi.aarch64.linux", "jdk.internal.foreign.abi.x64", "jdk.internal.foreign.abi.x64.sysv", "jdk.internal.foreign.abi.x64.windows", "jdk.internal.foreign.layout"});
    private boolean sealed = false;
    private final RuntimeForeignAccessSupportImpl accessSupport = new RuntimeForeignAccessSupportImpl();
    private final Set<SharedDesc> registeredDowncalls = ConcurrentHashMap.newKeySet();
    private int downcallCount = -1;
    private final Set<SharedDesc> registeredUpcalls = ConcurrentHashMap.newKeySet();
    private int upcallCount = -1;
    private final Set<DirectUpcallDesc> registeredDirectUpcalls = ConcurrentHashMap.newKeySet();
    private int directUpcallCount = -1;
    private final EconomicSet<ResolvedJavaType> neverAccessesSharedArena = EconomicSet.create();
    private final EconomicSet<ResolvedJavaMethod> neverAccessesSharedArenaMethods = EconomicSet.create();
    private static final Linker LINKER = Linker.nativeLinker();
    private static final String JLI_PACKAGE = "java.lang.invoke";
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+13/src/java.base/share/classes/java/lang/invoke/VarHandles.java#L313-L344")
    private static final List<String> VAR_HANDLE_SEGMENT_ACCESSORS = List.of("VarHandleSegmentAsBooleans", "VarHandleSegmentAsBytes", "VarHandleSegmentAsShorts", "VarHandleSegmentAsChars", "VarHandleSegmentAsInts", "VarHandleSegmentAsLongs", "VarHandleSegmentAsFloats", "VarHandleSegmentAsDoubles");

    @Fold
    public static ForeignFunctionsFeature singleton() {
        return (ForeignFunctionsFeature)ImageSingletons.lookup(ForeignFunctionsFeature.class);
    }

    private void checkNotSealed() {
        UserError.guarantee((!this.sealed ? 1 : 0) != 0, (String)"Registration of foreign functions was closed.", (Object[])new Object[0]);
    }

    protected ForeignFunctionsFeature() {
        for (Map.Entry<String, String[]> modulePackages : REQUIRES_CONCEALED.entrySet()) {
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.EXPORT, ForeignFunctionsFeature.class, (boolean)false, (String)modulePackages.getKey(), (String[])modulePackages.getValue());
        }
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        if (!SubstrateOptions.isForeignAPIEnabled()) {
            return false;
        }
        UserError.guarantee((!SubstrateOptions.useLLVMBackend() ? 1 : 0) != 0, (String)"Support for the Foreign Function and Memory API is not available with the LLVM backend.", (Object[])new Object[0]);
        return true;
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        AbiUtils abiUtils = AbiUtils.create();
        ForeignFunctionsRuntime foreignFunctionsRuntime = new ForeignFunctionsRuntime(abiUtils);
        ImageSingletons.add(AbiUtils.class, (Object)abiUtils);
        ImageSingletons.add(ForeignSupport.class, (Object)foreignFunctionsRuntime);
        ImageSingletons.add(ForeignFunctionsRuntime.class, (Object)foreignFunctionsRuntime);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        ImageSingletons.add(RuntimeForeignAccessSupport.class, (Object)this.accessSupport);
        if (((Boolean)SubstrateOptions.SharedArenaSupport.getValue()).booleanValue()) {
            assert (ForeignAPIPredicates.SharedArenasEnabled.getValue());
            ImageSingletons.add(SharedArenaSupport.class, (Object)new SharedArenaSupportImpl());
        }
        ImageClassLoader imageClassLoader = access.getImageClassLoader();
        ConfigurationParserUtils.parseAndRegisterConfigurationsFromCombinedFile((ConfigurationParser)this.getConfigurationParser(imageClassLoader), (ImageClassLoader)imageClassLoader, (String)"panama foreign");
    }

    private ConfigurationParser getConfigurationParser(ImageClassLoader imageClassLoader) {
        Map canonicalLayouts = ForeignFunctionsRuntime.areFunctionCallsSupported() ? AbiUtils.singleton().canonicalLayouts() : Linker.nativeLinker().canonicalLayouts();
        return new ForeignFunctionsConfigurationParser(imageClassLoader, this.accessSupport, canonicalLayouts);
    }

    private void createDowncallStubs(FeatureImpl.BeforeAnalysisAccessImpl access) {
        this.downcallCount = ForeignFunctionsFeature.createStubs(this.registeredDowncalls, access, false, new DowncallStubFactory(access.getMetaAccess().getWrapped())).size();
    }

    private void createUpcallStubs(FeatureImpl.BeforeAnalysisAccessImpl access) {
        Map<DirectUpcall, UpcallStub> directUpcallStubs = ForeignFunctionsFeature.createStubs(this.registeredDirectUpcalls, access, true, new DirectUpcallStubFactory(access.getUniverse(), access.getMetaAccess().getWrapped(), this.registeredUpcalls));
        this.directUpcallCount = directUpcallStubs.size();
        this.registeredDirectUpcalls.clear();
        Map<JavaEntryPointInfo, UpcallStub> upcallStubs = ForeignFunctionsFeature.createStubs(this.registeredUpcalls, access, true, new UpcallStubFactory(access.getUniverse(), access.getMetaAccess().getWrapped()));
        this.upcallCount = upcallStubs.size();
        this.registeredUpcalls.clear();
    }

    private static <S, T, U extends ResolvedJavaMethod> Map<S, U> createStubs(Iterable<T> sources, FeatureImpl.BeforeAnalysisAccessImpl access, boolean registerAsEntryPoints, StubFactory<S, T, U> factory) {
        HashMap<S, U> created = new HashMap<S, U>();
        for (T source : sources) {
            S key = factory.createKey(source);
            if (created.containsKey(key)) continue;
            U stub = factory.generateStub(key);
            AnalysisMethod analysisStub = access.getUniverse().lookup(stub);
            access.getBigBang().addRootMethod(analysisStub, false, (Object)("Foreign stub, registered in " + String.valueOf(ForeignFunctionsFeature.class)), new MultiMethod.MultiMethodKey[0]);
            if (registerAsEntryPoints) {
                analysisStub.registerAsNativeEntryPoint((Object)CEntryPointData.createCustomUnpublished());
            }
            created.put(key, stub);
            factory.registerStub(key, (CFunctionPointer)new MethodPointer((ResolvedJavaMethod)analysisStub));
        }
        return created;
    }

    private static void registerVarHandleMethodsForReflection(Feature.FeatureAccess access, Class<?> subtype) {
        assert (JLI_PACKAGE.equals(subtype.getPackage().getName()));
        RuntimeReflection.register((Executable[])subtype.getDeclaredMethods());
    }

    private static String platform() {
        return (OS.getCurrent().className + "-" + SubstrateUtil.getArchitectureName()).toLowerCase(Locale.ROOT);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        this.sealed = true;
        AbiUtils.singleton().checkLibrarySupport();
        for (String simpleName : VAR_HANDLE_SEGMENT_ACCESSORS) {
            Class varHandleSegmentAsXClass = ReflectionUtil.lookupClass((String)("java.lang.invoke." + simpleName));
            access.registerSubtypeReachabilityHandler(ForeignFunctionsFeature::registerVarHandleMethodsForReflection, varHandleSegmentAsXClass);
        }
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)ReflectionUtil.lookupClass((boolean)false, (String)"jdk.internal.foreign.abi.DowncallLinker"), (String)"USE_SPEC"), (object, object2) -> false);
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)ReflectionUtil.lookupClass((boolean)false, (String)"jdk.internal.foreign.abi.UpcallLinker"), (String)"USE_SPEC"), (object, object2) -> false);
        RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{RuntimeSystemLookup.class});
        access.registerAsRoot((Executable)ReflectionUtil.lookupMethod(ForeignFunctionsRuntime.class, (String)"captureCallState", (Class[])new Class[]{Integer.TYPE, CIntPointer.class}), false, "Runtime support, registered in " + String.valueOf(ForeignFunctionsFeature.class), new MultiMethod.MultiMethodKey[0]);
        if (ForeignFunctionsRuntime.areFunctionCallsSupported()) {
            this.createDowncallStubs(access);
            this.createUpcallStubs(access);
        } else {
            if (!(this.registeredDowncalls.isEmpty() && this.registeredUpcalls.isEmpty() && this.registeredDirectUpcalls.isEmpty())) {
                this.registeredDowncalls.clear();
                this.registeredUpcalls.clear();
                this.registeredDirectUpcalls.clear();
                LogUtils.warning((String)"Registered down- and upcall stubs will be ignored because calling foreign functions is currently not supported on platform: %s", (Object[])new Object[]{ForeignFunctionsFeature.platform()});
            }
            this.downcallCount = 0;
            this.upcallCount = 0;
            this.directUpcallCount = 0;
        }
        ProgressReporter.singleton().setForeignFunctionsInfo(this.getCreatedDowncallStubsCount(), this.getCreatedUpcallStubsCount());
        access.registerAsRead(ReflectionUtil.lookupField(MemorySessionImpl.class, (String)"state"), (Object)"field location is killed after safepoint");
        try {
            this.initSafeArenaAccessors(access);
        }
        catch (Throwable t) {
            throw GraalError.shouldNotReachHere((Throwable)t);
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+14/src/java.base/share/classes/java/nio/MappedMemoryUtils.java")
    protected void initSafeArenaAccessors(FeatureImpl.BeforeAnalysisAccessImpl access) throws NoSuchMethodException {
        AnalysisMetaAccess metaAccess = access.getMetaAccess();
        this.registerSafeArenaAccessorClass((MetaAccessProvider)metaAccess, FactoryMethodHolder.class);
        this.registerSafeArenaAccessorClass((MetaAccessProvider)metaAccess, FactoryThrowMethodHolder.class);
        this.registerSafeArenaAccessorClass((MetaAccessProvider)metaAccess, LogUtils.class);
        this.registerSafeArenaAccessorMethod((MetaAccessProvider)metaAccess, Supplier.class.getMethod("get", new Class[0]));
        this.registerSafeArenaAccessorMethod((MetaAccessProvider)metaAccess, VMError.class.getMethod("shouldNotReachHereSubstitution", new Class[0]));
        this.registerSafeArenaAccessorMethod((MetaAccessProvider)metaAccess, ScopedMemoryAccess.ScopedAccessError.class.getMethod("newRuntimeException", new Class[0]));
        this.registerSafeArenaAccessorMethod((MetaAccessProvider)metaAccess, Throwable.class.getMethod("getMessage", new Class[0]));
        this.registerSafeArenaAccessorMethod((MetaAccessProvider)metaAccess, ReflectionUtil.lookupMethod(Throwable.class, (String)"fillInStackTrace", (Class[])new Class[]{Integer.TYPE}));
        Class<Target_java_nio_MappedMemoryUtils> mappedMemoryUtils = Target_java_nio_MappedMemoryUtils.class;
        this.registerSafeArenaAccessorMethod((MetaAccessProvider)metaAccess, ReflectionUtil.lookupMethod(mappedMemoryUtils, (String)"force", (Class[])new Class[]{FileDescriptor.class, Long.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE}));
        this.registerSafeArenaAccessorMethod((MetaAccessProvider)metaAccess, ReflectionUtil.lookupMethod(mappedMemoryUtils, (String)"isLoaded", (Class[])new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE}));
        this.registerSafeArenaAccessorMethod((MetaAccessProvider)metaAccess, ReflectionUtil.lookupMethod(mappedMemoryUtils, (String)"unload", (Class[])new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE}));
        this.registerSafeArenaAccessorMethod((MetaAccessProvider)metaAccess, ReflectionUtil.lookupMethod(SubstrateMappedMemoryUtils.class, (String)"load", (Class[])new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE}));
        this.registerSafeArenaAccessorMethod((MetaAccessProvider)metaAccess, ReflectionUtil.lookupMethod(MemorySessionImpl.class, (String)"checkValidStateRaw", (Class[])new Class[0]));
        this.registerSafeArenaAccessorMethod((MetaAccessProvider)metaAccess, ReflectionUtil.lookupMethod(AbstractMemorySegmentImpl.class, (String)"unsafeGetBase", (Class[])new Class[0]));
        this.registerSafeArenaAccessorMethod((MetaAccessProvider)metaAccess, ReflectionUtil.lookupMethod(AbstractMemorySegmentImpl.class, (String)"unsafeGetOffset", (Class[])new Class[0]));
    }

    protected void registerSafeArenaAccessorClass(MetaAccessProvider metaAccess, Class<?> klass) {
        this.neverAccessesSharedArena.add((Object)metaAccess.lookupJavaType(klass));
    }

    protected void registerSafeArenaAccessorMethod(MetaAccessProvider metaAccess, Executable method) {
        this.neverAccessesSharedArenaMethods.add((Object)metaAccess.lookupJavaMethod(method));
    }

    public EconomicSet<ResolvedJavaType> getNeverAccessesSharedArena() {
        return this.neverAccessesSharedArena;
    }

    public EconomicSet<ResolvedJavaMethod> getNeverAccessesSharedArenaMethods() {
        return this.neverAccessesSharedArenaMethods;
    }

    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(new SnippetRuntime.SubstrateForeignCallDescriptor[]{ForeignFunctionsRuntime.CAPTURE_CALL_STATE});
    }

    public int getCreatedDowncallStubsCount() {
        assert (this.sealed);
        assert (this.downcallCount >= 0);
        return this.downcallCount;
    }

    public int getCreatedUpcallStubsCount() {
        assert (this.sealed);
        assert (this.upcallCount >= 0);
        return this.upcallCount;
    }

    public int getCreatedDirectUpcallStubsCount() {
        assert (this.sealed);
        assert (this.directUpcallCount >= 0);
        return this.directUpcallCount;
    }

    private final class RuntimeForeignAccessSupportImpl
    extends ConditionalConfigurationRegistry
    implements StronglyTypedRuntimeForeignAccessSupport {
        private final MethodHandles.Lookup implLookup = (MethodHandles.Lookup)ReflectionUtil.readStaticField(MethodHandles.Lookup.class, (String)"IMPL_LOOKUP");

        private RuntimeForeignAccessSupportImpl() {
        }

        @Override
        public void registerForDowncall(ConfigurationCondition condition, FunctionDescriptor desc, Linker.Option ... options) {
            ForeignFunctionsFeature.this.checkNotSealed();
            try {
                LinkerOptions linkerOptions = LinkerOptions.forDowncall(desc, options);
                this.registerConditionalConfiguration(condition, configurationCondition -> ForeignFunctionsFeature.this.registeredDowncalls.add(new SharedDesc(desc, linkerOptions)));
            }
            catch (IllegalArgumentException e) {
                throw UserError.abort((Throwable)e, (String)"Could not register downcall", (Object[])new Object[0]);
            }
        }

        @Override
        public void registerForUpcall(ConfigurationCondition condition, FunctionDescriptor desc, Linker.Option ... options) {
            ForeignFunctionsFeature.this.checkNotSealed();
            try {
                LinkerOptions linkerOptions = LinkerOptions.forUpcall(desc, options);
                this.registerConditionalConfiguration(condition, configurationCondition -> ForeignFunctionsFeature.this.registeredUpcalls.add(new SharedDesc(desc, linkerOptions)));
            }
            catch (IllegalArgumentException e) {
                throw UserError.abort((Throwable)e, (String)"Could not register upcall", (Object[])new Object[0]);
            }
        }

        @Override
        public void registerForDirectUpcall(ConfigurationCondition condition, MethodHandle target, FunctionDescriptor desc, Linker.Option ... options) {
            ForeignFunctionsFeature.this.checkNotSealed();
            DirectMethodHandleDesc directMethodHandleDesc = target.describeConstable().filter(x -> {
                DirectMethodHandleDesc dmh;
                return x instanceof DirectMethodHandleDesc && (dmh = (DirectMethodHandleDesc)x).kind() == DirectMethodHandleDesc.Kind.STATIC;
            }).map(x -> (DirectMethodHandleDesc)x).orElseThrow(() -> new IllegalArgumentException("Target must be a direct method handle to a static method"));
            Executable method = this.implLookup.revealDirect(Objects.requireNonNull(target)).reflectAs(Executable.class, this.implLookup);
            try {
                LinkerOptions linkerOptions = LinkerOptions.forUpcall(desc, options);
                this.registerConditionalConfiguration(condition, configurationCondition -> {
                    RuntimeReflection.register((Executable[])new Executable[]{method});
                    ForeignFunctionsFeature.this.registeredDirectUpcalls.add(new DirectUpcallDesc(target, directMethodHandleDesc, desc, linkerOptions));
                });
            }
            catch (IllegalArgumentException e) {
                throw UserError.abort((Throwable)e, (String)"Could not register direct upcall", (Object[])new Object[0]);
            }
        }
    }

    private final class SharedArenaSupportImpl
    implements SharedArenaSupport {
        private SharedArenaSupportImpl() {
        }

        public BasePhase<MidTierContext> createOptimizeSharedArenaAccessPhase() {
            VMError.guarantee((boolean)ForeignAPIPredicates.SharedArenasEnabled.getValue(), (String)"Support for shared arenas must be enabled");
            VMError.guarantee((!RuntimeCompilation.isEnabled() ? 1 : 0) != 0, (String)"Shared arenas cannot be used together with runtime compilations (GR-65268)");
            VMError.guarantee((!VectorAPIEnabled.getValue() ? 1 : 0) != 0, (String)"Shared arenas cannot be used together with Vector API support (GR-65162)");
            PhaseSuite sharedArenaPhases = new PhaseSuite();
            sharedArenaPhases.appendPhase((BasePhase)new SubstrateOptimizeSharedArenaAccessPhase(CanonicalizerPhase.create()));
            sharedArenaPhases.appendPhase((BasePhase)new IterativeConditionalEliminationPhase(CanonicalizerPhase.create(), false));
            sharedArenaPhases.appendPhase((BasePhase)CanonicalizerPhase.create());
            return sharedArenaPhases;
        }

        public void registerSafeArenaAccessorClass(AnalysisMetaAccess metaAccess, Class<?> klass) {
            assert (ForeignAPIPredicates.SharedArenasEnabled.getValue());
            ForeignFunctionsFeature.this.registerSafeArenaAccessorClass((MetaAccessProvider)metaAccess, klass);
        }
    }

    private record DowncallStubFactory(MetaAccessProvider metaAccessProvider) implements StubFactory<NativeEntryPointInfo, SharedDesc, DowncallStub>
    {
        @Override
        public NativeEntryPointInfo createKey(SharedDesc registeredDescriptor) {
            return AbiUtils.singleton().makeNativeEntrypoint(registeredDescriptor.fd, registeredDescriptor.options);
        }

        @Override
        public DowncallStub generateStub(NativeEntryPointInfo stubDescriptor) {
            return new DowncallStub(stubDescriptor, this.metaAccessProvider);
        }

        @Override
        public void registerStub(NativeEntryPointInfo stubDescriptor, CFunctionPointer stubPointer) {
            ForeignFunctionsRuntime.singleton().addDowncallStubPointer(stubDescriptor, stubPointer);
        }
    }

    private static interface StubFactory<S, T, U extends ResolvedJavaMethod> {
        public S createKey(T var1);

        public U generateStub(S var1);

        public void registerStub(S var1, CFunctionPointer var2);
    }

    private static final class DirectUpcallStubFactory
    implements StubFactory<DirectUpcall, DirectUpcallDesc, UpcallStub> {
        private static final String COULD_NOT_EXTRACT_METHOD_HANDLE_FOR_UPCALL = "Could not extract method handle for upcall.";
        private final AnalysisUniverse universe;
        private final MetaAccessProvider metaAccessProvider;
        private final Method arrangeUpcallMethod;
        private final Method adaptUpcallForIMRMethod;
        private final Set<SharedDesc> registeredUpcalls;

        DirectUpcallStubFactory(AnalysisUniverse universe, MetaAccessProvider metaAccessProvider, Set<SharedDesc> registeredUpcalls) {
            this.universe = universe;
            this.metaAccessProvider = metaAccessProvider;
            this.registeredUpcalls = registeredUpcalls;
            this.arrangeUpcallMethod = ReflectionUtil.lookupMethod(LINKER.getClass(), (String)"arrangeUpcall", (Class[])new Class[]{MethodType.class, FunctionDescriptor.class, LinkerOptions.class});
            this.adaptUpcallForIMRMethod = ReflectionUtil.lookupMethod(SharedUtils.class, (String)"adaptUpcallForIMR", (Class[])new Class[]{MethodHandle.class, Boolean.TYPE});
        }

        @Override
        @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+25/src/java.base/share/classes/jdk/internal/foreign/abi/AbstractLinker.java#L117-L135"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+13/src/java.base/share/classes/jdk/internal/foreign/abi/SharedUtils.java#L191-L210")})
        public DirectUpcall createKey(DirectUpcallDesc desc) {
            AbiUtils abiUtils = AbiUtils.singleton();
            MethodHandle target = desc.mh();
            boolean inMemoryReturn = abiUtils.isInMemoryReturn(desc.fd().returnLayout());
            if (inMemoryReturn) {
                target = (MethodHandle)ReflectionUtil.invokeMethod((Method)this.adaptUpcallForIMRMethod, null, (Object[])new Object[]{target, abiUtils.dropReturn()});
            }
            AbstractLinker.UpcallStubFactory upcallStubFactory = (AbstractLinker.UpcallStubFactory)ReflectionUtil.invokeMethod((Method)this.arrangeUpcallMethod, (Object)LINKER, (Object[])new Object[]{desc.fd().toMethodType(), desc.fd(), desc.options()});
            UnaryOperator<MethodHandle> doBindingsMaker = DirectUpcallStubFactory.lookupAndReadUnaryOperatorField(upcallStubFactory, inMemoryReturn);
            MethodHandle doBindings = (MethodHandle)doBindingsMaker.apply(target);
            doBindings = MethodHandles.insertArguments(MethodHandles.exactInvoker(doBindings.type()), 0, doBindings);
            JavaEntryPointInfo jepi = abiUtils.makeJavaEntryPoint(desc.fd(), desc.options());
            this.registeredUpcalls.add(desc.toSharedDesc());
            return new DirectUpcall(desc.mhDesc(), doBindings, jepi);
        }

        @Override
        public UpcallStub generateStub(DirectUpcall directUpcall) {
            return LowLevelUpcallStub.makeDirect(directUpcall.bindings(), directUpcall.jep(), this.universe, this.metaAccessProvider);
        }

        @Override
        public void registerStub(DirectUpcall stubDescriptor, CFunctionPointer stubPointer) {
            ForeignFunctionsRuntime.singleton().addDirectUpcallStubPointer(stubDescriptor.targetDesc(), stubDescriptor.jep(), stubPointer);
        }

        @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+13/src/java.base/share/classes/jdk/internal/foreign/abi/UpcallLinker.java#L62-L110"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+13/src/java.base/share/classes/jdk/internal/foreign/abi/SharedUtils.java#L201-L207")})
        private static UnaryOperator<MethodHandle> lookupAndReadUnaryOperatorField(AbstractLinker.UpcallStubFactory outerFactory, boolean inMemoryReturn) {
            Field unaryOperatorField;
            Class<?> upcallStubFactoryClass;
            UnaryOperator value;
            AbstractLinker.UpcallStubFactory upcallStubFactory = outerFactory;
            if (inMemoryReturn) {
                Class<?> outerFactoryClass = outerFactory.getClass();
                Field upcallStubFactoryField = DirectUpcallStubFactory.findSingleFieldOfType(AbstractLinker.UpcallStubFactory.class, outerFactoryClass.getDeclaredFields());
                upcallStubFactory = (AbstractLinker.UpcallStubFactory)ReflectionUtil.readField(outerFactoryClass, (String)upcallStubFactoryField.getName(), (Object)outerFactory);
            }
            if ((value = (UnaryOperator)ReflectionUtil.readField(upcallStubFactoryClass = upcallStubFactory.getClass(), (String)(unaryOperatorField = DirectUpcallStubFactory.findSingleFieldOfType(UnaryOperator.class, upcallStubFactoryClass.getDeclaredFields())).getName(), (Object)upcallStubFactory)) == null) {
                throw VMError.shouldNotReachHere((String)COULD_NOT_EXTRACT_METHOD_HANDLE_FOR_UPCALL);
            }
            return value;
        }

        private static Field findSingleFieldOfType(Class<?> expectedFieldType, Field[] declaredFields) {
            Field candidate = null;
            for (Field field : declaredFields) {
                if (!expectedFieldType.isAssignableFrom(field.getType())) continue;
                if (candidate != null) {
                    throw VMError.shouldNotReachHere((String)COULD_NOT_EXTRACT_METHOD_HANDLE_FOR_UPCALL);
                }
                candidate = field;
            }
            if (candidate == null) {
                throw VMError.shouldNotReachHere((String)COULD_NOT_EXTRACT_METHOD_HANDLE_FOR_UPCALL);
            }
            return candidate;
        }
    }

    private record UpcallStubFactory(AnalysisUniverse universe, MetaAccessProvider metaAccessProvider) implements StubFactory<JavaEntryPointInfo, SharedDesc, UpcallStub>
    {
        @Override
        public JavaEntryPointInfo createKey(SharedDesc registeredDescriptor) {
            return AbiUtils.singleton().makeJavaEntryPoint(registeredDescriptor.fd, registeredDescriptor.options);
        }

        @Override
        public UpcallStub generateStub(JavaEntryPointInfo stubDescriptor) {
            return LowLevelUpcallStub.make(stubDescriptor, this.universe, this.metaAccessProvider);
        }

        @Override
        public void registerStub(JavaEntryPointInfo stubDescriptor, CFunctionPointer stubPointer) {
            ForeignFunctionsRuntime.singleton().addUpcallStubPointer(stubDescriptor, stubPointer);
        }
    }

    private record DirectUpcall(DirectMethodHandleDesc targetDesc, MethodHandle bindings, JavaEntryPointInfo jep) {
        @Override
        public boolean equals(Object o) {
            if (this == o || !(o instanceof DirectUpcall)) {
                return this == o;
            }
            return Objects.equals(this.targetDesc, ((DirectUpcall)o).targetDesc);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.targetDesc);
        }
    }

    private record DirectUpcallDesc(MethodHandle mh, DirectMethodHandleDesc mhDesc, FunctionDescriptor fd, LinkerOptions options) {
        public SharedDesc toSharedDesc() {
            return new SharedDesc(this.fd, this.options);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o || !(o instanceof DirectUpcallDesc)) {
                return this == o;
            }
            DirectUpcallDesc that = (DirectUpcallDesc)o;
            return Objects.equals(this.mhDesc, that.mhDesc) && Objects.equals(this.fd, that.fd) && Objects.equals(this.options, that.options);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.mhDesc, this.fd, this.options);
        }
    }

    private record SharedDesc(FunctionDescriptor fd, LinkerOptions options) {
    }
}

