/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign;

import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.configure.ForeignConfigurationParser;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.foreign.MemoryLayoutParser;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.foreign.AddressLayout;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jdk.graal.compiler.util.json.JsonFormatter;
import jdk.graal.compiler.util.json.JsonParserException;
import jdk.internal.foreign.layout.ValueLayouts;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeForeignAccessSupport;

@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+22/src/java.base/share/classes/jdk/internal/foreign/abi/LinkerOptions.java")
@Platforms(value={Platform.HOSTED_ONLY.class})
public class ForeignFunctionsConfigurationParser
extends ForeignConfigurationParser<FunctionDescriptor, Linker.Option[]> {
    private static final String DOWNCALL_OPTION_CAPTURE_CALL_STATE = "captureCallState";
    private static final String DOWNCALL_OPTION_FIRST_VARIADIC_ARG = "firstVariadicArg";
    private static final String DOWNCALL_OPTION_CRITICAL = "critical";
    private static final String DOWNCALL_OPTION_ALLOW_HEAP_ACCESS = "allowHeapAccess";
    private static final Linker.Option[] EMPTY_OPTIONS = new Linker.Option[0];
    private final ImageClassLoader imageClassLoader;
    private final RuntimeForeignAccessSupport accessSupport;
    private final Map<String, MemoryLayout> canonicalLayouts;
    private MethodHandles.Lookup implLookup;

    public ForeignFunctionsConfigurationParser(ImageClassLoader imageClassLoader, RuntimeForeignAccessSupport access, Map<String, MemoryLayout> canonicalLayouts) {
        super(EnumSet.of(ConfigurationParserOption.STRICT_CONFIGURATION));
        this.imageClassLoader = imageClassLoader;
        this.accessSupport = access;
        this.canonicalLayouts = canonicalLayouts;
    }

    protected EnumSet<ConfigurationParserOption> supportedOptions() {
        EnumSet base = super.supportedOptions();
        base.add(ConfigurationParserOption.PRINT_MISSING_ELEMENTS);
        return base;
    }

    protected void registerDowncall(ConfigurationCondition configurationCondition, FunctionDescriptor descriptor, Linker.Option[] options) {
        this.accessSupport.registerForDowncall(ConfigurationCondition.alwaysTrue(), (Object)descriptor, (Object[])options);
    }

    protected void registerUpcall(ConfigurationCondition configurationCondition, FunctionDescriptor descriptor, Linker.Option[] options) {
        this.accessSupport.registerForUpcall(ConfigurationCondition.alwaysTrue(), (Object)descriptor, (Object[])options);
    }

    protected void registerDirectUpcallWithDescriptor(String className, String methodName, FunctionDescriptor descriptor, Linker.Option[] options) {
        MethodHandle target;
        Class aClass;
        try {
            aClass = this.imageClassLoader.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.handleMissingElement(e, "Cannot find class '%s' used to register method(s) '%s' for a direct upcall(s). ", className, methodName);
            return;
        }
        MethodType methodType = descriptor.toMethodType();
        try {
            target = this.getImplLookup().findStatic(aClass, methodName, methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            this.handleMissingElement(e, "Method '%s.%s(%s)' could not be registered as an upcall target method. Please verify that the method is static and that the parameter types match.", className, methodName, methodType);
            return;
        }
        this.accessSupport.registerForDirectUpcall(ConfigurationCondition.alwaysTrue(), target, (Object)descriptor, (Object[])options);
    }

    protected void registerDirectUpcallWithoutDescriptor(String className, String methodName, EconomicMap<String, Object> optionsMap) {
        LinkedList<Pair> descriptors;
        Class aClass;
        try {
            aClass = this.imageClassLoader.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.handleMissingElement(e, "Cannot find class '%s' used to register method(s) '%s' for a direct upcall. ", className, methodName);
            return;
        }
        try {
            descriptors = new LinkedList<Pair>();
            for (Method method : ForeignFunctionsConfigurationParser.findStaticMethods(aClass, methodName)) {
                try {
                    descriptors.add(Pair.create((Object)ForeignFunctionsConfigurationParser.deriveFunctionDescriptor(method), (Object)this.getImplLookup().unreflect(method)));
                }
                catch (AmbiguousParameterType | InvalidCarrierType e) {
                    this.handleMissingElement(e);
                }
                catch (IllegalAccessException e) {
                    this.handleMissingElement(e, "Method '%s.%s' and all its possible overloads could not be registered as upcall target methods. Please verify that all overloads of the method are static.", className, methodName);
                }
            }
        }
        catch (NoSuchMethodException e) {
            this.handleMissingElement(e, "Method '%s.%s' and all its possible overloads could not be registered as upcall target methods. Please verify that all overloads of the method are static.", className, methodName);
            return;
        }
        for (Pair pair : descriptors) {
            Linker.Option[] options = this.createUpcallOptions(optionsMap, (FunctionDescriptor)pair.getLeft());
            try {
                this.accessSupport.registerForDirectUpcall(ConfigurationCondition.alwaysTrue(), (MethodHandle)pair.getRight(), pair.getLeft(), (Object[])options);
            }
            catch (IllegalArgumentException e) {
                this.handleMissingElement(e, "Could not register direct upcall stub '%s.%s%s'", className, methodName, ((FunctionDescriptor)pair.getLeft()).toMethodType());
            }
        }
    }

    private static List<Method> findStaticMethods(Class<?> clazz, String methodName) throws NoSuchMethodException {
        LinkedList<Method> result = new LinkedList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !methodName.equals(method.getName())) continue;
            result.add(method);
        }
        if (result.isEmpty()) {
            throw new NoSuchMethodException(methodName);
        }
        return result;
    }

    private static FunctionDescriptor deriveFunctionDescriptor(Method method) throws AmbiguousParameterType {
        MemoryLayout resLayout = ForeignFunctionsConfigurationParser.deriveMemoryLayout(method, null, method.getReturnType());
        MemoryLayout[] argLayouts = (MemoryLayout[])Arrays.stream(method.getParameters()).map(p -> ForeignFunctionsConfigurationParser.deriveMemoryLayout(method, p.getName(), p.getType())).toArray(MemoryLayout[]::new);
        return resLayout != null ? FunctionDescriptor.of(resLayout, argLayouts) : FunctionDescriptor.ofVoid(argLayouts);
    }

    private static MemoryLayout deriveMemoryLayout(Method method, String parameterName, Class<?> type) throws AmbiguousParameterType {
        if (parameterName == null && type == Void.TYPE) {
            return null;
        }
        try {
            ValueLayout valueLayout = ValueLayouts.valueLayout(type, ByteOrder.nativeOrder());
            if (valueLayout instanceof AddressLayout) {
                assert (type == MemorySegment.class);
                throw new AmbiguousParameterType(String.format("%s type \"%s\" of method \"%s.%s\" requires additional information. Please specify the layout (such as 'struct', or void* for a pointer) for the parameter and return types.", ForeignFunctionsConfigurationParser.describe(parameterName), MemorySegment.class.getName(), method.getDeclaringClass().getName(), method.getName()));
            }
            return valueLayout;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidCarrierType(String.format("%s type \"%s\" of method \"%s.%s\" cannot be mapped to a ValueLayout. This method cannot be used for a direct upcall. If there are multiple overloads of this method and another overload should be use, you need to provide the parameter and return types.", ForeignFunctionsConfigurationParser.describe(parameterName), type.getTypeName(), method.getDeclaringClass().getName(), method.getName()));
        }
    }

    private static String describe(String parameterName) {
        return parameterName != null ? "Parameter \"" + parameterName + "\" with" : "Return";
    }

    protected FunctionDescriptor createFunctionDescriptor(String returnType, List<String> parameterTypes) {
        try {
            Optional<MemoryLayout> returnLayout = MemoryLayoutParser.parseAllowVoid(returnType, this.canonicalLayouts);
            MemoryLayout[] parameterLayouts = this.parseParameterTypes(parameterTypes);
            return returnLayout.map(memoryLayout -> FunctionDescriptor.of(memoryLayout, parameterLayouts)).orElseGet(() -> FunctionDescriptor.ofVoid(parameterLayouts));
        }
        catch (MemoryLayoutParser.MemoryLayoutParserException e) {
            throw new JsonParserException(e.getMessage());
        }
    }

    private MemoryLayout[] parseParameterTypes(List<String> parameterTypes) throws MemoryLayoutParser.MemoryLayoutParserException {
        MemoryLayout[] parameterLayouts = new MemoryLayout[parameterTypes.size()];
        for (int i = 0; i < parameterLayouts.length; ++i) {
            parameterLayouts[i] = MemoryLayoutParser.parse(parameterTypes.get(i), this.canonicalLayouts);
        }
        return parameterLayouts;
    }

    protected Linker.Option[] createDowncallOptions(EconomicMap<String, Object> map, FunctionDescriptor desc) {
        this.checkAttributes(map, "options", List.of(), List.of(DOWNCALL_OPTION_FIRST_VARIADIC_ARG, DOWNCALL_OPTION_CAPTURE_CALL_STATE, DOWNCALL_OPTION_CRITICAL));
        ArrayList<Linker.Option> res = new ArrayList<Linker.Option>();
        if (map.containsKey((Object)DOWNCALL_OPTION_FIRST_VARIADIC_ARG)) {
            int firstVariadic = (int)ForeignFunctionsConfigurationParser.asLong((Object)map.get((Object)DOWNCALL_OPTION_FIRST_VARIADIC_ARG), (String)"");
            if (firstVariadic < 0 || firstVariadic > desc.argumentLayouts().size()) {
                throw new JsonParserException("firstVariadicArg: Index '" + firstVariadic + "' not in bounds for desc: " + String.valueOf(desc));
            }
            res.add(Linker.Option.firstVariadicArg(firstVariadic));
        }
        if (map.containsKey((Object)DOWNCALL_OPTION_CAPTURE_CALL_STATE) && ForeignFunctionsConfigurationParser.asBoolean((Object)map.get((Object)DOWNCALL_OPTION_CAPTURE_CALL_STATE, (Object)""), (String)DOWNCALL_OPTION_CAPTURE_CALL_STATE)) {
            res.add(Linker.Option.captureCallState("errno"));
        }
        if (map.containsKey((Object)DOWNCALL_OPTION_CRITICAL)) {
            Object criticalOpt = map.get((Object)DOWNCALL_OPTION_CRITICAL, (Object)"");
            if (criticalOpt instanceof EconomicMap) {
                EconomicMap criticalMap = (EconomicMap)criticalOpt;
                this.checkAttributes(criticalMap, DOWNCALL_OPTION_CRITICAL, List.of(), List.of(DOWNCALL_OPTION_ALLOW_HEAP_ACCESS));
                boolean allowHeapAccess = false;
                if (criticalMap.containsKey((Object)DOWNCALL_OPTION_ALLOW_HEAP_ACCESS)) {
                    allowHeapAccess = ForeignFunctionsConfigurationParser.asBoolean((Object)criticalMap.get((Object)DOWNCALL_OPTION_ALLOW_HEAP_ACCESS), (String)DOWNCALL_OPTION_ALLOW_HEAP_ACCESS);
                }
                res.add(Linker.Option.critical((boolean)allowHeapAccess));
            } else {
                throw new JsonParserException("allowHeapAccess should be a boolean or a map");
            }
        }
        return (Linker.Option[])res.toArray(Linker.Option[]::new);
    }

    protected Linker.Option[] createUpcallOptions(EconomicMap<String, Object> map, FunctionDescriptor desc) {
        this.checkAttributes(map, "options", List.of(), List.of());
        return EMPTY_OPTIONS;
    }

    private MethodHandles.Lookup getImplLookup() {
        if (this.implLookup == null) {
            this.implLookup = (MethodHandles.Lookup)ReflectionUtil.readStaticField(MethodHandles.Lookup.class, (String)"IMPL_LOOKUP");
        }
        return this.implLookup;
    }

    protected void handleRegistrationError(Exception cause, EconomicMap<String, Object> map) {
        this.handleMissingElement(cause, "Could not register foreign stub '%s'", JsonFormatter.formatJson(map));
    }

    protected void handleMissingElement(Throwable cause, String format, Object ... args) {
        if (this.checkOption(ConfigurationParserOption.PRINT_MISSING_ELEMENTS)) {
            Object message = format.formatted(args);
            if (cause != null) {
                message = (String)message + " Reason: " + cause.getClass().getTypeName() + ": " + cause.getMessage() + ".";
            }
            LogUtils.warning((String)message);
        }
    }

    protected void handleMissingElement(Throwable reason) {
        if (this.checkOption(ConfigurationParserOption.PRINT_MISSING_ELEMENTS)) {
            LogUtils.warning((String)(reason.getClass().getTypeName() + ": " + reason.getMessage()));
        }
    }

    private static final class AmbiguousParameterType
    extends RuntimeException {
        AmbiguousParameterType(String message) {
            super(message);
        }
    }

    private static final class InvalidCarrierType
    extends RuntimeException {
        InvalidCarrierType(String message) {
            super(message);
        }
    }
}

