/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.ArenaIntrinsics;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.nodes.foreign.ScopedMemExceptionHandlerClusterNode;
import com.oracle.svm.util.LogUtils;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.internal.foreign.MemorySessionImpl;

public class SubstrateForeignUtil {
    @AlwaysInline(value="Compiler expects the code shape")
    public static void logExceptionSeen(Throwable e) {
        if (SubstrateOptions.printClosedArenaUponThrow()) {
            try {
                LogUtils.info((String)("Saw an exception in the cluster portion of the graph, message was=" + e.getMessage() + "\n"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @AlwaysInline(value="Compiler expects the code shape")
    public static <T> void checkIdentity(T actual, T expected) {
        if (actual != expected) {
            throw new IllegalArgumentException("Unexpected object");
        }
    }

    @AlwaysInline(value="factored out only for readability")
    public static void checkSession(MemorySessionImpl session) {
        if (session != null) {
            session.checkValidStateRaw();
        }
    }

    @AlwaysInline(value="factored out only for readability")
    public static void sessionExceptionHandler(MemorySessionImpl session, Object base, long offset) {
        long scope = ArenaIntrinsics.checkArenaValidInScope((MemorySessionImpl)session, (Object)base, (long)offset);
        if (scope != 0L) {
            ScopedMemExceptionHandlerClusterNode.ClusterBeginNode.beginExceptionCluster((long)scope);
            MemorySessionImpl clusterSession = ScopedMemExceptionHandlerClusterNode.ExceptionInputNode.clusterInputValue((long)scope, (MemorySessionImpl)session);
            if (clusterSession != null) {
                try {
                    clusterSession.checkValidStateRaw();
                }
                catch (Throwable e) {
                    SubstrateForeignUtil.logExceptionSeen(e);
                    throw ScopedMemExceptionHandlerClusterNode.ExceptionPathNode.endClusterExceptionPath((Throwable)e, (long)scope);
                }
            }
            ScopedMemExceptionHandlerClusterNode.RegularPathNode.endClusterNormalPath((long)scope);
        }
        GraalDirectives.controlFlowAnchor();
    }
}

