/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.foreign.ForeignFunctionsRuntime;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import java.util.function.BooleanSupplier;
import jdk.graal.compiler.options.OptionKey;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class ForeignAPIPredicates {

    public static final class SharedArenasDisabled
    implements BooleanSupplier {
        private static final String SHARED_ARENA_SUPPORT_OPTION_NAME = SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.SharedArenaSupport, (String)"+");

        @Platforms(value={Platform.HOSTED_ONLY.class})
        SharedArenasDisabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return !SharedArenasEnabled.getValue();
        }

        public static RuntimeException fail() {
            assert (!SharedArenasEnabled.getValue());
            throw VMError.unsupportedFeature((String)("Support for Arena.ofShared is not active: enable with " + SHARED_ARENA_SUPPORT_OPTION_NAME));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final class SharedArenasEnabled
    implements BooleanSupplier {
        public static boolean getValue() {
            return SubstrateOptions.isForeignAPIEnabled() && (Boolean)SubstrateOptions.SharedArenaSupport.getValue() != false;
        }

        @Override
        public boolean getAsBoolean() {
            return SharedArenasEnabled.getValue();
        }
    }

    public static final class FunctionCallsUnsupported
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return SubstrateOptions.isForeignAPIEnabled() && !ForeignFunctionsRuntime.areFunctionCallsSupported();
        }
    }

    public static final class FunctionCallsSupported
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return SubstrateOptions.isForeignAPIEnabled() && ForeignFunctionsRuntime.areFunctionCallsSupported();
        }
    }

    public static final class Enabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return SubstrateOptions.isForeignAPIEnabled();
        }
    }
}

