/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.common.option.CommonOptions;
import com.oracle.svm.core.FallbackExecutor;
import com.oracle.svm.core.NativeImageClassLoaderOptions;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.VM;
import com.oracle.svm.core.option.BundleMember;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.ArchiveSupport;
import com.oracle.svm.core.util.ClasspathUtils;
import com.oracle.svm.core.util.ExitStatus;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.driver.APIOptionHandler;
import com.oracle.svm.driver.ArgFilesOptionPreprocessor;
import com.oracle.svm.driver.BundleSupport;
import com.oracle.svm.driver.CmdLineOptionHandler;
import com.oracle.svm.driver.DefaultOptionHandler;
import com.oracle.svm.driver.MacroOption;
import com.oracle.svm.driver.MacroOptionHandler;
import com.oracle.svm.driver.MemoryUtil;
import com.oracle.svm.driver.WindowsBuildEnvironmentUtil;
import com.oracle.svm.driver.launcher.ContainerSupport;
import com.oracle.svm.driver.metainf.MetaInfFileType;
import com.oracle.svm.driver.metainf.NativeImageMetaInfResourceProcessor;
import com.oracle.svm.driver.metainf.NativeImageMetaInfWalker;
import com.oracle.svm.hosted.NativeImageGeneratorRunner;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.hosted.util.JDKArgsUtils;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.svm.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.module.FindException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import jdk.internal.jimage.ImageReader;
import org.graalvm.nativeimage.ProcessProperties;

public class NativeImage {
    private static final String DEFAULT_GENERATOR_CLASS_NAME = NativeImageGeneratorRunner.class.getName();
    private static final String DEFAULT_GENERATOR_MODULE_NAME = NativeImageGeneratorRunner.class.getModule().getName();
    private static final String DEFAULT_GENERATOR_9PLUS_SUFFIX = "$JDK9Plus";
    private static final String CUSTOM_SYSTEM_CLASS_LOADER = NativeImageSystemClassLoader.class.getCanonicalName();
    static final boolean IS_AOT = Boolean.getBoolean("com.oracle.graalvm.isaot");
    static final String platform = NativeImage.getPlatform();
    static final String graalvmVendor = VM.getVendor();
    static final String graalvmVendorUrl = VM.getVendorUrl();
    static final String graalvmVendorVersion = VM.getVendorVersion();
    private static final String ALL_UNNAMED = "ALL-UNNAMED";
    static final String graalvmVersion = System.getProperty("org.graalvm.version", "dev");
    private final Path driverTempDir;
    private static final String DRIVER_TEMP_DIR_PREFIX = "driverRoot-";
    static final Map<String, String[]> graalCompilerFlags = NativeImage.getCompilerFlags();
    final Map<String, String> systemPackagesToModules = NativeImage.getSystemPackages();
    private static final String usageText = NativeImage.getResource("/Usage.txt");
    final CmdLineOptionHandler cmdLineOptionHandler;
    final DefaultOptionHandler defaultOptionHandler;
    final APIOptionHandler apiOptionHandler;
    public static final String oH = "-H:";
    static final String oHEnabled = "-H:+";
    static final String oHDisabled = "-H:-";
    static final String oR = "-R:";
    final String enablePrintFlags = CommonOptions.PrintFlags.getName();
    final String enablePrintFlagsWithExtraHelp = CommonOptions.PrintFlagsWithExtraHelp.getName();
    final String oHModule = NativeImage.oH(SubstrateOptions.Module);
    final String oHClass = NativeImage.oH(SubstrateOptions.Class);
    final String oHName = NativeImage.oH(SubstrateOptions.Name);
    final String oHPath = NativeImage.oH(SubstrateOptions.ConcealedOptions.Path);
    final String oHUseLibC = NativeImage.oH(SubstrateOptions.UseLibC);
    final String oHEnableStaticExecutable = NativeImage.oHEnabled((OptionKey<Boolean>)SubstrateOptions.StaticExecutable);
    final String oHEnableSharedLibraryFlagPrefix = "-H:+" + SubstrateOptions.SharedLibrary.getName();
    final String oHEnableImageLayerFlagPrefix = "-H:" + SubstrateOptions.LayerCreate.getName();
    final String oHColor = NativeImage.oH(SubstrateOptions.Color);
    final String oHEnableBuildOutputProgress = NativeImage.oHEnabledByDriver((OptionKey<Boolean>)SubstrateOptions.BuildOutputProgress);
    final String oHEnableBuildOutputLinks = NativeImage.oHEnabledByDriver((OptionKey<Boolean>)SubstrateOptions.BuildOutputLinks);
    final String oHCLibraryPath = NativeImage.oH(SubstrateOptions.CLibraryPath);
    final String oHFallbackThreshold = NativeImage.oH(SubstrateOptions.FallbackThreshold);
    final String oHFallbackExecutorJavaArg = NativeImage.oH(FallbackExecutor.Options.FallbackExecutorJavaArg);
    final String oRRuntimeJavaArg = NativeImage.oR(FallbackExecutor.Options.FallbackExecutorRuntimeJavaArg);
    final String oHTraceClassInitialization = NativeImage.oH(SubstrateOptions.TraceClassInitialization);
    final String oHTraceObjectInstantiation = NativeImage.oH(SubstrateOptions.TraceObjectInstantiation);
    final String oHTargetPlatform = NativeImage.oH(SubstrateOptions.TargetPlatform);
    final String oHInspectServerContentPath = NativeImage.oH(PointstoOptions.InspectServerContentPath);
    final String oHDeadlockWatchdogInterval = NativeImage.oH(SubstrateOptions.DeadlockWatchdogInterval);
    final String oHLayerCreate = NativeImage.oH(SubstrateOptions.LayerCreate);
    final Map<String, String> imageBuilderEnvironment = new HashMap<String, String>();
    private final ArrayList<String> imageBuilderArgs = new ArrayList();
    private final Set<String> imageBuilderUniqueLeftoverArgs = Collections.newSetFromMap(new IdentityHashMap());
    private final LinkedHashSet<Path> imageBuilderModulePath = new LinkedHashSet();
    private final LinkedHashSet<Path> imageBuilderClasspath = new LinkedHashSet();
    private final LinkedHashSet<Path> imageProvidedJars = new LinkedHashSet();
    private final ArrayList<String> imageBuilderJavaArgs = new ArrayList();
    private final LinkedHashSet<Path> imageClasspath = new LinkedHashSet();
    private final LinkedHashSet<Path> imageModulePath = new LinkedHashSet();
    private final ArrayList<String> customJavaArgs = new ArrayList();
    private final LinkedHashSet<Path> customImageClasspath = new LinkedHashSet();
    private final ArrayList<OptionHandler<? extends NativeImage>> optionHandlers = new ArrayList();
    protected final BuildConfiguration config;
    final Map<String, String> userConfigProperties = new HashMap<String, String>();
    private final Map<String, String> propertyFileSubstitutionValues = new HashMap<String, String>();
    private int verbose = Boolean.valueOf(System.getenv("VERBOSE_GRAALVM_LAUNCHERS")) != false ? 1 : 0;
    private boolean diagnostics = false;
    Path diagnosticsDir;
    private boolean jarOptionMode = false;
    private boolean moduleOptionMode = false;
    private boolean dryRun = false;
    private String printFlagsOptionQuery = null;
    private String printFlagsWithExtraHelpOptionQuery = null;
    final MacroOption.Registry optionRegistry;
    private final List<ExcludeConfig> excludedConfigs = new ArrayList<ExcludeConfig>();
    private final LinkedHashSet<String> addModules = new LinkedHashSet();
    private final LinkedHashSet<String> limitModules = new LinkedHashSet();
    private long imageBuilderPid = -1L;
    BundleSupport bundleSupport;
    private final ArchiveSupport archiveSupport;
    private final DriverMetaInfProcessor metaInfProcessor;
    static final String CONFIG_FILE_ENV_VAR_KEY = "NATIVE_IMAGE_CONFIG_FILE";
    private List<String> defaultNativeImageArgs = null;
    private String targetPlatform = null;
    boolean buildExecutable;
    String targetLibC;
    String mainClass;
    String mainClassModule;
    String imageName;
    Path imagePath;
    protected static Function<BuildConfiguration, NativeImage> defaultNativeImageProvider = NativeImage::new;
    static final String MANY_SPACES_REGEX = "\\s+";

    private static String getPlatform() {
        return (OS.getCurrent().className + "-" + SubstrateUtil.getArchitectureName()).toLowerCase(Locale.ROOT);
    }

    private static Map<String, String[]> getCompilerFlags() {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (String versionTag : NativeImage.getResource(NativeImage.flagsFileName("versions")).split("\n")) {
            result.put(versionTag, NativeImage.getResource(NativeImage.flagsFileName(versionTag)).split("\n"));
        }
        return result;
    }

    private static String flagsFileName(String versionTag) {
        return "/graal-compiler-flags-" + versionTag + ".config";
    }

    private static Map<String, String> getSystemPackages() {
        HashMap<String, String> res = new HashMap<String, String>();
        for (ModuleReference moduleRef : ModuleFinder.ofSystem().findAll()) {
            ModuleDescriptor moduleDescriptor = moduleRef.descriptor();
            for (String packageName : moduleDescriptor.packages()) {
                res.put(packageName, moduleDescriptor.name());
            }
        }
        return Map.copyOf(res);
    }

    static String getResource(String resourceName) {
        String string;
        block8: {
            InputStream input = NativeImage.class.getResourceAsStream(resourceName);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
                String resourceString = reader.lines().collect(Collectors.joining("\n"));
                string = resourceString.replace("%pathsep%", File.pathSeparator);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    VMError.shouldNotReachHere((Throwable)e);
                    return null;
                }
            }
            input.close();
        }
        return string;
    }

    private static <T> String oH(OptionKey<T> option) {
        return oH + option.getName() + "=";
    }

    private static <T> String oH(OptionKey<T> option, String origin) {
        VMError.guarantee((origin != null && !origin.contains("=") ? 1 : 0) != 0);
        return oH + option.getName() + "@" + origin + "=";
    }

    private static String oHEnabled(OptionKey<Boolean> option) {
        return oHEnabled + option.getName();
    }

    private static String oHEnabledByDriver(OptionKey<Boolean> option) {
        return NativeImage.oHEnabled(option) + "@driver";
    }

    private static String oHDisabled(OptionKey<Boolean> option) {
        return oHDisabled + option.getName();
    }

    private static <T> String oR(OptionKey<T> option) {
        return oR + option.getName() + "=";
    }

    private ArrayList<String> createFallbackBuildArgs() {
        Path imagePathPath;
        ArrayList<String> buildArgs = new ArrayList<String>();
        buildArgs.add(NativeImage.oHEnabled((OptionKey<Boolean>)SubstrateOptions.UnlockExperimentalVMOptions));
        Collection fallbackSystemProperties = this.customJavaArgs.stream().filter(s -> s.startsWith("-D")).collect(Collectors.toCollection(LinkedHashSet::new));
        String fallbackExecutorSystemPropertyOption = NativeImage.oH(FallbackExecutor.Options.FallbackExecutorSystemProperty);
        for (String property : fallbackSystemProperties) {
            buildArgs.add(NativeImage.injectHostedOptionOrigin(fallbackExecutorSystemPropertyOption + property, "driver"));
        }
        List<String> runtimeJavaArgs = this.imageBuilderArgs.stream().filter(s -> s.startsWith(this.oRRuntimeJavaArg)).toList();
        buildArgs.addAll(runtimeJavaArgs);
        List<String> fallbackExecutorJavaArgs = this.imageBuilderArgs.stream().filter(s -> s.startsWith(this.oHFallbackExecutorJavaArg)).toList();
        buildArgs.addAll(fallbackExecutorJavaArgs);
        buildArgs.add(NativeImage.oHEnabled((OptionKey<Boolean>)SubstrateOptions.BuildOutputSilent));
        buildArgs.add(NativeImage.oHEnabled((OptionKey<Boolean>)SubstrateOptions.ParseRuntimeOptions));
        try {
            imagePathPath = this.canonicalize(this.imagePath);
        }
        catch (NativeImageError | InvalidPathException e) {
            throw NativeImage.showError("The given " + this.oHPath + String.valueOf(this.imagePath) + " argument does not specify a valid path", e);
        }
        boolean[] isPortable = new boolean[]{true};
        String classpathString = this.imageClasspath.stream().map(path -> {
            try {
                return imagePathPath.relativize((Path)path);
            }
            catch (IllegalArgumentException e) {
                isPortable[0] = false;
                return path;
            }
        }).map(Path::toString).collect(Collectors.joining(File.pathSeparator));
        if (!isPortable[0]) {
            LogUtils.warning((String)"The produced fallback image will not be portable, because not all classpath entries could be relativized (e.g., they are on another drive).");
        }
        buildArgs.add(this.oHPath + imagePathPath.toString());
        buildArgs.add(NativeImage.oH(FallbackExecutor.Options.FallbackExecutorClasspath) + classpathString);
        buildArgs.add(NativeImage.oH(FallbackExecutor.Options.FallbackExecutorMainClass) + this.mainClass);
        buildArgs.add(NativeImage.oHDisabled((OptionKey<Boolean>)SubstrateOptions.UnlockExperimentalVMOptions));
        buildArgs.add(NativeImage.oHDisabled((OptionKey<Boolean>)SubstrateOptions.DetectUserDirectoriesInImageHeap));
        buildArgs.add(FallbackExecutor.class.getName());
        buildArgs.add(this.imageName);
        this.defaultOptionHandler.addFallbackBuildArgs(buildArgs);
        for (OptionHandler<? extends NativeImage> handler : this.optionHandlers) {
            handler.addFallbackBuildArgs(buildArgs);
        }
        return buildArgs;
    }

    protected NativeImage(BuildConfiguration config) {
        this.config = config;
        this.metaInfProcessor = new DriverMetaInfProcessor();
        this.archiveSupport = new ArchiveSupport(this.isVerbose());
        String configFile = System.getenv(CONFIG_FILE_ENV_VAR_KEY);
        if (configFile != null && !configFile.isEmpty()) {
            try {
                this.userConfigProperties.putAll(ArchiveSupport.loadProperties((Path)this.canonicalize(Paths.get(configFile, new String[0]))));
            }
            catch (NativeImageError | Exception e) {
                NativeImage.showError("Invalid environment variable NATIVE_IMAGE_CONFIG_FILE", e);
            }
        }
        this.addPlainImageBuilderArg(this.oHPath + String.valueOf(config.getWorkingDirectory()), "driver");
        this.optionRegistry = new MacroOption.Registry();
        this.optionRegistry.addMacroOptionRoot(config.rootDir);
        this.optionRegistry.addMacroOptionRoot(config.rootDir.resolve(Paths.get("lib", "svm")));
        this.cmdLineOptionHandler = new CmdLineOptionHandler(this);
        this.defaultOptionHandler = new DefaultOptionHandler(this);
        this.registerOptionHandler(this.defaultOptionHandler);
        this.apiOptionHandler = new APIOptionHandler(this);
        this.registerOptionHandler(this.apiOptionHandler);
        this.registerOptionHandler(new MacroOptionHandler(this));
        this.driverTempDir = config.driverTempDir != null ? config.driverTempDir : this.archiveSupport.createTempDir(DRIVER_TEMP_DIR_PREFIX, new AtomicBoolean(true));
        config.setDriverTempDir(this.driverTempDir);
    }

    void addMacroOptionRoot(Path configDir) {
        Path origRootDir = this.canonicalize(configDir);
        Path rootDir = this.useBundle() ? this.bundleSupport.substituteClassPath(origRootDir) : origRootDir;
        this.optionRegistry.addMacroOptionRoot(rootDir);
    }

    protected void registerOptionHandler(OptionHandler<? extends NativeImage> handler) {
        this.optionHandlers.add(handler);
    }

    private List<String> getDefaultNativeImageArgs() {
        if (this.defaultNativeImageArgs == null) {
            ArrayList args = new ArrayList();
            String propertyOptions = this.userConfigProperties.get("NativeImageArgs");
            if (propertyOptions != null) {
                Collections.addAll(args, propertyOptions.split(" +"));
            }
            String envVarName = "NATIVE_IMAGE_OPTIONS";
            String nativeImageOptionsValue = System.getenv("NATIVE_IMAGE_OPTIONS");
            if (nativeImageOptionsValue != null) {
                args.addAll(JDKArgsUtils.parseArgsFromEnvVar((String)nativeImageOptionsValue, (String)"NATIVE_IMAGE_OPTIONS", msg -> NativeImage.showError(msg)));
            }
            if (!args.isEmpty()) {
                String buildApplyOptionName = BundleSupport.BundleOptionVariants.apply.optionName();
                if (this.config.getBuildArgs().stream().noneMatch(arg -> arg.startsWith(buildApplyOptionName + "="))) {
                    if (nativeImageOptionsValue != null) {
                        LogUtils.info((String)"Picked up NATIVE_IMAGE_OPTIONS", (String)nativeImageOptionsValue);
                    }
                    this.defaultNativeImageArgs = List.copyOf(args);
                } else {
                    LogUtils.warning((String)("Option '" + buildApplyOptionName + "' in use. Ignoring environment variables NATIVE_IMAGE_OPTIONS and NATIVE_IMAGE_CONFIG_FILE."));
                }
            } else {
                this.defaultNativeImageArgs = List.of();
            }
        }
        return this.defaultNativeImageArgs;
    }

    static void ensureDirectoryExists(Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                throw NativeImage.showError("File " + String.valueOf(dir) + " is not a directory");
            }
        } else {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw NativeImage.showError("Could not create directory " + String.valueOf(dir));
            }
        }
    }

    private void prepareImageBuildArgs() {
        this.addImageBuilderJavaArgs("-Xss10m");
        this.addImageBuilderJavaArgs(MemoryUtil.determineMemoryFlags(this.config.getHostFlags()));
        this.addImageBuilderJavaArgs("-Djava.awt.headless=true");
        this.addImageBuilderJavaArgs("-Dorg.graalvm.vendor=" + graalvmVendor);
        this.addImageBuilderJavaArgs("-Dorg.graalvm.vendorurl=" + graalvmVendorUrl);
        this.addImageBuilderJavaArgs("-Dorg.graalvm.vendorversion=" + graalvmVendorVersion);
        this.addImageBuilderJavaArgs("-Dorg.graalvm.version=" + graalvmVersion);
        this.addImageBuilderJavaArgs("-Dcom.oracle.graalvm.isaot=true");
        this.addImageBuilderJavaArgs("-Djava.system.class.loader=" + CUSTOM_SYSTEM_CLASS_LOADER);
        this.addImageBuilderJavaArgs("-Dorg.graalvm.nativeimage.imagecode=buildtime");
        this.addImageBuilderJavaArgs("-Xshare:off");
        this.config.getImageClasspath().forEach(this::addCustomImageClasspath);
    }

    private void completeOptionArgs() {
        LinkedHashSet<MacroOption.EnabledOption> enabledOptions = this.optionRegistry.getEnabledOptions();
        if (!enabledOptions.isEmpty()) {
            this.addPlainImageBuilderArg(this.oHFallbackThreshold + "0", "driver");
        }
        NativeImage.consolidateListArgs(this.imageBuilderJavaArgs, "-Dpolyglot.engine.PreinitializeContexts=", ",", Function.identity());
        NativeImage.consolidateListArgs(this.imageBuilderJavaArgs, "-Dpolyglot.image-build-time.PreinitializeContexts=", ",", Function.identity());
    }

    protected static void replaceArg(Collection<String> args, String argPrefix, String argSuffix) {
        args.removeIf(arg -> arg.startsWith(argPrefix));
        args.add(argPrefix + argSuffix);
    }

    private static LinkedHashSet<String> collectListArgs(Collection<String> args, String argPrefix, String delimiter) {
        LinkedHashSet<String> allEntries = new LinkedHashSet<String>();
        for (String arg : args) {
            String argEntriesRaw;
            if (!arg.startsWith(argPrefix) || (argEntriesRaw = arg.substring(argPrefix.length())).isEmpty()) continue;
            allEntries.addAll(Arrays.asList(argEntriesRaw.split(delimiter)));
        }
        return allEntries;
    }

    private static void consolidateListArgs(Collection<String> args, String argPrefix, String delimiter, Function<String, String> mapFunc) {
        LinkedHashSet<String> allEntries = NativeImage.collectListArgs(args, argPrefix, delimiter);
        if (!allEntries.isEmpty()) {
            NativeImage.replaceArg(args, argPrefix, allEntries.stream().map(mapFunc).collect(Collectors.joining(delimiter)));
        }
    }

    private boolean processClasspathNativeImageMetaInf(Path classpathEntry) {
        try {
            return NativeImageMetaInfWalker.walkMetaInfForCPEntry(classpathEntry, this.metaInfProcessor);
        }
        catch (NativeImageMetaInfWalker.MetaInfWalkException e) {
            throw NativeImage.showError(e.getMessage(), e.cause);
        }
    }

    public void addExcludeConfig(Pattern jarPattern, Pattern resourcePattern) {
        this.excludedConfigs.add(new ExcludeConfig(jarPattern, resourcePattern));
    }

    private static String injectHostedOptionOrigin(String option, String origin) {
        if (origin != null && option.startsWith(oH)) {
            char boolPrefix;
            String optionOriginSeparator = "@";
            int eqIndex = option.indexOf(61);
            char c = boolPrefix = option.length() > oH.length() ? option.charAt(oH.length()) : (char)'\u0000';
            if (boolPrefix == '-' || boolPrefix == '+') {
                if (eqIndex != -1) {
                    NativeImage.showError("Malformed boolean native-image hosted-option '" + option + "' (boolean option with extraneous '=') from " + String.valueOf(OptionOrigin.from((String)origin)) + ".");
                }
                return option + optionOriginSeparator + origin;
            }
            if (eqIndex == -1) {
                NativeImage.showError("Malformed native-image hosted-option '" + option + "' ('=' missing after option name) from " + String.valueOf(OptionOrigin.from((String)origin)) + ".");
            }
            String front = option.substring(0, eqIndex);
            String back = option.substring(eqIndex);
            return front + optionOriginSeparator + origin + back;
        }
        return option;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean processJarManifestMainAttributes(Path jarFilePath, BiConsumer<Path, Attributes> manifestConsumer) {
        try (JarFile jarFile = new JarFile(jarFilePath.toFile());){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                boolean bl = false;
                return bl;
            }
            manifestConsumer.accept(jarFilePath, manifest.getMainAttributes());
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw NativeImage.showError("Invalid or corrupt jarfile " + String.valueOf(jarFilePath), e);
        }
    }

    void handleManifestFileAttributes(Path jarFilePath, Attributes mainAttributes) {
        this.handleMainClassAttribute(jarFilePath, mainAttributes);
        this.handleModuleAttributes(mainAttributes);
        this.handleEnableNativeAccessAttribute(mainAttributes);
    }

    void handleMainClassAttribute(Path jarFilePath, Attributes mainAttributes) {
        String mainClassValue = mainAttributes.getValue("Main-Class");
        if (mainClassValue == null) {
            NativeImage.showError("No main manifest attribute, in " + String.valueOf(jarFilePath));
        }
        String origin = "manifest from " + String.valueOf(jarFilePath.toUri());
        this.addPlainImageBuilderArg(this.oHClass + mainClassValue, origin);
    }

    void handleModuleAttributes(Attributes mainAttributes) {
        String addExportsValues;
        String addOpensValues = mainAttributes.getValue("Add-Opens");
        if (addOpensValues != null) {
            this.handleModuleExports(addOpensValues, (OptionKey<?>)NativeImageClassLoaderOptions.AddOpens);
        }
        if ((addExportsValues = mainAttributes.getValue("Add-Exports")) != null) {
            this.handleModuleExports(addExportsValues, (OptionKey<?>)NativeImageClassLoaderOptions.AddExports);
        }
    }

    void handleEnableNativeAccessAttribute(Attributes mainAttributes) {
        String nativeAccessAttrName = mainAttributes.getValue("Enable-Native-Access");
        if (nativeAccessAttrName != null) {
            if (!ALL_UNNAMED.equals(nativeAccessAttrName)) {
                throw NativeImage.showError("illegal value \"" + nativeAccessAttrName + "\" for " + nativeAccessAttrName + " manifest attribute. Only ALL-UNNAMED is allowed");
            }
            this.addImageBuilderJavaArgs("--enable-native-access=ALL-UNNAMED");
        }
    }

    void handleClassPathAttribute(LinkedHashSet<Path> destination, Path jarFilePath, Attributes mainAttributes) {
        String classPathValue = mainAttributes.getValue("Class-Path");
        if (classPathValue != null) {
            Path origJarFilePath = null;
            for (String cp : classPathValue.split(" +")) {
                Path manifestClassPath = Path.of(cp, new String[0]);
                if (!manifestClassPath.isAbsolute()) {
                    Path relativeManifestClassPath = manifestClassPath;
                    manifestClassPath = jarFilePath.getParent().resolve(relativeManifestClassPath);
                    if (this.useBundle() && !Files.exists(manifestClassPath, new LinkOption[0])) {
                        if (origJarFilePath == null) {
                            origJarFilePath = this.bundleSupport.originalPath(jarFilePath);
                        }
                        if (origJarFilePath == null) {
                            assert (false) : "Manifest Class-Path handling failed. No original path for " + String.valueOf(jarFilePath) + " available.";
                            break;
                        }
                        manifestClassPath = origJarFilePath.getParent().resolve(relativeManifestClassPath);
                    }
                }
                this.addImageClasspathEntry(destination, manifestClassPath.normalize(), false);
            }
        }
    }

    private void handleModuleExports(String modulesValues, OptionKey<?> option) {
        String[] modules;
        for (String fromModule : modules = modulesValues.split(" ")) {
            this.addPlainImageBuilderArg(NativeImage.oH(option) + fromModule + "=ALL-UNNAMED");
        }
    }

    private Stream<Path> resolveTargetSpecificPaths(Path base) {
        Stream.Builder<Path> builder = Stream.builder();
        String clibrariesPath = this.targetPlatform != null ? this.targetPlatform : platform;
        Path osArch = base.resolve(clibrariesPath);
        if (this.targetLibC != null) {
            builder.add(osArch.resolve(this.targetLibC));
        }
        builder.add(osArch);
        builder.add(base);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int completeImageBuild() {
        Optional<ArgumentEntry> fallbackThresholdEntry;
        String imageBuildID;
        this.processNativeImageArgs();
        this.apiOptionHandler.validateExperimentalOptions();
        this.config.getBuilderClasspath().forEach(this::addImageBuilderClasspath);
        if (this.config.getBuilderInspectServerPath() != null) {
            this.addPlainImageBuilderArg(this.oHInspectServerContentPath + String.valueOf(this.config.getBuilderInspectServerPath()));
        }
        this.config.getBuilderModulePath().forEach(this::addImageBuilderModulePath);
        String upgradeModulePath = this.config.getBuilderUpgradeModulePath().stream().map(p -> this.canonicalize((Path)p).toString()).collect(Collectors.joining(File.pathSeparator));
        if (!upgradeModulePath.isEmpty()) {
            this.addImageBuilderJavaArgs(Arrays.asList("--upgrade-module-path", upgradeModulePath));
        }
        this.completeOptionArgs();
        this.addTargetArguments();
        String defaultLibC = OS.getCurrent() == OS.LINUX ? "glibc" : null;
        this.targetLibC = NativeImage.getHostedOptionArgument(this.imageBuilderArgs, this.oHUseLibC).map(ArgumentEntry::value).orElse(System.getProperty("substratevm.HostLibC", defaultLibC));
        String clibrariesBuilderArg = this.config.getBuilderCLibrariesPaths().stream().flatMap(this::resolveTargetSpecificPaths).map(Path::toString).collect(Collectors.joining(",", this.oHCLibraryPath, ""));
        this.imageBuilderArgs.add(0, clibrariesBuilderArg);
        boolean printFlags = false;
        if (this.printFlagsOptionQuery != null) {
            printFlags = true;
            this.addPlainImageBuilderArg(oH + this.enablePrintFlags + "=" + this.printFlagsOptionQuery);
            this.addPlainImageBuilderArg(oR + this.enablePrintFlags + "=" + this.printFlagsOptionQuery);
        } else if (this.printFlagsWithExtraHelpOptionQuery != null) {
            printFlags = true;
            this.addPlainImageBuilderArg(oH + this.enablePrintFlagsWithExtraHelp + "=" + this.printFlagsWithExtraHelpOptionQuery);
            this.addPlainImageBuilderArg(oR + this.enablePrintFlagsWithExtraHelp + "=" + this.printFlagsWithExtraHelpOptionQuery);
        }
        if (this.shouldAddCWDToCP()) {
            if (this.useBundle()) {
                throw NativeImage.showError("Bundle support requires -cp or -p to be set (implicit current directory classpath unsupported).");
            }
            this.addImageClasspath(Paths.get(".", new String[0]));
        }
        this.imageClasspath.addAll(this.customImageClasspath);
        this.imageBuilderJavaArgs.add("-Djdk.internal.lambda.disableEagerInitialization=true");
        this.imageBuilderJavaArgs.add("-Djdk.internal.lambda.eagerlyInitialize=false");
        this.imageBuilderJavaArgs.add("-Djava.lang.invoke.InnerClassLambdaMetafactory.initializeLambdas=false");
        this.imageBuilderJavaArgs.add("-Djava.lang.invoke.MethodHandle.DONT_INLINE_THRESHOLD=-1");
        this.imageBuilderJavaArgs.add("-Djava.lang.invoke.MethodHandle.PROFILE_GWT=false");
        boolean afterOption = false;
        for (String arg2 : this.customJavaArgs) {
            if (arg2.startsWith("-")) {
                afterOption = true;
                continue;
            }
            if (!afterOption) {
                NativeImage.showError("Found invalid image builder Java VM argument: " + arg2);
                continue;
            }
            afterOption = false;
        }
        this.addImageBuilderJavaArgs(this.customJavaArgs.toArray(new String[0]));
        this.imageBuilderJavaArgs.addAll(this.getAgentArguments());
        Optional<ArgumentEntry> lastMainClass = NativeImage.getHostedOptionArgument(this.imageBuilderArgs, this.oHClass);
        this.mainClass = lastMainClass.map(ArgumentEntry::value).orElse(null);
        this.buildExecutable = this.imageBuilderArgs.stream().noneMatch(arg -> arg.startsWith(this.oHEnableSharedLibraryFlagPrefix) || arg.startsWith(this.oHEnableImageLayerFlagPrefix));
        boolean staticExecutable = this.imageBuilderArgs.stream().anyMatch(arg -> arg.contains(this.oHEnableStaticExecutable));
        if (this.useBundle() && this.bundleSupport.useContainer && staticExecutable) {
            this.showMessage("Native Image Bundles: Skipping containerized build, not supported for --static.");
            this.bundleSupport.useContainer = false;
        }
        boolean listModules = this.imageBuilderArgs.stream().anyMatch(arg -> arg.contains("-H:+ListModules"));
        if ((printFlags |= this.imageBuilderArgs.stream().anyMatch(arg -> arg.matches("-H:MicroArchitecture(@[^=]*)?=list"))) || listModules) {
            this.addPlainImageBuilderArg(this.oHName + "dummy-image");
        } else {
            ArrayList<ArgumentEntry> extraImageArgs = new ArrayList<ArgumentEntry>();
            int imageBuilderArgsSize = this.imageBuilderArgs.size();
            for (int i = 0; i < imageBuilderArgsSize; ++i) {
                String builderArg = this.imageBuilderArgs.get(i);
                if (!this.imageBuilderUniqueLeftoverArgs.contains(builderArg)) continue;
                extraImageArgs.add(new ArgumentEntry(i, builderArg));
            }
            Optional<ArgumentEntry> lastImageName = NativeImage.getHostedOptionArgument(this.imageBuilderArgs, this.oHName);
            if (!lastImageName.isEmpty()) {
                NativeImage.validateImageName(lastImageName.get().value());
            }
            if (!this.jarOptionMode) {
                boolean hasMainClass;
                this.mainClassModule = NativeImage.getHostedOptionArgumentValue(this.imageBuilderArgs, this.oHModule);
                boolean hasMainClassModule = this.mainClassModule != null && !this.mainClassModule.isEmpty();
                boolean bl = hasMainClass = this.mainClass != null && !this.mainClass.isEmpty();
                if (extraImageArgs.isEmpty()) {
                    if (this.buildExecutable && !hasMainClassModule && !hasMainClass && !listModules) {
                        String moduleMsg = this.config.modulePathBuild ? " (or <module>/<mainclass>)" : "";
                        NativeImage.showError("Please specify class" + moduleMsg + " containing the main entry point method. (see --help)");
                    }
                } else if (!this.moduleOptionMode) {
                    boolean extraMainClassIsLast;
                    ArgumentEntry extraMainClass = (ArgumentEntry)extraImageArgs.removeFirst();
                    boolean bl2 = extraMainClassIsLast = lastMainClass.isEmpty() || lastMainClass.get().index < extraMainClass.index;
                    if (extraMainClassIsLast) {
                        hasMainClass = true;
                        this.mainClass = extraMainClass.value;
                        this.imageBuilderArgs.add(NativeImage.oH(SubstrateOptions.Class, "explicit main-class") + this.mainClass);
                    }
                }
                if (extraImageArgs.isEmpty()) {
                    if (lastImageName.isEmpty()) {
                        if (hasMainClass) {
                            this.imageBuilderArgs.add(NativeImage.oH(SubstrateOptions.Name, "main-class lower case as image name") + this.mainClass.toLowerCase(Locale.ROOT));
                        } else if (hasMainClassModule) {
                            this.imageBuilderArgs.add(NativeImage.oH(SubstrateOptions.Name, "image-name from module-name") + this.mainClassModule.toLowerCase(Locale.ROOT));
                        } else if (!listModules) {
                            throw NativeImage.showError("Missing image-name. Use -o <imagename> to provide one.");
                        }
                    }
                } else {
                    boolean extraNameIsLast;
                    ArgumentEntry extraImageName = (ArgumentEntry)extraImageArgs.removeFirst();
                    boolean bl3 = extraNameIsLast = lastImageName.isEmpty() || lastImageName.get().index < extraImageName.index;
                    if (extraNameIsLast) {
                        this.imageBuilderArgs.add(NativeImage.oH(SubstrateOptions.Name, "explicit image name") + NativeImage.validateImageName(extraImageName.value));
                    }
                }
            } else if (!extraImageArgs.isEmpty()) {
                boolean extraNameIsLast;
                ArgumentEntry extraImageName = (ArgumentEntry)extraImageArgs.removeFirst();
                boolean bl = extraNameIsLast = lastImageName.isEmpty() || lastImageName.get().index < extraImageName.index;
                if (extraNameIsLast) {
                    this.imageBuilderArgs.add(NativeImage.oH(SubstrateOptions.Name, "explicit image name") + extraImageName.value);
                }
            }
            if (this.mainClass != null && !this.mainClass.isEmpty() && !Character.isJavaIdentifierStart(this.mainClass.charAt(0))) {
                NativeImage.showError("'%s' is not a valid mainclass. Specify a valid classname for the class that contains the main method.".formatted(this.mainClass));
            }
            if (!extraImageArgs.isEmpty()) {
                NativeImage.showError("Unrecognized option(s): " + StringUtil.joinSingleQuoted(extraImageArgs.stream().map(ArgumentEntry::value).toList()));
            }
            this.imageBuilderArgs.removeIf(this.imageBuilderUniqueLeftoverArgs::contains);
            this.imageBuilderUniqueLeftoverArgs.clear();
        }
        ArgumentEntry imageNameEntry = NativeImage.getHostedOptionArgument(this.imageBuilderArgs, this.oHName).orElseThrow();
        this.imageName = imageNameEntry.value;
        ArgumentEntry imagePathEntry = NativeImage.getHostedOptionArgument(this.imageBuilderArgs, this.oHPath).orElseThrow();
        this.imagePath = Path.of(imagePathEntry.value, new String[0]);
        Path imageNamePath = Path.of(this.imageName, new String[0]);
        Path imageNamePathParent = imageNamePath.getParent();
        if (imageNamePathParent != null) {
            this.imageName = imageNamePath.getFileName().toString();
            if (!imageNamePathParent.isAbsolute()) {
                imageNamePathParent = this.imagePath.resolve(imageNamePathParent);
            }
            if (!this.useBundle()) {
                if (!Files.isDirectory(imageNamePathParent, new LinkOption[0])) {
                    throw NativeImage.showError("Writing image to non-existent directory " + String.valueOf(imageNamePathParent) + " is not allowed. Create the missing directory if you want the image to be written to that location.");
                }
                if (!Files.isWritable(imageNamePathParent)) {
                    throw NativeImage.showError("Writing image to directory without write access " + String.valueOf(imageNamePathParent) + " is not possible. Ensure the directory has write access or specify image path with write access.");
                }
            }
            this.imagePath = imageNamePathParent;
            NativeImage.updateArgumentEntryValue(this.imageBuilderArgs, imageNameEntry, this.imageName);
            NativeImage.updateArgumentEntryValue(this.imageBuilderArgs, imagePathEntry, this.imagePath.toString());
        }
        if (this.useBundle()) {
            imageBuildID = this.bundleSupport.getImageBuildID();
            Object bundleName = this.imageName.endsWith(".nib") ? this.imageName : this.imageName + ".nib";
            this.bundleSupport.updateBundleLocation(this.imagePath.resolve((String)bundleName), false);
            this.imagePath = this.bundleSupport.substituteImagePath(this.imagePath);
            NativeImage.updateArgumentEntryValue(this.imageBuilderArgs, imagePathEntry, this.imagePath.toString());
        } else {
            String value = this.getNativeImageArgs().toString();
            imageBuildID = SubstrateUtil.getUUIDFromString((String)value).toString();
        }
        this.addPlainImageBuilderArg(NativeImage.oH(SubstrateOptions.ImageBuildID, "driver") + imageBuildID);
        LinkedHashSet<Path> finalImageModulePath = new LinkedHashSet<Path>(this.imageModulePath);
        LinkedHashSet<Path> finalImageClasspath = new LinkedHashSet<Path>(this.imageClasspath);
        LinkedHashSet<Path> finalImageProvidedJars = new LinkedHashSet<Path>(this.imageProvidedJars);
        if (this.config.modulePathBuild) {
            finalImageProvidedJars.addAll(this.config.getImageProvidedModulePath());
            finalImageModulePath.addAll(finalImageProvidedJars);
        } else {
            finalImageProvidedJars.addAll(this.config.getImageProvidedClasspath());
            finalImageClasspath.addAll(finalImageProvidedJars);
        }
        finalImageProvidedJars.forEach(this::processClasspathNativeImageMetaInf);
        if (!this.config.buildFallbackImage() && (fallbackThresholdEntry = NativeImage.getHostedOptionArgument(this.imageBuilderArgs, this.oHFallbackThreshold)).isPresent() && fallbackThresholdEntry.get().value.equals("10")) {
            return ExitStatus.FALLBACK_IMAGE.getValue();
        }
        if (!this.limitModules.isEmpty()) {
            this.imageBuilderJavaArgs.add("-Dsvm.modulesupport.limitedModules=" + String.join((CharSequence)",", this.limitModules));
        }
        if (this.config.modulePathBuild && !finalImageClasspath.isEmpty()) {
            this.imageBuilderJavaArgs.add("--add-modules=ALL-DEFAULT");
        }
        Set<String> enableNativeAccessModules = this.getModulesFromPath(this.imageBuilderModulePath).keySet();
        this.imageBuilderJavaArgs.add("--enable-native-access=" + String.join((CharSequence)",", enableNativeAccessModules));
        boolean useColorfulOutput = this.configureBuildOutput();
        List<String> finalImageBuilderJavaArgs = Stream.concat(this.config.getBuilderJavaArgs().stream(), this.imageBuilderJavaArgs.stream()).collect(Collectors.toList());
        try {
            int n = this.buildImage(finalImageBuilderJavaArgs, this.imageBuilderClasspath, this.imageBuilderModulePath, this.imageBuilderArgs, finalImageClasspath, finalImageModulePath);
            return n;
        }
        finally {
            if (useColorfulOutput) {
                this.performANSIReset();
            }
        }
    }

    private static String validateImageName(String imageName) {
        if (imageName.startsWith("-")) {
            LogUtils.warning((String)("Image name ('" + imageName + "') start with a dash. Is another option wrongly interpreted as image name? (see --help)"));
        }
        return imageName;
    }

    private static void updateArgumentEntryValue(List<String> argList, ArgumentEntry listEntry, String newValue) {
        APIOptionHandler.BuilderArgumentParts argParts = APIOptionHandler.BuilderArgumentParts.from(argList.get(listEntry.index));
        argParts.optionValue = newValue;
        argList.set(listEntry.index, argParts.toString());
    }

    private static String getLocationAgnosticArgPrefix(String argPrefix) {
        VMError.guarantee((argPrefix.startsWith(oH) && argPrefix.endsWith("=") ? 1 : 0) != 0, (String)"argPrefix has to be a hosted option that ends with \"=\"");
        return "^" + argPrefix.substring(0, argPrefix.length() - 1) + "(@[^=]*)?=";
    }

    private static String getHostedOptionArgumentValue(List<String> args, String argPrefix) {
        return NativeImage.getHostedOptionArgument(args, argPrefix).map(entry -> entry.value).orElse(null);
    }

    private static Optional<ArgumentEntry> getHostedOptionArgument(List<String> args, String argPrefix) {
        List<ArgumentEntry> values = NativeImage.getHostedOptionArgumentValues(args, argPrefix);
        return values.isEmpty() ? Optional.empty() : Optional.of(values.getLast());
    }

    private static List<ArgumentEntry> getHostedOptionArgumentValues(List<String> args, String argPrefix) {
        ArrayList<ArgumentEntry> values = new ArrayList<ArgumentEntry>();
        String locationAgnosticArgPrefix = NativeImage.getLocationAgnosticArgPrefix(argPrefix);
        Pattern pattern = Pattern.compile(locationAgnosticArgPrefix);
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            Matcher matcher = pattern.matcher(arg);
            if (!matcher.find()) continue;
            values.add(new ArgumentEntry(i, arg.substring(matcher.group().length())));
        }
        return values;
    }

    private static Boolean getHostedOptionBooleanArgumentValue(List<String> args, OptionKey<Boolean> option) {
        String locationAgnosticBooleanPattern = "^-H:[+-]" + option.getName() + "(@[^=]*)?$";
        Pattern pattern = Pattern.compile(locationAgnosticBooleanPattern);
        Boolean result = null;
        for (String arg : args) {
            Matcher matcher = pattern.matcher(arg);
            if (!matcher.find()) continue;
            result = arg.startsWith(oHEnabled);
        }
        return result;
    }

    private boolean shouldAddCWDToCP() {
        if (this.config.buildFallbackImage() || this.printFlagsOptionQuery != null || this.printFlagsWithExtraHelpOptionQuery != null) {
            return false;
        }
        Optional<MacroOption.EnabledOption> explicitMacroOption = this.optionRegistry.getEnabledOptions(OptionUtils.MacroOptionKind.Macro).stream().filter(MacroOption.EnabledOption::isEnabledFromCommandline).findAny();
        if (explicitMacroOption.isPresent()) {
            return false;
        }
        if (this.useBundle() && this.bundleSupport.loadBundle) {
            return false;
        }
        return this.customImageClasspath.isEmpty() && this.imageModulePath.isEmpty();
    }

    private List<String> getAgentArguments() {
        ArrayList<String> args = new ArrayList<String>();
        Object agentOptions = "";
        List<ArgumentEntry> traceClassInitializationOpts = NativeImage.getHostedOptionArgumentValues(this.imageBuilderArgs, this.oHTraceClassInitialization);
        List<ArgumentEntry> traceObjectInstantiationOpts = NativeImage.getHostedOptionArgumentValues(this.imageBuilderArgs, this.oHTraceObjectInstantiation);
        if (!traceClassInitializationOpts.isEmpty()) {
            agentOptions = NativeImage.getAgentOptions(traceClassInitializationOpts, "c");
        }
        if (!traceObjectInstantiationOpts.isEmpty()) {
            if (!((String)agentOptions).isEmpty()) {
                agentOptions = (String)agentOptions + ",";
            }
            agentOptions = (String)agentOptions + NativeImage.getAgentOptions(traceObjectInstantiationOpts, "o");
        }
        if (!((String)agentOptions).isEmpty()) {
            if (this.useDebugAttach()) {
                throw NativeImage.showError("--debug-attach cannot be used with class initialization/object instantiation tracing (" + this.oHTraceClassInitialization + "/ + " + this.oHTraceObjectInstantiation + ").");
            }
            args.add("-agentlib:native-image-diagnostics-agent=" + (String)agentOptions);
        }
        return args;
    }

    private static String getAgentOptions(List<ArgumentEntry> options, String optionName) {
        return options.stream().flatMap(optValue -> Arrays.stream(optValue.value.split(","))).map(clazz -> optionName + "=" + clazz).collect(Collectors.joining(","));
    }

    private void addTargetArguments() {
        this.targetPlatform = NativeImage.getHostedOptionArgumentValue(this.imageBuilderArgs, this.oHTargetPlatform);
        if (this.targetPlatform == null) {
            return;
        }
        this.targetPlatform = this.targetPlatform.toLowerCase(Locale.ROOT);
        String[] parts = this.targetPlatform.split("-");
        if (parts.length != 2) {
            throw NativeImage.showError("--target argument must be in format <OS>-<architecture>");
        }
        String targetOS = parts[0];
        String targetArch = parts[1];
        if (this.customJavaArgs.stream().anyMatch(arg -> arg.startsWith("-Dsvm.platform="))) {
            LogUtils.warning((String)"Usage of -Dsvm.platform might conflict with --target parameter.");
        }
        if (targetOS != null) {
            this.customJavaArgs.add("-Dsvm.targetPlatformOS=" + targetOS);
        }
        if (targetArch != null) {
            this.customJavaArgs.add("-Dsvm.targetPlatformArch=" + targetArch);
        }
    }

    protected static List<String> createImageBuilderArgs(List<String> imageArgs, List<Path> imagecp, List<Path> imagemp) {
        ArrayList<String> result = new ArrayList<String>();
        if (!imagecp.isEmpty()) {
            result.add("-imagecp");
            result.add(imagecp.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
        }
        if (!imagemp.isEmpty()) {
            result.add("-imagemp");
            result.add(imagemp.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
        }
        result.addAll(imageArgs);
        return result;
    }

    protected Path createVMInvocationArgumentFile(List<String> arguments) {
        try {
            Path argsFile = this.createFileInTempDir("vminvocation.args");
            StringJoiner joiner = new StringJoiner("\n");
            for (String arg : arguments) {
                String quoted = SubstrateUtil.quoteShellArg((String)arg);
                if (quoted.startsWith("'")) {
                    quoted = quoted.replace("\\", "\\\\");
                }
                joiner.add(quoted);
            }
            String joinedOptions = joiner.toString();
            Files.write(argsFile, joinedOptions.getBytes(), new OpenOption[0]);
            return argsFile;
        }
        catch (IOException e) {
            throw NativeImage.showError(e.getMessage());
        }
    }

    protected Path createImageBuilderArgumentFile(List<String> imageBuilderArguments) {
        try {
            Path argsFile = this.createFileInTempDir("native-image.args");
            String joinedOptions = String.join((CharSequence)"\u0000", imageBuilderArguments);
            Files.write(argsFile, joinedOptions.getBytes(), new OpenOption[0]);
            return argsFile;
        }
        catch (IOException e) {
            throw NativeImage.showError(e.getMessage());
        }
    }

    protected int buildImage(List<String> javaArgs, LinkedHashSet<Path> cp, LinkedHashSet<Path> mp, ArrayList<String> imageArgs, LinkedHashSet<Path> imagecp, LinkedHashSet<Path> imagemp) {
        String javaExecutable;
        ArrayList<String> arguments = new ArrayList<String>(javaArgs);
        if (!cp.isEmpty()) {
            arguments.addAll(Arrays.asList("-cp", cp.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator))));
        }
        if (!mp.isEmpty()) {
            List<String> strings = Arrays.asList("--module-path", mp.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
            arguments.addAll(strings);
        }
        if (this.useBundle()) {
            LogUtils.warning((String)"Native Image Bundles are an experimental feature.");
        }
        BiFunction<Path, BundleMember.Role, Path> substituteAuxiliaryPath = this.useBundle() ? this.bundleSupport::substituteAuxiliaryPath : (a, b) -> a;
        Function<String, String> imageArgsTransformer = rawArg -> this.apiOptionHandler.transformBuilderArgument((String)rawArg, substituteAuxiliaryPath);
        List<String> finalImageArgs = imageArgs.stream().map(imageArgsTransformer).collect(Collectors.toList());
        Function substituteClassPath = this.useBundle() ? this.bundleSupport::substituteClassPath : Function.identity();
        List<Path> finalImageClassPath = imagecp.stream().map(substituteClassPath).collect(Collectors.toList());
        Function substituteModulePath = this.useBundle() ? this.bundleSupport::substituteModulePath : Function.identity();
        List<Path> localImageModulePath = imagemp.stream().map(substituteModulePath).collect(Collectors.toList());
        Map<String, Path> applicationModules = this.getModulesFromPath(localImageModulePath);
        if (!applicationModules.isEmpty()) {
            applicationModules.keySet().removeAll(this.getBuiltInModules());
            applicationModules.keySet().removeAll(this.getModulesFromPath(mp).keySet());
        }
        List<Path> finalImageModulePath = applicationModules.values().stream().toList();
        Set<String> implicitlyRequiredSystemModules = this.getImplicitlyRequiredSystemModules(finalImageModulePath);
        this.addModules.addAll(implicitlyRequiredSystemModules);
        if (!this.addModules.isEmpty()) {
            arguments.add("-Dsvm.modulesupport.addedModules=" + String.join((CharSequence)",", this.addModules));
            ArrayList<String> addModulesForBuilderVM = new ArrayList<String>();
            for (String moduleNameInAddModules : this.addModules) {
                if (applicationModules.containsKey(moduleNameInAddModules)) continue;
                addModulesForBuilderVM.add(moduleNameInAddModules);
            }
            if (!addModulesForBuilderVM.isEmpty()) {
                arguments.add("--add-modules=" + String.join((CharSequence)",", addModulesForBuilderVM));
            }
        }
        arguments.addAll(this.config.getGeneratorMainClass());
        Path keepAliveFile = OS.getCurrent().hasProcFS ? Path.of("/proc/" + ProcessHandle.current().pid() + "/comm", new String[0]) : this.createFileInTempDir(".native_image.alive");
        boolean useContainer = this.useBundle() && this.bundleSupport.useContainer;
        Path keepAliveFileInContainer = Path.of("/keep_alive", new String[0]);
        arguments.addAll(Arrays.asList("-keepalive", (useContainer ? keepAliveFileInContainer : keepAliveFile).toString()));
        List<String> finalImageBuilderArgs = NativeImage.createImageBuilderArgs(finalImageArgs, finalImageClassPath, finalImageModulePath);
        ArrayList<String> command = new ArrayList<String>();
        ArrayList<String> completeCommandList = new ArrayList<String>();
        if (useContainer) {
            ContainerSupport.replacePaths(arguments, this.config.getJavaHome(), this.bundleSupport.rootDir);
            ContainerSupport.replacePaths(finalImageBuilderArgs, this.config.getJavaHome(), this.bundleSupport.rootDir);
            Path binJava = Paths.get("bin", "java");
            javaExecutable = ContainerSupport.GRAAL_VM_HOME.resolve(binJava).toString();
        } else {
            javaExecutable = this.canonicalize(this.config.getJavaExecutable()).toString();
        }
        Path argFile = this.createVMInvocationArgumentFile(arguments);
        Path builderArgFile = this.createImageBuilderArgumentFile(finalImageBuilderArgs);
        if (useContainer) {
            if (!Files.exists(this.bundleSupport.containerSupport.dockerfile, new LinkOption[0])) {
                this.bundleSupport.createDockerfile(this.bundleSupport.containerSupport.dockerfile);
            }
            int exitStatusCode = this.bundleSupport.containerSupport.initializeImage();
            switch (ExitStatus.of((int)exitStatusCode)) {
                case OK: {
                    break;
                }
                case BUILDER_ERROR: {
                    throw NativeImage.showError(null, null, exitStatusCode);
                }
                case OUT_OF_MEMORY: 
                case OUT_OF_MEMORY_KILLED: {
                    this.showOutOfMemoryWarning();
                    throw NativeImage.showError(null, null, exitStatusCode);
                }
                default: {
                    String message = String.format("Container build request for '%s' failed with exit status %d", this.imageName, exitStatusCode);
                    throw NativeImage.showError(message, null, exitStatusCode);
                }
            }
            Map<Path, ContainerSupport.TargetPath> mountMapping = ContainerSupport.mountMappingFor(this.config.getJavaHome(), this.bundleSupport.inputDir, this.bundleSupport.outputDir);
            mountMapping.put(argFile, ContainerSupport.TargetPath.readonly(argFile));
            mountMapping.put(builderArgFile, ContainerSupport.TargetPath.readonly(builderArgFile));
            mountMapping.put(keepAliveFile, ContainerSupport.TargetPath.readonly(keepAliveFileInContainer));
            List<String> containerCommand = this.bundleSupport.containerSupport.createCommand(this.imageBuilderEnvironment, mountMapping);
            command.addAll(containerCommand);
            completeCommandList.addAll(containerCommand);
        }
        command.add(javaExecutable);
        command.add("@" + String.valueOf(argFile));
        command.add("--image-args-file=" + String.valueOf(builderArgFile));
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(command);
        Map<String, String> environment = pb.environment();
        String deprecatedSanitationKey = "NATIVE_IMAGE_DEPRECATED_BUILDER_SANITATION";
        String deprecatedSanitationValue = System.getenv().getOrDefault(deprecatedSanitationKey, "false");
        if (Boolean.parseBoolean(deprecatedSanitationValue)) {
            if (this.useBundle()) {
                this.bundleSupport = null;
                throw NativeImage.showError("Bundle support is not compatible with environment variable %s=%s.".formatted(deprecatedSanitationKey, deprecatedSanitationValue));
            }
            if (!this.imageBuilderEnvironment.isEmpty()) {
                throw NativeImage.showError("Option -E<env-var-key>[=<env-var-value>] is not compatible with environment variable %s=%s.".formatted(deprecatedSanitationKey, deprecatedSanitationValue));
            }
            LogUtils.warningDeprecatedEnvironmentVariable((String)deprecatedSanitationKey);
            NativeImage.deprecatedSanitizeJVMEnvironment(environment);
        } else {
            NativeImage.sanitizeJVMEnvironment(environment, this.imageBuilderEnvironment);
        }
        if (OS.WINDOWS.isCurrent()) {
            WindowsBuildEnvironmentUtil.propagateEnv(environment);
        }
        environment.put("USE_NATIVE_IMAGE_JAVA_PLATFORM_MODULE_SYSTEM", Boolean.toString(this.config.modulePathBuild));
        environment.put("DRIVER_TEMP_DIR_ENV_VARIABLE", this.config.driverTempDir.toString());
        if (!this.config.modulePathBuild) {
            throw NativeImage.showError("Running the image generator on the class path is no longer possible. Setting the environment variable USE_NATIVE_IMAGE_JAVA_PLATFORM_MODULE_SYSTEM=false is no longer supported.");
        }
        completeCommandList.addAll(0, environment.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).sorted().toList());
        completeCommandList.add(javaExecutable);
        completeCommandList.addAll(arguments);
        completeCommandList.addAll(finalImageBuilderArgs);
        String commandLine = SubstrateUtil.getShellCommandString(completeCommandList, (boolean)true);
        if (this.isDiagnostics()) {
            Path finalDiagnosticsDir = this.useBundle() ? this.bundleSupport.substituteAuxiliaryPath(this.diagnosticsDir, BundleMember.Role.Output) : this.diagnosticsDir.toAbsolutePath();
            ReportUtils.report((String)"command line arguments", (String)finalDiagnosticsDir.toString(), (String)"command-line", (String)"txt", printWriter -> printWriter.write(commandLine));
        } else {
            this.showVerboseMessage(this.isVerbose(), "Executing [");
            this.showVerboseMessage(this.isVerbose(), commandLine);
            this.showVerboseMessage(this.isVerbose(), "]");
        }
        if (this.dryRun) {
            return ExitStatus.OK.getValue();
        }
        Process p = null;
        try {
            p = pb.inheritIO().start();
            this.imageBuilderPid = p.pid();
            int n = p.waitFor();
            return n;
        }
        catch (IOException | InterruptedException e2) {
            throw NativeImage.showError(e2.getMessage());
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    private Path createFileInTempDir(String fileName) {
        Objects.requireNonNull(fileName);
        try {
            Path path = this.driverTempDir.resolve(fileName);
            Files.deleteIfExists(path);
            Files.createFile(path, new FileAttribute[0]);
            return path;
        }
        catch (InvalidPathException e) {
            throw NativeImage.showError("Invalid path for file in temp directory: " + e.getMessage());
        }
        catch (IOException e) {
            throw NativeImage.showError("Unable to create file in temp directory: " + e.getMessage());
        }
    }

    private Set<String> getBuiltInModules() {
        Path jdkRoot = this.config.rootDir;
        try {
            ImageReader reader = ImageReader.open(jdkRoot.resolve("lib/modules"));
            return new LinkedHashSet<String>(List.of(reader.getModuleNames()));
        }
        catch (IOException e) {
            throw NativeImage.showError("Unable to determine builtin modules of JDK in " + String.valueOf(jdkRoot), e);
        }
    }

    private Map<String, Path> getModulesFromPath(Collection<Path> modulePath) {
        if (!this.config.modulePathBuild || modulePath.isEmpty()) {
            return Map.of();
        }
        LinkedHashMap<String, Path> mrefs = new LinkedHashMap<String, Path>();
        try {
            ModuleFinder finder = ModuleFinder.of((Path[])modulePath.toArray(Path[]::new));
            for (ModuleReference mref : finder.findAll()) {
                String moduleName = mref.descriptor().name();
                VMError.guarantee((moduleName != null && !moduleName.isEmpty() ? 1 : 0) != 0, (String)"Unnamed module on modulePath");
                URI moduleLocation = mref.location().orElseThrow(() -> VMError.shouldNotReachHere((String)("ModuleReference for module " + moduleName + " has no location.")));
                mrefs.put(moduleName, Path.of(moduleLocation));
            }
        }
        catch (FindException e) {
            throw NativeImage.showError("Failed to collect ModuleReferences for module-path entries " + String.valueOf(modulePath), e);
        }
        return mrefs;
    }

    private Set<String> getImplicitlyRequiredSystemModules(Collection<Path> modulePath) {
        if (!this.config.modulePathBuild || modulePath.isEmpty()) {
            return Set.of();
        }
        ModuleFinder systemModuleFinder = ModuleFinder.ofSystem();
        ModuleFinder appModuleFinder = ModuleFinder.of((Path[])modulePath.toArray(Path[]::new));
        ModuleFinder finder = ModuleFinder.compose(appModuleFinder, systemModuleFinder);
        Map<String, ModuleReference> modules = finder.findAll().stream().collect(Collectors.toMap(m -> m.descriptor().name(), m -> m));
        HashSet<String> applicationModulePathRequiredModules = new HashSet<String>();
        ArrayDeque<ModuleReference> discoveryQueue = new ArrayDeque<ModuleReference>(modules.values());
        while (!discoveryQueue.isEmpty()) {
            ModuleReference module = (ModuleReference)discoveryQueue.poll();
            Set<String> requiredModules = NativeImage.getRequiredModules(module);
            List<ModuleReference> requiredModuleReferences = requiredModules.stream().map(mn -> modules.getOrDefault(mn, null)).filter(Objects::nonNull).toList();
            discoveryQueue.addAll(requiredModuleReferences);
            applicationModulePathRequiredModules.addAll(requiredModules);
        }
        applicationModulePathRequiredModules.retainAll(this.getBuiltInModules());
        return applicationModulePathRequiredModules;
    }

    private static Set<String> getRequiredModules(ModuleReference mref) {
        return mref.descriptor().requires().stream().map(ModuleDescriptor.Requires::name).collect(Collectors.toSet());
    }

    boolean useBundle() {
        return this.bundleSupport != null;
    }

    public ArchiveSupport archiveSupport() {
        return this.archiveSupport;
    }

    @Deprecated
    private static void deprecatedSanitizeJVMEnvironment(Map<String, String> environment) {
        String[] jvmAffectingEnvironmentVariables;
        for (String affectingEnvironmentVariable : jvmAffectingEnvironmentVariables = new String[]{"JAVA_COMPILER", "_JAVA_OPTIONS", "JAVA_TOOL_OPTIONS", "JDK_JAVA_OPTIONS", "CLASSPATH"}) {
            environment.remove(affectingEnvironmentVariable);
        }
    }

    private static void sanitizeJVMEnvironment(Map<String, String> environment, Map<String, String> imageBuilderEnvironment) {
        Function<Object, Object> keyMapper;
        HashSet<String> requiredKeys = new HashSet<String>(List.of("PATH", "PWD", "HOME", "LANG", "LANGUAGE"));
        if (OS.WINDOWS.isCurrent()) {
            requiredKeys.addAll(List.of("TEMP", "INCLUDE", "LIB"));
            keyMapper = s -> s.toUpperCase(Locale.ROOT);
        } else {
            keyMapper = Function.identity();
        }
        HashMap<String, String> restrictedEnvironment = new HashMap<String, String>();
        environment.forEach((key, val) -> {
            String mappedKey = (String)keyMapper.apply(key);
            if (requiredKeys.contains(mappedKey) || mappedKey.startsWith("LC_")) {
                restrictedEnvironment.put((String)key, (String)val);
            }
        });
        Iterator<Map.Entry<String, String>> iterator = imageBuilderEnvironment.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (entry.getValue() != null) {
                restrictedEnvironment.put(entry.getKey(), entry.getValue());
                continue;
            }
            environment.forEach((key, val) -> {
                if (((String)keyMapper.apply(key)).equals(keyMapper.apply((String)entry.getKey()))) {
                    restrictedEnvironment.put((String)entry.getKey(), (String)val);
                    entry.setValue((String)val);
                }
            });
            if (entry.getValue() != null) continue;
            LogUtils.warning((String)("Environment variable '" + entry.getKey() + "' is undefined and therefore not available during image build-time."));
            iterator.remove();
        }
        environment.clear();
        environment.putAll(restrictedEnvironment);
    }

    public static void main(String[] args) {
        NativeImage.performBuild(new BuildConfiguration(Arrays.asList(args)), defaultNativeImageProvider);
    }

    public static List<String> translateAPIOptions(List<String> arguments) {
        APIOptionHandler handler = new APIOptionHandler(defaultNativeImageProvider.apply(new BuildConfiguration(arguments)));
        ArgumentQueue argumentQueue = new ArgumentQueue("driver");
        handler.nativeImage.config.args.forEach(argumentQueue::add);
        ArrayList<String> translatedOptions = new ArrayList<String>();
        while (!argumentQueue.isEmpty()) {
            String translatedOption = handler.translateOption(argumentQueue);
            String originalOption = argumentQueue.poll();
            translatedOptions.add(translatedOption != null ? translatedOption : originalOption);
        }
        return translatedOptions;
    }

    protected static void performBuild(BuildConfiguration config, Function<BuildConfiguration, NativeImage> nativeImageProvider) {
        try {
            NativeImage.build(config, nativeImageProvider);
        }
        catch (NativeImageError e) {
            String message = e.getMessage();
            if (message != null) {
                NativeImage.show(System.err::println, "Error: " + message);
            }
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                NativeImage.show(System.err::println, "Caused by: " + String.valueOf(cause));
            }
            if (config.getBuildArgs().contains("--verbose")) {
                e.printStackTrace();
            }
            System.exit(e.exitCode);
        }
        System.exit(ExitStatus.OK.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void build(BuildConfiguration config, Function<BuildConfiguration, NativeImage> nativeImageProvider) {
        NativeImage nativeImage = nativeImageProvider.apply(config);
        if (config.getBuildArgs().isEmpty()) {
            nativeImage.showMessage(usageText);
            return;
        }
        try {
            nativeImage.prepareImageBuildArgs();
        }
        catch (NativeImageError e) {
            if (!nativeImage.isVerbose()) throw NativeImage.showError("Requirements for building native images are not fulfilled [cause: " + e.getMessage() + "]", null);
            throw NativeImage.showError("Requirements for building native images are not fulfilled", e);
        }
        try {
            int exitStatusCode = nativeImage.completeImageBuild();
            switch (ExitStatus.of((int)exitStatusCode)) {
                case OK: {
                    return;
                }
                case BUILDER_ERROR: {
                    throw NativeImage.showError(null, null, exitStatusCode);
                }
                case FALLBACK_IMAGE: {
                    nativeImage.showMessage("Generating fallback image...");
                    NativeImage.build(new FallbackBuildConfiguration(nativeImage), nativeImageProvider);
                    LogUtils.warning((String)("Image '" + nativeImage.imageName + "' is a fallback image that requires a JDK for execution (use --no-fallback to suppress fallback image generation and to print more detailed information why a fallback image was necessary)."));
                    return;
                }
                case REBUILD_AFTER_ANALYSIS: {
                    NativeImage.build(config, buildConfig -> {
                        NativeImage rebuildNativeImage = (NativeImage)nativeImageProvider.apply((BuildConfiguration)buildConfig);
                        rebuildNativeImage.addImageBuilderJavaArgs(String.format("-D%s=true", "com.oracle.svm.rebuild"));
                        return rebuildNativeImage;
                    });
                    return;
                }
                case OUT_OF_MEMORY: 
                case OUT_OF_MEMORY_KILLED: {
                    nativeImage.showOutOfMemoryWarning();
                    throw NativeImage.showError(null, null, exitStatusCode);
                }
                default: {
                    String message = String.format("Image build request for '%s' (pid: %d, path: %s) failed with exit status %d", nativeImage.imageName, nativeImage.imageBuilderPid, nativeImage.imagePath, exitStatusCode);
                    throw NativeImage.showError(message, null, exitStatusCode);
                }
            }
        }
        finally {
            if (nativeImage.useBundle()) {
                nativeImage.bundleSupport.complete();
            }
        }
    }

    Path canonicalize(Path path) {
        return this.canonicalize(path, true);
    }

    Path canonicalize(Path path, boolean strict) {
        Path absolutePath;
        Path prev;
        if (this.useBundle() && (prev = this.bundleSupport.restoreCanonicalization(path)) != null) {
            return prev;
        }
        Path path2 = absolutePath = path.isAbsolute() ? path : this.config.getWorkingDirectory().resolve(path);
        if (!strict) {
            return this.useBundle() ? this.bundleSupport.recordCanonicalization(path, absolutePath) : absolutePath;
        }
        try {
            Path realPath = absolutePath.toRealPath(new LinkOption[0]);
            if (!Files.isReadable(realPath)) {
                NativeImage.showError("Path entry " + String.valueOf(path) + " is not readable");
            }
            return this.useBundle() ? this.bundleSupport.recordCanonicalization(path, realPath) : realPath;
        }
        catch (IOException e) {
            throw NativeImage.showError("Invalid Path entry " + String.valueOf(path), e);
        }
    }

    public void addImageBuilderModulePath(Path modulePathEntry) {
        this.imageBuilderModulePath.add(this.canonicalize(modulePathEntry));
    }

    public void addAddedModules(String addModulesArg) {
        this.addModules.addAll(Arrays.asList(SubstrateUtil.split((String)addModulesArg, (String)",")));
    }

    public void addLimitedModules(String limitModulesArg) {
        this.limitModules.addAll(Arrays.asList(SubstrateUtil.split((String)limitModulesArg, (String)",")));
    }

    void addImageBuilderClasspath(Path classpath) {
        this.imageBuilderClasspath.add(this.canonicalize(classpath));
    }

    void addImageProvidedJars(Path path) {
        this.imageProvidedJars.add(this.canonicalize(path));
    }

    void addImageBuilderJavaArgs(String ... javaArgs) {
        this.addImageBuilderJavaArgs(Arrays.asList(javaArgs));
    }

    void addImageBuilderJavaArgs(Collection<String> javaArgs) {
        this.imageBuilderJavaArgs.addAll(javaArgs);
    }

    void addPlainImageBuilderArg(String plainArg, String origin) {
        this.addPlainImageBuilderArg(plainArg, origin, true);
    }

    void addPlainImageBuilderArg(String plainArg, String origin, boolean override) {
        this.addPlainImageBuilderArg(NativeImage.injectHostedOptionOrigin(plainArg, origin), override);
    }

    void addPlainImageBuilderArg(String plainArg) {
        this.addPlainImageBuilderArg(plainArg, true);
    }

    void addPlainImageBuilderArg(String plainArg, boolean override) {
        assert (plainArg.startsWith(oH) || plainArg.startsWith(oR));
        if (!override) {
            int posValueSeparator = plainArg.indexOf(61);
            if (posValueSeparator > 0) {
                String existingValue;
                String argPrefix = plainArg.substring(0, posValueSeparator);
                int posOriginSeparator = plainArg.indexOf(64);
                if (posOriginSeparator > 0) {
                    argPrefix = argPrefix.substring(0, posOriginSeparator);
                }
                if ((existingValue = NativeImage.getHostedOptionArgumentValue(this.imageBuilderArgs, argPrefix + "=")) != null) {
                    return;
                }
            } else {
                VMError.shouldNotReachHere((String)"override=false currently only works for non-boolean options");
            }
        }
        this.imageBuilderArgs.add(plainArg);
    }

    void addImageClasspath(Path classpath) {
        this.addImageClasspathEntry(this.imageClasspath, classpath, true);
    }

    void addImageModulePath(Path modulePathEntry) {
        this.addImageModulePath(modulePathEntry, true, true);
    }

    void addImageModulePath(Path modulePathEntry, boolean strict, boolean processMetaInf) {
        Path mpEntry;
        this.enableModulePathBuild();
        try {
            mpEntry = this.canonicalize(modulePathEntry);
        }
        catch (NativeImageError e) {
            if (strict) {
                throw e;
            }
            if (this.isVerbose()) {
                LogUtils.warning((String)("Invalid module-path entry: " + String.valueOf(modulePathEntry)));
            }
            this.imageModulePath.add(this.canonicalize(modulePathEntry, false));
            return;
        }
        if (this.imageModulePath.contains(mpEntry)) {
            return;
        }
        Path mpEntryFinal = this.useBundle() ? this.bundleSupport.substituteModulePath(mpEntry) : mpEntry;
        this.imageModulePath.add(mpEntryFinal);
        if (processMetaInf) {
            this.processClasspathNativeImageMetaInf(mpEntryFinal);
        }
    }

    void addCustomImageClasspath(String classpath) {
        for (Path path : NativeImage.expandAsteriskClassPathElement(classpath)) {
            this.addImageClasspathEntry(this.customImageClasspath, path, false);
        }
    }

    public static List<Path> expandAsteriskClassPathElement(String cp) {
        ArrayList<String> components;
        int lastElementIndex;
        Object separators = Pattern.quote(File.separator);
        if (OS.getCurrent().equals((Object)OS.WINDOWS)) {
            separators = (String)separators + "/";
        }
        if ((lastElementIndex = (components = new ArrayList<String>(List.of(cp.split("[" + (String)separators + "]")))).size() - 1) >= 0 && "*".equals(components.get(lastElementIndex))) {
            List<Path> list;
            block10: {
                components.remove(lastElementIndex);
                Path searchDir = Path.of(String.join((CharSequence)File.separator, components), new String[0]);
                Stream<Path> filesInSearchDir = Files.list(searchDir);
                try {
                    list = filesInSearchDir.filter(NativeImage::hasJarFileSuffix).collect(Collectors.toList());
                    if (filesInSearchDir == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (filesInSearchDir != null) {
                            try {
                                filesInSearchDir.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw NativeImage.showError("Class path element asterisk (*) expansion failed for directory " + String.valueOf(searchDir));
                    }
                }
                filesInSearchDir.close();
            }
            return list;
        }
        return List.of(Path.of(cp, new String[0]));
    }

    private static boolean hasJarFileSuffix(Path p) {
        return p.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".jar");
    }

    void addCustomImageClasspath(Path classpath) {
        this.addImageClasspathEntry(this.customImageClasspath, classpath, true);
    }

    private void addImageClasspathEntry(LinkedHashSet<Path> destination, Path classpath, boolean strict) {
        Path classpathEntryFinal;
        Path classpathEntry;
        try {
            classpathEntry = this.canonicalize(classpath);
        }
        catch (NativeImageError e) {
            if (strict) {
                throw e;
            }
            if (this.isVerbose()) {
                LogUtils.warning((String)("Invalid classpath entry: " + String.valueOf(classpath)));
            }
            destination.add(this.canonicalize(classpath, false));
            return;
        }
        Path path = classpathEntryFinal = this.useBundle() ? this.bundleSupport.substituteClassPath(classpathEntry) : classpathEntry;
        if (!this.imageClasspath.contains(classpathEntryFinal) && !this.customImageClasspath.contains(classpathEntryFinal)) {
            boolean added = destination.add(classpathEntryFinal);
            if (ClasspathUtils.isJar((Path)classpathEntryFinal)) {
                NativeImage.processJarManifestMainAttributes(classpathEntryFinal, (jarFilePath, attributes) -> this.handleClassPathAttribute(destination, (Path)jarFilePath, (Attributes)attributes));
            }
            boolean forcedOnModulePath = this.processClasspathNativeImageMetaInf(classpathEntryFinal);
            if (added && forcedOnModulePath) {
                destination.remove(classpathEntryFinal);
            }
        }
    }

    void addCustomJavaArgs(String javaArg) {
        this.customJavaArgs.add(javaArg);
    }

    void addVerbose() {
        ++this.verbose;
    }

    void enableDiagnostics() {
        if (this.diagnostics) {
            return;
        }
        this.diagnostics = true;
        this.diagnosticsDir = Paths.get("reports", ReportUtils.timeStampedFileName((String)"diagnostics", (String)""));
        this.addVerbose();
        this.addVerbose();
    }

    void setJarOptionMode(boolean val) {
        this.jarOptionMode = val;
    }

    void setModuleOptionMode(boolean val) {
        this.enableModulePathBuild();
        this.moduleOptionMode = val;
    }

    private void enableModulePathBuild() {
        if (!this.config.modulePathBuild) {
            NativeImage.showError("Module options not allowed in this image build. Reason: " + this.config.imageBuilderModeEnforcer);
        }
        this.config.modulePathBuild = true;
    }

    boolean isVerbose() {
        return this.verbose > 0;
    }

    boolean isVVerbose() {
        return this.verbose > 1;
    }

    boolean isVVVerbose() {
        return this.verbose > 2;
    }

    boolean isDiagnostics() {
        return this.diagnostics;
    }

    boolean useDebugAttach() {
        return this.cmdLineOptionHandler.useDebugAttach;
    }

    protected void setDryRun(boolean val) {
        this.dryRun = val;
    }

    boolean isDryRun() {
        return this.dryRun;
    }

    public void setPrintFlagsOptionQuery(String val) {
        this.printFlagsOptionQuery = val;
    }

    public void setPrintFlagsWithExtraHelpOptionQuery(String val) {
        this.printFlagsWithExtraHelpOptionQuery = val;
    }

    void showVerboseMessage(boolean show, String message) {
        if (show) {
            NativeImage.show(System.out::println, message);
        }
    }

    void showMessage(String message) {
        NativeImage.show(System.out::println, message);
    }

    void showMessage(String format, Object ... args) {
        this.showMessage(String.format(format, args));
    }

    void showNewline() {
        System.out.println();
    }

    void showMessagePart(String message) {
        NativeImage.show(s -> {
            System.out.print((String)s);
            System.out.flush();
        }, message);
    }

    void showOutOfMemoryWarning() {
        String xmxFlag = "-Xmx";
        String lastMaxHeapValue = this.imageBuilderArgs.stream().filter(arg -> arg.startsWith(xmxFlag)).reduce((first, second) -> second).orElse(null);
        Object maxHeapText = lastMaxHeapValue == null ? "" : " (The maximum heap size of the process was set with '" + lastMaxHeapValue + "'.)";
        Object additionalAction = lastMaxHeapValue == null ? "" : " or increase the maximum heap size using the '" + xmxFlag + "' option";
        this.showMessage("The Native Image build process ran out of memory.%s%nPlease make sure your build system has more memory available%s.", maxHeapText, additionalAction);
    }

    void performANSIReset() {
        this.showMessagePart("\u001b[0m");
    }

    public static Error showError(String message) {
        throw new NativeImageError(message);
    }

    public static Error showError(String message, Throwable cause) {
        throw new NativeImageError(message, cause);
    }

    public static Error showError(String message, Throwable cause, int exitCode) {
        throw new NativeImageError(message, cause, exitCode);
    }

    private static void show(Consumer<String> printFunc, String message) {
        printFunc.accept(message);
    }

    protected static List<Path> getJars(Path dir, String ... jarBaseNames) {
        List<Path> list;
        block8: {
            List<String> baseNameList = Arrays.asList(jarBaseNames);
            Stream<Path> files = Files.list(dir);
            try {
                list = files.filter(p -> {
                    if (!NativeImage.hasJarFileSuffix(p)) {
                        return false;
                    }
                    if (baseNameList.isEmpty()) {
                        return true;
                    }
                    String jarFileName = p.getFileName().toString();
                    String jarBaseName = jarFileName.substring(0, jarFileName.length() - ".jar".length());
                    return baseNameList.contains(jarBaseName);
                }).collect(Collectors.toList());
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw NativeImage.showError("Unable to use jar-files from directory " + String.valueOf(dir), e);
                }
            }
            files.close();
        }
        return list;
    }

    private void processNativeImageArgs() {
        NativeImageArgsProcessor argsProcessor = new NativeImageArgsProcessor("user");
        for (String arg : this.getNativeImageArgs()) {
            argsProcessor.accept(arg);
        }
        argsProcessor.apply(false);
    }

    List<String> getNativeImageArgs() {
        ArgFilesOptionPreprocessor argFilesOptionPreprocessor = new ArgFilesOptionPreprocessor();
        return Stream.concat(this.getDefaultNativeImageArgs().stream(), this.config.getBuildArgs().stream()).flatMap(arg -> argFilesOptionPreprocessor.process((String)arg).stream()).toList();
    }

    private static boolean isDumbTerm() {
        String term = System.getenv().getOrDefault("TERM", "");
        return term.isEmpty() || term.equals("dumb") || term.equals("unknown");
    }

    private static boolean hasColorSupport() {
        return !NativeImage.isDumbTerm() && !SubstrateUtil.isNonInteractiveTerminal() && OS.getCurrent() != OS.WINDOWS && System.getenv("NO_COLOR") == null;
    }

    private static boolean hasProgressSupport(List<String> imageBuilderArgs) {
        if (NativeImage.isDumbTerm() || SubstrateUtil.isNonInteractiveTerminal()) {
            return false;
        }
        if (!NativeImage.getHostedOptionArgumentValues(imageBuilderArgs, "-H:Log=").isEmpty()) {
            return NativeImage.logRedirectedToFile();
        }
        return true;
    }

    private static boolean logRedirectedToFile() {
        String value = System.getProperty("graal.LogFile");
        return value != null && !value.equals("%o") && !value.equals("%e");
    }

    private boolean configureBuildOutput() {
        boolean useColorfulOutput = false;
        String colorValue = NativeImage.getHostedOptionArgumentValue(this.imageBuilderArgs, this.oHColor);
        if (colorValue != null) {
            if ("always".equals(colorValue)) {
                useColorfulOutput = true;
            } else if ("auto".equals(colorValue)) {
                useColorfulOutput = NativeImage.hasColorSupport();
                this.addPlainImageBuilderArg(this.oHColor + (useColorfulOutput ? "always" : "never"), "driver");
            }
        } else {
            Boolean buildOutputColorfulValue = NativeImage.getHostedOptionBooleanArgumentValue(this.imageBuilderArgs, (OptionKey<Boolean>)SubstrateOptions.BuildOutputColorful);
            if (buildOutputColorfulValue != null) {
                useColorfulOutput = buildOutputColorfulValue;
            } else if (NativeImage.hasColorSupport()) {
                useColorfulOutput = true;
                this.addPlainImageBuilderArg(this.oHColor + "always", "driver");
            }
        }
        if (NativeImage.getHostedOptionBooleanArgumentValue(this.imageBuilderArgs, (OptionKey<Boolean>)SubstrateOptions.BuildOutputProgress) == null && NativeImage.hasProgressSupport(this.imageBuilderArgs)) {
            this.addPlainImageBuilderArg(this.oHEnableBuildOutputProgress);
        }
        if (NativeImage.getHostedOptionBooleanArgumentValue(this.imageBuilderArgs, (OptionKey<Boolean>)SubstrateOptions.BuildOutputLinks) == null && (colorValue == null || "auto".equals(colorValue)) && useColorfulOutput) {
            this.addPlainImageBuilderArg(this.oHEnableBuildOutputLinks);
        }
        return useColorfulOutput;
    }

    static boolean forEachPropertyValue(String propertyValue, Consumer<String> target, Function<String, String> resolver) {
        return NativeImage.forEachPropertyValue(propertyValue, target, resolver, MANY_SPACES_REGEX);
    }

    static boolean forEachPropertyValue(String propertyValue, Consumer<String> target, Function<String, String> resolver, String separatorRegex) {
        if (propertyValue != null) {
            for (String propertyValuePart : propertyValue.split(separatorRegex)) {
                target.accept(resolver.apply(propertyValuePart));
            }
            return true;
        }
        return false;
    }

    public void addOptionKeyValue(String key, String value) {
        this.propertyFileSubstitutionValues.put(key, value);
    }

    static String resolvePropertyValue(String val, String optionArg, Path componentDirectory, BuildConfiguration config) {
        String resultVal = val;
        if (optionArg != null) {
            resultVal = NativeImage.safeSubstitution(resultVal, "${*}", optionArg);
            for (String argNameValue : optionArg.split(",")) {
                String[] splitted = argNameValue.split(":", 2);
                if (splitted.length != 2) continue;
                String argName = splitted[0];
                String argValue = splitted[1];
                if (argName.isEmpty()) continue;
                resultVal = NativeImage.safeSubstitution(resultVal, "${" + argName + "}", argValue);
            }
        }
        resultVal = NativeImage.safeSubstitution(resultVal, "${.}", componentDirectory.toString());
        resultVal = NativeImage.safeSubstitution(resultVal, "${java.home}", config.getJavaHome().toString());
        return resultVal;
    }

    private static String safeSubstitution(String source, CharSequence target, CharSequence replacement) {
        if (replacement == null && source.contains(target)) {
            throw NativeImage.showError("Unable to provide meaningful substitution for \"" + String.valueOf(target) + "\" in " + source);
        }
        return source.replace(target, replacement);
    }

    public static final class NativeImageError
    extends Error {
        final int exitCode;

        private NativeImageError(String message) {
            this(message, null);
        }

        private NativeImageError(String message, Throwable cause) {
            this(message, cause, ExitStatus.DRIVER_ERROR.getValue());
        }

        public NativeImageError(String message, Throwable cause, int exitCode) {
            super(message, cause);
            this.exitCode = exitCode;
        }
    }

    static abstract class OptionHandler<T extends NativeImage> {
        protected final T nativeImage;

        OptionHandler(T nativeImage) {
            this.nativeImage = nativeImage;
        }

        abstract boolean consume(ArgumentQueue var1);

        void addFallbackBuildArgs(List<String> buildArgs) {
        }
    }

    protected static class BuildConfiguration {
        private static final Method isModulePathBuild = ReflectionUtil.lookupMethod(ModuleSupport.class, (String)"isModulePathBuild", (Class[])new Class[0]);
        private static final String JAVA_EXECUTABLE_OVERRIDE = System.getProperty("com.oracle.svm.driver.java.executable.override");
        protected boolean modulePathBuild;
        String imageBuilderModeEnforcer;
        protected final Path workDir;
        protected final Path rootDir;
        protected final Path libJvmciDir;
        protected final List<String> args;
        private HostFlags hostFlags;
        private Path driverTempDir;

        BuildConfiguration(BuildConfiguration original) {
            this.modulePathBuild = original.modulePathBuild;
            this.imageBuilderModeEnforcer = original.imageBuilderModeEnforcer;
            this.workDir = original.workDir;
            this.rootDir = original.rootDir;
            this.libJvmciDir = original.libJvmciDir;
            this.args = original.args;
            this.hostFlags = original.hostFlags;
            this.driverTempDir = original.driverTempDir;
        }

        protected BuildConfiguration(List<String> args) {
            this(null, null, args);
        }

        BuildConfiguration(Path rootDir, Path workDir, List<String> args) {
            try {
                this.modulePathBuild = (Boolean)isModulePathBuild.invoke(null, new Object[0]);
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                VMError.shouldNotReachHere((Throwable)e);
            }
            this.imageBuilderModeEnforcer = null;
            this.args = Collections.unmodifiableList(args);
            Path path = this.workDir = workDir != null ? workDir : Paths.get(".", new String[0]).toAbsolutePath().normalize();
            if (rootDir != null) {
                this.rootDir = rootDir;
            } else if (IS_AOT) {
                Path executablePath = Paths.get(ProcessProperties.getExecutableName(), new String[0]);
                assert (executablePath != null);
                Path binDir = executablePath.getParent();
                Path rootDirCandidate = binDir.getParent();
                if (rootDirCandidate.endsWith(platform)) {
                    rootDirCandidate = rootDirCandidate.getParent();
                }
                if (rootDirCandidate.endsWith(Paths.get("lib", "svm"))) {
                    rootDirCandidate = rootDirCandidate.getParent().getParent();
                }
                this.rootDir = rootDirCandidate;
            } else {
                String rootDirProperty = "native-image.root";
                String rootDirString = System.getProperty(rootDirProperty);
                if (rootDirString == null) {
                    rootDirString = System.getProperty("java.home");
                }
                this.rootDir = Paths.get(rootDirString, new String[0]);
            }
            Path ljDir = this.rootDir.resolve(Paths.get("lib", "jvmci"));
            this.libJvmciDir = Files.exists(ljDir, new LinkOption[0]) ? ljDir : null;
        }

        public List<String> getGeneratorMainClass() {
            if (this.modulePathBuild) {
                return Arrays.asList("--module", DEFAULT_GENERATOR_MODULE_NAME + "/" + DEFAULT_GENERATOR_CLASS_NAME);
            }
            return List.of(DEFAULT_GENERATOR_CLASS_NAME + NativeImage.DEFAULT_GENERATOR_9PLUS_SUFFIX);
        }

        public Path getWorkingDirectory() {
            return this.workDir;
        }

        public Path getJavaHome() {
            return this.rootDir;
        }

        public Path getJavaExecutable() {
            if (JAVA_EXECUTABLE_OVERRIDE != null) {
                return Paths.get(JAVA_EXECUTABLE_OVERRIDE, new String[0]);
            }
            Path binJava = Paths.get("bin", OS.getCurrent() == OS.WINDOWS ? "java.exe" : "java");
            if (Files.isExecutable(this.rootDir.resolve(binJava))) {
                return this.rootDir.resolve(binJava);
            }
            String javaHome = System.getenv("JAVA_HOME");
            if (javaHome == null) {
                throw NativeImage.showError("Environment variable JAVA_HOME is not set");
            }
            Path javaHomeDir = Paths.get(javaHome, new String[0]);
            if (!Files.isDirectory(javaHomeDir, new LinkOption[0])) {
                throw NativeImage.showError("Environment variable JAVA_HOME does not refer to a directory");
            }
            if (!Files.isExecutable(javaHomeDir.resolve(binJava))) {
                throw NativeImage.showError("Environment variable JAVA_HOME does not refer to a directory with a " + String.valueOf(binJava) + " executable");
            }
            return javaHomeDir.resolve(binJava);
        }

        public List<Path> getBuilderClasspath() {
            if (this.modulePathBuild) {
                return Collections.emptyList();
            }
            ArrayList<Path> result = new ArrayList<Path>();
            if (this.libJvmciDir != null) {
                result.addAll(NativeImage.getJars(this.libJvmciDir, "graal-sdk", "graal", "enterprise-graal"));
            }
            result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "svm", "builder")), new String[0]));
            if (!this.modulePathBuild) {
                result.addAll(this.createTruffleBuilderModulePath());
            }
            return result;
        }

        public List<Path> getBuilderCLibrariesPaths() {
            return Collections.singletonList(this.rootDir.resolve(Paths.get("lib", "svm", "clibraries")));
        }

        public Path getBuilderInspectServerPath() {
            Path inspectPath = this.rootDir.resolve(Paths.get("lib", "svm", "inspect"));
            if (Files.isDirectory(inspectPath, new LinkOption[0])) {
                return inspectPath;
            }
            return null;
        }

        public List<Path> getImageProvidedClasspath() {
            return this.getImageProvidedJars();
        }

        public List<Path> getImageProvidedModulePath() {
            return this.getImageProvidedJars();
        }

        protected List<Path> getImageProvidedJars() {
            return NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "svm")), new String[0]);
        }

        protected void setDriverTempDir(Path tempDir) {
            Objects.requireNonNull(tempDir);
            VMError.guarantee((boolean)Files.isDirectory(tempDir, new LinkOption[0]));
            this.driverTempDir = tempDir;
        }

        public HostFlags getHostFlags() {
            if (this.hostFlags == null) {
                this.hostFlags = this.gatherHostFlags();
            }
            return this.hostFlags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HostFlags gatherHostFlags() {
            boolean useJVMCINativeLibrary = false;
            boolean hasUseJVMCICompiler = false;
            boolean hasMaxRAMPercentage = false;
            boolean hasMaximumHeapSizePercent = false;
            boolean hasGCTimeRatio = false;
            boolean hasExitOnOutOfMemoryError = false;
            boolean hasUseParallelGC = false;
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            NativeImage.sanitizeJVMEnvironment(pb.environment(), Map.of());
            List<String> command = pb.command();
            command.add(this.getJavaExecutable().toString());
            command.add("-XX:+PrintFlagsFinal");
            command.add("-version");
            Process process = null;
            try {
                process = pb.start();
                try (Scanner inputScanner = new Scanner(process.getInputStream());){
                    while (inputScanner.hasNextLine()) {
                        String line = inputScanner.nextLine();
                        if (line.contains("bool UseJVMCINativeLibrary ")) {
                            String value = SubstrateUtil.split((String)line, (String)"=")[1];
                            if (!value.trim().startsWith("true")) continue;
                            useJVMCINativeLibrary = true;
                            continue;
                        }
                        if (line.contains("bool UseJVMCICompiler ")) {
                            hasUseJVMCICompiler = true;
                            continue;
                        }
                        if (line.contains(" MaxRAMPercentage ")) {
                            hasMaxRAMPercentage = true;
                            continue;
                        }
                        if (line.contains(" GCTimeRatio ")) {
                            hasGCTimeRatio = true;
                            continue;
                        }
                        if (line.contains(" bool ExitOnOutOfMemoryError ")) {
                            hasExitOnOutOfMemoryError = true;
                            continue;
                        }
                        if (line.contains(" MaximumHeapSizePercent ")) {
                            hasMaximumHeapSizePercent = true;
                            continue;
                        }
                        if (!line.contains(" UseParallelGC ")) continue;
                        hasUseParallelGC = true;
                    }
                }
                process.waitFor();
            }
            catch (Exception exception) {
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
            return new HostFlags(useJVMCINativeLibrary, hasUseJVMCICompiler, hasMaxRAMPercentage, hasGCTimeRatio, hasExitOnOutOfMemoryError, hasMaximumHeapSizePercent, hasUseParallelGC);
        }

        public List<String> getBuilderJavaArgs() {
            ArrayList<String> builderJavaArgs = new ArrayList<String>();
            String javaVersion = String.valueOf(JavaVersionUtil.JAVA_SPEC);
            String[] flagsForVersion = graalCompilerFlags.get(javaVersion);
            if (flagsForVersion == null) {
                String suffix = "";
                if (System.getProperty("java.home").contains("-dev")) {
                    suffix = " Update SubstrateCompilerFlagsBuilder.compute_graal_compiler_flags_map() in mx_substratevm.py to add a configuration for a new Java version.";
                }
                NativeImage.showError(String.format("Image building not supported for Java version %s in %s with VM configuration \"%s\".%s", System.getProperty("java.version"), System.getProperty("java.home"), System.getProperty("java.vm.name"), suffix));
            }
            for (String line : flagsForVersion) {
                if (!this.modulePathBuild && line.startsWith("--add-exports=")) {
                    builderJavaArgs.add(line.substring(0, line.lastIndexOf(61) + 1) + NativeImage.ALL_UNNAMED);
                    continue;
                }
                builderJavaArgs.add(line);
            }
            if (this.getHostFlags().useJVMCINativeLibrary()) {
                builderJavaArgs.add("-XX:+UseJVMCINativeLibrary");
            } else if (this.getHostFlags().hasUseJVMCICompiler()) {
                builderJavaArgs.add("-XX:-UseJVMCICompiler");
            }
            return builderJavaArgs;
        }

        public List<Path> getBuilderModulePath() {
            ArrayList<Path> result = new ArrayList<Path>();
            if (this.libJvmciDir != null) {
                result.addAll(NativeImage.getJars(this.libJvmciDir, "enterprise-graal"));
                result.addAll(NativeImage.getJars(this.libJvmciDir, "word", "collections", "nativeimage", "nativeimage-libgraal"));
            }
            if (this.modulePathBuild) {
                result.addAll(this.createTruffleBuilderModulePath());
                result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "svm", "builder")), new String[0]));
            }
            return result;
        }

        private List<Path> createTruffleBuilderModulePath() {
            Path libTruffleDir = this.rootDir.resolve(Paths.get("lib", "truffle"));
            List<Path> jars = NativeImage.getJars(libTruffleDir, "truffle-api", "truffle-runtime", "truffle-enterprise");
            if (!jars.isEmpty()) {
                jars.addAll(NativeImage.getJars(libTruffleDir, "truffle-compiler"));
                Path builderPath = this.rootDir.resolve(Paths.get("lib", "truffle", "builder"));
                if (Files.exists(builderPath, new LinkOption[0])) {
                    List<Path> truffleRuntimeSVMJars = NativeImage.getJars(builderPath, "truffle-runtime-svm", "truffle-enterprise-svm");
                    jars.addAll(truffleRuntimeSVMJars);
                    if (this.libJvmciDir != null && !truffleRuntimeSVMJars.isEmpty()) {
                        jars.addAll(NativeImage.getJars(this.libJvmciDir, "polyglot"));
                    }
                }
                if (this.libJvmciDir != null) {
                    jars.addAll(NativeImage.getJars(libTruffleDir, "jniutils"));
                }
            }
            if (this.libJvmciDir != null) {
                jars.addAll(NativeImage.getJars(libTruffleDir, "truffle-compiler"));
            }
            return jars;
        }

        public List<Path> getBuilderUpgradeModulePath() {
            return this.libJvmciDir != null ? NativeImage.getJars(this.libJvmciDir, "graal", "graal-management") : Collections.emptyList();
        }

        public List<Path> getImageClasspath() {
            return Collections.emptyList();
        }

        public List<String> getBuildArgs() {
            return this.args;
        }

        public boolean buildFallbackImage() {
            return false;
        }
    }

    class DriverMetaInfProcessor
    implements NativeImageMetaInfResourceProcessor {
        DriverMetaInfProcessor() {
        }

        @Override
        public boolean processMetaInfResource(Path classpathEntry, Path resourceRoot, Path resourcePath, MetaInfFileType type) throws IOException {
            boolean isNativeImagePropertiesFile = type.equals((Object)MetaInfFileType.Properties);
            boolean ignoreClasspathEntry = false;
            Map properties = null;
            if (isNativeImagePropertiesFile) {
                String forceOnModulePath;
                properties = ArchiveSupport.loadProperties((InputStream)Files.newInputStream(resourcePath, new OpenOption[0]));
                if (NativeImage.this.config.modulePathBuild && (forceOnModulePath = (String)properties.get("ForceOnModulePath")) != null) {
                    try {
                        ModuleFinder finder = ModuleFinder.of(classpathEntry);
                        ModuleReference ref = finder.find(forceOnModulePath).orElse(null);
                        if (ref == null) {
                            throw NativeImage.showError("Failed to process ForceOnModulePath attribute: Module descriptor for the module " + forceOnModulePath + " was not found in class-path entry: " + String.valueOf(classpathEntry) + ".");
                        }
                    }
                    catch (FindException e) {
                        throw NativeImage.showError("Failed to process ForceOnModulePath attribute: Module descriptor for the module " + forceOnModulePath + " could not be resolved with class-path entry: " + String.valueOf(classpathEntry) + ".", e);
                    }
                    NativeImage.this.addImageModulePath(classpathEntry, true, false);
                    NativeImage.this.addAddedModules(forceOnModulePath);
                    ignoreClasspathEntry = true;
                }
            }
            String originSuffix = isNativeImagePropertiesFile ? "" : "+api";
            NativeImage nativeImage = NativeImage.this;
            Objects.requireNonNull(nativeImage);
            NativeImageArgsProcessor args = nativeImage.new NativeImageArgsProcessor(String.valueOf(resourcePath.toUri()) + originSuffix);
            Path componentDirectory = resourceRoot.relativize(resourcePath).getParent();
            Function<String, String> resolver = str -> {
                int nameCount = componentDirectory.getNameCount();
                String optionArg = null;
                if (nameCount > 2) {
                    String optionArgKey = componentDirectory.subpath(2, nameCount).toString();
                    optionArg = NativeImage.this.propertyFileSubstitutionValues.get(optionArgKey);
                }
                return NativeImage.resolvePropertyValue(str, optionArg, componentDirectory, NativeImage.this.config);
            };
            if (isNativeImagePropertiesFile) {
                String imageNameValue = (String)properties.get("ImageName");
                if (imageNameValue != null) {
                    NativeImage.this.addPlainImageBuilderArg(NativeImage.this.oHName + resolver.apply(imageNameValue), resourcePath.toUri().toString());
                }
                NativeImage nativeImage2 = NativeImage.this;
                NativeImage.forEachPropertyValue((String)properties.get("JavaArgs"), xva$0 -> nativeImage2.addImageBuilderJavaArgs((String)xva$0), resolver);
                NativeImage.forEachPropertyValue((String)properties.get("Args"), args, resolver);
                NativeImage.forEachPropertyValue((String)properties.get("ProvidedHostedOptions"), NativeImage.this.apiOptionHandler::injectKnownHostedOption, resolver);
            } else {
                args.accept(NativeImage.oH(type.optionKey) + String.valueOf(resourceRoot.relativize(resourcePath)));
            }
            args.apply(true);
            return ignoreClasspathEntry;
        }

        @Override
        public void showWarning(String message) {
            if (NativeImage.this.isVerbose()) {
                LogUtils.warning((String)message);
            }
        }

        @Override
        public void showVerboseMessage(String message) {
            NativeImage.this.showVerboseMessage(NativeImage.this.isVerbose(), message);
        }

        @Override
        public boolean isExcluded(Path resourcePath, Path entry) {
            Path srcPath = NativeImage.this.useBundle() ? NativeImage.this.bundleSupport.originalPath(entry) : null;
            Path matchPath = srcPath != null ? srcPath : entry;
            return NativeImage.this.excludedConfigs.stream().filter(e -> e.jarPattern.matcher(matchPath.toString()).find()).anyMatch(e -> e.resourcePattern.matcher(resourcePath.toString()).find());
        }
    }

    public record HostFlags(boolean useJVMCINativeLibrary, boolean hasUseJVMCICompiler, boolean hasMaxRAMPercentage, boolean hasGCTimeRatio, boolean hasExitOnOutOfMemoryError, boolean hasMaximumHeapSizePercent, boolean hasUseParallelGC) {
    }

    private record ExcludeConfig(Pattern jarPattern, Pattern resourcePattern) {
    }

    private record ArgumentEntry(int index, String value) {
    }

    static class ArgumentQueue {
        private final ArrayDeque<String> queue = new ArrayDeque();
        public final String argumentOrigin;
        public int numberOfFirstObservedActiveUnlockExperimentalVMOptions = -1;

        ArgumentQueue(String argumentOrigin) {
            this.argumentOrigin = argumentOrigin;
        }

        public void add(String arg) {
            this.queue.add(arg);
        }

        public String poll() {
            return this.queue.poll();
        }

        public void push(String arg) {
            this.queue.push(arg);
        }

        public String peek() {
            return this.queue.peek();
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public int size() {
            return this.queue.size();
        }

        public List<String> snapshot() {
            return new ArrayList<String>(this.queue);
        }
    }

    private static final class FallbackBuildConfiguration
    extends BuildConfiguration {
        private final List<String> fallbackBuildArgs;

        private FallbackBuildConfiguration(NativeImage original) {
            super(original.config);
            this.fallbackBuildArgs = original.createFallbackBuildArgs();
        }

        @Override
        public List<String> getBuildArgs() {
            return this.fallbackBuildArgs;
        }

        @Override
        public boolean buildFallbackImage() {
            return true;
        }
    }

    class NativeImageArgsProcessor
    implements Consumer<String> {
        private final ArgumentQueue args;

        NativeImageArgsProcessor(String argumentOrigin) {
            this.args = new ArgumentQueue(argumentOrigin);
        }

        @Override
        public void accept(String arg) {
            this.args.add(arg);
        }

        void apply(boolean strict) {
            ArgumentQueue queue = new ArgumentQueue(this.args.argumentOrigin);
            while (!this.args.isEmpty()) {
                int numArgs = this.args.size();
                if (NativeImage.this.cmdLineOptionHandler.consume(this.args)) {
                    assert (this.args.size() < numArgs) : "OptionHandler pretends to consume argument(s) but isn't: " + NativeImage.this.cmdLineOptionHandler.getClass().getName();
                    continue;
                }
                queue.add(this.args.poll());
            }
            NativeImage.this.apiOptionHandler.ensureConsistentUnlockScopes(queue);
            while (!queue.isEmpty()) {
                boolean consumed = false;
                for (OptionHandler handler : NativeImage.this.optionHandlers.reversed()) {
                    int numArgs = queue.size();
                    if (!handler.consume(queue)) continue;
                    assert (queue.size() < numArgs) : "OptionHandler pretends to consume argument(s) but isn't: " + handler.getClass().getName();
                    consumed = true;
                    break;
                }
                if (consumed) continue;
                if (strict) {
                    NativeImage.showError("Property 'Args' contains invalid entry '" + queue.peek() + "'");
                    continue;
                }
                String uniqueLeftoverArg = new String(queue.poll());
                NativeImage.this.imageBuilderUniqueLeftoverArgs.add(uniqueLeftoverArg);
                NativeImage.this.imageBuilderArgs.add(uniqueLeftoverArg);
            }
        }
    }
}

