/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.stream.StreamSupport;
import jdk.vm.ci.common.JVMCIError;

public class TypeStateUtils {
    private static final MethodHandle bitSetArrayAccess;
    private static final MethodHandle wordInUseAccess;
    private static final MethodHandle sizeIsStickyAccess;
    private static final MethodHandle trimToSizeAccess;

    public static long[] extractBitSetField(BitSet bitSet) {
        try {
            return bitSetArrayAccess.invokeExact(bitSet);
        }
        catch (Throwable t) {
            throw JVMCIError.shouldNotReachHere((Throwable)t);
        }
    }

    public static int getWordsInUse(BitSet bitSet) {
        try {
            return wordInUseAccess.invokeExact(bitSet);
        }
        catch (Throwable t) {
            throw JVMCIError.shouldNotReachHere((Throwable)t);
        }
    }

    public static boolean getSizeIsSticky(BitSet bitSet) {
        try {
            return sizeIsStickyAccess.invokeExact(bitSet);
        }
        catch (Throwable t) {
            throw JVMCIError.shouldNotReachHere((Throwable)t);
        }
    }

    public static boolean needsTrim(BitSet bitSet) {
        long[] words;
        int wordsInUse = TypeStateUtils.getWordsInUse(bitSet);
        return wordsInUse != (words = TypeStateUtils.extractBitSetField(bitSet)).length;
    }

    private static void trimBitSetToSize(BitSet bs) {
        try {
            trimToSizeAccess.invokeExact(bs);
        }
        catch (Throwable t) {
            throw JVMCIError.shouldNotReachHere((Throwable)t);
        }
    }

    public static boolean isSuperset(BitSet first, BitSet second) {
        if (first.length() >= second.length()) {
            long[] bits1 = TypeStateUtils.extractBitSetField(first);
            long[] bits2 = TypeStateUtils.extractBitSetField(second);
            boolean isSuperset = true;
            int numberOfWords = Math.min(bits1.length, bits2.length);
            for (int i = 0; i < numberOfWords; ++i) {
                if ((bits1[i] & bits2[i]) == bits2[i]) continue;
                isSuperset = false;
                break;
            }
            return isSuperset;
        }
        return false;
    }

    public static AnalysisObject[] concat(AnalysisObject[] oa1, AnalysisObject[] oa2) {
        int resultSize = oa1.length + oa2.length;
        AnalysisObject[] result = new AnalysisObject[resultSize];
        System.arraycopy(oa1, 0, result, 0, oa1.length);
        System.arraycopy(oa2, 0, result, oa1.length, oa2.length);
        return result;
    }

    public static AnalysisObject[] union(PointsToAnalysis bb, AnalysisObject[] a1, AnalysisObject[] a2) {
        if (a1.length == 1 && bb.analysisPolicy().isSummaryObject(a1[0])) {
            bb.analysisPolicy().noteMerge(bb, a1);
            bb.analysisPolicy().noteMerge(bb, a2);
            return a1;
        }
        if (a2.length == 1 && bb.analysisPolicy().isSummaryObject(a2[0])) {
            bb.analysisPolicy().noteMerge(bb, a1);
            bb.analysisPolicy().noteMerge(bb, a2);
            return a2;
        }
        if (a1.length >= a2.length) {
            return TypeStateUtils.arraysUnion(bb, a1, a2);
        }
        return TypeStateUtils.arraysUnion(bb, a2, a1);
    }

    private static AnalysisObject[] arraysUnion(PointsToAnalysis bb, AnalysisObject[] a1, AnalysisObject[] a2) {
        assert (a1.length >= a2.length) : "Union is commutative, must call it with a1 being the bigger state";
        assert (a1.length > 1 || !bb.analysisPolicy().isSummaryObject(a1[0])) : a1;
        assert (a2.length > 1 || !bb.analysisPolicy().isSummaryObject(a2[0])) : a2;
        if (a1 == a2) {
            return a1;
        }
        if (a1[a1.length - 1].getId() < a2[0].getId()) {
            return TypeStateUtils.checkUnionSize(bb, a1, a2, TypeStateUtils.concat(a1, a2));
        }
        if (a2[a2.length - 1].getId() < a1[0].getId()) {
            return TypeStateUtils.checkUnionSize(bb, a1, a2, TypeStateUtils.concat(a2, a1));
        }
        int idx1 = 0;
        int idx2 = 0;
        while (idx1 < a1.length) {
            AnalysisObject o1 = a1[idx1];
            AnalysisObject o2 = a2[idx2];
            if (o1.getId() < o2.getId()) {
                ++idx1;
                continue;
            }
            if (o1 != o2) break;
            ++idx1;
            if (++idx2 != a2.length) continue;
            return a1;
        }
        ArrayList<AnalysisObject> objectsList = new ArrayList<AnalysisObject>(a1.length + a2.length);
        objectsList.addAll(Arrays.asList(a1).subList(0, idx1));
        while (idx1 < a1.length && idx2 < a2.length) {
            AnalysisObject o1 = a1[idx1];
            AnalysisObject o2 = a2[idx2];
            if (o1.equals(o2)) {
                objectsList.add(o1);
                ++idx1;
                ++idx2;
                continue;
            }
            assert (o1.getId() != o2.getId()) : String.valueOf(o1) + ", " + String.valueOf(o2);
            if (o1.getId() < o2.getId()) {
                objectsList.add(o1);
                ++idx1;
                continue;
            }
            objectsList.add(o2);
            ++idx2;
        }
        if (idx1 < a1.length) {
            assert (idx2 == a2.length) : idx2;
            objectsList.addAll(Arrays.asList(a1).subList(idx1, a1.length));
        } else if (idx2 < a2.length) {
            assert (idx1 == a1.length) : idx1;
            objectsList.addAll(Arrays.asList(a2).subList(idx2, a2.length));
        }
        return TypeStateUtils.checkUnionSize(bb, a1, a2, objectsList.toArray(new AnalysisObject[objectsList.size()]));
    }

    private static AnalysisObject[] checkUnionSize(PointsToAnalysis bb, AnalysisObject[] oa1, AnalysisObject[] oa2, AnalysisObject[] result) {
        assert (result.length >= 2) : result;
        if (bb.analysisPolicy().limitObjectArrayLength() && result.length > bb.analysisPolicy().maxObjectSetSize()) {
            AnalysisObject rObj = result[0].type().getContextInsensitiveAnalysisObject();
            bb.analysisPolicy().noteMerge(bb, oa1);
            bb.analysisPolicy().noteMerge(bb, oa2);
            bb.analysisPolicy().noteMerge(bb, rObj);
            return new AnalysisObject[]{rObj};
        }
        return result;
    }

    public static boolean isContextInsensitiveTypeState(BigBang bb, TypeState state) {
        for (AnalysisObject object : state.objects(bb)) {
            if (object.isContextInsensitiveObject()) continue;
            return false;
        }
        return true;
    }

    public static boolean holdsSingleTypeState(AnalysisObject[] objects) {
        return TypeStateUtils.holdsSingleTypeState(objects, objects.length);
    }

    public static boolean holdsSingleTypeState(AnalysisObject[] objects, int size) {
        int lastType;
        int firstType = objects[0].getTypeId();
        return firstType == (lastType = objects[size - 1].getTypeId());
    }

    public static BitSet or(BitSet bs1, BitSet bs2) {
        BitSet bsr;
        if (bs1.size() > bs2.size()) {
            bsr = TypeStateUtils.getClone(bs1);
            bsr.or(bs2);
        } else {
            bsr = TypeStateUtils.getClone(bs2);
            bsr.or(bs1);
        }
        assert (!TypeStateUtils.needsTrim(bsr)) : bsr;
        return bsr;
    }

    public static BitSet and(BitSet bs1, BitSet bs2) {
        BitSet bsr;
        if (bs1.size() < bs2.size()) {
            bsr = TypeStateUtils.getClone(bs1);
            bsr.and(bs2);
        } else {
            bsr = TypeStateUtils.getClone(bs2);
            bsr.and(bs1);
        }
        TypeStateUtils.trimBitSetToSize(bsr);
        return bsr;
    }

    public static BitSet andNot(BitSet bs1, BitSet bs2) {
        BitSet bsr = TypeStateUtils.getClone(bs1);
        bsr.andNot(bs2);
        TypeStateUtils.trimBitSetToSize(bsr);
        return bsr;
    }

    public static BitSet clear(BitSet bs1, int bitIndex) {
        BitSet bsr = TypeStateUtils.getClone(bs1);
        bsr.clear(bitIndex);
        TypeStateUtils.trimBitSetToSize(bsr);
        return bsr;
    }

    public static BitSet set(BitSet bs1, int bitIndex) {
        BitSet bsr;
        int highestSetIndex = bs1.length() - 1;
        if (bitIndex > highestSetIndex) {
            bsr = new BitSet(bitIndex + 1);
            bsr.or(bs1);
            bsr.set(bitIndex);
        } else {
            bsr = TypeStateUtils.getClone(bs1);
            bsr.set(bitIndex);
        }
        assert (!TypeStateUtils.needsTrim(bsr)) : bsr;
        return bsr;
    }

    public static BitSet newBitSet(int index1, int index2) {
        BitSet bs = new BitSet(Math.max(index1, index2) + 1);
        bs.set(index1);
        bs.set(index2);
        assert (!TypeStateUtils.needsTrim(bs)) : bs;
        return bs;
    }

    private static BitSet getClone(BitSet original) {
        assert (TypeStateUtils.getSizeIsSticky(original)) : original;
        BitSet clone = (BitSet)original.clone();
        assert (!TypeStateUtils.needsTrim(clone)) : clone;
        return clone;
    }

    public static boolean closeToAllInstantiated(BigBang bb, TypeState state) {
        if (state.isPrimitive()) {
            return false;
        }
        return TypeStateUtils.closeToAllInstantiated(bb, state.typesCount());
    }

    public static boolean closeToAllInstantiated(BigBang bb, List<AnalysisType> state) {
        return TypeStateUtils.closeToAllInstantiated(bb, state.size());
    }

    private static boolean closeToAllInstantiated(BigBang bb, int typeCount) {
        if (typeCount > 200) {
            int allInstCount = (int)StreamSupport.stream(bb.getAllInstantiatedTypes().spliterator(), false).count();
            return (long)typeCount * 100L / (long)allInstCount > 75L;
        }
        return false;
    }

    static {
        try {
            bitSetArrayAccess = MethodHandles.lookup().unreflectGetter(ReflectionUtil.lookupField(BitSet.class, (String)"words"));
            wordInUseAccess = MethodHandles.lookup().unreflectGetter(ReflectionUtil.lookupField(BitSet.class, (String)"wordsInUse"));
            sizeIsStickyAccess = MethodHandles.lookup().unreflectGetter(ReflectionUtil.lookupField(BitSet.class, (String)"sizeIsSticky"));
            trimToSizeAccess = MethodHandles.lookup().unreflect(ReflectionUtil.lookupMethod(BitSet.class, (String)"trimToSize", (Class[])new Class[0]));
        }
        catch (IllegalAccessException t) {
            throw JVMCIError.shouldNotReachHere((Throwable)t);
        }
    }
}

