/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphInfo;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.BaseLayerType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.DefaultInvokeTypeFlowUtil;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.common.meta.MultiMethod;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import jdk.vm.ci.code.BytecodePosition;

final class DefaultVirtualInvokeTypeFlow
extends AbstractVirtualInvokeTypeFlow {
    private TypeState seenReceiverTypes = TypeState.forEmpty();

    DefaultVirtualInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, MultiMethod.MultiMethodKey callerMultiMethodKey) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, callerMultiMethodKey);
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        if (!this.isFlowEnabled()) {
            return;
        }
        if (this.isSaturated()) {
            return;
        }
        TypeState receiverState = this.getReceiver().getState();
        if (!this.isContextInsensitive()) {
            receiverState = this.filterReceiverState(bb, receiverState);
        }
        for (AnalysisType type : receiverState.types(bb)) {
            assert (this.receiverType.isAssignableFrom(type) || type.getWrapped() instanceof BaseLayerType) : String.valueOf(type) + " should be a subtype of " + String.valueOf(this.receiverType);
            if (this.isSaturated()) {
                return;
            }
            if (this.seenReceiverTypes.containsType(type)) continue;
            AnalysisMethod method = null;
            try {
                method = type.resolveConcreteMethod(this.targetMethod);
            }
            catch (UnsupportedFeatureException ex) {
                bb.getUnsupportedFeatures().addMessage("resolve_" + this.targetMethod.format("%H.%n(%p)"), this.targetMethod, ex.getMessage(), null, ex);
            }
            if (method == null || Modifier.isAbstract(method.getModifiers())) continue;
            assert (!Modifier.isAbstract(method.getModifiers())) : method;
            Collection<PointsToAnalysisMethod> calleeList = bb.getHostVM().getMultiMethodAnalysisPolicy().determineCallees(bb, PointsToAnalysis.assertPointsToAnalysisMethod(method), this.targetMethod, this.callerMultiMethodKey, this);
            for (PointsToAnalysisMethod callee : calleeList) {
                if (!callee.isOriginalMethod() && this.allOriginalCallees) {
                    this.allOriginalCallees = false;
                }
                MethodFlowsGraphInfo calleeFlows = callee.getTypeFlow().getOrCreateMethodFlowsGraphInfo(bb, this);
                assert (callee.getTypeFlow().getMethod().equals(callee)) : callee;
                if (this.addCallee(callee)) {
                    this.linkCallee(bb, false, calleeFlows);
                }
                this.updateReceiver(bb, calleeFlows, TypeState.forExactType(bb, type, false));
            }
        }
        this.seenReceiverTypes = receiverState;
    }

    @Override
    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        assert (this.isFlowEnabled()) : "Should only be executed if this flow is enabled " + String.valueOf(this);
        if (!this.setSaturated()) {
            return;
        }
        AbstractVirtualInvokeTypeFlow contextInsensitiveInvoke = (AbstractVirtualInvokeTypeFlow)this.targetMethod.initAndGetContextInsensitiveInvoke(bb, (BytecodePosition)this.source, false, this.callerMultiMethodKey);
        contextInsensitiveInvoke.addInvokeLocation((BytecodePosition)this.getSource());
        this.getReceiver().removeObserver(this);
        for (AnalysisMethod callee : super.getAllCallees()) {
            MethodFlowsGraphInfo calleeFlows = PointsToAnalysis.assertPointsToAnalysisMethod(callee).getTypeFlow().getMethodFlowsGraphInfo();
            for (int i = 0; i < this.actualParameters.length; ++i) {
                FormalParamTypeFlow formalParam = calleeFlows.getParameter(i);
                if (this.actualParameters[i] == null || formalParam == null) continue;
                this.actualParameters[i].removeUse(formalParam);
            }
            if (this.actualReturn == null || calleeFlows.getReturnFlow() == null) continue;
            calleeFlows.getReturnFlow().removeUse(this.actualReturn);
        }
        for (int i = 1; i < this.actualParameters.length; ++i) {
            if (this.actualParameters[i] == null) continue;
            this.actualParameters[i].addUse(bb, contextInsensitiveInvoke.getActualParameter(i));
        }
        if (this.actualReturn != null) {
            contextInsensitiveInvoke.getActualReturn().addUse(bb, this.actualReturn);
        }
    }

    @Override
    public boolean setSaturated() {
        boolean success = super.setSaturated();
        if (this.isClone()) {
            success |= this.originalInvoke.setSaturated();
        }
        return success;
    }

    @Override
    public Collection<AnalysisMethod> getOriginalCallees() {
        if (this.isSaturated()) {
            return this.targetMethod.getContextInsensitiveVirtualInvoke(this.callerMultiMethodKey).getOriginalCallees();
        }
        return super.getOriginalCallees();
    }

    @Override
    public Collection<AnalysisMethod> getAllCallees() {
        if (this.isSaturated()) {
            return this.targetMethod.getContextInsensitiveVirtualInvoke(this.callerMultiMethodKey).getAllCallees();
        }
        return super.getAllCallees();
    }

    @Override
    public Collection<AnalysisMethod> getCalleesForReturnLinking() {
        if (this.isSaturated()) {
            return Collections.emptyList();
        }
        return super.getAllCallees();
    }

    @Override
    public Collection<MethodFlowsGraph> getAllNonStubCalleesFlows(PointsToAnalysis bb) {
        return DefaultInvokeTypeFlowUtil.getAllNonStubCalleesFlows(this);
    }
}

