/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.object;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.flow.context.object.ContextSensitiveAnalysisObject;
import com.oracle.graal.pointsto.heap.ImageHeapRelocatableConstant;
import com.oracle.graal.pointsto.meta.AnalysisType;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.JavaConstant;

public class ConstantContextSensitiveObject
extends ContextSensitiveAnalysisObject {
    private final JavaConstant constant;
    private volatile boolean mergedWithUniqueConstant;

    public ConstantContextSensitiveObject(PointsToAnalysis bb, AnalysisType type) {
        this(bb, type, null);
    }

    public ConstantContextSensitiveObject(PointsToAnalysis bb, AnalysisType type, JavaConstant constant) {
        super(bb.getUniverse(), type, AnalysisObject.AnalysisObjectKind.ConstantContextSensitive);
        assert (bb.trackConcreteAnalysisObjects(type)) : type;
        assert (!(constant instanceof ImageHeapRelocatableConstant)) : "relocatable constants have an unknown state and should not be represented by a constant type state: " + String.valueOf(constant);
        this.constant = constant;
        bb.profileConstantObject(type);
    }

    @Override
    public JavaConstant asConstant() {
        return this.constant;
    }

    public boolean isMergedConstantObject() {
        return this.constant == null;
    }

    public void setMergedWithUniqueConstantObject() {
        this.mergedWithUniqueConstant = true;
    }

    @Override
    public void noteMerge(PointsToAnalysis bb) {
        assert (bb.analysisPolicy().isMergingEnabled()) : "policy mismatch";
        if (!this.merged && !this.isEmptyObjectArrayConstant(bb)) {
            super.noteMerge(bb);
        }
    }

    @Override
    protected List<AnalysisObject> getAllObjectsMergedWith() {
        ArrayList<AnalysisObject> result = new ArrayList<AnalysisObject>();
        if (this.merged) {
            result.add(this.type().getContextInsensitiveAnalysisObject());
        }
        if (this.mergedWithUniqueConstant) {
            result.add(this.type().getUniqueConstantObject());
        }
        return result;
    }

    @Override
    public boolean isEmptyObjectArrayConstant(PointsToAnalysis bb) {
        if (this.isMergedConstantObject()) {
            return false;
        }
        return AnalysisObject.isEmptyObjectArrayConstant(bb, this.asConstant());
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(super.toString()).append("  ");
        if (this.constant == null) {
            result.append("MERGED CONSTANT");
        } else {
            result.append(this.constant);
        }
        return result.toString();
    }
}

