/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.bytecode;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.CallSiteSensitiveMethodTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphClone;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphInfo;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeAnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeSensitiveAnalysisPolicy;
import com.oracle.graal.pointsto.flow.context.bytecode.TypesObjectsIterator;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.common.meta.MultiMethod;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.code.BytecodePosition;

final class BytecodeSensitiveVirtualInvokeTypeFlow
extends AbstractVirtualInvokeTypeFlow {
    private final Set<MethodFlowsGraph> calleesFlows = new ConcurrentHashMap(4, 0.75f, 1).keySet(Boolean.TRUE);
    private final AnalysisContext callerContext;

    BytecodeSensitiveVirtualInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, MultiMethod.MultiMethodKey callerMultiMethodKey) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, callerMultiMethodKey);
        this.callerContext = null;
    }

    private BytecodeSensitiveVirtualInvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, BytecodeSensitiveVirtualInvokeTypeFlow original) {
        super(bb, methodFlows, original);
        this.callerContext = ((MethodFlowsGraphClone)methodFlows).context();
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new BytecodeSensitiveVirtualInvokeTypeFlow(bb, methodFlows, this);
    }

    @Override
    protected void onFlowEnabled(PointsToAnalysis bb) {
        if (this.isClone()) {
            bb.postTask(() -> this.onObservedUpdate(bb));
        }
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        assert (this.isClone() || this.isContextInsensitive()) : this;
        TypeState receiverState = this.getReceiver().getState();
        if ((receiverState = this.filterReceiverState(bb, receiverState)).isEmpty() || receiverState.isNull()) {
            return;
        }
        TypesObjectsIterator toi = new TypesObjectsIterator(receiverState);
        while (toi.hasNextType()) {
            AnalysisType type = toi.nextType();
            AnalysisMethod method = type.resolveConcreteMethod(this.getTargetMethod());
            if (method == null || Modifier.isAbstract(method.getModifiers())) {
                toi.skipObjects(type);
                continue;
            }
            assert (!Modifier.isAbstract(method.getModifiers())) : method;
            Collection<PointsToAnalysisMethod> calleeList = bb.getHostVM().getMultiMethodAnalysisPolicy().determineCallees(bb, PointsToAnalysis.assertPointsToAnalysisMethod(method), this.targetMethod, this.callerMultiMethodKey, this);
            for (PointsToAnalysisMethod callee : calleeList) {
                if (!callee.isOriginalMethod() && this.allOriginalCallees) {
                    this.allOriginalCallees = false;
                }
                CallSiteSensitiveMethodTypeFlow calleeTypeFlow = (CallSiteSensitiveMethodTypeFlow)callee.getTypeFlow();
                while (toi.hasNextObject(type)) {
                    AnalysisObject actualReceiverObject = toi.nextObject(type);
                    BytecodeAnalysisContext calleeContext = BytecodeSensitiveAnalysisPolicy.contextPolicy(bb).calleeContext(bb, actualReceiverObject, (BytecodeAnalysisContext)this.callerContext, (MethodTypeFlow)calleeTypeFlow);
                    MethodFlowsGraphInfo calleeFlows = calleeTypeFlow.addContext(bb, calleeContext, this);
                    if (this.calleesFlows.add((MethodFlowsGraph)calleeFlows)) {
                        this.addCallee(calleeFlows.getMethod());
                        this.linkCallee(bb, false, calleeFlows);
                    }
                    this.updateReceiver(bb, calleeFlows, actualReceiverObject);
                }
            }
        }
    }

    @Override
    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        this.replaceObservedWith(bb, this.receiverType);
    }

    @Override
    public Collection<MethodFlowsGraph> getAllNonStubCalleesFlows(PointsToAnalysis bb) {
        return this.calleesFlows;
    }
}

