/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reporter.flamegraph;

import com.oracle.graal.reporter.data.SamplerOutputData;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import jdk.graal.compiler.util.json.JsonFormatter;
import org.graalvm.collections.EconomicMap;

public final class SVGSamplerOutput {
    private static final EconomicMap<String, Boolean> OPTIONS = EconomicMap.create();
    private final StringBuilder output = new StringBuilder();

    SVGSamplerOutput() {
    }

    public static String generateSamplingFlameGraph(SamplerOutputData.SamplingData data, String profiles) throws IOException {
        GraphOwner graph = new GraphOwner(data);
        graph.addComponent(new SVGFlameGraph(graph, profiles));
        graph.addComponent(new SVGHistogram(graph));
        return graph.generateSVG();
    }

    private static String generateGroupStart(Map<String, String> attributes) {
        StringBuilder result = new StringBuilder();
        result.append("<g ");
        for (String key : new String[]{"class", "style", "onmouseover", "onmouseout", "onclick", "id"}) {
            if (!attributes.containsKey(key)) continue;
            result.append(String.format("%s=\"%s\"", key, attributes.get(key)));
            result.append(" ");
        }
        result.append(">").append(System.lineSeparator());
        if (attributes.containsKey("g_extra")) {
            result.append(attributes.get("g_extra"));
        }
        if (attributes.containsKey("title")) {
            result.append(String.format("<title>%s</title>", attributes.get("title")));
        }
        if (attributes.containsKey("href")) {
            result.append(String.format("<a xlink:href=%s", attributes.get("href")));
            String target = attributes.getOrDefault("target", "_top");
            result.append(String.format(" target=%s", target));
        }
        return result.toString();
    }

    private static String generateGroupEnd(Map<String, String> attributes) {
        StringBuilder result = new StringBuilder();
        if (attributes.containsKey("href")) {
            result.append("</a>").append(System.lineSeparator());
        }
        result.append("</g>").append(System.lineSeparator());
        return result.toString();
    }

    private static String generateSubDrawingStart(Map<String, String> attributes) {
        StringBuilder result = new StringBuilder();
        result.append("<svg ");
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            result.append(String.format("%s=\"%s\"", e.getKey(), e.getValue()));
            result.append(" ");
        }
        result.append(">").append(System.lineSeparator());
        return result.toString();
    }

    private static String generateSubDrawingEnd() {
        return "</svg>" + System.lineSeparator();
    }

    private static String generateFilledRectangle(double x1, double y1, double w, double h, String fill, String extras, Map<String, String> attributes) {
        StringBuilder result = new StringBuilder();
        result.append(String.format("<rect x=\"%f\" y=\"%f\" width=\"%f\" height=\"%f\" fill=\"%s\" %s", x1, y1, w, h, fill, extras));
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            result.append(String.format(" %s=\"%s\"", entry.getKey(), entry.getValue()));
        }
        result.append("/>").append(System.lineSeparator());
        return result.toString();
    }

    public static String generateFilledText(String color, String font, double size, double x, double y, String text, String loc, String extras) {
        return String.format("<text text-anchor=\"%s\" x=\"%f\" y=\"%f\" font-size=\"%f\" font-family=\"%s\" fill=\"%s\" %s >%s</text>%n", loc == null ? "left" : loc, x, y, size, font, color, extras == null ? "" : extras, SVGSamplerOutput.escapeText(text));
    }

    private static String escapeText(String text) {
        return text.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String generateRGBColor(int r, int g, int b) {
        return String.format("rgb(%d, %d, %d)", r, g, b);
    }

    private void appendSVGStart(double width, double height) {
        this.output.append("<?xml version=\"1.0\" standalone=\"no\"?>").append(System.lineSeparator());
        this.output.append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">").append(System.lineSeparator());
        this.output.append(String.format("<svg version=\"1.1\" width=\"%1$f\" height=\"%2$f\" onload=\"init(evt)\" viewBox=\"0 0 %1$f %2$f\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">%n", width, height));
    }

    private void appendSection(String data) {
        this.output.append(data);
    }

    private void appendSVGEnd() {
        this.output.append("</svg>");
    }

    public String toString() {
        return this.output.toString();
    }

    static {
        OPTIONS.put((Object)"gradientBackground", (Object)Boolean.FALSE);
        OPTIONS.put((Object)"colorCycling", (Object)Boolean.FALSE);
        OPTIONS.put((Object)"collapseRecursiveCalls", (Object)Boolean.FALSE);
        OPTIONS.put((Object)"canvasResizing", (Object)Boolean.FALSE);
    }

    private static class GraphOwner
    implements SVGComponent {
        private static int sampleId = 0;
        private final SVGSamplerOutput svg = new SVGSamplerOutput();
        private final ArrayList<SVGComponent> components = new ArrayList();
        private final Random random = new Random();
        private final Map<GraphColorMap, String> languageColors = new HashMap<GraphColorMap, String>();
        private final Map<GraphColorMap, Map<SampleKey, String>> colorsForKeys = new HashMap<GraphColorMap, Map<SampleKey, String>>();
        private final HashMap<Integer, HashMap<SampleKey, EconomicMap<String, Object>>> recursiveChildMap = new HashMap();
        private final Map<String, Integer> sampleNameIds = new HashMap<String, Integer>();
        private final Map<String, Integer> sourceIds = new HashMap<String, Integer>();
        private final Map<SampleKey, Integer> sampleKeyIds = new HashMap<SampleKey, Integer>();
        private final List<String> sampleNames = new ArrayList<String>();
        private final List<String> sourceNames = new ArrayList<String>();
        private final ArrayList<SampleKey> sampleKeys = new ArrayList();
        private final List<List<Integer>> sampleJsonKeys = new ArrayList<List<Integer>>();
        private final List<EconomicMap<String, Object>> sampleData = new ArrayList<EconomicMap<String, Object>>();

        GraphOwner(SamplerOutputData.SamplingData data) {
            this.languageColors.put(GraphColorMap.GRAY, "<none>");
            this.buildSampleData(data);
        }

        private int getSampleKeyId(int id, String sampleName) {
            int sampleNameId = this.sampleNameIds.computeIfAbsent(sampleName, k -> {
                this.sampleNames.add((String)k);
                return this.sampleNames.size() - 1;
            });
            int sourceId = this.sourceIds.computeIfAbsent("<none>", k -> {
                this.sourceNames.add((String)k);
                return this.sourceNames.size() - 1;
            });
            int sourceLine = 0;
            return this.sampleKeyIds.computeIfAbsent(new SampleKey(id, sampleNameId, sourceId, sourceLine), k -> {
                this.sampleKeys.add((SampleKey)k);
                ArrayList<Integer> sampleJsonKey = new ArrayList<Integer>();
                sampleJsonKey.add(k.sampleId);
                sampleJsonKey.add(k.nameId);
                sampleJsonKey.add(k.sourceId);
                sampleJsonKey.add(k.sourceLine);
                this.sampleJsonKeys.add(sampleJsonKey);
                return this.sampleKeys.size() - 1;
            });
        }

        protected EconomicMap<String, Object> getSampleData(int id) {
            return this.sampleData.get(id);
        }

        protected String getSampleName(int keyId) {
            return this.sampleNames.get(this.sampleKeys.get((int)keyId).nameId);
        }

        private long buildEntryPointSampleData(SamplerOutputData.SamplingNode entyPointNode, ArrayDeque<Task> tasks, List<Integer> siblings, long x) {
            EconomicMap entryPointSample = EconomicMap.create();
            this.sampleData.add((EconomicMap<String, Object>)entryPointSample);
            int id = sampleId++;
            entryPointSample.put((Object)"id", (Object)id);
            int entryPointBci = 0;
            entryPointSample.put((Object)"k", (Object)this.getSampleKeyId(id, GraphOwner.generateSampleName(entyPointNode, entryPointBci)));
            entryPointSample.put((Object)"p", (Object)0);
            entryPointSample.put((Object)"i", (Object)0);
            entryPointSample.put((Object)"c", (Object)0);
            entryPointSample.put((Object)"l", (Object)GraphColorMap.GRAY.ordinal());
            entryPointSample.put((Object)"sc", (Object)GraphColorMap.RED.ordinal());
            entryPointSample.put((Object)"x", (Object)x);
            long totalSamples = 0L;
            ArrayList<Integer> children = new ArrayList<Integer>();
            long childCount = 0L;
            for (Map.Entry<Integer, List<SamplerOutputData.SamplingNode>> entry : entyPointNode.children().entrySet()) {
                Integer bci = entry.getKey();
                List<SamplerOutputData.SamplingNode> nodes = entry.getValue();
                for (SamplerOutputData.SamplingNode childNode : nodes) {
                    tasks.addLast(new Task(childNode, bci, children, totalSamples + x, id));
                    totalSamples += childNode.totalCount();
                    ++childCount;
                }
            }
            entryPointSample.put((Object)"h", (Object)totalSamples);
            if (childCount > 0L) {
                entryPointSample.put((Object)"s", children);
            }
            siblings.add(GraphOwner.getInt((EconomicMap<String, Object>)entryPointSample, "id"));
            return totalSamples;
        }

        private GraphColorMap getLanguageColorMap() {
            String language = "<none>";
            GraphColorMap color = GraphColorMap.GRAY;
            if (this.languageColors.containsValue(language)) {
                for (Map.Entry<GraphColorMap, String> entry : this.languageColors.entrySet()) {
                    if (!language.equals(entry.getValue())) continue;
                    color = entry.getKey();
                    break;
                }
            } else {
                for (GraphColorMap key : GraphColorMap.values()) {
                    if (key == GraphColorMap.FLAME || this.languageColors.containsKey((Object)key)) continue;
                    color = key;
                    this.languageColors.put(key, language);
                    break;
                }
            }
            return color;
        }

        private static String generateSampleName(SamplerOutputData.SamplingNode node, int bci) {
            if (node.compilationRoot() != null) {
                return node.compilationRoot() + ":" + bci;
            }
            return node.method() + ":" + bci;
        }

        private static GraphColorMap getSampleColorMap(SamplerOutputData.SamplingNode.State state) {
            switch (state) {
                case HOT_ROOT: {
                    return GraphColorMap.RED;
                }
                case INLINED: {
                    return GraphColorMap.AQUA;
                }
            }
            return GraphColorMap.GRAY;
        }

        private static int getInt(EconomicMap<String, Object> map, String key) {
            Object value = map.get((Object)key);
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            throw new IllegalStateException("Value is not an integer: " + String.valueOf(value));
        }

        private void processSample(Task task, ArrayDeque<Task> tasks) {
            EconomicMap sample = EconomicMap.create();
            this.sampleData.add((EconomicMap<String, Object>)sample);
            SamplerOutputData.SamplingNode node = task.node;
            int id = sampleId++;
            sample.put((Object)"id", (Object)id);
            sample.put((Object)"k", (Object)this.getSampleKeyId(id, GraphOwner.generateSampleName(node, task.bci)));
            sample.put((Object)"p", (Object)task.parent);
            sample.put((Object)"i", (Object)0);
            sample.put((Object)"c", (Object)node.selfCount());
            sample.put((Object)"h", (Object)node.totalCount());
            sample.put((Object)"l", (Object)this.getLanguageColorMap().ordinal());
            sample.put((Object)"sc", (Object)GraphOwner.getSampleColorMap(node.state()).ordinal());
            sample.put((Object)"x", (Object)task.x);
            ArrayList<Integer> children = new ArrayList<Integer>();
            int childCount = 0;
            long offset = node.selfCount();
            for (Map.Entry<Integer, List<SamplerOutputData.SamplingNode>> entry : node.children().entrySet()) {
                Integer bci = entry.getKey();
                List<SamplerOutputData.SamplingNode> nodes = entry.getValue();
                for (SamplerOutputData.SamplingNode childNode : nodes) {
                    tasks.addLast(new Task(childNode, bci, children, task.x + offset, id));
                    offset += childNode.totalCount();
                    ++childCount;
                }
            }
            if (childCount > 0) {
                sample.put((Object)"s", children);
            }
            task.siblings.add(GraphOwner.getInt((EconomicMap<String, Object>)sample, "id"));
        }

        public Map<SampleKey, String> colorsForType(GraphColorMap type) {
            if (this.colorsForKeys.containsKey((Object)type)) {
                return this.colorsForKeys.get((Object)type);
            }
            HashMap<SampleKey, String> colors = new HashMap<SampleKey, String>();
            this.colorsForKeys.put(type, colors);
            return colors;
        }

        public String colorForKey(int keyId, GraphColorMap type) {
            SampleKey key = this.sampleKeys.get(keyId);
            Map<SampleKey, String> colors = this.colorsForType(type);
            if (colors.containsKey(key)) {
                return colors.get(key);
            }
            int r = 0;
            int g = 9;
            int b = 0;
            double v1 = this.random.nextDouble();
            double v2 = this.random.nextDouble();
            double v3 = this.random.nextDouble();
            switch (type.ordinal()) {
                case 0: {
                    r = (int)(200.0 + 35.0 * v3);
                    g = (int)(100.0 + 100.0 * v1);
                    b = (int)(30.0 + 50.0 * v2);
                    break;
                }
                case 4: {
                    r = (int)(200.0 + 55.0 * v1);
                    b = g = (int)(80.0 * v1);
                    break;
                }
                case 2: {
                    r = (int)(190.0 + 65.0 * v1);
                    g = (int)(90.0 + 65.0 * v1);
                    b = 0;
                    break;
                }
                case 5: {
                    g = r = (int)(175.0 + 55.0 * v1);
                    b = (int)(50.0 + 20.0 * v1);
                    break;
                }
                case 3: {
                    g = (int)(200.0 + 55.0 * v1);
                    b = r = (int)(80.0 * v1);
                    break;
                }
                case 1: {
                    r = (int)(50.0 + 60.0 * v1);
                    g = (int)(165.0 + 55.0 * v1);
                    b = (int)(165.0 + 55.0 * v1);
                    break;
                }
                case 7: {
                    g = r = (int)(80.0 * v1);
                    b = (int)(200.0 + 55.0 * v1);
                    break;
                }
                case 6: {
                    r = (int)(190.0 + 65.0 * v1);
                    g = (int)(80.0 + 60.0 * v1);
                    b = r;
                    break;
                }
                case 8: {
                    g = r = (int)(175.0 + 55.0 * v1);
                    b = r;
                }
            }
            String color = SVGSamplerOutput.generateRGBColor(r, g, b);
            colors.put(key, color);
            return color;
        }

        private void buildColorDataForSample(EconomicMap<String, Object> sample) {
            this.colorForKey(GraphOwner.getInt(sample, "k"), GraphColorMap.values()[GraphOwner.getInt(sample, "sc")]);
            this.colorForKey(GraphOwner.getInt(sample, "k"), GraphColorMap.FLAME);
            this.colorForKey(GraphOwner.getInt(sample, "k"), GraphColorMap.values()[GraphOwner.getInt(sample, "l")]);
        }

        private void buildColorData() {
            for (EconomicMap<String, Object> sample : this.sampleData) {
                this.buildColorDataForSample(sample);
            }
        }

        private HashMap<SampleKey, EconomicMap<String, Object>> childrenByKeyForSample(EconomicMap<String, Object> sample) {
            return this.recursiveChildMap.computeIfAbsent(GraphOwner.getInt(sample, "id"), k -> new HashMap());
        }

        private static void addRecursiveChild(EconomicMap<String, Object> sample, EconomicMap<String, Object> child) {
            List<Integer> children;
            if (!sample.containsKey((Object)"rs")) {
                children = new ArrayList();
                sample.put((Object)"rs", children);
            } else {
                children = (List)sample.get((Object)"rs");
            }
            children.add(GraphOwner.getInt(child, "id"));
            child.put((Object)"rc", (Object)GraphOwner.getInt(child, "c"));
            child.put((Object)"ri", (Object)GraphOwner.getInt(child, "i"));
            child.put((Object)"rh", (Object)GraphOwner.getInt(child, "h"));
        }

        private static void mergeCounts(EconomicMap<String, Object> a, EconomicMap<String, Object> b, boolean child) {
            int aRI = a.containsKey((Object)"ri") ? GraphOwner.getInt(a, "ri") : GraphOwner.getInt(a, "i");
            int aRC = a.containsKey((Object)"rc") ? GraphOwner.getInt(a, "rc") : GraphOwner.getInt(a, "c");
            int aRH = a.containsKey((Object)"rh") ? GraphOwner.getInt(a, "rh") : GraphOwner.getInt(a, "h");
            aRI += GraphOwner.getInt(b, "i");
            aRC += GraphOwner.getInt(b, "c");
            if (!child) {
                aRH += GraphOwner.getInt(b, "h");
            }
            a.put((Object)"ri", (Object)aRI);
            a.put((Object)"rc", (Object)aRC);
            a.put((Object)"rh", (Object)aRH);
            b.put((Object)"ro", (Object)GraphOwner.getInt(a, "id"));
        }

        private void calculateRecursiveData(EconomicMap<String, Object> sample) {
            if (sample.containsKey((Object)"p")) {
                EconomicMap<String, Object> parent = this.getSampleData(GraphOwner.getInt(sample, "p"));
                EconomicMap<String, Object> owner = parent.containsKey((Object)"ro") ? this.getSampleData(GraphOwner.getInt(parent, "ro")) : parent;
                if (GraphOwner.getInt(parent, "k") == GraphOwner.getInt(sample, "k")) {
                    GraphOwner.mergeCounts(owner, sample, true);
                } else {
                    SampleKey key;
                    HashMap<SampleKey, EconomicMap<String, Object>> siblings = this.childrenByKeyForSample(owner);
                    if (siblings.containsKey(key = this.sampleKeys.get(GraphOwner.getInt(sample, "k")))) {
                        EconomicMap<String, Object> sibling = siblings.get(key);
                        GraphOwner.mergeCounts(sibling, sample, false);
                    } else {
                        siblings.put(key, sample);
                        GraphOwner.addRecursiveChild(owner, sample);
                    }
                    sample.put((Object)"rp", (Object)GraphOwner.getInt(owner, "id"));
                }
            } else {
                sample.put((Object)"rc", (Object)GraphOwner.getInt(sample, "c"));
                sample.put((Object)"ri", (Object)GraphOwner.getInt(sample, "i"));
                sample.put((Object)"rh", (Object)GraphOwner.getInt(sample, "h"));
            }
        }

        private void buildRecursiveData() {
            for (EconomicMap<String, Object> sample : this.sampleData) {
                this.calculateRecursiveData(sample);
            }
            ArrayDeque<RecursivePositionTask> tasks = new ArrayDeque<RecursivePositionTask>();
            RecursivePositionTask task = new RecursivePositionTask(this.getSampleData(0), 0L);
            while (task != null) {
                task.sample.put((Object)"rx", (Object)task.x);
                if (task.sample.containsKey((Object)"rs")) {
                    long offset = task.x + (long)GraphOwner.getInt(task.sample, "ri") + (long)GraphOwner.getInt(task.sample, "rc");
                    for (Object childId : (List)task.sample.get((Object)"rs")) {
                        EconomicMap<String, Object> child = this.getSampleData((Integer)childId);
                        tasks.add(new RecursivePositionTask(child, offset));
                        offset += (long)GraphOwner.getInt(child, "rh");
                    }
                }
                task = (RecursivePositionTask)tasks.poll();
            }
        }

        private void buildSampleData(SamplerOutputData.SamplingData data) {
            ArrayDeque<Task> tasks = new ArrayDeque<Task>();
            EconomicMap rootSample = EconomicMap.create();
            this.sampleData.add((EconomicMap<String, Object>)rootSample);
            int id = sampleId++;
            rootSample.put((Object)"id", (Object)id);
            rootSample.put((Object)"k", (Object)this.getSampleKeyId(id, "All entry points"));
            rootSample.put((Object)"i", (Object)0);
            rootSample.put((Object)"c", (Object)0);
            rootSample.put((Object)"x", (Object)0);
            rootSample.put((Object)"l", (Object)GraphColorMap.GRAY.ordinal());
            rootSample.put((Object)"sc", (Object)GraphColorMap.RED.ordinal());
            long totalSamples = 0L;
            ArrayList<Integer> children = new ArrayList<Integer>();
            for (SamplerOutputData.SamplingNode entryPointNode : data.entryPoints()) {
                totalSamples += this.buildEntryPointSampleData(entryPointNode, tasks, children, totalSamples);
            }
            rootSample.put((Object)"h", (Object)totalSamples);
            rootSample.put((Object)"s", children);
            Task task = tasks.poll();
            while (task != null) {
                this.processSample(task, tasks);
                task = tasks.poll();
            }
            this.buildColorData();
            this.buildRecursiveData();
        }

        public void addComponent(SVGComponent component) {
            this.components.add(component);
        }

        public String generateSVG() throws IOException {
            this.svg.appendSVGStart(this.width(), this.height());
            this.svg.appendSection(this.css());
            this.svg.appendSection(this.script());
            this.svg.appendSection(this.drawCanvas(0.0, 0.0));
            this.svg.appendSVGEnd();
            return this.svg.toString();
        }

        @Override
        public String css() {
            StringBuilder css = new StringBuilder();
            if (((Boolean)OPTIONS.get((Object)"gradientBackground")).booleanValue()) {
                css.append("<defs>").append(System.lineSeparator());
                css.append("\t<linearGradient id=\"background\" y1=\"0\" y2=\"1\" x1=\"0\" x2=\"0\" >").append(System.lineSeparator());
                css.append(String.format("\t\t<stop stop-color=\"%s\" offset=\"5%%\" />%n", Color.GRADIENT_BACKGROUND_START));
                css.append(String.format("\t\t<stop stop-color=\"%s\" offset=\"95%%\" />%n", Color.GRADIENT_BACKGROUND_END));
                css.append("\t</linearGradient>").append(System.lineSeparator());
                css.append("</defs>").append(System.lineSeparator());
            }
            css.append("<style type=\"text/css\">").append(System.lineSeparator());
            for (SVGComponent component : this.components) {
                css.append(component.css());
            }
            css.append("</style>").append(System.lineSeparator());
            return css.toString();
        }

        static String readResource(String name) {
            StringBuilder resource = new StringBuilder();
            try (InputStream stream = SVGHistogram.class.getResourceAsStream("resources/" + name);){
                assert (stream != null);
                try (Scanner scanner = new Scanner(stream);){
                    while (scanner.hasNextLine()) {
                        resource.append(scanner.nextLine());
                        resource.append(System.lineSeparator());
                    }
                }
            }
            catch (IOException e) {
                throw new Error("Resources are missing from this build.");
            }
            return resource.toString();
        }

        private String samples() {
            StringBuilder result = new StringBuilder();
            result.append("var profileNames = ");
            result.append(JsonFormatter.formatJson(this.sampleNames));
            result.append(";");
            result.append(System.lineSeparator());
            result.append("var sourceNames = ");
            result.append(JsonFormatter.formatJson(this.sourceNames));
            result.append(";");
            result.append(System.lineSeparator());
            result.append("var sampleKeys = ");
            result.append(JsonFormatter.formatJson(this.sampleJsonKeys));
            result.append(";");
            result.append(System.lineSeparator());
            result.append("var profileData = ");
            result.append(JsonFormatter.formatJson(this.sampleData));
            result.append(";");
            result.append(System.lineSeparator());
            result.append("var colorData = ");
            ArrayList<EconomicMap> colors = new ArrayList<EconomicMap>();
            for (GraphColorMap cm : GraphColorMap.values()) {
                if (this.colorsForKeys.containsKey((Object)cm)) {
                    EconomicMap map = EconomicMap.create();
                    for (Map.Entry<SampleKey, String> e : this.colorsForKeys.get((Object)cm).entrySet()) {
                        map.put((Object)this.sampleKeyIds.get(e.getKey()).toString(), (Object)e.getValue());
                    }
                    colors.add(map);
                    continue;
                }
                colors.add(EconomicMap.create());
            }
            result.append(JsonFormatter.formatJson(colors));
            result.append(";");
            result.append(System.lineSeparator());
            result.append("var languageNames = ");
            ArrayList<String> languageNames = new ArrayList<String>();
            for (GraphColorMap cm : GraphColorMap.values()) {
                languageNames.add(this.languageColors.getOrDefault((Object)cm, ""));
            }
            result.append(JsonFormatter.formatJson(languageNames));
            result.append(";");
            result.append(System.lineSeparator());
            return result.toString();
        }

        @Override
        public String initFunction(String argName) {
            StringBuilder result = new StringBuilder();
            result.append(String.format("function init(%s) {%n", argName));
            for (SVGComponent component : this.components) {
                result.append(component.initFunction(argName));
            }
            result.append("resize();").append(System.lineSeparator());
            result.append("}").append(System.lineSeparator());
            return result.toString();
        }

        @Override
        public String resizeFunction() {
            StringBuilder result = new StringBuilder();
            result.append("function resize() {").append(System.lineSeparator());
            result.append("owner_resize(document.firstElementChild.clientWidth);").append(System.lineSeparator());
            for (SVGComponent component : this.components) {
                result.append(component.resizeFunction());
            }
            result.append("}").append(System.lineSeparator());
            result.append("window.onresize = resize;").append(System.lineSeparator());
            return result.toString();
        }

        @Override
        public String searchFunction(String argName) {
            StringBuilder result = new StringBuilder();
            result.append(String.format("var searchColor = \"%s\";%n", Color.SEARCH));
            result.append(GraphOwner.readResource("search.js"));
            result.append(String.format("function search(%s) {%n", argName));
            for (SVGComponent component : this.components) {
                result.append(component.searchFunction(argName));
            }
            result.append("}").append(System.lineSeparator());
            return result.toString();
        }

        @Override
        public String resetSearchFunction() {
            StringBuilder result = new StringBuilder();
            result.append("    function reset_search() {").append(System.lineSeparator());
            for (SVGComponent component : this.components) {
                result.append(component.resetSearchFunction());
            }
            result.append("}").append(System.lineSeparator());
            return result.toString();
        }

        private static String colorChangeFunction() {
            return GraphOwner.readResource("color_change.js");
        }

        @Override
        public String script() throws IOException {
            StringBuilder result = new StringBuilder();
            result.append("<script type=\"text/ecmascript\">").append(System.lineSeparator());
            result.append("<![CDATA[").append(System.lineSeparator());
            result.append(GraphOwner.readResource("graphowner.js"));
            result.append("'use strict';").append(System.lineSeparator());
            result.append(String.format("var options = %s;%n", JsonFormatter.formatJson(OPTIONS)));
            result.append(String.format("var fontSize = %s;%n", 14.0));
            result.append(String.format("var fontWidth = %s;%n", 0.5));
            result.append(this.samples());
            result.append(this.resizeFunction());
            result.append(this.initFunction("evt"));
            result.append(this.searchFunction("term"));
            result.append(this.resetSearchFunction());
            result.append(GraphOwner.colorChangeFunction());
            for (SVGComponent component : this.components) {
                result.append(component.script());
            }
            result.append("]]>").append(System.lineSeparator());
            result.append("</script>").append(System.lineSeparator());
            return result.toString();
        }

        @Override
        public double width() {
            return this.components.stream().mapToDouble(SVGComponent::width).reduce(Math::max).orElse(0.0);
        }

        @Override
        public double height() {
            return this.components.stream().mapToDouble(SVGComponent::height).reduce(Double::sum).orElse(0.0);
        }

        @Override
        public String drawCanvas(double x, double y) {
            double offset = y;
            StringBuilder canvas = new StringBuilder();
            for (SVGComponent component : this.components) {
                canvas.append(component.drawCanvas(x, offset));
                offset += component.height();
            }
            return canvas.toString();
        }

        public static String abbreviate(String fullText, double width) {
            int textLength = (int)(width / 7.0);
            Object text = textLength > fullText.length() ? fullText : (textLength >= 3 ? fullText.substring(0, textLength - 2) + "..." : "");
            return text;
        }

        private static final class SampleKey {
            int sampleId;
            int nameId;
            int sourceId;
            int sourceLine;

            SampleKey(int sampleId, int nameId, int sourceId, int sourceLine) {
                this.sampleId = sampleId;
                this.nameId = nameId;
                this.sourceId = sourceId;
                this.sourceLine = sourceLine;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.sampleId;
                result = 31 * result + this.nameId;
                result = 31 * result + this.sourceId;
                result = 31 * result + this.sourceLine;
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                SampleKey other = (SampleKey)obj;
                if (this.sampleId != other.sampleId) {
                    return false;
                }
                if (this.nameId != other.nameId) {
                    return false;
                }
                if (this.sourceId != other.sourceId) {
                    return false;
                }
                return this.sourceLine == other.sourceLine;
            }
        }

        private static final class Task {
            final SamplerOutputData.SamplingNode node;
            final int bci;
            final List<Integer> siblings;
            final long x;
            final int parent;

            Task(SamplerOutputData.SamplingNode node, int bci, List<Integer> siblings, long x, int parent) {
                this.node = node;
                this.bci = bci;
                this.siblings = siblings;
                this.x = x;
                this.parent = parent;
            }
        }

        private static final class RecursivePositionTask {
            EconomicMap<String, Object> sample;
            long x;

            RecursivePositionTask(EconomicMap<String, Object> sample, long x) {
                this.sample = sample;
                this.x = x;
            }
        }
    }

    private static class SVGFlameGraph
    implements SVGComponent {
        private final GraphOwner owner;
        private final int maxDepth;
        private final double widthPerTime;
        private final long sampleCount;
        private final String subtitle;

        SVGFlameGraph(GraphOwner owner, String profiles) {
            this.owner = owner;
            this.sampleCount = GraphOwner.getInt(owner.getSampleData(0), "h");
            this.widthPerTime = (this.width() - 20.0) / (double)this.sampleCount;
            this.maxDepth = this.maxDepth(owner.getSampleData(0));
            this.subtitle = "Profile(s): " + profiles;
        }

        private int maxDepth(EconomicMap<String, Object> samples) {
            double width = this.sampleWidth(samples);
            if (width < 3.0) {
                return 0;
            }
            int childDepth = 0;
            if (samples.containsKey((Object)"rs")) {
                for (Object childId : (List)samples.get((Object)"rs")) {
                    childDepth = Integer.max(childDepth, this.maxDepth(this.owner.getSampleData((Integer)childId)));
                }
            }
            return childDepth + 1;
        }

        @Override
        public String css() {
            return ".func_g:hover { stroke:black; stroke-width:0.5; cursor:pointer; }";
        }

        @Override
        public String script() {
            return String.format("var xpad = %s;%nvar fg_width = %s;%nvar fg_bottom_padding = %s;%nvar fg_min_width = %s;%n", 10.0, 1200.0, 38.0, 3.0) + String.format("var fg_frameheight = %s;%nvar fg_top_padding = %s;%n", 16.0, 97.0) + GraphOwner.readResource("flamegraph.js");
        }

        @Override
        public String initFunction(String argName) {
            return String.format("fg_init(%s)%n", argName);
        }

        @Override
        public String resizeFunction() {
            return "fg_resize(document.firstElementChild.clientWidth);" + System.lineSeparator();
        }

        @Override
        public String searchFunction(String argName) {
            return String.format("fg_search(%s)%n", argName);
        }

        @Override
        public String resetSearchFunction() {
            return "fg_reset_search()" + System.lineSeparator();
        }

        private double sampleWidth(EconomicMap<String, Object> sample) {
            long hitCount = GraphOwner.getInt(sample, "rh");
            return this.widthPerTime * (double)hitCount;
        }

        private double sampleX(EconomicMap<String, Object> sample) {
            long x = GraphOwner.getInt(sample, "rx");
            return this.widthPerTime * (double)x + 10.0;
        }

        private String drawSample(double baseY, DrawTask task, ArrayDeque<DrawTask> tasks) {
            StringBuilder output = new StringBuilder();
            EconomicMap<String, Object> sample = task.sample;
            int depth = task.depth;
            double y = baseY - (double)depth * 16.0;
            double width = this.sampleWidth(sample);
            double x = this.sampleX(sample);
            if (width < 3.0) {
                return "";
            }
            int id = GraphOwner.getInt(sample, "id");
            HashMap<String, String> groupAttrs = new HashMap<String, String>();
            groupAttrs.put("class", "func_g");
            groupAttrs.put("onclick", id == 0 ? "unzoom()" : "zoom(this)");
            groupAttrs.put("onmouseover", "s(this)");
            groupAttrs.put("onmouseout", "c(this)");
            groupAttrs.put("id", "f_" + id);
            String name = this.owner.getSampleName(GraphOwner.getInt(sample, "k"));
            int selfTime = GraphOwner.getInt(sample, "i") + GraphOwner.getInt(sample, "c");
            int totalTime = GraphOwner.getInt(sample, "h");
            double selfTimePercentage = 100.0 * (double)selfTime / (double)this.sampleCount;
            double totalTimePercentage = 100.0 * (double)totalTime / (double)this.sampleCount;
            String title = String.format("%s%nTotal: %d (%.2f%%), Self: %d (%.2f%%)", name, totalTime, totalTimePercentage, selfTime, selfTimePercentage);
            groupAttrs.put("title", SVGSamplerOutput.escapeText(title));
            output.append(SVGSamplerOutput.generateGroupStart(groupAttrs));
            HashMap<String, String> rectAttrs = new HashMap<String, String>();
            output.append(SVGSamplerOutput.generateFilledRectangle(x, y, width, 16.0, this.owner.colorForKey(GraphOwner.getInt(sample, "k"), GraphColorMap.values()[GraphOwner.getInt(sample, "sc")]), "rx=\"2\" ry=\"2\"", rectAttrs));
            output.append(SVGSamplerOutput.generateFilledText(Color.TEXT, "verdana, arial, sans-serif", 14.0, x + 3.0, y - 5.0 + 16.0, GraphOwner.abbreviate(name, width), null, ""));
            output.append(SVGSamplerOutput.generateGroupEnd(groupAttrs));
            if (sample.containsKey((Object)"rs")) {
                for (Object childId : (List)sample.get((Object)"rs")) {
                    EconomicMap<String, Object> child = this.owner.getSampleData((Integer)childId);
                    tasks.add(new DrawTask(child, depth + 1));
                }
            }
            return output.toString();
        }

        private String drawSamples(double y, EconomicMap<String, Object> root) {
            ArrayDeque<DrawTask> tasks = new ArrayDeque<DrawTask>();
            StringBuilder output = new StringBuilder();
            DrawTask task = new DrawTask(root, 0);
            while (task != null) {
                output.append(this.drawSample(y, task, tasks));
                task = tasks.poll();
            }
            return output.toString();
        }

        private String drawTree() {
            StringBuilder output = new StringBuilder();
            double baseY = -54.0;
            output.append(this.drawSamples(baseY, this.owner.getSampleData(0)));
            return output.toString();
        }

        @Override
        public String drawCanvas(double x, double y) {
            StringBuilder output = new StringBuilder();
            HashMap<String, String> svgAttrs = new HashMap<String, String>();
            svgAttrs.put("x", Double.toString(x));
            svgAttrs.put("y", Double.toString(y));
            svgAttrs.put("width", Double.toString(this.width()));
            svgAttrs.put("height", Double.toString(this.height()));
            svgAttrs.put("viewBox", String.format("0.0 -%f %f %f", this.height(), this.width(), this.height()));
            output.append(SVGSamplerOutput.generateSubDrawingStart(svgAttrs));
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put("id", "flamegraph");
            output.append(SVGSamplerOutput.generateGroupStart(attr));
            HashMap<String, String> canvasAttr = new HashMap<String, String>();
            canvasAttr.put("id", "fg_canvas");
            output.append(SVGSamplerOutput.generateFilledRectangle(0.0, -this.height(), this.width(), this.height(), Color.BACKGROUND, "", canvasAttr));
            output.append(this.drawTree());
            output.append(SVGSamplerOutput.generateFilledText(Color.TEXT, "verdana, arial, sans-serif", 14.0, 10.0, -19.0, " ", "", "id=\"details\""));
            output.append(SVGSamplerOutput.generateFilledText(Color.TEXT, "verdana, arial, sans-serif", 14.0, this.width() - 10.0 - 100.0, -19.0, " ", "", "id=\"matched\" onclick=\"search_prompt()\""));
            output.append(SVGSamplerOutput.generateGroupEnd(attr));
            output.append(SVGSamplerOutput.generateSubDrawingEnd());
            output.append(SVGSamplerOutput.generateFilledText(Color.TEXT, "verdana, arial, sans-serif", 24.0, this.width() / 2.0, 28.0, "Flame graph", "middle", "id=\"fg_title\""));
            output.append(SVGSamplerOutput.generateFilledText(Color.TEXT, "verdana, arial, sans-serif", 17.0, this.width() / 2.0, 52.0, this.subtitle, "middle", "id=\"fg_subtitle\""));
            output.append(SVGSamplerOutput.generateFilledText(Color.TEXT, "verdana, arial, sans-serif", 14.0, this.width() / 2.0, 69.0, "Press \"?\" for legend and help.", "middle", "id=\"fg_help\""));
            output.append(SVGSamplerOutput.generateFilledText(Color.TEXT, "verdana, arial, sans-serif", 14.0, 10.0, 28.0, "Reset zoom", "", "id=\"unzoom\" onclick=\"unzoom()\" style=\"opacity:0.1;cursor:pointer\""));
            output.append(SVGSamplerOutput.generateFilledText(Color.TEXT, "verdana, arial, sans-serif", 14.0, this.width() - 10.0, 28.0, "Search", "end", "id=\"search\"  onclick=\"search_prompt()\" onmouseover=\"fg_searchover()\" onmouseout=\"fg_searchout()\""));
            return output.toString();
        }

        @Override
        public double width() {
            return 1200.0;
        }

        @Override
        public double height() {
            return 16.0 * (double)this.maxDepth + 97.0 + 38.0;
        }

        private static final class DrawTask {
            final EconomicMap<String, Object> sample;
            final int depth;

            DrawTask(EconomicMap<String, Object> sample, int depth) {
                this.sample = sample;
                this.depth = depth;
            }
        }
    }

    private static interface SVGComponent {
        public String css();

        public String script() throws IOException;

        public String initFunction(String var1);

        public String resizeFunction();

        public String searchFunction(String var1);

        public String resetSearchFunction();

        public String drawCanvas(double var1, double var3);

        public double width();

        public double height();
    }

    private static class SVGHistogram
    implements SVGComponent {
        private final GraphOwner owner;
        private final List<EconomicMap<String, Integer>> histogram;
        private final double widthPerTime;
        private final long sampleCount;

        SVGHistogram(GraphOwner owner) {
            this.owner = owner;
            this.histogram = this.buildHistogram(owner.getSampleData(0));
            double timeMax = (Integer)this.histogram.get(0).get((Object)"i") + (Integer)this.histogram.get(0).get((Object)"c");
            this.widthPerTime = (this.width() - 20.0) / timeMax;
            long count = 0L;
            for (EconomicMap<String, Integer> bar : this.histogram) {
                count += (long)((Integer)bar.get((Object)"i") + (Integer)bar.get((Object)"c"));
            }
            this.sampleCount = count;
            double minTime = 3.0 / this.widthPerTime;
            this.histogram.removeIf(x -> (double)((Integer)x.get((Object)"i") + (Integer)x.get((Object)"c")) < minTime);
        }

        private List<EconomicMap<String, Integer>> buildHistogram(EconomicMap<String, Object> sample) {
            HashMap<GraphOwner.SampleKey, EconomicMap<String, Integer>> bars = new HashMap<GraphOwner.SampleKey, EconomicMap<String, Integer>>();
            ArrayDeque<EconomicMap<String, Object>> samples = new ArrayDeque<EconomicMap<String, Object>>();
            EconomicMap<String, Object> next = sample;
            while (next != null) {
                this.buildHistogram(next, samples, bars);
                next = samples.poll();
            }
            ArrayList<EconomicMap<String, Integer>> lines = new ArrayList<EconomicMap<String, Integer>>(bars.values());
            lines.sort((a, b) -> Integer.compare((Integer)b.get((Object)"i") + (Integer)b.get((Object)"c"), (Integer)a.get((Object)"i") + (Integer)a.get((Object)"c")));
            return lines;
        }

        private void buildHistogram(EconomicMap<String, Object> sample, ArrayDeque<EconomicMap<String, Object>> samples, Map<GraphOwner.SampleKey, EconomicMap<String, Integer>> bars) {
            EconomicMap bar = bars.computeIfAbsent(this.owner.sampleKeys.get(GraphOwner.getInt(sample, "k")), k -> {
                EconomicMap entry = EconomicMap.create();
                entry.put((Object)"id", (Object)GraphOwner.getInt(sample, "id"));
                entry.put((Object)"i", (Object)0);
                entry.put((Object)"c", (Object)0);
                entry.put((Object)"l", (Object)GraphOwner.getInt(sample, "l"));
                entry.put((Object)"k", (Object)GraphOwner.getInt(sample, "k"));
                entry.put((Object)"sc", (Object)GraphOwner.getInt(sample, "sc"));
                return entry;
            });
            bar.put((Object)"i", (Object)((Integer)bar.get((Object)"i") + GraphOwner.getInt(sample, "i")));
            bar.put((Object)"c", (Object)((Integer)bar.get((Object)"c") + GraphOwner.getInt(sample, "c")));
            if (sample.containsKey((Object)"s")) {
                for (Object childId : (List)sample.get((Object)"s")) {
                    samples.add(this.owner.getSampleData((Integer)childId));
                }
            }
        }

        @Override
        public String css() {
            return ".func_h:hover { stroke:black; stroke-width:0.5; cursor:pointer; }";
        }

        @Override
        public String script() {
            StringBuilder script = new StringBuilder();
            script.append(String.format("var h_width = %s;%n", this.width()));
            script.append(String.format("var h_minwidth = %s;%n", 3.0));
            script.append(String.format("var h_top_padding = %s;%n", 70.0));
            script.append(String.format("var h_bottom_padding = %s;%n", 38.0));
            script.append(String.format("var h_frameheight = %s;%n", 16.0));
            script.append("var histogramData = ");
            script.append(JsonFormatter.formatJson(this.histogram));
            script.append(";").append(System.lineSeparator());
            script.append(GraphOwner.readResource("histogram.js"));
            return script.toString();
        }

        @Override
        public String initFunction(String argName) {
            return String.format("h_init(%s)%n", argName);
        }

        @Override
        public String resizeFunction() {
            return "h_resize(document.firstElementChild.clientWidth);" + System.lineSeparator();
        }

        @Override
        public String searchFunction(String argName) {
            return String.format("h_search(%s)%n", argName);
        }

        @Override
        public String resetSearchFunction() {
            return "h_reset_search()" + System.lineSeparator();
        }

        private String drawElement(EconomicMap<String, Integer> bar, int position) {
            double textX;
            String name = this.owner.getSampleName((Integer)bar.get((Object)"k"));
            long selfTime = (Integer)bar.get((Object)"c") + (Integer)bar.get((Object)"i");
            double width = this.widthPerTime * (double)selfTime;
            double x1 = 10.0;
            double y1 = 70.0 + (double)position * 16.0;
            StringBuilder output = new StringBuilder();
            if (width < 3.0) {
                return "";
            }
            HashMap<String, String> groupAttrs = new HashMap<String, String>();
            groupAttrs.put("class", "func_h");
            groupAttrs.put("id", "h_" + position);
            groupAttrs.put("onclick", "h_highlight(this)");
            groupAttrs.put("onmouseover", "s(this)");
            groupAttrs.put("onmouseout", "c(this)");
            StringBuilder title = new StringBuilder();
            title.append("Function: ");
            title.append(name);
            title.append(System.lineSeparator());
            int interpreted = (Integer)bar.get((Object)"i");
            int compiled = (Integer)bar.get((Object)"c");
            title.append(String.format("%d samples (%d interpreted, %d compiled).%n", interpreted + compiled, interpreted, compiled));
            double percent = 100.0 * (double)(compiled + interpreted) / (double)this.sampleCount;
            title.append(String.format("%.2f%% of displayed samples.%n", percent));
            groupAttrs.put("title", SVGSamplerOutput.escapeText(title.toString()));
            output.append(SVGSamplerOutput.generateGroupStart(groupAttrs));
            HashMap<String, String> rectAttrs = new HashMap<String, String>();
            output.append(SVGSamplerOutput.generateFilledRectangle(x1, y1, width, 16.0, this.owner.colorForKey((Integer)bar.get((Object)"k"), GraphColorMap.values()[(Integer)bar.get((Object)"sc")]), "rx=\"2\" ry=\"2\"", rectAttrs));
            double afterWidth = 1200.0 - width - 20.0;
            int textLength = (int)(width / 28.0);
            int afterLength = (int)(afterWidth / 28.0);
            String text = name;
            if (textLength > name.length()) {
                textX = x1 + 3.0;
            } else if (afterLength > name.length()) {
                textX = x1 + 3.0 + width;
            } else if (textLength > afterLength) {
                textX = x1 + 3.0;
                text = GraphOwner.abbreviate(name, width);
            } else {
                textX = x1 + 3.0 + width;
                text = GraphOwner.abbreviate(name, afterWidth);
            }
            output.append(SVGSamplerOutput.generateFilledText(Color.TEXT, "verdana, arial, sans-serif", 14.0, textX, y1 - 5.0 + 16.0, text, null, ""));
            output.append(SVGSamplerOutput.generateGroupEnd(groupAttrs));
            return output.toString();
        }

        @Override
        public String drawCanvas(double x, double y) {
            StringBuilder output = new StringBuilder();
            HashMap<String, String> svgattr = new HashMap<String, String>();
            svgattr.put("x", Double.toString(x));
            svgattr.put("y", Double.toString(y));
            svgattr.put("width", Double.toString(this.width()));
            svgattr.put("height", Double.toString(this.height()));
            svgattr.put("viewBox", String.format("0.0 0.0 %f %f", this.width(), this.height()));
            output.append(SVGSamplerOutput.generateSubDrawingStart(svgattr));
            HashMap<String, String> attr = new HashMap<String, String>();
            HashMap<String, String> canvasAttr = new HashMap<String, String>();
            attr.put("id", "histogram");
            canvasAttr.put("id", "h_canvas");
            output.append(SVGSamplerOutput.generateGroupStart(attr));
            output.append(SVGSamplerOutput.generateFilledRectangle(0.0, 0.0, this.width(), this.height(), Color.BACKGROUND, "", canvasAttr));
            output.append(SVGSamplerOutput.generateFilledText(Color.TEXT, "verdana, arial, sans-serif", 24.0, this.width() / 2.0, 28.0, "Histogram", "middle", "id=\"h_title\""));
            for (int position = 0; position < this.histogram.size(); ++position) {
                output.append(this.drawElement(this.histogram.get(position), position));
            }
            output.append(SVGSamplerOutput.generateGroupEnd(attr));
            output.append(SVGSamplerOutput.generateSubDrawingEnd());
            return output.toString();
        }

        @Override
        public double width() {
            return 1200.0;
        }

        @Override
        public double height() {
            return (double)this.histogram.size() * 16.0 + 70.0 + 38.0;
        }
    }

    private static enum GraphColorMap {
        FLAME,
        AQUA,
        ORANGE,
        GREEN,
        RED,
        YELLOW,
        PURPLE,
        BLUE,
        GRAY;

    }

    private static final class Font {
        public static final String FAMILY = "verdana, arial, sans-serif";
        public static final double SIZE = 14.0;
        public static final double WIDTH = 0.5;

        private Font() {
        }
    }

    private static final class Color {
        private static final String TEXT = SVGSamplerOutput.generateRGBColor(0, 0, 0);
        private static final String BACKGROUND = SVGSamplerOutput.generateRGBColor(255, 255, 255);
        private static final String GRADIENT_BACKGROUND_START = SVGSamplerOutput.generateRGBColor(238, 238, 238);
        private static final String GRADIENT_BACKGROUND_END = SVGSamplerOutput.generateRGBColor(238, 238, 176);
        private static final String SEARCH = SVGSamplerOutput.generateRGBColor(255, 255, 96);

        private Color() {
        }
    }

    private static final class Dimensions {
        private static final double MIN_WIDTH = 3.0;
        private static final double IMAGE_WIDTH = 1200.0;
        private static final double XPAD = 10.0;
        private static final double FRAME_HEIGHT = 16.0;
        private static final double FLAMEGRAPH_TOP_PADDING = 97.0;
        private static final double FLAMEGRAPH_BOTTOM_PADDING = 38.0;
        private static final double HISTOGRAM_TOP_PADDING = 70.0;
        private static final double HISTOGRAM_BOTTOM_PADDING = 38.0;

        private Dimensions() {
        }
    }
}

