/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reporter.data;

import com.oracle.graal.reporter.data.ComponentData;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import jdk.graal.compiler.util.json.JsonBuilder;
import jdk.graal.compiler.util.json.JsonWriter;

public record TableData(List<HeaderRowData> headerRows, List<RowData> bodyRows, String classes, boolean filterable, String json) implements ComponentData
{
    public static final String HEADER_KEY = "header";
    public static final String BODY_KEY = "body";
    public static final String CLASSES_KEY = "classes";
    public static final String FILTERABLE_KEY = "filterable";
    public static final String JSON_KEY = "json";

    public TableData(List<HeaderRowData> headerRows, List<RowData> bodyRows) {
        this(headerRows, bodyRows, null, false, null);
    }

    @Override
    public String toJson() throws IOException {
        StringWriter writer = new StringWriter();
        try (JsonBuilder.ObjectBuilder builder = new JsonWriter((Writer)writer).objectBuilder();){
            this.toJson(builder);
        }
        return writer.toString();
    }

    public void toJson(JsonBuilder.ObjectBuilder builder) throws IOException {
        JsonBuilder.ObjectBuilder rowBuilder;
        try (JsonBuilder.ArrayBuilder headerBuilder = builder.append(HEADER_KEY).array();){
            for (HeaderRowData headerRow : this.headerRows) {
                rowBuilder = headerBuilder.nextEntry().object();
                try {
                    headerRow.toJson(rowBuilder);
                }
                finally {
                    if (rowBuilder == null) continue;
                    rowBuilder.close();
                }
            }
        }
        try (JsonBuilder.ArrayBuilder bodyBuilder = builder.append(BODY_KEY).array();){
            for (RowData bodyRow : this.bodyRows) {
                rowBuilder = bodyBuilder.nextEntry().object();
                try {
                    bodyRow.toJson(rowBuilder);
                }
                finally {
                    if (rowBuilder == null) continue;
                    rowBuilder.close();
                }
            }
        }
        if (this.classes != null) {
            builder.append(CLASSES_KEY, (Object)this.classes);
        }
        builder.append(FILTERABLE_KEY, (Object)this.filterable);
        if (this.json != null) {
            builder.append(JSON_KEY, (Object)this.json);
        }
    }

    public static final class HeaderRowData
    extends RowData {
        public HeaderRowData(List<HeaderCellData> cells) {
            super(cells);
        }

        @Override
        String kind() {
            return TableData.HEADER_KEY;
        }
    }

    public static class RowData {
        static final String KIND_KEY = "kind";
        static final String CELLS_KEY = "cells";
        static final String VISIBLE_KEY = "visible";
        private final List<? extends CellData> cells;
        private final boolean visible;

        public RowData(List<? extends CellData> cells, boolean visible) {
            this.cells = cells;
            this.visible = visible;
        }

        public RowData(List<? extends CellData> cells) {
            this.cells = cells;
            this.visible = true;
        }

        String kind() {
            return "plain";
        }

        public void toJson(JsonBuilder.ObjectBuilder builder) throws IOException {
            builder.append(KIND_KEY, (Object)this.kind());
            try (JsonBuilder.ArrayBuilder cellsBuilder = builder.append(CELLS_KEY).array();){
                for (CellData cellData : this.cells) {
                    JsonBuilder.ObjectBuilder cellBuilder = cellsBuilder.nextEntry().object();
                    try {
                        cellData.toJson(cellBuilder);
                    }
                    finally {
                        if (cellBuilder == null) continue;
                        cellBuilder.close();
                    }
                }
            }
            builder.append(VISIBLE_KEY, (Object)this.visible);
        }
    }

    public static final class FooterCellData
    extends CellData {
        public FooterCellData(String text, int colSpan) {
            super(text, colSpan, null);
        }

        public FooterCellData(String text, int colSpan, String classes) {
            super(text, colSpan, classes);
        }

        @Override
        String kind() {
            return "footer";
        }

        @Override
        String tooltip() {
            return null;
        }
    }

    public static final class LinksCellData
    extends CellData {
        static final String HREFS_KEY = "hrefs";
        private final List<String> hrefs;

        public LinksCellData(List<String> texts, List<String> hrefs, String classes) {
            super(String.join((CharSequence)",", texts), null, classes);
            this.hrefs = hrefs;
        }

        public LinksCellData(List<String> texts, List<String> hrefs) {
            super(String.join((CharSequence)",", texts), null, null);
            this.hrefs = hrefs;
        }

        @Override
        String kind() {
            return "links";
        }

        @Override
        String tooltip() {
            return null;
        }

        @Override
        public void toJson(JsonBuilder.ObjectBuilder builder) throws IOException {
            super.toJson(builder);
            builder.append(HREFS_KEY, (Object)String.join((CharSequence)",", this.hrefs));
        }
    }

    public static final class TotalHeaderCellData
    extends HeaderCellData {
        static final String TOTAL_KEY = "total";
        private final String total;
        private final String tooltip;
        private final boolean sortable;

        public TotalHeaderCellData(String text, String total, String classes, String tooltip, boolean sortable) {
            super(text, null, classes);
            this.total = total;
            this.tooltip = tooltip;
            this.sortable = sortable;
        }

        @Override
        String kind() {
            return TOTAL_KEY;
        }

        @Override
        String tooltip() {
            return this.tooltip;
        }

        @Override
        boolean sortable() {
            return this.sortable;
        }

        @Override
        HeaderCellData.SortType sortType() {
            return HeaderCellData.SortType.SIZE;
        }

        @Override
        boolean filterable() {
            return false;
        }

        @Override
        String[] filterValues() {
            return null;
        }

        @Override
        String[] filterNames() {
            return null;
        }

        @Override
        String[] filterTooltips() {
            return null;
        }

        @Override
        public void toJson(JsonBuilder.ObjectBuilder builder) throws IOException {
            super.toJson(builder);
            builder.append(TOTAL_KEY, (Object)this.total);
        }
    }

    public static class SizeCellData
    extends CellData {
        static final String PERCENTAGE_KEY = "percentage";
        private final double percentage;

        public SizeCellData(String text, double percentage) {
            super(text, null, null);
            this.percentage = percentage;
        }

        @Override
        String kind() {
            return "size";
        }

        @Override
        String tooltip() {
            return null;
        }

        @Override
        public void toJson(JsonBuilder.ObjectBuilder builder) throws IOException {
            super.toJson(builder);
            builder.append(PERCENTAGE_KEY, (Object)this.percentage);
        }
    }

    public static final class IconCellData
    extends CellData {
        public IconCellData(String text, String classes) {
            super(text, null, classes);
        }

        @Override
        String kind() {
            return "icon";
        }

        @Override
        String tooltip() {
            return null;
        }
    }

    public static final class BadgesCellData
    extends CellData {
        static final String BADGE_CLASSES_KEY = "badgeClasses";
        private final List<String> badgeClasses;

        public BadgesCellData(List<String> texts, List<String> badgeClasses, String classes) {
            super(String.join((CharSequence)",", texts), null, classes);
            this.badgeClasses = badgeClasses;
        }

        public BadgesCellData(List<String> texts, List<String> badgeClasses) {
            super(String.join((CharSequence)",", texts), null, null);
            this.badgeClasses = badgeClasses;
        }

        public BadgesCellData(List<String> texts) {
            this(texts, null);
        }

        @Override
        String kind() {
            return "badges";
        }

        @Override
        String tooltip() {
            return null;
        }

        @Override
        public void toJson(JsonBuilder.ObjectBuilder builder) throws IOException {
            super.toJson(builder);
            if (this.badgeClasses != null) {
                builder.append(BADGE_CLASSES_KEY, (Object)String.join((CharSequence)",", this.badgeClasses));
            }
        }
    }

    public static final class TitleHeaderCellData
    extends HeaderCellData {
        private final String tooltip;

        public TitleHeaderCellData(String text, String tooltip) {
            super(text, null, null);
            this.tooltip = tooltip;
        }

        public TitleHeaderCellData(String text, Integer colSpan) {
            super(text, colSpan, null);
            this.tooltip = null;
        }

        public TitleHeaderCellData(String text) {
            super(text, null, null);
            this.tooltip = null;
        }

        @Override
        String kind() {
            return "title";
        }

        @Override
        String tooltip() {
            return this.tooltip;
        }

        @Override
        boolean sortable() {
            return false;
        }

        @Override
        HeaderCellData.SortType sortType() {
            return null;
        }

        @Override
        boolean filterable() {
            return false;
        }

        @Override
        String[] filterValues() {
            return null;
        }

        @Override
        String[] filterNames() {
            return null;
        }

        @Override
        String[] filterTooltips() {
            return null;
        }
    }

    public static final class RawCellData
    extends CellData {
        public RawCellData(String text, String classes) {
            super(text, null, classes);
        }

        public RawCellData(String text) {
            super(text, null, null);
        }

        @Override
        String kind() {
            return "raw";
        }

        @Override
        String tooltip() {
            return null;
        }
    }

    public static final class TextHeaderCellData
    extends HeaderCellData {
        private final String tooltip;
        private final boolean sortable;
        private final HeaderCellData.SortType sortType;
        private final boolean filterable;
        private final String[] filterValues;
        private final String[] filterNames;
        private final String[] filterTooltips;

        public TextHeaderCellData(String text, String classes, String tooltip, boolean sortable, HeaderCellData.SortType sortType) {
            super(text, null, classes);
            this.tooltip = tooltip;
            this.sortable = sortable;
            this.sortType = sortType;
            this.filterable = false;
            this.filterValues = null;
            this.filterNames = null;
            this.filterTooltips = null;
        }

        public TextHeaderCellData(String text, String classes, String tooltip, boolean sortable, HeaderCellData.SortType sortType, boolean filterable, String[] filterValues, String[] filterNames, String[] filterTooltips) {
            super(text, null, classes);
            this.tooltip = tooltip;
            this.sortable = sortable;
            this.sortType = sortType;
            this.filterable = filterable;
            this.filterValues = filterValues;
            this.filterNames = filterNames;
            this.filterTooltips = filterTooltips;
        }

        public TextHeaderCellData(String text) {
            super(text, null, null);
            this.tooltip = null;
            this.sortable = false;
            this.sortType = null;
            this.filterable = false;
            this.filterValues = null;
            this.filterNames = null;
            this.filterTooltips = null;
        }

        public TextHeaderCellData(String text, String classes) {
            super(text, null, classes);
            this.tooltip = null;
            this.sortable = false;
            this.sortType = null;
            this.filterable = false;
            this.filterValues = null;
            this.filterNames = null;
            this.filterTooltips = null;
        }

        public TextHeaderCellData(String text, Integer colSpan) {
            super(text, colSpan, null);
            this.tooltip = null;
            this.sortable = false;
            this.sortType = null;
            this.filterable = false;
            this.filterValues = null;
            this.filterNames = null;
            this.filterTooltips = null;
        }

        @Override
        String kind() {
            return "text";
        }

        @Override
        String tooltip() {
            return this.tooltip;
        }

        @Override
        boolean sortable() {
            return this.sortable;
        }

        @Override
        HeaderCellData.SortType sortType() {
            return this.sortType;
        }

        @Override
        boolean filterable() {
            return this.filterable;
        }

        @Override
        String[] filterValues() {
            return this.filterValues;
        }

        @Override
        String[] filterNames() {
            return this.filterNames;
        }

        @Override
        String[] filterTooltips() {
            return this.filterTooltips;
        }
    }

    public static final class TextCellData
    extends CellData {
        private final String tooltip;

        public TextCellData(String text, String classes, String tooltip) {
            super(text, null, classes);
            this.tooltip = tooltip;
        }

        public TextCellData(String text, String classes) {
            super(text, null, classes);
            this.tooltip = null;
        }

        public TextCellData(String text, Integer width) {
            super(text, null, null, width);
            this.tooltip = null;
        }

        public TextCellData(String text) {
            super(text, null, null);
            this.tooltip = null;
        }

        @Override
        String kind() {
            return "text";
        }

        @Override
        String tooltip() {
            return this.tooltip;
        }
    }

    public static abstract class HeaderCellData
    extends CellData {
        static final String SORTABLE_KEY = "sortable";
        static final String SORT_TYPE_KEY = "sortType";
        static final String FILTERABLE_KEY = "filterable";
        static final String FILTER_VALUES_KEY = "filterValues";
        static final String FILTER_NAMES_KEY = "filterNames";
        static final String FILTER_TOOLTIPS_KEY = "filterTooltips";

        HeaderCellData(String text, Integer colSpan, String classes) {
            super(text, colSpan, classes);
        }

        abstract boolean sortable();

        abstract SortType sortType();

        abstract boolean filterable();

        abstract String[] filterValues();

        abstract String[] filterNames();

        abstract String[] filterTooltips();

        @Override
        public void toJson(JsonBuilder.ObjectBuilder builder) throws IOException {
            super.toJson(builder);
            builder.append(SORTABLE_KEY, (Object)this.sortable());
            if (this.sortType() != null) {
                builder.append(SORT_TYPE_KEY, (Object)this.sortType().toString());
            }
            builder.append("filterable", (Object)this.filterable());
            if (this.filterable()) {
                try (JsonBuilder.ArrayBuilder filterValuesBuilder = builder.append(FILTER_VALUES_KEY).array();){
                    for (String filterValue : this.filterValues()) {
                        filterValuesBuilder.append((Object)filterValue);
                    }
                }
                try (JsonBuilder.ArrayBuilder filterNamesBuilder = builder.append(FILTER_NAMES_KEY).array();){
                    for (String filterName : this.filterNames()) {
                        filterNamesBuilder.append((Object)filterName);
                    }
                }
                try (JsonBuilder.ArrayBuilder filterTooltipsBuilder = builder.append(FILTER_TOOLTIPS_KEY).array();){
                    for (String filterTooltip : this.filterTooltips()) {
                        filterTooltipsBuilder.append((Object)filterTooltip);
                    }
                }
            }
        }

        public static enum SortType {
            STRING("string"),
            NUMBER("number"),
            SIZE("size");

            final String name;

            private SortType(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }
        }
    }

    public static abstract class CellData {
        static final String KIND_KEY = "kind";
        static final String TEXT_KEY = "text";
        static final String COL_SPAN_KEY = "colSpan";
        static final String CLASSES_KEY = "classes";
        static final String WIDTH_KEY = "width";
        static final String TOOLTIP_KEY = "tooltip";
        private final String text;
        private final Integer colSpan;
        private final String classes;
        private final Integer width;

        CellData(String text, Integer colSpan, String classes, Integer width) {
            this.text = text;
            this.colSpan = colSpan;
            this.classes = classes;
            this.width = width;
        }

        CellData(String text, Integer colSpan, String classes) {
            this.text = text;
            this.colSpan = colSpan;
            this.classes = classes;
            this.width = null;
        }

        abstract String kind();

        abstract String tooltip();

        public void toJson(JsonBuilder.ObjectBuilder builder) throws IOException {
            builder.append(KIND_KEY, (Object)this.kind());
            builder.append(TEXT_KEY, (Object)this.text);
            if (this.colSpan != null) {
                builder.append(COL_SPAN_KEY, (Object)this.colSpan);
            }
            if (this.classes != null) {
                builder.append("classes", (Object)this.classes);
            }
            if (this.width != null) {
                builder.append(WIDTH_KEY, (Object)this.width);
            }
            if (this.tooltip() != null) {
                builder.append(TOOLTIP_KEY, (Object)this.tooltip());
            }
        }
    }

    public static final class AccordionRowData
    extends RowData {
        static final String CONTENT_KEY = "content";
        static final String COL_SPAN_KEY = "colSpan";
        private final int colSpan;
        private final TableData nestedTable;

        public AccordionRowData(List<CellData> cells, boolean visible, int colSpan, TableData nestedTable) {
            super(cells, visible);
            this.colSpan = colSpan;
            this.nestedTable = nestedTable;
        }

        @Override
        String kind() {
            return "accordion";
        }

        @Override
        public void toJson(JsonBuilder.ObjectBuilder builder) throws IOException {
            super.toJson(builder);
            builder.append(COL_SPAN_KEY, (Object)this.colSpan);
            try (JsonBuilder.ObjectBuilder contentBuilder = builder.append(CONTENT_KEY).object();){
                this.nestedTable.toJson(contentBuilder);
            }
        }
    }
}

