/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reporter.data;

import com.oracle.graal.reporter.data.ComponentData;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import jdk.graal.compiler.util.json.JsonBuilder;
import jdk.graal.compiler.util.json.JsonWriter;

public record SunburstChartData(ArcData rootArc, double limit) implements ComponentData
{
    private static final String DATA_KEY = "data";
    private static final String LIMIT_KEY = "limit";
    private static final double DEFAULT_LIMIT = 0.005;

    public SunburstChartData(ArcData rootArc) {
        this(rootArc, 0.005);
    }

    @Override
    public String toJson() throws IOException {
        StringWriter writer = new StringWriter();
        try (JsonBuilder.ObjectBuilder builder = new JsonWriter((Writer)writer).objectBuilder();){
            this.toJson(builder);
        }
        return writer.toString();
    }

    void toJson(JsonBuilder.ObjectBuilder builder) throws IOException {
        try (JsonBuilder.ObjectBuilder dataBuilder = builder.append(DATA_KEY).object();){
            this.rootArc.toJson(dataBuilder);
        }
        builder.append(LIMIT_KEY, (Object)this.limit);
    }

    public static class ArcData {
        private static final String LABEL_KEY = "label";
        private static final String VALUE_KEY = "value";
        private static final String CHILDREN_KEY = "children";
        private static final String PAYLOAD_KEY = "payload";
        private final String label;
        private int value;
        private final Map<String, ArcData> children;
        private ArcPayload payload;

        public ArcData(String label) {
            this.label = label;
            this.value = 0;
            this.children = new HashMap<String, ArcData>();
            this.payload = null;
        }

        public void addValue(int newValue) {
            this.value += newValue;
        }

        public boolean containsChildArc(String childLabel) {
            return this.children.containsKey(childLabel);
        }

        public ArcData getChildArc(String childLabel) {
            return this.children.get(childLabel);
        }

        public void putChildArc(String childLabel, ArcData childArc) {
            this.children.put(childLabel, childArc);
        }

        public void traverseChildrenArcs(Consumer<ArcData> arcVisitor) {
            for (ArcData arcData : this.children.values()) {
                arcVisitor.accept(arcData);
            }
        }

        public boolean hasPayload() {
            return this.payload != null;
        }

        public ArcPayload getPayload() {
            return this.payload;
        }

        public void setPayload(ArcPayload payload) {
            this.payload = payload;
        }

        public void toJson(JsonBuilder.ObjectBuilder builder) throws IOException {
            builder.append(LABEL_KEY, (Object)this.label);
            builder.append(VALUE_KEY, (Object)this.value);
            try (JsonBuilder.ArrayBuilder childrenBuilder = builder.append(CHILDREN_KEY).array();){
                for (ArcData childArc : this.children.values()) {
                    JsonBuilder.ObjectBuilder childBuilder = childrenBuilder.nextEntry().object();
                    try {
                        childArc.toJson(childBuilder);
                    }
                    finally {
                        if (childBuilder == null) continue;
                        childBuilder.close();
                    }
                }
            }
            if (this.payload != null) {
                try (JsonBuilder.ObjectBuilder payloadBuilder = builder.append(PAYLOAD_KEY).object();){
                    this.payload.toJson(payloadBuilder);
                }
            }
        }
    }

    public static abstract class ArcPayload {
        public abstract void toJson(JsonBuilder.ObjectBuilder var1) throws IOException;
    }
}

