/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reporter.data;

import com.oracle.graal.reporter.data.ComponentData;
import com.oracle.graal.reporter.flamegraph.SVGSamplerOutput;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.util.json.JsonBuilder;
import jdk.graal.compiler.util.json.JsonWriter;

public record SamplerOutputData(String html) implements ComponentData
{
    private static final String HTML_KEY = "html";

    public SamplerOutputData(SamplingData samplingData, String profiles) throws IOException {
        this(Base64.getEncoder().encodeToString(SVGSamplerOutput.generateSamplingFlameGraph(samplingData, profiles).getBytes()));
    }

    @Override
    public String toJson() throws IOException {
        StringWriter writer = new StringWriter();
        try (JsonBuilder.ObjectBuilder builder = new JsonWriter((Writer)writer).objectBuilder();){
            builder.append(HTML_KEY, (Object)this.html);
        }
        return writer.toString();
    }

    public record SamplingData(List<SamplingNode> entryPoints) {
    }

    public record SamplingNode(String compilationRoot, String method, long selfCount, long totalCount, State state, Map<Integer, List<SamplingNode>> children) {

        public static enum State {
            HOT_ROOT,
            COLD_ROOT,
            INLINED,
            COLD;

        }
    }
}

