/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reporter.data;

import com.oracle.graal.reporter.data.ComponentData;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import jdk.graal.compiler.util.json.JsonBuilder;
import jdk.graal.compiler.util.json.JsonWriter;

public record HorizontalStackedBarChartData(String title, String subtitle, List<BarData> bars) implements ComponentData
{
    static final String TITLE_KEY = "title";
    static final String SUBTITLE_KEY = "subtitle";
    static final String BARS_KEY = "bars";

    @Override
    public String toJson() throws IOException {
        StringWriter writer = new StringWriter();
        try (JsonBuilder.ObjectBuilder builder = new JsonWriter((Writer)writer).objectBuilder();){
            builder.append(TITLE_KEY, (Object)this.title);
            builder.append(SUBTITLE_KEY, (Object)this.subtitle);
            try (JsonBuilder.ArrayBuilder barsBuilder = builder.append(BARS_KEY).array();){
                for (BarData bar : this.bars) {
                    JsonBuilder.ObjectBuilder barBuilder = barsBuilder.nextEntry().object();
                    try {
                        bar.toJson(barBuilder);
                    }
                    finally {
                        if (barBuilder == null) continue;
                        barBuilder.close();
                    }
                }
            }
        }
        return writer.toString();
    }

    public record BarData(double value, String label, String text, String details, Integer target) {
        static final String VALUE_KEY = "value";
        static final String LABEL_KEY = "label";
        static final String TEXT_KEY = "text";
        static final String DETAILS_KEY = "details";
        static final String TARGET_KEY = "target";

        public BarData(double value, String label, String text) {
            this(value, label, text, null, null);
        }

        public void toJson(JsonBuilder.ObjectBuilder builder) throws IOException {
            builder.append(VALUE_KEY, (Object)this.value);
            builder.append(LABEL_KEY, (Object)this.label);
            builder.append(TEXT_KEY, (Object)this.text);
            if (this.details != null) {
                builder.append(DETAILS_KEY, (Object)this.details);
            }
            if (this.target != null) {
                builder.append(TARGET_KEY, (Object)this.target);
            }
        }
    }
}

