/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reporter.data;

import com.oracle.graal.reporter.data.ComponentData;
import com.oracle.graal.reporter.data.ExpertFeature;
import com.oracle.graal.reporter.data.SunburstChartData;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import jdk.graal.compiler.util.json.JsonBuilder;
import jdk.graal.compiler.util.json.JsonWriter;

public record BreakdownData(String name, String tooltip, String tableName, List<BreakdownType> types, String typesTooltip, List<SunburstChartData> data, List<String> tableValueKinds, int defaultIndex) implements ComponentData
{
    static final String NAME_KEY = "name";
    static final String TOOLTIP_KEY = "tooltip";
    static final String TABLE_NAME_KEY = "tableName";
    static final String TYPES_KEY = "types";
    static final String TYPES_TOOLTIP_KEY = "typesTooltip";
    static final String DATA_KEY = "data";
    static final String TABLE_VALUE_KINDS_KEY = "tableValueKinds";
    static final String DEFAULT_INDEX_KEY = "defaultIndex";

    @Override
    public String toJson() throws IOException {
        StringWriter writer = new StringWriter();
        try (JsonBuilder.ObjectBuilder builder = new JsonWriter((Writer)writer).objectBuilder();){
            builder.append(NAME_KEY, (Object)this.name);
            if (this.tooltip != null) {
                builder.append(TOOLTIP_KEY, (Object)this.tooltip);
            }
            builder.append(TABLE_NAME_KEY, (Object)this.tableName);
            try (JsonBuilder.ArrayBuilder typesBuilder = builder.append(TYPES_KEY).array();){
                for (BreakdownType type : this.types) {
                    JsonBuilder.ObjectBuilder typeBuilder = typesBuilder.nextEntry().object();
                    try {
                        type.toJson(typeBuilder);
                    }
                    finally {
                        if (typeBuilder == null) continue;
                        typeBuilder.close();
                    }
                }
            }
            if (this.typesTooltip != null) {
                builder.append(TYPES_TOOLTIP_KEY, (Object)this.typesTooltip);
            }
            try (JsonBuilder.ArrayBuilder dataBuilder = builder.append(DATA_KEY).array();){
                for (SunburstChartData chartData : this.data) {
                    JsonBuilder.ObjectBuilder chartDataBuilder = dataBuilder.nextEntry().object();
                    try {
                        chartData.toJson(chartDataBuilder);
                    }
                    finally {
                        if (chartDataBuilder == null) continue;
                        chartDataBuilder.close();
                    }
                }
            }
            try (JsonBuilder.ArrayBuilder tableValueKindsBuilder = builder.append(TABLE_VALUE_KINDS_KEY).array();){
                for (String tableValueType : this.tableValueKinds) {
                    tableValueKindsBuilder.nextEntry().value((Object)tableValueType);
                }
            }
            builder.append(DEFAULT_INDEX_KEY, (Object)this.defaultIndex);
        }
        return writer.toString();
    }

    public static class BreakdownType {
        static final String NAME_KEY = "name";
        static final String TOOLTIP_KEY = "tooltip";
        private final String name;
        private final String tooltip;

        public BreakdownType(String name, String tooltip) {
            this.name = name;
            this.tooltip = tooltip;
        }

        public void toJson(JsonBuilder.ObjectBuilder builder) throws IOException {
            builder.append("name", (Object)this.name);
            if (this.tooltip != null) {
                builder.append("tooltip", (Object)this.tooltip);
            }
        }
    }

    public static final class ExpertBreakdownType
    extends BreakdownType
    implements ExpertFeature {
        public ExpertBreakdownType(String name, String tooltip) {
            super(name, tooltip);
        }

        @Override
        public void toJson(JsonBuilder.ObjectBuilder builder) throws IOException {
            super.toJson(builder);
            ExpertFeature.super.markAsExpertFeature(builder);
        }
    }
}

