/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reporter;

import com.oracle.graal.reporter.Report;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Reporter {
    private static final String HTML_TEMPLATE = "/index.html";
    private static final String CSS_RESOURCES = "/css-resources.txt";
    private static final String CSS_OPENING_TAG = "<style>";
    private static final String CSS_CLOSING_TAG = "</style>";
    private static final String JS_RESOURCES = "/js-resources.txt";
    private static final String OBFUSCATED_MAIN_JS_RESOURCE = "/js/main.min.js";
    private static final String JS_OPENING_TAG = "<script>";
    private static final String JS_CLOSING_TAG = "</script>";
    private static final Pattern EMBEDDING_COMMAND_REGEX = Pattern.compile("<!-- @(.+) -->");
    private static final String CSS_EMBEDDING_COMMAND = "CSS";
    private static final String JS_EMBEDDING_COMMAND = "JS";

    public static void generate(Report report, Path targetPath) throws ReportGenerationError {
        ArrayList<String> html = new ArrayList<String>();
        Reporter.readAndProcessResourceLines(HTML_TEMPLATE, line -> {
            Matcher m = EMBEDDING_COMMAND_REGEX.matcher(line.trim());
            if (m.find()) {
                String command;
                switch (command = m.group(1)) {
                    case "CSS": {
                        Reporter.embedReportCSS(report, html);
                        break;
                    }
                    case "JS": {
                        Reporter.embedReportJS(report, html);
                    }
                }
            } else {
                html.add((String)line);
            }
        });
        Reporter.writeReportHTML(html, targetPath);
    }

    private static void readAndProcessResourceLines(String name, Consumer<String> processor) throws ReportGenerationError {
        try {
            InputStream input = Reporter.class.getResourceAsStream(name);
            assert (input != null) : "Failed to access resource: " + name;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
                String line;
                while ((line = reader.readLine()) != null) {
                    processor.accept(line);
                }
            }
        }
        catch (IOException e) {
            throw new ReportGenerationError("Failed reading CSS/JS resource (%s).".formatted(name), e);
        }
    }

    private static void embedReportCSS(Report report, List<String> html) {
        Reporter.readAndProcessResourceLines(CSS_RESOURCES, cssFile -> {
            if (report.cssResources().contains(cssFile)) {
                html.add("\t<style>");
                Reporter.readAndProcessResourceLines(cssFile, line -> html.add("\t\t" + line));
                html.add("\t</style>");
            }
        });
    }

    private static void embedReportJS(Report report, List<String> html) {
        String reportJson;
        Reporter.readAndProcessResourceLines(JS_RESOURCES, jsFile -> {
            if (report.jsResources().contains(jsFile) || jsFile.equals(OBFUSCATED_MAIN_JS_RESOURCE)) {
                html.add("\t<script>");
                Reporter.readAndProcessResourceLines(jsFile, line -> html.add("\t\t" + line));
                html.add("\t</script>");
            }
        });
        try {
            reportJson = report.toJson();
        }
        catch (IOException e) {
            throw new ReportGenerationError("Failed to convert report data to JSON", e);
        }
        html.add(JS_OPENING_TAG);
        html.add(reportJson);
        html.add(JS_CLOSING_TAG);
    }

    private static void writeReportHTML(List<String> html, Path targetPath) throws ReportGenerationError {
        Path targetDirectory = targetPath.getParent();
        if (targetDirectory == null) {
            throw new ReportGenerationError("Report path (%s) should always have a parent directory.".formatted(targetPath));
        }
        try {
            Files.createDirectories(targetDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ReportGenerationError("Failed creating report directory (%s).".formatted(targetDirectory), e);
        }
        try {
            Files.write(targetPath, html, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ReportGenerationError("Failed writing HTML content into report file (%s).".formatted(targetPath), e);
        }
    }

    public static final class ReportGenerationError
    extends Error {
        private static final long serialVersionUID = 8997054859570547145L;

        ReportGenerationError(String message) {
            super(message);
        }

        ReportGenerationError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

