/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reporter;

import com.oracle.graal.reporter.ExperimentalSection;
import com.oracle.graal.reporter.Reporter;
import com.oracle.graal.reporter.Section;
import com.oracle.graal.reporter.component.Accordions;
import com.oracle.graal.reporter.component.Component;
import com.oracle.graal.reporter.component.CompositeComponent;
import com.oracle.graal.reporter.component.Main;
import com.oracle.graal.reporter.component.Tabs;
import com.oracle.graal.reporter.component.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import jdk.graal.compiler.util.json.JsonBuilder;
import jdk.graal.compiler.util.json.JsonWriter;

public final class Report {
    private static final Set<Component> coreComponents = Set.of(Main.instance(), Utils.instance(), Accordions.instance(), Tabs.instance());
    private static final String DEFAULT_ICON = "/img/graalvm.ico";
    private final String toolName;
    private final String appName;
    private final String dateTime;
    private final String icon;
    private final boolean expertMode;
    private final Map<Integer, Section> sections;
    private final Set<String> cssResources;
    private final Set<String> jsResources;

    public Report(String toolName, String appName, boolean expertMode) {
        this.toolName = toolName;
        this.appName = appName;
        this.dateTime = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date());
        this.icon = Base64.getEncoder().encodeToString(Report.readDefaultIconResource());
        this.expertMode = expertMode;
        this.sections = new TreeMap<Integer, Section>();
        this.cssResources = new HashSet<String>();
        this.jsResources = new HashSet<String>();
        for (Component coreComponent : coreComponents) {
            this.cssResources.addAll(Report.getAllComponentResources(coreComponent, Component::cssResource));
            this.jsResources.addAll(Report.getAllComponentResources(coreComponent, Component::jsResource));
        }
    }

    public Set<String> cssResources() {
        return this.cssResources;
    }

    public Set<String> jsResources() {
        return this.jsResources;
    }

    public void addSectionAt(int position, Section section) {
        assert (!this.sections.containsKey(position)) : "Report section at the position %d is already defined (old: %s, new: %s).".formatted(position, this.sections.get(position).name(), section.name());
        this.sections.put(position, section);
        for (Component component : section.components()) {
            this.cssResources.addAll(Report.getAllComponentResources(component, Component::cssResource));
            this.jsResources.addAll(Report.getAllComponentResources(component, Component::jsResource));
        }
    }

    String toJson() throws IOException {
        StringWriter writer = new StringWriter();
        Report.variableToJson(writer, "toolName", this.toolName);
        Report.variableToJson(writer, "appName", this.appName);
        Report.variableToJson(writer, "dateTime", this.dateTime);
        Report.variableToJson(writer, "icon", this.icon);
        Report.variableToJson(writer, "expertMode", Boolean.toString(this.expertMode));
        this.sectionsToJson(writer);
        return writer.toString();
    }

    private static byte[] readDefaultIconResource() {
        byte[] byArray;
        block9: {
            InputStream is = Reporter.class.getResourceAsStream(DEFAULT_ICON);
            try {
                assert (is != null) : "Failed to access resource: /img/graalvm.ico";
                byArray = is.readAllBytes();
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new Reporter.ReportGenerationError("Failed reading image resource (%s).".formatted(DEFAULT_ICON), e);
                }
            }
            is.close();
        }
        return byArray;
    }

    private static Set<String> getAllComponentResources(Component component, Function<Component, String> resourceGetter) {
        HashSet<String> resources = new HashSet<String>();
        resources.add(resourceGetter.apply(component));
        if (component instanceof CompositeComponent) {
            CompositeComponent compositeComponent = (CompositeComponent)component;
            for (Component containedComponent : compositeComponent.components()) {
                resources.addAll(Report.getAllComponentResources(containedComponent, resourceGetter));
            }
        }
        return resources;
    }

    private static void variableToJson(StringWriter writer, String name, String value) {
        writer.append("const ").append(name).append("=\"").append(value).append("\";").append(System.lineSeparator());
    }

    private void sectionsToJson(StringWriter writer) throws IOException {
        writer.append("const sections=");
        try (JsonWriter jsonWriter = new JsonWriter((Writer)writer);
             JsonBuilder.ArrayBuilder sectionsBuilder = jsonWriter.arrayBuilder();){
            for (Section section : this.sections.values()) {
                JsonBuilder.ObjectBuilder sectionBuilder = sectionsBuilder.nextEntry().object();
                try {
                    sectionBuilder.append("name", (Object)section.name());
                    try (JsonBuilder.ArrayBuilder componentsBuilder = sectionBuilder.append("components").array();){
                        for (Component component : section.components()) {
                            jsonWriter.append(component.toJSVariable()).appendSeparator();
                        }
                    }
                    if (!(section instanceof ExperimentalSection)) continue;
                    ExperimentalSection experimentalSection = (ExperimentalSection)section;
                    experimentalSection.markAsExperimentalFeature(sectionBuilder);
                }
                finally {
                    if (sectionBuilder == null) continue;
                    sectionBuilder.close();
                }
            }
        }
        writer.append(";");
    }
}

