/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.agent.BreakpointInterceptor;
import com.oracle.svm.agent.NativeImageAgent;
import com.oracle.svm.agent.NativeImageAgentJNIHandleSet;
import com.oracle.svm.agent.stackaccess.InterceptedState;
import com.oracle.svm.agent.tracing.core.Tracer;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.jni.JNIObjectHandles;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIFieldId;
import com.oracle.svm.core.jni.headers.JNIFunctionPointerTypes;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.core.jni.headers.JNINativeInterface;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.jvmtiagentbase.AgentIsolate;
import com.oracle.svm.jvmtiagentbase.Support;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEnv;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiError;
import java.util.function.Supplier;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class JniCallInterceptor {
    private static Tracer tracer;
    private static NativeImageAgent agent;
    private static Supplier<InterceptedState> interceptedStateSupplier;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.DefineClassFunctionPointer> defineClassLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.FindClassFunctionPointer> findClassLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.FindClassFunctionPointer> allocObjectLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.GetMethodIDFunctionPointer> getMethodIDLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.GetMethodIDFunctionPointer> getStaticMethodIDLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.GetFieldIDFunctionPointer> getFieldIDLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.GetFieldIDFunctionPointer> getStaticFieldIDLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.ThrowNewFunctionPointer> throwNewLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.FromReflectedMethodFunctionPointer> fromReflectedMethodLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.FromReflectedFieldFunctionPointer> fromReflectedFieldLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.ToReflectedMethodFunctionPointer> toReflectedMethodLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.ToReflectedFieldFunctionPointer> toReflectedFieldLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.NewObjectArrayFunctionPointer> newObjectArrayLiteral;

    JniCallInterceptor() {
    }

    private static boolean shouldTrace() {
        return tracer != null;
    }

    private static InterceptedState initInterceptedState() {
        return interceptedStateSupplier.get();
    }

    private static void traceCall(JNIEnvironment env, String function, JNIObjectHandle clazz, JNIObjectHandle declaringClass, JNIObjectHandle callerClass, Object result, InterceptedState state, Object ... args) {
        JNIObjectHandle pending = Support.jniFunctions().getExceptionOccurred().invoke(env);
        Support.clearException((JNIEnvironment)env);
        tracer.traceCall("jni", function, BreakpointInterceptor.getTypeDescriptor(env, clazz), BreakpointInterceptor.getTypeDescriptor(env, declaringClass), Support.getClassNameOr((JNIEnvironment)env, (JNIObjectHandle)callerClass, null, (String)Tracer.UNKNOWN_VALUE), result, state.getFullStackTraceOrNull(), args);
        Support.checkNoException((JNIEnvironment)env);
        if (pending.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            Support.checkJni((int)Support.jniFunctions().getThrow().invoke(env, pending));
        }
    }

    @CEntryPoint(name="DefineClass")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static JNIObjectHandle defineClass(JNIEnvironment env, CCharPointer name, JNIObjectHandle loader, CCharPointer buf, int bufLen) {
        InterceptedState state = JniCallInterceptor.initInterceptedState();
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(state, env);
        JNIObjectHandle result = Support.jniFunctions().getDefineClass().invoke(env, name, loader, buf, bufLen);
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "DefineClass", (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, name.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), state, Support.fromCString((CCharPointer)name));
        }
        return result;
    }

    private static JNIObjectHandle getCallerClass(InterceptedState state, JNIEnvironment env) {
        try {
            JNIObjectHandle jNIObjectHandle = state.getDirectCallerClass();
            return jNIObjectHandle;
        }
        finally {
            Support.checkNoException((JNIEnvironment)env);
        }
    }

    @CEntryPoint(name="FindClass")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static JNIObjectHandle findClass(JNIEnvironment env, CCharPointer name) {
        String className;
        InterceptedState state = JniCallInterceptor.initInterceptedState();
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(state, env);
        JNIObjectHandle result = Support.jniFunctions().getFindClass().invoke(env, name);
        if (JNIObjectHandles.nullHandle().equal((ComparableWord)result) || Support.clearException((JNIEnvironment)env)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        if (JniCallInterceptor.shouldTrace() && (className = Support.fromCString((CCharPointer)name)) != null) {
            JniCallInterceptor.traceCall(env, "FindClass", (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, name.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), state, className);
        }
        return result;
    }

    @CEntryPoint(name="AllocObject")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    static JNIObjectHandle allocObject(JNIEnvironment env, JNIObjectHandle clazz) {
        InterceptedState state = JniCallInterceptor.initInterceptedState();
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(state, env);
        JNIObjectHandle result = Support.jniFunctions().getAllocObject().invoke(env, clazz);
        if (JNIObjectHandles.nullHandle().equal((ComparableWord)result) || Support.clearException((JNIEnvironment)env)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "AllocObject", clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), state, new Object[0]);
        }
        return result;
    }

    @CEntryPoint(name="GetMethodID")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static JNIMethodId getMethodID(JNIEnvironment env, JNIObjectHandle clazz, CCharPointer name, CCharPointer signature) {
        InterceptedState state = JniCallInterceptor.initInterceptedState();
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(state, env);
        JNIMethodId result = Support.jniFunctions().getGetMethodID().invoke(env, clazz, name, signature);
        if (JniCallInterceptor.shouldTrace()) {
            boolean shouldHandleCall = clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && name.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && signature.notEqual((ComparableWord)JNIObjectHandles.nullHandle());
            JniCallInterceptor.traceCall(env, "GetMethodID", clazz, Support.getMethodDeclaringClass((JNIMethodId)result), callerClass, shouldHandleCall, state, Support.fromCString((CCharPointer)name), Support.fromCString((CCharPointer)signature));
        }
        return result;
    }

    @CEntryPoint(name="GetStaticMethodID")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static JNIMethodId getStaticMethodID(JNIEnvironment env, JNIObjectHandle clazz, CCharPointer name, CCharPointer signature) {
        InterceptedState state = JniCallInterceptor.initInterceptedState();
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(state, env);
        JNIMethodId result = Support.jniFunctions().getGetStaticMethodID().invoke(env, clazz, name, signature);
        if (JniCallInterceptor.shouldTrace()) {
            boolean shouldHandleCall = clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && name.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && signature.notEqual((ComparableWord)JNIObjectHandles.nullHandle());
            JniCallInterceptor.traceCall(env, "GetStaticMethodID", clazz, Support.getMethodDeclaringClass((JNIMethodId)result), callerClass, shouldHandleCall, state, Support.fromCString((CCharPointer)name), Support.fromCString((CCharPointer)signature));
        }
        return result;
    }

    @CEntryPoint(name="GetFieldID")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static JNIFieldId getFieldID(JNIEnvironment env, JNIObjectHandle clazz, CCharPointer name, CCharPointer signature) {
        InterceptedState state = JniCallInterceptor.initInterceptedState();
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(state, env);
        JNIFieldId result = Support.jniFunctions().getGetFieldID().invoke(env, clazz, name, signature);
        if (JniCallInterceptor.shouldTrace()) {
            boolean shouldHandleCall = clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && name.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && signature.notEqual((ComparableWord)JNIObjectHandles.nullHandle());
            JniCallInterceptor.traceCall(env, "GetFieldID", clazz, Support.getFieldDeclaringClass((JNIObjectHandle)clazz, (JNIFieldId)result), callerClass, shouldHandleCall, state, Support.fromCString((CCharPointer)name), Support.fromCString((CCharPointer)signature));
        }
        return result;
    }

    @CEntryPoint(name="GetStaticFieldID")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static JNIFieldId getStaticFieldID(JNIEnvironment env, JNIObjectHandle clazz, CCharPointer name, CCharPointer signature) {
        InterceptedState state = JniCallInterceptor.initInterceptedState();
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(state, env);
        JNIFieldId result = Support.jniFunctions().getGetStaticFieldID().invoke(env, clazz, name, signature);
        if (JniCallInterceptor.shouldTrace()) {
            boolean shouldHandleCall = clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && name.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && signature.notEqual((ComparableWord)JNIObjectHandles.nullHandle());
            JniCallInterceptor.traceCall(env, "GetStaticFieldID", clazz, Support.getFieldDeclaringClass((JNIObjectHandle)clazz, (JNIFieldId)result), callerClass, shouldHandleCall, state, Support.fromCString((CCharPointer)name), Support.fromCString((CCharPointer)signature));
        }
        return result;
    }

    @CEntryPoint(name="ThrowNew")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static int throwNew(JNIEnvironment env, JNIObjectHandle clazz, CCharPointer message) {
        InterceptedState state = JniCallInterceptor.initInterceptedState();
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(state, env);
        int result = Support.jniFunctions().getThrowNew().invoke(env, clazz, message);
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "ThrowNew", clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), state, Tracer.UNKNOWN_VALUE);
        }
        return result;
    }

    @CEntryPoint(name="FromReflectedMethod")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static JNIMethodId fromReflectedMethod(JNIEnvironment env, JNIObjectHandle method) {
        InterceptedState state = JniCallInterceptor.initInterceptedState();
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(state, env);
        JNIMethodId result = Support.jniFunctions().getFromReflectedMethod().invoke(env, method);
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        String name = null;
        String signature = null;
        if (result.isNonNull()) {
            declaring = Support.getMethodDeclaringClass((JNIMethodId)result);
            CCharPointerPointer namePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
            CCharPointerPointer signaturePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
            if (Support.jvmtiFunctions().GetMethodName().invoke(Support.jvmtiEnv(), result, namePtr, signaturePtr, (CCharPointerPointer)WordFactory.nullPointer()) == JvmtiError.JVMTI_ERROR_NONE) {
                name = Support.fromCString((CCharPointer)namePtr.read());
                signature = Support.fromCString((CCharPointer)signaturePtr.read());
                Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)namePtr.read());
                Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)signaturePtr.read());
            }
        }
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "FromReflectedMethod", declaring, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, result.isNonNull(), state, name, signature);
        }
        return result;
    }

    @CEntryPoint(name="FromReflectedField")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static JNIFieldId fromReflectedField(JNIEnvironment env, JNIObjectHandle field) {
        InterceptedState state = JniCallInterceptor.initInterceptedState();
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(state, env);
        JNIFieldId result = Support.jniFunctions().getFromReflectedField().invoke(env, field);
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        String name = Tracer.EXPLICIT_NULL;
        if (result.isNonNull()) {
            declaring = Support.callObjectMethod((JNIEnvironment)env, (JNIObjectHandle)field, (JNIMethodId)((NativeImageAgentJNIHandleSet)JniCallInterceptor.agent.handles()).javaLangReflectMemberGetDeclaringClass);
            name = Support.getFieldName((JNIObjectHandle)declaring, (JNIFieldId)result);
        }
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "FromReflectedField", declaring, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, result.isNonNull(), state, name);
        }
        return result;
    }

    @CEntryPoint(name="ToReflectedMethod")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static JNIObjectHandle toReflectedMethod(JNIEnvironment env, JNIObjectHandle clazz, JNIMethodId method, boolean isStatic) {
        InterceptedState state = JniCallInterceptor.initInterceptedState();
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(state, env);
        JNIObjectHandle declaring = Support.getMethodDeclaringClass((JNIMethodId)method);
        String name = null;
        String signature = null;
        CCharPointerPointer namePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        CCharPointerPointer signaturePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        if (Support.jvmtiFunctions().GetMethodName().invoke(Support.jvmtiEnv(), method, namePtr, signaturePtr, (CCharPointerPointer)WordFactory.nullPointer()) == JvmtiError.JVMTI_ERROR_NONE) {
            name = Support.fromCString((CCharPointer)namePtr.read());
            signature = Support.fromCString((CCharPointer)signaturePtr.read());
            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)namePtr.read());
            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)signaturePtr.read());
        }
        JNIObjectHandle result = Support.jniFunctions().getToReflectedMethod().invoke(env, clazz, method, isStatic);
        if (JniCallInterceptor.shouldTrace()) {
            boolean shouldHandleCall = clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && name != null && signature != null;
            JniCallInterceptor.traceCall(env, "ToReflectedMethod", clazz, declaring, callerClass, shouldHandleCall, state, name, signature);
        }
        return result;
    }

    @CEntryPoint(name="ToReflectedField")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static JNIObjectHandle toReflectedField(JNIEnvironment env, JNIObjectHandle clazz, JNIFieldId field, boolean isStatic) {
        InterceptedState state = JniCallInterceptor.initInterceptedState();
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(state, env);
        JNIObjectHandle declaring = Support.getFieldDeclaringClass((JNIObjectHandle)clazz, (JNIFieldId)field);
        String name = Support.getFieldName((JNIObjectHandle)clazz, (JNIFieldId)field);
        JNIObjectHandle result = Support.jniFunctions().getToReflectedField().invoke(env, clazz, field, isStatic);
        if (JniCallInterceptor.shouldTrace()) {
            boolean shouldHandleCall = clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && name != null;
            JniCallInterceptor.traceCall(env, "ToReflectedField", clazz, declaring, callerClass, shouldHandleCall, state, name);
        }
        return result;
    }

    @CEntryPoint(name="NewObjectArray")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static JNIObjectHandle newObjectArray(JNIEnvironment env, int length, JNIObjectHandle elementClass, JNIObjectHandle initialElement) {
        InterceptedState state = JniCallInterceptor.initInterceptedState();
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(state, env);
        JNIObjectHandle result = Support.jniFunctions().getNewObjectArray().invoke(env, length, elementClass, initialElement);
        JNIObjectHandle resultClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && !Support.testException((JNIEnvironment)env)) {
            resultClass = Support.jniFunctions().getGetObjectClass().invoke(env, result);
            if (Support.clearException((JNIEnvironment)env)) {
                resultClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "NewObjectArray", resultClass, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, elementClass.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), state, new Object[0]);
        }
        return result;
    }

    public static void onLoad(Tracer writer, NativeImageAgent nativeImageTracingAgent, Supplier<InterceptedState> interceptedStateProvider) {
        tracer = writer;
        interceptedStateSupplier = interceptedStateProvider;
        agent = nativeImageTracingAgent;
    }

    public static void onVMStart(JvmtiEnv jvmti) {
        WordPointer functionsPtr = (WordPointer)StackValue.get(WordPointer.class);
        Support.check((JvmtiError)jvmti.getFunctions().GetJNIFunctionTable().invoke(jvmti, functionsPtr));
        JNINativeInterface functions = (JNINativeInterface)functionsPtr.read();
        functions.setDefineClass((JNIFunctionPointerTypes.DefineClassFunctionPointer)defineClassLiteral.getFunctionPointer());
        functions.setFindClass((JNIFunctionPointerTypes.FindClassFunctionPointer)findClassLiteral.getFunctionPointer());
        functions.setAllocObject(allocObjectLiteral.getFunctionPointer());
        functions.setGetMethodID((JNIFunctionPointerTypes.GetMethodIDFunctionPointer)getMethodIDLiteral.getFunctionPointer());
        functions.setGetStaticMethodID((JNIFunctionPointerTypes.GetMethodIDFunctionPointer)getStaticMethodIDLiteral.getFunctionPointer());
        functions.setGetFieldID((JNIFunctionPointerTypes.GetFieldIDFunctionPointer)getFieldIDLiteral.getFunctionPointer());
        functions.setGetStaticFieldID((JNIFunctionPointerTypes.GetFieldIDFunctionPointer)getStaticFieldIDLiteral.getFunctionPointer());
        functions.setThrowNew((JNIFunctionPointerTypes.ThrowNewFunctionPointer)throwNewLiteral.getFunctionPointer());
        functions.setFromReflectedMethod((JNIFunctionPointerTypes.FromReflectedMethodFunctionPointer)fromReflectedMethodLiteral.getFunctionPointer());
        functions.setToReflectedMethod((JNIFunctionPointerTypes.ToReflectedMethodFunctionPointer)toReflectedMethodLiteral.getFunctionPointer());
        functions.setFromReflectedField((JNIFunctionPointerTypes.FromReflectedFieldFunctionPointer)fromReflectedFieldLiteral.getFunctionPointer());
        functions.setToReflectedField((JNIFunctionPointerTypes.ToReflectedFieldFunctionPointer)toReflectedFieldLiteral.getFunctionPointer());
        functions.setNewObjectArray((JNIFunctionPointerTypes.NewObjectArrayFunctionPointer)newObjectArrayLiteral.getFunctionPointer());
        Support.check((JvmtiError)jvmti.getFunctions().SetJNIFunctionTable().invoke(jvmti, functions));
        Support.check((JvmtiError)jvmti.getFunctions().Deallocate().invoke(jvmti, (PointerBase)functions));
    }

    public static void onUnload() {
        Support.jvmtiFunctions().SetJNIFunctionTable().invoke(Support.jvmtiEnv(), Support.jniFunctions());
        tracer = null;
    }

    static {
        defineClassLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"defineClass", (Class[])new Class[]{JNIEnvironment.class, CCharPointer.class, JNIObjectHandle.class, CCharPointer.class, Integer.TYPE});
        findClassLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"findClass", (Class[])new Class[]{JNIEnvironment.class, CCharPointer.class});
        allocObjectLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"allocObject", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class});
        getMethodIDLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"getMethodID", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, CCharPointer.class, CCharPointer.class});
        getStaticMethodIDLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"getStaticMethodID", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, CCharPointer.class, CCharPointer.class});
        getFieldIDLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"getFieldID", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, CCharPointer.class, CCharPointer.class});
        getStaticFieldIDLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"getStaticFieldID", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, CCharPointer.class, CCharPointer.class});
        throwNewLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"throwNew", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, CCharPointer.class});
        fromReflectedMethodLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"fromReflectedMethod", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class});
        fromReflectedFieldLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"fromReflectedField", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class});
        toReflectedMethodLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"toReflectedMethod", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, JNIMethodId.class, Boolean.TYPE});
        toReflectedFieldLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"toReflectedField", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, JNIFieldId.class, Boolean.TYPE});
        newObjectArrayLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"newObjectArray", (Class[])new Class[]{JNIEnvironment.class, Integer.TYPE, JNIObjectHandle.class, JNIObjectHandle.class});
    }
}

