/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.truffle;

import com.oracle.svm.enterprise.core.aq;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImage;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageBuilder;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageLoader;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageObjectReplacer;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImagePersistenceCancelledException;
import com.oracle.svm.enterprise.core.auximage.MaximumAuxiliaryImageSizeExceededException;
import com.oracle.svm.enterprise.truffle.h;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.enterprise.AbstractEngineCacheSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import jdk.graal.compiler.debug.TTY;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

public final class a
extends AbstractEngineCacheSupport {
    public static final OptionKey<String> a = new OptionKey((Object)"");
    public static final OptionKey<String> b = new OptionKey((Object)"");
    public static final OptionKey<String> c = new OptionKey((Object)"");
    public static final OptionKey<Boolean> d = new OptionKey((Object)false);
    public static final OptionKey<Long> e = new OptionKey((Object)-1L, com.oracle.svm.enterprise.truffle.h.H);
    public static final OptionKey<Boolean> f = new OptionKey((Object)true);
    public static final OptionKey<AbstractEngineCacheSupport.CompilePolicy> g = new OptionKey((Object)AbstractEngineCacheSupport.CompilePolicy.hot);
    public static final OptionKey<Boolean> h = new OptionKey((Object)Boolean.TRUE);
    public static final OptionKey<e> i = new OptionKey((Object)com.oracle.svm.enterprise.truffle.a$e.u);
    public static final OptionKey<Boolean> j = new OptionKey((Object)false);
    private final ThreadLocal<b> k = new ThreadLocal();
    private static final ComparableWord l = WordFactory.unsigned((int)0);

    public OptionDescriptors getEngineOptions() {
        return new com.oracle.svm.enterprise.truffle.b();
    }

    public int getPriority() {
        return 20;
    }

    public Object tryLoadingCachedEngine(OptionValues optionValues, Function<String, TruffleLogger> function) {
        if (!TruffleOptions.AOT) {
            return null;
        }
        Path path = com.oracle.svm.enterprise.truffle.a.a(optionValues);
        if (path == null) {
            this.traceLoad(optionValues, function, "No load engine cache configured.", new Object[0]);
            return null;
        }
        if (!((Boolean)aq.d.AuxiliaryEngineCache.getValue()).booleanValue()) {
            throw new IllegalArgumentException("Cache image cannot be loaded. Native image does not support auxilliary engine caching. Enable with -H:+AuxiliaryEngineCache at image build time.");
        }
        assert (this.k.get() == null);
        b b2 = this.a(optionValues, function, path);
        if (b2 == null) {
            return null;
        }
        this.k.set(b2);
        return b2.a();
    }

    private static Path a(OptionValues optionValues) {
        Path path;
        if (optionValues.hasBeenSet(a)) {
            if (optionValues.hasBeenSet(b)) {
                throw new IllegalArgumentException("The options engine.Cache and engine.CacheLoad are mutually exclusive.");
            }
            path = Paths.get((String)optionValues.get(a), new String[0]);
        } else if (optionValues.hasBeenSet(b)) {
            path = Paths.get((String)optionValues.get(b), new String[0]);
        } else {
            return null;
        }
        return path;
    }

    private static Path b(OptionValues optionValues) {
        Path path;
        if (optionValues.hasBeenSet(a)) {
            if (optionValues.hasBeenSet(c)) {
                throw new IllegalArgumentException("The options engine.Cache and engine.CacheStore are mutually exclusive.");
            }
            path = Paths.get((String)optionValues.get(a), new String[0]);
        } else if (optionValues.hasBeenSet(c)) {
            path = Paths.get((String)optionValues.get(c), new String[0]);
        } else {
            return null;
        }
        return path;
    }

    private b a(OptionValues optionValues, Function<String, TruffleLogger> function, Path path) {
        if (AuxiliaryImageLoader.hasLoaded()) {
            throw new IllegalStateException("Auxiliary image memory is already in use. Only one image can be loaded per process.");
        }
        boolean bl = (Boolean)optionValues.get(j);
        try {
            long l2 = 0L;
            if (bl) {
                l2 = System.currentTimeMillis();
                this.traceLoad(optionValues, function, "Try loading image '%s'...", new Object[]{path});
            }
            if (!Files.exists(path, new LinkOption[0])) {
                this.traceLoad(optionValues, function, "Failed to load image. File does not exist.", new Object[]{path});
                return null;
            }
            File file = path.toFile();
            AuxiliaryImage auxiliaryImage = AuxiliaryImageLoader.load((File)file);
            if (!auxiliaryImage.contains(b.class)) {
                this.traceLoad(optionValues, function, "Failed to load image. Image ignored.", new Object[]{path});
                return null;
            }
            b b2 = (b)auxiliaryImage.lookup(b.class);
            if (bl) {
                l2 = System.currentTimeMillis() - l2;
                this.traceLoad(optionValues, function, "Loaded image in %d ms. %,6d bytes %3d sources %3d roots", new Object[]{l2, file.length(), b2.b().length, b2.c().length});
            }
            return b2;
        }
        catch (Throwable throwable) {
            if (bl) {
                this.traceLoad(optionValues, function, "Failed to load image from %s. Image ignored.", new Object[]{path});
                throwable.printStackTrace(TTY.out);
            }
            return null;
        }
    }

    public void onEngineCreated(EngineData engineData) {
    }

    public void onEnginePatch(EngineData engineData) {
        if (!TruffleOptions.AOT) {
            return;
        }
        b b2 = this.k.get();
        if (b2 != null) {
            this.trace(engineData, "Engine from image successfully patched with new options.", new Object[]{b2});
            engineData.putEngineLocal(b.class, (Object)b2);
            this.k.set(null);
            engineData.mergeLoadedSources(b2.b());
        }
    }

    protected OptionKey<Boolean> getTraceOption() {
        return j;
    }

    public boolean isStoreEnabled(OptionValues optionValues) {
        return TruffleOptions.AOT && (com.oracle.svm.enterprise.truffle.a.b(optionValues) != null || (Boolean)optionValues.get(d) != false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onStoreCache(EngineData engineData, Path path, long l2) {
        try {
            boolean bl = this.a(engineData, path, (WordPointer)WordFactory.pointer((long)l2));
            return bl;
        }
        finally {
            this.restoreEngine(engineData);
        }
    }

    public boolean onEngineClosing(EngineData engineData) {
        Path path;
        if (!TruffleOptions.AOT) {
            return false;
        }
        if (this.k.get() != null) {
            this.k.set(null);
        }
        if ((path = com.oracle.svm.enterprise.truffle.a.b(engineData.getEngineOptions())) == null) {
            this.trace(engineData, "No store engine cache configured.", new Object[0]);
            return false;
        }
        path = path.toAbsolutePath();
        try {
            this.a(engineData, path, (WordPointer)WordFactory.nullPointer());
        }
        finally {
            this.restoreEngine(engineData);
        }
        return false;
    }

    private boolean a(EngineData engineData, Path path, WordPointer wordPointer) throws CancellationException {
        BooleanSupplier booleanSupplier;
        if (!((Boolean)aq.d.AuxiliaryEngineCache.getValue()).booleanValue()) {
            throw new IllegalArgumentException("Cache image cannot be stored. Native image does not support auxilliary engine caching. Enable with -H:+AuxiliaryEngineCache at image build time.");
        }
        AbstractEngineCacheSupport.CompilePolicy compilePolicy = (AbstractEngineCacheSupport.CompilePolicy)engineData.getEngineOptions().get(g);
        boolean bl = (Boolean)engineData.getEngineOptions().get(this.getTraceOption());
        if (Files.exists(path, new LinkOption[0]) && !Files.isWritable(path)) {
            throw new IllegalArgumentException("Configured store image path is not writable: " + String.valueOf(path.toAbsolutePath()));
        }
        long l2 = 0L;
        if (bl) {
            this.trace(engineData, "Preparing engine for store (compile policy %s)...", new Object[]{compilePolicy});
            l2 = System.currentTimeMillis();
        }
        if (wordPointer.isNonNull()) {
            long l3 = wordPointer.rawValue();
            booleanSupplier = () -> {
                ComparableWord comparableWord = (ComparableWord)((Pointer)WordFactory.pointer((long)l3)).readWord(0);
                return comparableWord.notEqual(l);
            };
        } else {
            booleanSupplier = null;
        }
        OptionValues optionValues = engineData.getEngineOptions();
        b b2 = new b(this.prepareEngine(engineData, compilePolicy, (Boolean)optionValues.get(h), (Boolean)optionValues.get(f), booleanSupplier));
        if (bl) {
            l2 = System.currentTimeMillis() - l2;
            this.trace(engineData, "Prepared engine in %,d ms.", new Object[]{l2});
        }
        b b3 = (b)engineData.getEngineLocal(b.class);
        engineData.clearEngineLocal(b.class);
        AbstractEngineCacheSupport.FinalizationResult finalizationResult = (AbstractEngineCacheSupport.FinalizationResult)engineData.getEngineLocal(AbstractEngineCacheSupport.FinalizationResult.class);
        engineData.clearEngineLocal(AbstractEngineCacheSupport.FinalizationResult.class);
        try {
            block15: {
                ByteBuffer byteBuffer = this.a(engineData, b3, b2, wordPointer);
                try {
                    if (byteBuffer == null) break block15;
                    if (bl) {
                        this.trace(engineData, "Writing image to %s...", new Object[]{path});
                        l2 = System.currentTimeMillis();
                    }
                    int n2 = com.oracle.svm.enterprise.truffle.a.a(byteBuffer, path.toFile());
                    if (bl) {
                        l2 = System.currentTimeMillis() - l2;
                        this.trace(engineData, "Finished writing %,5d bytes in %,d ms.", new Object[]{n2, l2});
                    }
                    boolean bl2 = true;
                    return bl2;
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Failed writing image " + String.valueOf(iOException), iOException);
                }
            }
            this.trace(engineData, "Skipped image write. ", new Object[]{path});
            boolean bl3 = false;
            return bl3;
        }
        finally {
            engineData.putEngineLocal(AbstractEngineCacheSupport.FinalizationResult.class, (Object)finalizationResult);
        }
    }

    private ByteBuffer a(EngineData engineData, b b2, b b3, WordPointer wordPointer) throws CancellationException {
        ByteBuffer byteBuffer;
        long l2;
        boolean bl = (Boolean)engineData.getEngineOptions().get(j);
        long l3 = 0L;
        if (bl) {
            this.trace(engineData, "Persisting engine for store ...", new Object[0]);
            l3 = System.currentTimeMillis();
        }
        AuxiliaryImageBuilder auxiliaryImageBuilder = new AuxiliaryImageBuilder();
        auxiliaryImageBuilder.add(b.class, (Object)b3);
        d d2 = new d(b3.b());
        a a2 = new a(b3.c());
        auxiliaryImageBuilder.registerObjectReplacer((AuxiliaryImageObjectReplacer)d2);
        auxiliaryImageBuilder.registerObjectReplacer((AuxiliaryImageObjectReplacer)a2);
        if (wordPointer.isNonNull()) {
            auxiliaryImageBuilder.enableControlMemoryWord(wordPointer);
        }
        if ((l2 = ((Long)engineData.getEngineOptions().get(e)).longValue()) >= 0L) {
            auxiliaryImageBuilder.setMaximumAllowedAuxiliaryImageSize(l2);
        }
        final Object object = engineData.getEngineLock();
        final Object object2 = new Object();
        final Object object3 = engineData.getEngineLogHandler();
        auxiliaryImageBuilder.registerObjectReplacer(new AuxiliaryImageObjectReplacer(){

            public Object replace(Object object4, AuxiliaryImageObjectReplacer.Access access) {
                if (object4 == object) {
                    return object2;
                }
                if (object4 == object3) {
                    return null;
                }
                return object4;
            }
        });
        try {
            byteBuffer = auxiliaryImageBuilder.persist();
        }
        catch (AuxiliaryImagePersistenceCancelledException auxiliaryImagePersistenceCancelledException) {
            CancellationException cancellationException = new CancellationException("Engine persist was cancelled.");
            cancellationException.initCause(auxiliaryImagePersistenceCancelledException);
            throw cancellationException;
        }
        catch (MaximumAuxiliaryImageSizeExceededException maximumAuxiliaryImageSizeExceededException) {
            if (bl) {
                this.trace(engineData, "Failed to persist engine to buffer. Image is bigger than the limit of " + l2 + " bytes.", new Object[0]);
            }
            return null;
        }
        catch (Throwable throwable) {
            if (bl) {
                this.trace(engineData, "Failed to persist engine to buffer.", new Object[0]);
                this.trace(engineData, String.valueOf(throwable), new Object[0]);
            }
            throw new IllegalStateException("Failed persisting image " + String.valueOf(throwable), throwable);
        }
        if (bl) {
            l3 = System.currentTimeMillis() - l3;
            this.trace(engineData, "Persisted engine in %d ms.", new Object[]{l3});
        }
        e e2 = (e)((Object)engineData.getEngineOptions().get(i));
        if (bl) {
            this.trace(engineData, "Detecting changes (update policy %s)...", new Object[]{e2.toString()});
        }
        if (b2 != null) {
            this.trace(engineData, "    Previous image contains  %3d sources and %3d function roots.", new Object[]{b2.b().length, b2.c().length});
        }
        this.trace(engineData, "    New image contains       %3d sources and %3d function roots.", new Object[]{d2.d().size(), a2.d().size(), engineData.getCallTargets().size()});
        switch (e2.ordinal()) {
            case 0: {
                this.trace(engineData, "    Always persist policy. ", new Object[0]);
                break;
            }
            case 2: {
                if (b2 == null) {
                    if (!bl) break;
                    this.trace(engineData, "    New image detected -> always persist.", new Object[0]);
                    break;
                }
                Source[] sourceArray = b2.b();
                if (!com.oracle.svm.enterprise.truffle.a.a(sourceArray, d2.d())) {
                    byteBuffer = null;
                }
                if (!bl) break;
                this.a(engineData, "sources", sourceArray, d2.d(), byteBuffer != null);
                break;
            }
            case 1: {
                CallTarget[] callTargetArray;
                if (b2 == null) {
                    if (!bl) break;
                    this.trace(engineData, "    New image detected -> always persist.", new Object[0]);
                    break;
                }
                CallTarget[] callTargetArray2 = callTargetArray = b2 == null ? null : b2.c();
                if (!com.oracle.svm.enterprise.truffle.a.a(callTargetArray, a2.d())) {
                    byteBuffer = null;
                }
                if (!bl) break;
                this.a(engineData, "function roots", callTargetArray, a2.d(), byteBuffer != null);
                break;
            }
            case 3: {
                byteBuffer = null;
                this.trace(engineData, "    Never persist policy. Keep previous image.", new Object[0]);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return byteBuffer;
    }

    private <T> void a(EngineData engineData, String string2, T[] TArray, Set<T> set, boolean bl) {
        if (bl) {
            HashSet<T> hashSet = new HashSet<T>();
            hashSet.addAll(set);
            if (TArray != null) {
                for (Object object2 : TArray) {
                    hashSet.remove(object2);
                }
            }
            this.trace(engineData, "    Changed %s detected:", new Object[]{string2});
            hashSet.stream().map(object -> object.toString() + " 0x" + Integer.toHexString(System.identityHashCode(object))).sorted().forEach(string -> this.trace(engineData, "      + %s", new Object[]{string}));
            hashSet.clear();
            if (TArray != null) {
                for (Object object2 : TArray) {
                    hashSet.add(object2);
                }
            }
            for (Object e2 : set) {
                hashSet.remove(e2);
            }
            hashSet.stream().map(object -> object.toString() + " 0x" + Integer.toHexString(System.identityHashCode(object))).sorted().forEach(string -> this.trace(engineData, "      - %s", new Object[]{string}));
        } else {
            this.trace(engineData, "    No changed %s detected.", new Object[]{string2});
        }
    }

    private static <T> boolean a(T[] TArray, Set<T> set) {
        if (TArray == null) {
            return true;
        }
        if (TArray.length != set.size()) {
            return true;
        }
        if (TArray.length == 0) {
            return false;
        }
        return !set.containsAll(Arrays.asList(TArray));
    }

    static int a(ByteBuffer byteBuffer, File file) throws IOException {
        Files.deleteIfExists(file.toPath());
        try (FileChannel fileChannel = new FileOutputStream(file).getChannel();){
            int n2 = fileChannel.write(byteBuffer);
            return n2;
        }
    }

    public void onEngineClosed(EngineData engineData) {
    }

    private static final class b {
        private final Object p;
        private final Source[] q = new Source[0];
        private final CallTarget[] r = new CallTarget[0];

        b(Object object) {
            this.p = object;
        }

        public Object a() {
            return this.p;
        }

        public Source[] b() {
            return this.q;
        }

        public CallTarget[] c() {
            return this.r;
        }

        public String toString() {
            return "CachedEngine[" + String.valueOf(this.p) + "]";
        }
    }

    static final class d
    extends c<Source> {
        d(Source[] sourceArray) {
            super(sourceArray);
        }

        protected Source[] c(int n2) {
            return new Source[n2];
        }

        @Override
        protected boolean c(Object object) {
            return object instanceof Source;
        }

        @Override
        protected /* synthetic */ Object[] b(int n2) {
            return this.c(n2);
        }
    }

    static final class a
    extends c<CallTarget> {
        a(CallTarget[] callTargetArray) {
            super(callTargetArray);
        }

        protected CallTarget[] a(int n2) {
            return new CallTarget[n2];
        }

        @Override
        protected boolean c(Object object) {
            return object instanceof OptimizedCallTarget;
        }

        @Override
        protected /* synthetic */ Object[] b(int n2) {
            return this.a(n2);
        }
    }

    public static final class e
    extends Enum<e> {
        public static final /* enum */ e u = new e();
        public static final /* enum */ e v = new e();
        public static final /* enum */ e w = new e();
        public static final /* enum */ e x = new e();
        private static final /* synthetic */ e[] $VALUES;

        public static e[] values() {
            return (e[])$VALUES.clone();
        }

        public static e a(String string) {
            return Enum.valueOf(e.class, string);
        }

        private static /* synthetic */ e[] e() {
            return new e[]{u, v, w, x};
        }

        static {
            $VALUES = com.oracle.svm.enterprise.truffle.a$e.e();
        }
    }

    static abstract class c<T>
    implements AuxiliaryImageObjectReplacer {
        private final T[] s;
        private final Set<T> t = Collections.newSetFromMap(new IdentityHashMap());

        c(T[] TArray) {
            this.s = TArray;
        }

        protected abstract boolean c(Object var1);

        public final Object replace(Object object, AuxiliaryImageObjectReplacer.Access access) {
            if (this.c(object)) {
                this.t.add(object);
            }
            return object;
        }

        protected abstract T[] b(int var1);

        public final void epilogue(AuxiliaryImageObjectReplacer.EpilogueAccess epilogueAccess) {
            T[] TArray = this.t.toArray(this.b(this.t.size()));
            epilogueAccess.replaceLate(this.s, TArray);
        }

        public final Set<T> d() {
            return this.t;
        }
    }
}

