/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jvmtiagentbase;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jni.JNIObjectHandles;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIErrors;
import com.oracle.svm.core.jni.headers.JNIFieldId;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.core.jni.headers.JNINativeInterface;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.core.jni.headers.JNIValue;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.jvmtiagentbase.JNIHandleSet;
import com.oracle.svm.jvmtiagentbase.JvmtiAgentBase;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEnv;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiError;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiFrameInfo;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiInterface;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class Support {
    private static JvmtiEnv jvmtiEnv;
    private static JNINativeInterface jniFunctions;
    private static int jvmtiVersion;

    public static boolean isInitialized() {
        boolean initialized = jvmtiEnv.isNonNull();
        assert (initialized == jniFunctions.isNonNull() && initialized == (jvmtiVersion != 0));
        return initialized;
    }

    public static void initialize(JvmtiEnv jvmti) {
        VMError.guarantee((!Support.isInitialized() ? 1 : 0) != 0);
        WordPointer functionsPtr = (WordPointer)StackValue.get(WordPointer.class);
        Support.check(jvmti.getFunctions().GetJNIFunctionTable().invoke(jvmti, functionsPtr));
        VMError.guarantee((functionsPtr.read() != WordFactory.nullPointer() ? 1 : 0) != 0, (String)"Functions table must be initialized exactly once");
        CIntPointer versionPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        Support.check(jvmti.getFunctions().GetVersionNumber().invoke(jvmti, versionPtr));
        jvmtiEnv = jvmti;
        jniFunctions = (JNINativeInterface)functionsPtr.read();
        jvmtiVersion = versionPtr.read();
    }

    public static void destroy() {
        Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)jniFunctions);
        jniFunctions = (JNINativeInterface)WordFactory.nullPointer();
        jvmtiEnv = (JvmtiEnv)WordFactory.nullPointer();
        jvmtiVersion = 0;
    }

    public static String getSystemProperty(JvmtiEnv jvmti, String propertyName) {
        try (CTypeConversion.CCharPointerHolder propertyKey = Support.toCString(propertyName);){
            String propertyValue = null;
            CCharPointerPointer propertyValuePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
            if (jvmti.getFunctions().GetSystemProperty().invoke(jvmti, propertyKey.get(), propertyValuePtr) == JvmtiError.JVMTI_ERROR_NONE) {
                propertyValue = Support.fromCString(propertyValuePtr.read());
                Support.check(jvmti.getFunctions().Deallocate().invoke(jvmti, (PointerBase)propertyValuePtr.read()));
            }
            String string = propertyValue;
            return string;
        }
    }

    public static String[] getSystemProperties(JvmtiEnv jvmti) {
        CIntPointer countPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        WordPointer propertyPtr = (WordPointer)StackValue.get(WordPointer.class);
        Support.check(jvmti.getFunctions().GetSystemProperties().invoke(jvmti, countPtr, propertyPtr));
        int numEntries = countPtr.read();
        CCharPointerPointer properties = (CCharPointerPointer)propertyPtr.read();
        String[] result = new String[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            CCharPointer rawEntry = properties.read(i);
            result[i] = Support.fromCString(rawEntry);
            Support.check(jvmti.getFunctions().Deallocate().invoke(jvmti, (PointerBase)rawEntry));
        }
        Support.check(jvmti.getFunctions().Deallocate().invoke(jvmti, (PointerBase)properties));
        return result;
    }

    public static JvmtiEnv jvmtiEnv() {
        return jvmtiEnv;
    }

    public static JvmtiInterface jvmtiFunctions() {
        return jvmtiEnv.getFunctions();
    }

    public static JNINativeInterface jniFunctions() {
        return jniFunctions;
    }

    public static int jvmtiVersion() {
        return jvmtiVersion;
    }

    public static String fromCString(CCharPointer s) {
        if (s.isNull()) {
            return null;
        }
        return CTypeConversion.toJavaString((CCharPointer)s, (UnsignedWord)SubstrateUtil.strlen((CCharPointer)s), (Charset)StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fromJniString(JNIEnvironment env, JNIObjectHandle handle) {
        CCharPointer cstr;
        if (handle.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && (cstr = Support.jniFunctions().getGetStringUTFChars().invoke(env, handle, (CCharPointer)WordFactory.nullPointer())).isNonNull()) {
            try {
                String string = Support.fromCString(cstr);
                return string;
            }
            finally {
                Support.jniFunctions().getReleaseStringUTFChars().invoke(env, handle, cstr);
            }
        }
        return null;
    }

    public static JNIObjectHandle toJniString(JNIEnvironment jni, String string) {
        try (CTypeConversion.CCharPointerHolder cString = Support.toCString(string);){
            JNIObjectHandle jNIObjectHandle = Support.jniFunctions().getNewStringUTF().invoke(jni, cString.get());
            return jNIObjectHandle;
        }
    }

    public static CTypeConversion.CCharPointerHolder toCString(String s) {
        return CTypeConversion.toCString((CharSequence)s);
    }

    public static boolean isSerializable(JNIEnvironment env, JNIObjectHandle serializeTargetClass) {
        return Support.jniFunctions().getIsAssignableFrom().invoke(env, serializeTargetClass, ((JNIHandleSet)((JvmtiAgentBase)JvmtiAgentBase.singleton()).handles()).javaIoSerializable);
    }

    public static JNIMethodId getCallerMethod(int depth) {
        JvmtiFrameInfo frameInfo = (JvmtiFrameInfo)StackValue.get(JvmtiFrameInfo.class);
        CIntPointer countPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        JvmtiError result = Support.jvmtiFunctions().GetStackTrace().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), depth, 1, (WordPointer)frameInfo, countPtr);
        if (result == JvmtiError.JVMTI_ERROR_NONE && countPtr.read() == 1) {
            return frameInfo.getMethod();
        }
        return (JNIMethodId)WordFactory.nullPointer();
    }

    public static JNIObjectHandle getObjectArgument(JNIObjectHandle thread, int slot) {
        assert (thread.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) || Support.jvmtiVersion() != 0x30130000) : "JDK-8292657";
        WordPointer handlePtr = (WordPointer)StackValue.get(WordPointer.class);
        if (Support.jvmtiFunctions().GetLocalObject().invoke(Support.jvmtiEnv(), thread, 0, slot, (PointerBase)handlePtr) != JvmtiError.JVMTI_ERROR_NONE) {
            return (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return (JNIObjectHandle)handlePtr.read();
    }

    public static JNIObjectHandle getReceiver(JNIObjectHandle thread) {
        assert (thread.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) || Support.jvmtiVersion() != 0x30130000) : "JDK-8292657";
        WordPointer handlePtr = (WordPointer)StackValue.get(WordPointer.class);
        JvmtiError result = Support.jvmtiFunctions().GetLocalInstance().invoke(Support.jvmtiEnv(), thread, 0, (PointerBase)handlePtr);
        if (result != JvmtiError.JVMTI_ERROR_NONE) {
            assert (result != JvmtiError.JVMTI_ERROR_INVALID_SLOT) : "not an instance method";
            return (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return (JNIObjectHandle)handlePtr.read();
    }

    public static String getClassNameOr(JNIEnvironment env, JNIObjectHandle clazz, String forNullHandle, String forNullNameOrException) {
        if (clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            JNIObjectHandle clazzName = Support.callObjectMethod(env, clazz, ((JNIHandleSet)((JvmtiAgentBase)JvmtiAgentBase.singleton()).handles()).javaLangClassGetName);
            if (Support.clearException(env)) {
                return forNullNameOrException;
            }
            String result = Support.fromJniString(env, clazzName);
            if (result == null) {
                result = forNullNameOrException;
            }
            return result;
        }
        return forNullHandle;
    }

    public static String getClassNameOrNull(JNIEnvironment env, JNIObjectHandle clazz) {
        return Support.getClassNameOr(env, clazz, null, null);
    }

    public static JNIObjectHandle getMethodDeclaringClass(JNIMethodId method) {
        WordPointer declaringClass = (WordPointer)StackValue.get(WordPointer.class);
        if (method.isNull() || Support.jvmtiFunctions().GetMethodDeclaringClass().invoke(Support.jvmtiEnv(), method, declaringClass) != JvmtiError.JVMTI_ERROR_NONE) {
            declaringClass.write((WordBase)WordFactory.nullPointer());
        }
        return (JNIObjectHandle)declaringClass.read();
    }

    public static JNIObjectHandle getFieldDeclaringClass(JNIObjectHandle clazz, JNIFieldId method) {
        WordPointer declaringClass = (WordPointer)StackValue.get(WordPointer.class);
        if (method.isNull() || Support.jvmtiFunctions().GetFieldDeclaringClass().invoke(Support.jvmtiEnv(), clazz, method, declaringClass) != JvmtiError.JVMTI_ERROR_NONE) {
            declaringClass.write((WordBase)WordFactory.nullPointer());
        }
        return (JNIObjectHandle)declaringClass.read();
    }

    public static String getFieldName(JNIObjectHandle clazz, JNIFieldId field) {
        String name = null;
        CCharPointerPointer namePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        if (Support.jvmtiFunctions().GetFieldName().invoke(Support.jvmtiEnv(), clazz, field, namePtr, (CCharPointerPointer)WordFactory.nullPointer(), (CCharPointerPointer)WordFactory.nullPointer()) == JvmtiError.JVMTI_ERROR_NONE) {
            name = Support.fromCString(namePtr.read());
            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)namePtr.read());
        }
        return name;
    }

    public static String getMethodNameOr(JNIMethodId methodId, String defaultValue) {
        String methodName = defaultValue;
        CCharPointerPointer methodNamePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        if (Support.jvmtiFunctions().GetMethodName().invoke(Support.jvmtiEnv(), methodId, methodNamePtr, (CCharPointerPointer)JNIObjectHandles.nullHandle(), (CCharPointerPointer)JNIObjectHandles.nullHandle()) == JvmtiError.JVMTI_ERROR_NONE) {
            methodName = Support.fromCString(methodNamePtr.read());
            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)methodNamePtr.read());
        }
        return methodName;
    }

    public static boolean clearException(JNIEnvironment localEnv) {
        if (Support.jniFunctions().getExceptionCheck().invoke(localEnv)) {
            Support.jniFunctions().getExceptionClear().invoke(localEnv);
            return true;
        }
        return false;
    }

    public static boolean testException(JNIEnvironment localEnv) {
        if (Support.jniFunctions().getExceptionCheck().invoke(localEnv)) {
            Support.jniFunctions().getExceptionDescribe().invoke(localEnv);
            return true;
        }
        return false;
    }

    public static JNIObjectHandle handleException(JNIEnvironment localEnv, boolean clear) {
        if (Support.jniFunctions().getExceptionCheck().invoke(localEnv)) {
            JNIObjectHandle exception = Support.jniFunctions().getExceptionOccurred().invoke(localEnv);
            if (clear) {
                Support.jniFunctions().getExceptionClear().invoke(localEnv);
            }
            return exception;
        }
        return (JNIObjectHandle)JNIObjectHandles.nullHandle();
    }

    public static JNIObjectHandle readObjectField(JNIEnvironment env, JNIObjectHandle obj, JNIFieldId fieldId) {
        return Support.jniFunctions().getGetObjectField().invoke(env, obj, fieldId);
    }

    public static JNIObjectHandle callObjectMethod(JNIEnvironment env, JNIObjectHandle obj, JNIMethodId method) {
        return Support.jniFunctions().getCallObjectMethodA().invoke(env, obj, method, (JNIValue)WordFactory.nullPointer());
    }

    public static JNIObjectHandle callObjectMethodL(JNIEnvironment env, JNIObjectHandle obj, JNIMethodId method, JNIObjectHandle l0) {
        JNIValue args = (JNIValue)StackValue.get((int)1, JNIValue.class);
        args.setObject(l0);
        return Support.jniFunctions().getCallObjectMethodA().invoke(env, obj, method, args);
    }

    public static JNIObjectHandle callObjectMethodLL(JNIEnvironment env, JNIObjectHandle obj, JNIMethodId method, JNIObjectHandle l0, JNIObjectHandle l1) {
        JNIValue args = (JNIValue)StackValue.get((int)2, JNIValue.class);
        args.addressOf(0).setObject(l0);
        args.addressOf(1).setObject(l1);
        return Support.jniFunctions().getCallObjectMethodA().invoke(env, obj, method, args);
    }

    public static JNIObjectHandle callObjectMethodLLL(JNIEnvironment env, JNIObjectHandle obj, JNIMethodId method, JNIObjectHandle l0, JNIObjectHandle l1, JNIObjectHandle l2) {
        JNIValue args = (JNIValue)StackValue.get((int)3, JNIValue.class);
        args.addressOf(0).setObject(l0);
        args.addressOf(1).setObject(l1);
        args.addressOf(2).setObject(l2);
        return Support.jniFunctions().getCallObjectMethodA().invoke(env, obj, method, args);
    }

    public static JNIObjectHandle callObjectMethodLLLL(JNIEnvironment env, JNIObjectHandle obj, JNIMethodId method, JNIObjectHandle l0, JNIObjectHandle l1, JNIObjectHandle l2, JNIObjectHandle l3) {
        JNIValue args = (JNIValue)StackValue.get((int)4, JNIValue.class);
        args.addressOf(0).setObject(l0);
        args.addressOf(1).setObject(l1);
        args.addressOf(2).setObject(l2);
        args.addressOf(3).setObject(l3);
        return Support.jniFunctions().getCallObjectMethodA().invoke(env, obj, method, args);
    }

    public static JNIObjectHandle callStaticObjectMethod(JNIEnvironment env, JNIObjectHandle clazz, JNIMethodId method) {
        JNIValue args = (JNIValue)StackValue.get((int)0, JNIValue.class);
        return Support.jniFunctions().getCallStaticObjectMethodA().invoke(env, clazz, method, args);
    }

    public static JNIObjectHandle callStaticObjectMethodL(JNIEnvironment env, JNIObjectHandle clazz, JNIMethodId method, JNIObjectHandle l0) {
        JNIValue args = (JNIValue)StackValue.get((int)1, JNIValue.class);
        args.setObject(l0);
        return Support.jniFunctions().getCallStaticObjectMethodA().invoke(env, clazz, method, args);
    }

    public static JNIObjectHandle callStaticObjectMethodLL(JNIEnvironment env, JNIObjectHandle clazz, JNIMethodId method, JNIObjectHandle l0, JNIObjectHandle l1) {
        JNIValue args = (JNIValue)StackValue.get((int)2, JNIValue.class);
        args.addressOf(0).setObject(l0);
        args.addressOf(1).setObject(l1);
        return Support.jniFunctions().getCallStaticObjectMethodA().invoke(env, clazz, method, args);
    }

    public static JNIObjectHandle callStaticObjectMethodLIL(JNIEnvironment env, JNIObjectHandle clazz, JNIMethodId method, JNIObjectHandle l0, int i1, JNIObjectHandle l2) {
        JNIValue args = (JNIValue)StackValue.get((int)3, JNIValue.class);
        args.addressOf(0).setObject(l0);
        args.addressOf(1).setInt(i1);
        args.addressOf(2).setObject(l2);
        return Support.jniFunctions().getCallStaticObjectMethodA().invoke(env, clazz, method, args);
    }

    public static JNIObjectHandle callStaticObjectMethodLLL(JNIEnvironment env, JNIObjectHandle clazz, JNIMethodId method, JNIObjectHandle l0, JNIObjectHandle l1, JNIObjectHandle l2) {
        JNIValue args = (JNIValue)StackValue.get((int)3, JNIValue.class);
        args.addressOf(0).setObject(l0);
        args.addressOf(1).setObject(l1);
        args.addressOf(2).setObject(l2);
        return Support.jniFunctions().getCallStaticObjectMethodA().invoke(env, clazz, method, args);
    }

    public static void callStaticVoidMethodLL(JNIEnvironment env, JNIObjectHandle clazz, JNIMethodId method, JNIObjectHandle l0, JNIObjectHandle l1) {
        JNIValue args = (JNIValue)StackValue.get((int)2, JNIValue.class);
        args.addressOf(0).setObject(l0);
        args.addressOf(1).setObject(l1);
        Support.jniFunctions().getCallStaticVoidMethodA().invoke(env, clazz, method, args);
    }

    public static boolean callStaticBooleanMethodL(JNIEnvironment env, JNIObjectHandle clazz, JNIMethodId method, JNIObjectHandle l0) {
        JNIValue args = (JNIValue)StackValue.get((int)1, JNIValue.class);
        args.addressOf(0).setObject(l0);
        return Support.jniFunctions().getCallStaticBooleanMethodA().invoke(env, clazz, method, args);
    }

    public static boolean callBooleanMethod(JNIEnvironment env, JNIObjectHandle obj, JNIMethodId method) {
        return Support.jniFunctions().getCallBooleanMethodA().invoke(env, obj, method, (JNIValue)WordFactory.nullPointer());
    }

    public static boolean callBooleanMethodL(JNIEnvironment env, JNIObjectHandle obj, JNIMethodId method, JNIObjectHandle l0) {
        JNIValue args = (JNIValue)StackValue.get((int)1, JNIValue.class);
        args.addressOf(0).setObject(l0);
        return Support.jniFunctions().getCallBooleanMethodA().invoke(env, obj, method, args);
    }

    public static long callLongMethod(JNIEnvironment env, JNIObjectHandle obj, JNIMethodId method) {
        return Support.jniFunctions().getCallLongMethodA().invoke(env, obj, method, (JNIValue)WordFactory.nullPointer());
    }

    public static long callLongMethodL(JNIEnvironment env, JNIObjectHandle obj, JNIMethodId method, JNIObjectHandle l0) {
        JNIValue args = (JNIValue)StackValue.get((int)1, JNIValue.class);
        args.addressOf(0).setObject(l0);
        return Support.jniFunctions().getCallLongMethodA().invoke(env, obj, method, args);
    }

    public static long callLongMethodLL(JNIEnvironment env, JNIObjectHandle obj, JNIMethodId method, JNIObjectHandle l0, JNIObjectHandle l1) {
        JNIValue args = (JNIValue)StackValue.get((int)2, JNIValue.class);
        args.addressOf(0).setObject(l0);
        args.addressOf(1).setObject(l1);
        return Support.jniFunctions().getCallLongMethodA().invoke(env, obj, method, args);
    }

    public static int callIntMethod(JNIEnvironment env, JNIObjectHandle obj, JNIMethodId method) {
        return Support.jniFunctions().getCallIntMethodA().invoke(env, obj, method, (JNIValue)WordFactory.nullPointer());
    }

    public static int callIntMethodL(JNIEnvironment env, JNIObjectHandle obj, JNIMethodId method, JNIObjectHandle l0) {
        JNIValue args = (JNIValue)StackValue.get((int)1, JNIValue.class);
        args.addressOf(0).setObject(l0);
        return Support.jniFunctions().getCallIntMethodA().invoke(env, obj, method, args);
    }

    public static JNIObjectHandle newObjectL(JNIEnvironment env, JNIObjectHandle clazz, JNIMethodId ctor, JNIObjectHandle l0) {
        JNIValue args = (JNIValue)StackValue.get((int)1, JNIValue.class);
        args.addressOf(0).setObject(l0);
        return Support.jniFunctions().getNewObjectA().invoke(env, clazz, ctor, args);
    }

    public static JNIObjectHandle newObjectLLLJ(JNIEnvironment env, JNIObjectHandle clazz, JNIMethodId ctor, JNIObjectHandle l0, JNIObjectHandle l1, JNIObjectHandle l2, long l3) {
        JNIValue args = (JNIValue)StackValue.get((int)4, JNIValue.class);
        args.addressOf(0).setObject(l0);
        args.addressOf(1).setObject(l1);
        args.addressOf(2).setObject(l2);
        args.addressOf(3).setLong(l3);
        return Support.jniFunctions().getNewObjectA().invoke(env, clazz, ctor, args);
    }

    public static void checkNoException(JNIEnvironment localEnv) {
        VMError.guarantee((!Support.testException(localEnv) ? 1 : 0) != 0);
    }

    public static void check(JvmtiError resultCode) {
        if (!resultCode.equals((Object)JvmtiError.JVMTI_ERROR_NONE)) {
            throw VMError.shouldNotReachHere((String)("JVMTI call failed with " + String.valueOf((Object)resultCode)));
        }
    }

    public static void checkPhase(JvmtiError resultCode) {
        if (resultCode == JvmtiError.JVMTI_ERROR_WRONG_PHASE) {
            throw new WrongPhaseError();
        }
        Support.check(resultCode);
    }

    public static void checkJni(int resultCode) {
        VMError.guarantee((resultCode == JNIErrors.JNI_OK() ? 1 : 0) != 0);
    }

    private Support() {
    }

    public static class WrongPhaseError
    extends Error {
        private static final long serialVersionUID = 8503239518909756105L;
    }
}

