/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.ConditionalElement;
import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.ConfigurationParser;
import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.configure.ResourceConfigurationParser;
import com.oracle.svm.configure.ResourcesRegistry;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.ConfigurationConditionPrintable;
import com.oracle.svm.configure.config.conditional.ConfigurationConditionResolver;
import com.oracle.svm.util.GlobUtils;
import com.oracle.svm.util.NativeImageResourcePathRepresentation;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import jdk.graal.compiler.util.json.JsonPrinter;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public final class ResourceConfiguration
extends ConfigurationBase<ResourceConfiguration, Predicate> {
    private final Set<ConditionalElement<String>> addedResources = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<ConditionalElement<ResourceEntry>> addedGlobs = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentMap<ConditionalElement<String>, Pattern> ignoredResources = new ConcurrentHashMap<ConditionalElement<String>, Pattern>();
    private final ConcurrentMap<ConditionalElement<String>, BundleConfiguration> bundles = new ConcurrentHashMap<ConditionalElement<String>, BundleConfiguration>();

    public ResourceConfiguration() {
    }

    public ResourceConfiguration(ResourceConfiguration other) {
        this.addedGlobs.addAll(other.addedGlobs);
        other.addedResources.forEach(this::classifyAndAddPattern);
        this.ignoredResources.putAll(other.ignoredResources);
        for (Map.Entry entry : other.bundles.entrySet()) {
            this.bundles.put((ConditionalElement)entry.getKey(), new BundleConfiguration((BundleConfiguration)entry.getValue()));
        }
    }

    @Override
    public ResourceConfiguration copy() {
        return new ResourceConfiguration(this);
    }

    @Override
    public void subtract(ResourceConfiguration other) {
        this.addedGlobs.removeAll(other.addedGlobs);
        this.addedResources.removeAll(other.addedResources);
        this.ignoredResources.keySet().removeAll(other.ignoredResources.keySet());
        this.bundles.keySet().removeAll(other.bundles.keySet());
    }

    @Override
    protected void merge(ResourceConfiguration other) {
        this.addedGlobs.addAll(other.addedGlobs);
        this.addedResources.addAll(other.addedResources);
        this.ignoredResources.putAll(other.ignoredResources);
        this.bundles.putAll(other.bundles);
    }

    @Override
    protected void intersect(ResourceConfiguration other) {
        this.addedGlobs.retainAll(other.addedGlobs);
        this.addedResources.retainAll(other.addedResources);
        this.ignoredResources.keySet().retainAll(other.ignoredResources.keySet());
        this.bundles.keySet().retainAll(other.bundles.keySet());
    }

    @Override
    protected void removeIf(Predicate predicate) {
        this.addedGlobs.removeIf(predicate::testIncludedGlob);
        this.addedResources.removeIf(predicate::testIncludedResource);
        this.bundles.entrySet().removeIf((? super E entry) -> predicate.testIncludedBundle((ConditionalElement)entry.getKey(), (BundleConfiguration)entry.getValue()));
    }

    @Override
    public void mergeConditional(UnresolvedConfigurationCondition condition, ResourceConfiguration other) {
        for (ConditionalElement<ResourceEntry> conditionalElement : other.addedGlobs) {
            this.addedGlobs.add(new ConditionalElement<ResourceEntry>(condition, conditionalElement.element()));
        }
        for (ConditionalElement<Object> conditionalElement : other.addedResources) {
            this.addedResources.add(new ConditionalElement<String>(condition, (String)conditionalElement.element()));
        }
        for (Map.Entry entry : other.ignoredResources.entrySet()) {
            this.ignoredResources.put(new ConditionalElement<String>(condition, (String)((ConditionalElement)entry.getKey()).element()), (Pattern)entry.getValue());
        }
        for (Map.Entry entry : other.bundles.entrySet()) {
            this.bundles.put(new ConditionalElement<String>(condition, (String)((ConditionalElement)entry.getKey()).element()), new BundleConfiguration((BundleConfiguration)entry.getValue()));
        }
    }

    public void addResourcePattern(UnresolvedConfigurationCondition condition, String pattern) {
        this.addedResources.add(new ConditionalElement<String>(condition, pattern));
    }

    public void addGlobPattern(UnresolvedConfigurationCondition condition, String pattern, String module) {
        String canonicalPattern = NativeImageResourcePathRepresentation.toCanonicalForm((String)pattern);
        ResourceEntry element = new ResourceEntry(ResourceConfiguration.escapePossibleGlobWildcards(canonicalPattern), module);
        this.addedGlobs.add(new ConditionalElement<ResourceEntry>(condition, element));
    }

    private static String escapePossibleGlobWildcards(String pattern) {
        String escapedPattern = pattern;
        Iterator iterator = GlobUtils.ALWAYS_ESCAPED_GLOB_WILDCARDS.iterator();
        while (iterator.hasNext()) {
            char wildcard = ((Character)iterator.next()).charValue();
            escapedPattern = escapedPattern.replace(String.valueOf(wildcard), "\\" + wildcard);
        }
        return escapedPattern;
    }

    private static String convertSimpleRegexToGlob(String pattern) {
        return ResourceConfiguration.escapePossibleGlobWildcards(pattern.replace("\\Q", "").replace("\\E", ""));
    }

    private static boolean isModuleIdentifierChar(int c) {
        return Character.isLetterOrDigit(c) || c == 46 || c == 43 || c == 45;
    }

    private static boolean isSimpleQuotedPattern(String pattern) {
        String quoteStart = "\\Q";
        String quoteEnd = "\\E";
        int quoteBeginning = pattern.indexOf(quoteStart);
        if (quoteBeginning == -1) {
            return false;
        }
        if (pattern.chars().limit(quoteBeginning).allMatch(ResourceConfiguration::isModuleIdentifierChar)) {
            return false;
        }
        if (pattern.lastIndexOf(quoteStart) != quoteBeginning) {
            return false;
        }
        int firstQuoteEnd = pattern.indexOf(quoteEnd);
        int lastQuoteEnd = pattern.lastIndexOf(quoteEnd);
        int expectedQuoteEndPosition = pattern.length() - 1;
        return firstQuoteEnd == lastQuoteEnd && firstQuoteEnd == expectedQuoteEndPosition;
    }

    private void classifyAndAddPattern(ConditionalElement<String> entry) {
        String pattern = entry.element();
        if (ResourceConfiguration.isSimpleQuotedPattern(pattern)) {
            String unquotedPattern = ResourceConfiguration.convertSimpleRegexToGlob(pattern);
            String module = null;
            int moduleSplitter = pattern.indexOf(58);
            if (moduleSplitter != -1) {
                String[] parts = unquotedPattern.split(":");
                module = parts[0];
                unquotedPattern = parts[1];
            }
            this.addedGlobs.add(new ConditionalElement<ResourceEntry>(entry.condition(), new ResourceEntry(unquotedPattern, module)));
        } else {
            this.addedResources.add(new ConditionalElement<String>(entry.condition(), pattern));
        }
    }

    public void ignoreResourcePattern(UnresolvedConfigurationCondition condition, String pattern) {
        this.ignoredResources.computeIfAbsent(new ConditionalElement<String>(condition, pattern), p -> Pattern.compile((String)p.element()));
    }

    public void addBundle(UnresolvedConfigurationCondition condition, String basename, Collection<Locale> locales) {
        BundleConfiguration config = this.getOrCreateBundleConfig(condition, basename);
        for (Locale locale : locales) {
            config.locales.add(locale.toLanguageTag());
        }
    }

    public void addBundle(UnresolvedConfigurationCondition condition, String baseName) {
        this.getOrCreateBundleConfig(condition, baseName);
    }

    private void addClassResourceBundle(UnresolvedConfigurationCondition condition, String basename, String className) {
        this.getOrCreateBundleConfig((UnresolvedConfigurationCondition)condition, (String)basename).classNames.add(className);
    }

    private BundleConfiguration getOrCreateBundleConfig(UnresolvedConfigurationCondition condition, String baseName) {
        ConditionalElement<String> key = new ConditionalElement<String>(condition, baseName);
        return this.bundles.computeIfAbsent(key, cond -> new BundleConfiguration(condition, baseName));
    }

    public boolean anyResourceMatches(String s) {
        for (Pattern pattern : this.ignoredResources.values()) {
            if (!pattern.matcher(s).matches()) continue;
            return false;
        }
        for (ConditionalElement conditionalElement : this.addedResources) {
            if (!Pattern.compile((String)conditionalElement.element()).matcher(s).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean anyBundleMatches(UnresolvedConfigurationCondition condition, String bundleName) {
        return this.bundles.containsKey(new ConditionalElement<String>(condition, bundleName));
    }

    public void printJson(JsonWriter writer) throws IOException {
        JsonPrinter.printCollection((JsonWriter)writer, this.addedGlobs, ConditionalElement.comparator(ResourceEntry.comparator()), (p, w) -> ResourceConfiguration.conditionalGlobElementJson(p, w, true), (boolean)true, (boolean)this.bundles.isEmpty());
        if (!this.bundles.isEmpty()) {
            if (!this.addedGlobs.isEmpty()) {
                writer.appendSeparator();
            }
            JsonPrinter.printCollection((JsonWriter)writer, this.bundles.keySet(), ConditionalElement.comparator(String::compareTo), (p, w) -> ResourceConfiguration.printResourceBundle((BundleConfiguration)this.bundles.get(p), w, true), (boolean)false, (boolean)true);
        }
    }

    @Override
    public void printLegacyJson(JsonWriter writer) throws IOException {
        writer.appendObjectStart();
        this.printResourcesJson(writer);
        writer.appendSeparator();
        this.printBundlesJson(writer);
        writer.appendSeparator();
        this.printGlobsJson(writer);
        writer.appendObjectEnd();
    }

    void printResourcesJson(JsonWriter writer) throws IOException {
        writer.quote("resources").appendFieldSeparator().appendObjectStart();
        writer.quote("includes").appendFieldSeparator();
        JsonPrinter.printCollection((JsonWriter)writer, this.addedResources, ConditionalElement.comparator(), ResourceConfiguration::conditionalRegexElementJson);
        if (!this.ignoredResources.isEmpty()) {
            writer.appendSeparator();
            writer.quote("excludes").appendFieldSeparator();
            JsonPrinter.printCollection((JsonWriter)writer, this.ignoredResources.keySet(), ConditionalElement.comparator(), ResourceConfiguration::conditionalRegexElementJson);
        }
        writer.appendObjectEnd();
    }

    void printBundlesJson(JsonWriter writer) throws IOException {
        writer.quote("bundles").appendFieldSeparator();
        JsonPrinter.printCollection((JsonWriter)writer, this.bundles.keySet(), ConditionalElement.comparator(), (p, w) -> ResourceConfiguration.printResourceBundle((BundleConfiguration)this.bundles.get(p), w, false));
    }

    void printGlobsJson(JsonWriter writer) throws IOException {
        writer.quote("globs").appendFieldSeparator();
        JsonPrinter.printCollection((JsonWriter)writer, this.addedGlobs, ConditionalElement.comparator(ResourceEntry.comparator()), (p, w) -> ResourceConfiguration.conditionalGlobElementJson(p, w, false));
    }

    @Override
    public ConfigurationParser createParser(boolean combinedFileSchema, EnumSet<ConfigurationParserOption> parserOptions) {
        return ResourceConfigurationParser.create(combinedFileSchema, ConfigurationConditionResolver.identityResolver(), new ParserAdapter(this), parserOptions);
    }

    public static void printResourceBundle(BundleConfiguration config, JsonWriter writer, boolean combinedFile) throws IOException {
        writer.appendObjectStart();
        ConfigurationConditionPrintable.printConditionAttribute(config.condition, writer, combinedFile);
        writer.quote(combinedFile ? "bundle" : "name").appendFieldSeparator().quote(config.baseName);
        if (!combinedFile && !config.locales.isEmpty()) {
            writer.appendSeparator().quote("locales").appendFieldSeparator();
            JsonPrinter.printCollection((JsonWriter)writer, config.locales, Comparator.naturalOrder(), (p, w) -> w.quote(p));
        }
        if (!combinedFile && !config.classNames.isEmpty()) {
            writer.appendSeparator().quote("classNames").appendFieldSeparator();
            JsonPrinter.printCollection((JsonWriter)writer, config.classNames, Comparator.naturalOrder(), (p, w) -> w.quote(p));
        }
        writer.appendObjectEnd();
    }

    @Override
    public boolean isEmpty() {
        return this.addedResources.isEmpty() && this.bundles.isEmpty() && this.addedGlobs.isEmpty();
    }

    @Override
    public boolean supportsCombinedFile() {
        if (!this.addedResources.isEmpty() || !this.ignoredResources.isEmpty()) {
            return false;
        }
        for (BundleConfiguration bundleConfiguration : this.bundles.values()) {
            if (bundleConfiguration.classNames.isEmpty() && bundleConfiguration.locales.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static void conditionalGlobElementJson(ConditionalElement<ResourceEntry> p, JsonWriter w, boolean combinedFile) throws IOException {
        String pattern = p.element().pattern();
        String module = p.element().module();
        w.appendObjectStart();
        ConfigurationConditionPrintable.printConditionAttribute(p.condition(), w, combinedFile);
        if (module != null) {
            w.quote("module").appendFieldSeparator().quote(module).appendSeparator();
        }
        w.quote("glob").appendFieldSeparator().quote(pattern);
        w.appendObjectEnd();
    }

    private static void conditionalRegexElementJson(ConditionalElement<String> p, JsonWriter w) throws IOException {
        w.appendObjectStart();
        ConfigurationConditionPrintable.printConditionAttribute(p.condition(), w, false);
        w.quote("pattern").appendFieldSeparator().quote(p.element());
        w.appendObjectEnd();
    }

    public static final class BundleConfiguration {
        public final UnresolvedConfigurationCondition condition;
        public final String baseName;
        public final Set<String> locales = ConcurrentHashMap.newKeySet();
        public final Set<String> classNames = ConcurrentHashMap.newKeySet();

        public BundleConfiguration(UnresolvedConfigurationCondition condition, String baseName) {
            this.condition = condition;
            this.baseName = baseName;
        }

        private BundleConfiguration(BundleConfiguration other) {
            this(other.condition, other.baseName);
            this.locales.addAll(other.locales);
            this.classNames.addAll(other.classNames);
        }
    }

    public static interface Predicate {
        public boolean testIncludedResource(ConditionalElement<String> var1);

        public boolean testIncludedBundle(ConditionalElement<String> var1, BundleConfiguration var2);

        public boolean testIncludedGlob(ConditionalElement<ResourceEntry> var1);
    }

    public record ResourceEntry(String pattern, String module) {
        public static Comparator<ResourceEntry> comparator() {
            Comparator<ResourceEntry> moduleComparator = Comparator.comparing(ResourceEntry::module, Comparator.nullsFirst(Comparator.naturalOrder()));
            Comparator<ResourceEntry> patternComparator = Comparator.comparing(ResourceEntry::pattern, Comparator.nullsFirst(Comparator.naturalOrder()));
            return moduleComparator.thenComparing(patternComparator);
        }
    }

    public static class ParserAdapter
    implements ResourcesRegistry<UnresolvedConfigurationCondition> {
        private final ResourceConfiguration configuration;

        ParserAdapter(ResourceConfiguration configuration) {
            this.configuration = configuration;
        }

        public void addResources(UnresolvedConfigurationCondition condition, String pattern, Object origin) {
            this.configuration.classifyAndAddPattern(new ConditionalElement<String>(condition, pattern));
        }

        public void addGlob(UnresolvedConfigurationCondition condition, String module, String glob, Object origin) {
            this.configuration.addedGlobs.add(new ConditionalElement<ResourceEntry>(condition, new ResourceEntry(glob, module)));
        }

        public void addResourceEntry(Module module, String resourcePath, Object origin) {
            throw new UnsupportedOperationException("Unused function.");
        }

        public void addCondition(ConfigurationCondition condition, Module module, String resourcePath) {
            throw new UnsupportedOperationException("Unused function.");
        }

        public void injectResource(Module module, String resourcePath, byte[] resourceContent, Object origin) {
            throw new UnsupportedOperationException("Resource injection is only supported via Feature implementation");
        }

        @Override
        public void ignoreResources(UnresolvedConfigurationCondition condition, String pattern) {
            this.configuration.ignoreResourcePattern(condition, pattern);
        }

        @Override
        public void addResourceBundles(UnresolvedConfigurationCondition condition, String baseName) {
            this.configuration.addBundle(condition, baseName);
        }

        @Override
        public void addResourceBundles(UnresolvedConfigurationCondition condition, String basename, Collection<Locale> locales) {
            this.configuration.addBundle(condition, basename, locales);
        }

        @Override
        public void addClassBasedResourceBundle(UnresolvedConfigurationCondition condition, String basename, String className) {
            this.configuration.addClassResourceBundle(condition, basename, className);
        }
    }
}

