/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.ConditionalConfigurationParser;
import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.configure.LambdaConfigurationTypeDescriptor;
import com.oracle.svm.configure.LegacySerializationConfigurationParser;
import com.oracle.svm.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.configure.ProxyConfigurationTypeDescriptor;
import com.oracle.svm.configure.SerializationMetadataParser;
import com.oracle.svm.configure.config.conditional.ConfigurationConditionResolver;
import java.util.EnumSet;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

public abstract class SerializationConfigurationParser<C>
extends ConditionalConfigurationParser {
    public static final String CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY = "customTargetConstructorClass";
    protected final ConfigurationConditionResolver<C> conditionResolver;
    protected final RuntimeSerializationSupport<C> serializationSupport;

    public static <C> SerializationConfigurationParser<C> create(boolean combinedFileSchema, ConfigurationConditionResolver<C> conditionResolver, RuntimeSerializationSupport<C> serializationSupport, EnumSet<ConfigurationParserOption> parserOptions) {
        if (combinedFileSchema) {
            return new SerializationMetadataParser<C>(conditionResolver, serializationSupport, parserOptions);
        }
        return new LegacySerializationConfigurationParser<C>(conditionResolver, serializationSupport, parserOptions);
    }

    public SerializationConfigurationParser(ConfigurationConditionResolver<C> conditionResolver, RuntimeSerializationSupport<C> serializationSupport, EnumSet<ConfigurationParserOption> parserOptions) {
        super(parserOptions);
        this.serializationSupport = serializationSupport;
        this.conditionResolver = conditionResolver;
    }

    protected void parseSerializationTypes(List<Object> listOfSerializationTypes, boolean lambdaCapturingTypes) {
        for (Object serializationType : listOfSerializationTypes) {
            this.parseSerializationDescriptorObject(SerializationConfigurationParser.asMap(serializationType, "Third-level of document must be serialization descriptor objects"), lambdaCapturingTypes);
        }
    }

    protected abstract void parseSerializationDescriptorObject(EconomicMap<String, Object> var1, boolean var2);

    protected void registerType(ConfigurationTypeDescriptor targetSerializationClass, C condition) {
        switch (targetSerializationClass.getDescriptorType()) {
            case NAMED: {
                this.serializationSupport.register(condition, ((NamedConfigurationTypeDescriptor)targetSerializationClass).name());
                break;
            }
            case PROXY: {
                this.serializationSupport.registerProxyClass(condition, ((ProxyConfigurationTypeDescriptor)targetSerializationClass).interfaceNames());
                break;
            }
            case LAMBDA: {
                this.serializationSupport.registerLambdaCapturingClass(condition, ((NamedConfigurationTypeDescriptor)((LambdaConfigurationTypeDescriptor)targetSerializationClass).declaringClass()).name());
            }
        }
    }
}

