/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.ClassNameSupport;
import com.oracle.svm.configure.ConfigurationTypeDescriptor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import jdk.graal.compiler.util.json.JsonWriter;

public record NamedConfigurationTypeDescriptor(String name) implements ConfigurationTypeDescriptor
{
    public static NamedConfigurationTypeDescriptor fromJSONName(String jsonName) {
        if (!ClassNameSupport.isValidTypeName(jsonName) && ClassNameSupport.isValidReflectionName(jsonName)) {
            return NamedConfigurationTypeDescriptor.fromReflectionName(jsonName);
        }
        return NamedConfigurationTypeDescriptor.fromTypeName(jsonName);
    }

    public static NamedConfigurationTypeDescriptor fromTypeName(String typeName) {
        Objects.requireNonNull(typeName);
        return new NamedConfigurationTypeDescriptor(typeName);
    }

    public static NamedConfigurationTypeDescriptor fromReflectionName(String reflectionName) {
        return NamedConfigurationTypeDescriptor.fromTypeName(ClassNameSupport.reflectionNameToTypeName(reflectionName));
    }

    public static NamedConfigurationTypeDescriptor fromJNIName(String jniName) {
        return NamedConfigurationTypeDescriptor.fromTypeName(ClassNameSupport.jniNameToTypeName(jniName));
    }

    @Override
    public ConfigurationTypeDescriptor.Kind getDescriptorType() {
        return ConfigurationTypeDescriptor.Kind.NAMED;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public Collection<String> getAllQualifiedJavaNames() {
        return Collections.singleton(this.name);
    }

    @Override
    public int compareTo(ConfigurationTypeDescriptor other) {
        if (other instanceof NamedConfigurationTypeDescriptor) {
            NamedConfigurationTypeDescriptor namedOther = (NamedConfigurationTypeDescriptor)other;
            return this.name.compareTo(namedOther.name);
        }
        return this.getDescriptorType().compareTo(other.getDescriptorType());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NamedConfigurationTypeDescriptor)) {
            return false;
        }
        NamedConfigurationTypeDescriptor that = (NamedConfigurationTypeDescriptor)object;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.quote(this.name);
    }
}

