/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.ConfigurationParser;
import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import java.io.IOException;
import java.util.EnumSet;
import java.util.function.Consumer;
import jdk.graal.compiler.util.json.JsonPrintable;
import jdk.graal.compiler.util.json.JsonWriter;

public abstract class ConfigurationBase<T extends ConfigurationBase<T, P>, P>
implements JsonPrintable {
    public abstract boolean isEmpty();

    public abstract T copy();

    protected abstract void merge(T var1);

    public abstract void mergeConditional(UnresolvedConfigurationCondition var1, T var2);

    protected abstract void subtract(T var1);

    protected abstract void intersect(T var1);

    protected abstract void removeIf(P var1);

    protected T copyAnd(Consumer<T> consumer) {
        T copy = this.copy();
        consumer.accept(copy);
        return copy;
    }

    public T copyAndMerge(T other) {
        return (T)this.copyAnd(copy -> copy.merge(other));
    }

    public T copyAndSubtract(T other) {
        return (T)this.copyAnd(copy -> copy.subtract(other));
    }

    public T copyAndIntersect(T other) {
        return (T)this.copyAnd(copy -> copy.intersect(other));
    }

    public T copyAndFilter(P predicate) {
        return (T)this.copyAnd(copy -> copy.removeIf(predicate));
    }

    public abstract ConfigurationParser createParser(boolean var1, EnumSet<ConfigurationParserOption> var2);

    public abstract boolean supportsCombinedFile();

    public void printLegacyJson(JsonWriter writer) throws IOException {
        this.printJson(writer);
    }
}

