/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.configure.deobfuscator;

import com.oracle.svm.enterprise.configure.deobfuscator.ObfuscationMaps;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class StackTraceDeobfuscator {
    private static final Pattern STACK_FRAME_PATTERN = Pattern.compile("^(?<prefix>\\s*at\\s+)(?:(?<module>[a-zA-Z_][a-zA-Z0-9_$.]*)(?:@(?<moduleVersion>[\\w.\\-+]+))?/)?(?<class>.+)\\.(?<method>[^.]+)\\((?<parenthesis>[^)]*)\\)(?<suffix>.*)?$");
    private static final List<LineReplacer> REPLACERS = List.of(new LineReplacer(HeaderPatterns.EXCEPTION_IN, StackTraceDeobfuscator::headerReplacer), new LineReplacer(HeaderPatterns.SIMPLE, StackTraceDeobfuscator::headerReplacer), new LineReplacer(HeaderPatterns.CAUSED_BY, StackTraceDeobfuscator::headerReplacer), new LineReplacer(STACK_FRAME_PATTERN, StackTraceDeobfuscator::stackFrameReplacer));

    public static String deobfuscate(List<String> lines, ObfuscationMaps maps) {
        return lines.stream().map(line -> StackTraceDeobfuscator.deobfuscate(line, maps)).collect(Collectors.joining(System.lineSeparator()));
    }

    private static String deobfuscate(String line, ObfuscationMaps maps) {
        String deobfuscatedLine = line;
        for (LineReplacer lineReplacer : REPLACERS) {
            deobfuscatedLine = lineReplacer.pattern().matcher(deobfuscatedLine).replaceAll(matchResult -> lineReplacer.applyReplacement(maps, (MatchResult)matchResult));
        }
        return deobfuscatedLine;
    }

    private static String headerReplacer(ObfuscationMaps maps, MatchResult matchResult) {
        String prefix = StackTraceDeobfuscator.getGroup(matchResult, "prefix");
        String obfClass = StackTraceDeobfuscator.getGroup(matchResult, "class");
        if (obfClass == null) {
            return "";
        }
        String message = StackTraceDeobfuscator.getGroup(matchResult, "msg");
        String className = StackTraceDeobfuscator.deobfuscateClassName(obfClass, maps.packageMap(), maps.typeMap());
        StringBuilder sb = new StringBuilder();
        sb.append(prefix != null ? prefix : "");
        sb.append(className);
        if (message != null) {
            sb.append(": ").append(message);
        }
        return sb.toString();
    }

    private static String stackFrameReplacer(ObfuscationMaps maps, MatchResult matchResult) {
        String prefix = StackTraceDeobfuscator.getGroup(matchResult, "prefix");
        String obfModule = StackTraceDeobfuscator.getGroup(matchResult, "module");
        String obfModuleVersion = StackTraceDeobfuscator.getGroup(matchResult, "moduleVersion");
        String obfClass = StackTraceDeobfuscator.getGroup(matchResult, "class");
        String obfMethod = StackTraceDeobfuscator.getGroup(matchResult, "method");
        String obfParenthesis = StackTraceDeobfuscator.getGroup(matchResult, "parenthesis");
        String suffix = StackTraceDeobfuscator.getGroup(matchResult, "suffix");
        if (obfClass == null) {
            return "";
        }
        String moduleName = StackTraceDeobfuscator.deobfuscateModuleWithVersion(obfModule, obfModuleVersion, maps.moduleMap());
        String className = StackTraceDeobfuscator.deobfuscateClassName(obfClass, maps.packageMap(), maps.typeMap());
        String methodName = maps.methodMap().getOrDefault(obfMethod, obfMethod);
        String parenthesis = StackTraceDeobfuscator.deobfuscateParenthesis(obfParenthesis, maps.sourceFileMap());
        StringBuilder rep = new StringBuilder();
        rep.append(prefix != null ? prefix : "at ");
        rep.append(moduleName);
        rep.append(className).append('.').append(methodName);
        rep.append('(').append(parenthesis).append(')');
        if (suffix != null) {
            rep.append(suffix);
        }
        return rep.toString();
    }

    private static String getGroup(MatchResult m, String name) {
        try {
            return m.group(name);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return null;
        }
    }

    private static String deobfuscateModuleWithVersion(String obfModule, String obfModuleVersion, Map<String, String> moduleMap) {
        if (obfModule == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String moduleName = moduleMap.getOrDefault(obfModule, obfModule);
        sb.append(moduleName);
        if (obfModuleVersion != null) {
            sb.append('@').append(obfModuleVersion);
        }
        sb.append('/');
        return sb.toString();
    }

    private static String deobfuscateClassName(String obfClass, Map<String, String> packageMap, Map<String, String> typeMap) {
        String packageName = null;
        String simpleName = obfClass;
        int lastDot = obfClass.lastIndexOf(46);
        if (lastDot != -1) {
            packageName = obfClass.substring(0, lastDot);
            simpleName = obfClass.substring(lastDot + 1);
        }
        StringBuilder result = new StringBuilder();
        if (packageName != null) {
            String deobPkg = packageMap.getOrDefault(packageName, packageName);
            result.append(deobPkg).append('.');
        }
        String deobSimpleName = typeMap.getOrDefault(simpleName, simpleName);
        result.append(deobSimpleName);
        return result.toString();
    }

    private static String deobfuscateParenthesis(String paren, Map<String, String> fileNames) {
        if (paren == null) {
            return "";
        }
        String file = paren;
        String lineNum = null;
        int colonIdx = paren.lastIndexOf(58);
        if (colonIdx != -1 && colonIdx < paren.length() - 1) {
            file = paren.substring(0, colonIdx);
            lineNum = paren.substring(colonIdx + 1);
        }
        String deobFile = fileNames.getOrDefault(file, file);
        if (lineNum != null) {
            return deobFile + ":" + lineNum;
        }
        return deobFile;
    }

    private record LineReplacer(Pattern pattern, BiFunction<ObfuscationMaps, MatchResult, String> replacer) {
        String applyReplacement(ObfuscationMaps maps, MatchResult matchResult) {
            String replacement = this.replacer().apply(maps, matchResult);
            return Matcher.quoteReplacement(replacement);
        }
    }

    private static final class Groups {
        private static final String PREFIX = "prefix";
        private static final String CLASS = "class";
        private static final String MESSAGE = "msg";
        private static final String MODULE = "module";
        private static final String MODULE_VERSION = "moduleVersion";
        private static final String METHOD = "method";
        private static final String PARENTHESIS = "parenthesis";
        private static final String SUFFIX = "suffix";

        private Groups() {
        }
    }

    private static final class HeaderPatterns {
        static final Pattern EXCEPTION_IN = HeaderPatterns.makeHeaderPattern("Exception in thread \"[^\"]+\"\\s+");
        static final Pattern CAUSED_BY = HeaderPatterns.makeHeaderPattern("Caused by: ");
        static final Pattern SIMPLE = HeaderPatterns.makeHeaderPattern("");

        private HeaderPatterns() {
        }

        private static Pattern makeHeaderPattern(String prefixRegex) {
            return Pattern.compile("^(?<prefix>" + prefixRegex + ")(?<class>[\\w.$]+)(?::\\s*(?<msg>.*))?$");
        }
    }
}

