/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.configure.deobfuscator;

import com.oracle.svm.configure.ConfigurationUsageException;
import com.oracle.svm.enterprise.configure.deobfuscator.ObfuscationMaps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import jdk.graal.compiler.util.json.JsonParser;
import jdk.graal.compiler.util.json.JsonParserException;
import org.graalvm.collections.EconomicMap;

public final class ObfuscationMappingFileParser {
    public static ObfuscationMaps parse(Path mapFile) throws IOException, ConfigurationUsageException {
        HashMap<String, String> moduleMap = new HashMap<String, String>();
        HashMap<String, String> packageMap = new HashMap<String, String>();
        HashMap<String, String> typeMap = new HashMap<String, String>();
        HashMap<String, String> sourceFileMap = new HashMap<String, String>();
        HashMap<String, String> methodMap = new HashMap<String, String>();
        try (BufferedReader reader = Files.newBufferedReader(mapFile);){
            EconomicMap<String, Object> map = ObfuscationMappingFileParser.parseToMap(reader);
            ObfuscationMappingFileParser.addTuplesToMap(map, "modules", moduleMap, Function.identity());
            ObfuscationMappingFileParser.addTuplesToMap(map, "packages", packageMap, Function.identity());
            ObfuscationMappingFileParser.addTuplesToMap(map, "types", typeMap, str -> ObfuscationMappingFileParser.extractLastSegment(str, '.'));
            ObfuscationMappingFileParser.addTuplesToMap(map, "files", sourceFileMap, ObfuscationMappingFileParser::extractSourceFileName);
            ObfuscationMappingFileParser.addTuplesToMap(map, "methods", methodMap, str -> ObfuscationMappingFileParser.extractLastSegment(str, '.'));
        }
        return new ObfuscationMaps(moduleMap, packageMap, typeMap, sourceFileMap, methodMap);
    }

    private static EconomicMap<String, Object> parseToMap(Reader reader) throws ConfigurationUsageException {
        try {
            return (EconomicMap)new JsonParser(reader).parse();
        }
        catch (IOException | JsonParserException e) {
            String errorMessage = String.format("Failed to parse obfuscation mapping file. Verify that this file is produced by the 'native-image' command %s. Exception: %s", "'-H:AdvancedObfuscation=export-mapping'", e.getMessage());
            throw new ConfigurationUsageException(errorMessage);
        }
    }

    private static void addTuplesToMap(EconomicMap<String, Object> rootMap, String field, Map<String, String> targetMap, Function<String, String> valueTransformer) throws ConfigurationUsageException {
        Object arr = rootMap.get((Object)field);
        if (arr == null) {
            throw new ConfigurationUsageException(String.format("Field '%s' is missing from the obfuscation mapping file. This field is required.", field));
        }
        if (!(arr instanceof List)) {
            throw new ConfigurationUsageException(String.format("Field '%s' is not a list in the obfuscation mapping file.", field));
        }
        List items = (List)arr;
        for (Object entry : items) {
            List tuple;
            if (!(entry instanceof List) || (tuple = (List)entry).size() != 2) {
                throw new ConfigurationUsageException(String.format("Field '%s' contains an invalid mapping tuple: %s", field, entry));
            }
            String original = Objects.toString(tuple.get(0), null);
            String obfuscated = Objects.toString(tuple.get(1), null);
            if (original == null || obfuscated == null) {
                throw new ConfigurationUsageException(String.format("Null value in mapping tuple of field '%s': %s", field, tuple));
            }
            targetMap.put(obfuscated, valueTransformer.apply(original));
        }
    }

    private static String extractSourceFileName(String original) {
        return ObfuscationMappingFileParser.extractLastSegment(original, '/', '\\');
    }

    private static String extractLastSegment(String input, char ... delimiters) {
        int lastPos = -1;
        for (char delimiter : delimiters) {
            int pos = input.lastIndexOf(delimiter);
            if (pos <= lastPos) continue;
            lastPos = pos;
        }
        return lastPos != -1 ? input.substring(lastPos + 1) : input;
    }

    private static final class JSONKeys {
        static final String MODULES = "modules";
        static final String PACKAGES = "packages";
        static final String TYPES = "types";
        static final String FILES = "files";
        static final String METHODS = "methods";

        private JSONKeys() {
        }
    }
}

