/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.configure.command;

import com.oracle.svm.configure.ConfigurationUsageException;
import com.oracle.svm.configure.command.ConfigurationCommand;
import com.oracle.svm.enterprise.profiling.framework.PGOData;
import com.oracle.svm.enterprise.profiling.framework.ProfileDumper;
import com.oracle.svm.enterprise.profiling.loaders.IprofContent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Function;

public final class ConfigurationMergePGOProfilesCommand
extends ConfigurationCommand {
    public String getName() {
        return "merge-pgo-profiles";
    }

    public void apply(Iterator<String> argumentsIterator) throws IOException {
        Path outputFilePath = null;
        HashSet<Path> inputFilePaths = new HashSet<Path>();
        block10: while (argumentsIterator.hasNext()) {
            String argument = argumentsIterator.next();
            String[] optionValue = argument.split("=");
            if (optionValue.length != 2) {
                throw new ConfigurationUsageException(String.format("Format is not valid: %s. Options should be in format --<option>=<value>. ", argument));
            }
            Object option = optionValue[0];
            Object value = optionValue[1];
            switch (option) {
                case "--input-dir": {
                    Path inputDir = ConfigurationMergePGOProfilesCommand.requirePath((String)option, (String)value);
                    File dir = new File(inputDir.toUri());
                    if (!Files.isDirectory(inputDir, new LinkOption[0])) {
                        throw new ConfigurationUsageException("--input-dir expects a path to a directory, but file path is given: " + String.valueOf(inputDir) + ". Please use a directory path or use --input-file to select a path to a file.");
                    }
                    File[] files = dir.listFiles();
                    assert (files != null);
                    for (File inputFile : files) {
                        if (!inputFile.getName().endsWith(".iprof")) continue;
                        inputFilePaths.add(inputFile.toPath());
                    }
                    continue block10;
                }
                case "--output-file": {
                    outputFilePath = ConfigurationMergePGOProfilesCommand.getOrCreateFile((String)option, (String)value);
                    break;
                }
                case "--input-file": {
                    Path inputFile = ConfigurationMergePGOProfilesCommand.requirePath((String)option, (String)value);
                    if (!Files.isRegularFile(inputFile, new LinkOption[0])) {
                        throw new ConfigurationUsageException("Cannot find input file: " + String.valueOf(inputFile));
                    }
                    inputFilePaths.add(inputFile);
                    break;
                }
                default: {
                    throw new ConfigurationUsageException("Unknown option: " + (String)option);
                }
            }
        }
        if (inputFilePaths.isEmpty()) {
            throw new ConfigurationUsageException("An input file is not specified. Please specify the input file(s) using --input-file option.");
        }
        if (outputFilePath == null) {
            throw new ConfigurationUsageException("An output file is not specified. Please specify the output file using --output-file option.");
        }
        ArrayList<IprofContent> iprofs = new ArrayList<IprofContent>();
        for (Path inputPath : inputFilePaths) {
            iprofs.add(IprofContent.parseFromIprof((Path)inputPath, System.out::println, (boolean)false, Collections.emptyList()));
        }
        PGOData profile = new PGOData.Builder(iprofs).build();
        ProfileDumper.dumpToFile((ProfileDumper)ProfileDumper.create((ProfileDumper.DumpableData)profile, Function.identity(), (boolean)false), outputFilePath, (boolean)false);
    }

    protected String getDescription0() {
        return "        combine multiple profile files into a single one.\n    --input-dir=<path>\n                          reads all profiles (*.iprof) stored in <path> directory (not subdirectories).\n    --output-file=<path>\n                          specifies a file to which the merged profiles are written.\n    --input-file=<path>\n                          reads a profile (*.iprof) from given <path>.\n".replaceAll("\n", System.lineSeparator());
    }
}

