/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.configure.command;

import com.oracle.svm.configure.ConfigurationUsageException;
import com.oracle.svm.configure.command.ConfigurationCommand;
import com.oracle.svm.enterprise.configure.deobfuscator.ObfuscationMappingFileParser;
import com.oracle.svm.enterprise.configure.deobfuscator.ObfuscationMaps;
import com.oracle.svm.enterprise.configure.deobfuscator.StackTraceDeobfuscator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;

public final class ConfigurationDeobfuscateCommand
extends ConfigurationCommand {
    public static final String ADVANCED_OBFUSCATION_NI_COMMAND = "'-H:AdvancedObfuscation=export-mapping'";
    private static final String OPTION_MAP_FILE = "--map-file";
    private static final String OPTION_INPUT_FILE = "--input-file";
    private static final String OPTION_OUTPUT_FILE = "--output-file";

    public String getName() {
        return "deobfuscate";
    }

    public void apply(Iterator<String> argumentsIterator) throws IOException {
        Path mapFile = null;
        Path inputPath = null;
        Path outputPath = null;
        InputStream input = System.in;
        block15: while (argumentsIterator.hasNext()) {
            String argument = argumentsIterator.next();
            String[] optionValue = argument.split("=");
            if (optionValue.length != 2) {
                throw new ConfigurationUsageException(String.format("Format is not valid: %s. Options should be in format --<option>=<value>. ", argument));
            }
            String option = optionValue[0];
            String value = optionValue[1];
            switch (option) {
                case "--map-file": {
                    mapFile = Path.of(value, new String[0]);
                    continue block15;
                }
                case "--input-file": {
                    inputPath = Path.of(value, new String[0]);
                    continue block15;
                }
                case "--output-file": {
                    outputPath = ConfigurationDeobfuscateCommand.getOrCreateFile((String)option, (String)value);
                    continue block15;
                }
            }
            throw new ConfigurationUsageException(String.format("Unknown option: %s", option));
        }
        if (mapFile == null) {
            throw new ConfigurationUsageException(String.format("An obfuscation mapping file was not specified. Please specify the map file using the %s option.", OPTION_MAP_FILE));
        }
        if (!Files.exists(mapFile, new LinkOption[0]) || Files.isDirectory(mapFile, new LinkOption[0])) {
            throw new ConfigurationUsageException(String.format("The obfuscation mapping file does not exist or is a directory: %s", mapFile));
        }
        if (inputPath != null) {
            if (!Files.exists(inputPath, new LinkOption[0]) || Files.isDirectory(inputPath, new LinkOption[0])) {
                throw new ConfigurationUsageException(String.format("The input file does not exist or is a directory: %s", inputPath));
            }
            input = Files.newInputStream(inputPath, new OpenOption[0]);
        }
        ArrayList<String> stackTraceLines = new ArrayList<String>();
        try (Scanner scanner = new Scanner(input, StandardCharsets.UTF_8);){
            while (scanner.hasNextLine()) {
                stackTraceLines.add(scanner.nextLine());
            }
        }
        ObfuscationMaps obfuscationMaps = ObfuscationMappingFileParser.parse(mapFile);
        String deobfuscatedStackTrace = StackTraceDeobfuscator.deobfuscate(stackTraceLines, obfuscationMaps);
        if (outputPath != null) {
            Files.writeString(outputPath, (CharSequence)deobfuscatedStackTrace, new OpenOption[0]);
        } else {
            System.out.print(deobfuscatedStackTrace);
        }
    }

    protected String getDescription0() {
        return String.format("               deobfuscate stack traces.\n    %s=<path>\n                          the obfuscation mapping file obtained when building\n                          your image with %s.\n    %s=<path>\n                          an optional file containing the obfuscated stack trace.\n                          You can alternatively pass the stack trace via stdin.\n    %s=<path>\n                          writes the deobfuscated stack trace to <path> if\n                          specified; otherwise to stdout.\n", OPTION_MAP_FILE, ADVANCED_OBFUSCATION_NI_COMMAND, OPTION_INPUT_FILE, OPTION_OUTPUT_FILE).replaceAll("\n", System.lineSeparator());
    }
}

