/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.resident;

import com.oracle.svm.core.thread.PlatformThreads;

public enum JDWPThreadStatus {
    ZOMBIE(0),
    RUNNING(1),
    SLEEPING(2),
    MONITOR(3),
    WAIT(4),
    NOT_STARTED(5);

    public final int value;

    private JDWPThreadStatus(int value) {
        this.value = value;
    }

    public static int getThreadStatus(Thread thread) {
        int state = PlatformThreads.getThreadStatus(thread);
        JDWPThreadStatus status = switch (state) {
            case 0 -> NOT_STARTED;
            case 1025 -> MONITOR;
            case 401, 417, 657, 673 -> WAIT;
            case 225 -> SLEEPING;
            case 2 -> ZOMBIE;
            default -> RUNNING;
        };
        return status.value;
    }
}

