/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.resident;

import com.oracle.svm.interpreter.debug.EventHandler;
import com.oracle.svm.jdwp.bridge.EventHandlerBridge;
import com.oracle.svm.jdwp.bridge.TagConstants;
import com.oracle.svm.jdwp.bridge.TypeTag;
import com.oracle.svm.jdwp.bridge.jniutils.JNIMethodScope;
import com.oracle.svm.jdwp.resident.DebuggingOnDemandHandler;
import com.oracle.svm.jdwp.resident.JDWPBridgeImpl;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class EnterHSEventHandler
implements EventHandler {
    private final EventHandlerBridge jdwpEventHandler;

    public EnterHSEventHandler(EventHandlerBridge jdwpEventHandler) {
        this.jdwpEventHandler = jdwpEventHandler;
    }

    @Override
    public void onEventAt(Thread thread, ResolvedJavaMethod method, int bci, Object returnValue, int eventKindFlags) {
        try (JNIMethodScope ignored = new JNIMethodScope("JDWPServer::onEventAt", DebuggingOnDemandHandler.currentThreadJniEnv());){
            byte returnTag;
            long returnPrimitiveOrId;
            long threadId = JDWPBridgeImpl.getIds().toId(thread);
            long methodId = JDWPBridgeImpl.getIds().toId(method);
            ResolvedJavaType declaringType = method.getDeclaringClass();
            long classId = JDWPBridgeImpl.getIds().toId(declaringType);
            byte typeTag = TypeTag.getKind(declaringType);
            JavaKind returnKind = method.getSignature().getReturnKind();
            if (returnValue == null) {
                returnPrimitiveOrId = 0L;
                returnTag = JavaKind.Void == returnKind ? (byte)86 : 76;
            } else {
                returnPrimitiveOrId = DebuggingOnDemandHandler.toPrimitiveOrId(returnKind, returnValue);
                Class<Object> returnClass = switch (returnKind) {
                    case JavaKind.Byte -> Byte.TYPE;
                    case JavaKind.Boolean -> Boolean.TYPE;
                    case JavaKind.Char -> Character.TYPE;
                    case JavaKind.Short -> Short.TYPE;
                    case JavaKind.Int -> Integer.TYPE;
                    case JavaKind.Float -> Float.TYPE;
                    case JavaKind.Long -> Long.TYPE;
                    case JavaKind.Double -> Double.TYPE;
                    case JavaKind.Void -> Void.TYPE;
                    default -> returnValue.getClass();
                };
                returnTag = TagConstants.getTagFromClass(returnClass);
            }
            assert (TagConstants.isValidTag(returnTag)) : returnTag;
            this.jdwpEventHandler.onEventAt(threadId, classId, typeTag, methodId, bci, returnTag, returnPrimitiveOrId, eventKindFlags);
        }
    }
}

