/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge.nativebridge;

import com.oracle.svm.jdwp.bridge.nativebridge.BinaryInput;
import com.oracle.svm.jdwp.bridge.nativebridge.BinaryMarshaller;
import com.oracle.svm.jdwp.bridge.nativebridge.BinaryOutput;

final class NullableBinaryMarshaller<T>
implements BinaryMarshaller<T> {
    private static final byte NULL = 0;
    private static final byte NON_NULL = 1;
    private final BinaryMarshaller<T> delegate;

    NullableBinaryMarshaller(BinaryMarshaller<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T read(BinaryInput input) {
        byte nullStatus = input.readByte();
        switch (nullStatus) {
            case 0: {
                return null;
            }
            case 1: {
                return this.delegate.read(input);
            }
        }
        throw new IllegalArgumentException("Unexpected input " + nullStatus);
    }

    @Override
    public void write(BinaryOutput output, T object) {
        if (object != null) {
            output.writeByte(1);
            this.delegate.write(output, object);
        } else {
            output.writeByte(0);
        }
    }

    @Override
    public void readUpdate(BinaryInput input, T object) {
        byte nullStatus = input.readByte();
        switch (nullStatus) {
            case 0: {
                assert (object == null);
                break;
            }
            case 1: {
                assert (object != null);
                this.delegate.readUpdate(input, object);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected input " + nullStatus);
            }
        }
    }

    @Override
    public void writeUpdate(BinaryOutput output, T object) {
        if (object != null) {
            output.writeByte(1);
            this.delegate.writeUpdate(output, object);
        } else {
            output.writeByte(0);
        }
    }

    @Override
    public int inferSize(T object) {
        if (object != null) {
            return 1 + this.delegate.inferSize(object);
        }
        return 1;
    }

    @Override
    public int inferUpdateSize(T object) {
        if (object != null) {
            return 1 + this.delegate.inferUpdateSize(object);
        }
        return 1;
    }
}

