/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge;

import com.oracle.svm.jdwp.bridge.Packet;

public final class UnmodifiablePacket
implements Packet {
    private final int id;
    private final byte flags;
    private final byte commandSet;
    private final byte command;
    private final short errorCode;
    private final byte[] packetBytes;

    public static UnmodifiablePacket parseAndWrap(byte[] packetBytes) {
        return new UnmodifiablePacket(packetBytes);
    }

    private UnmodifiablePacket(final byte[] packetBytes) {
        if (packetBytes.length < 11) {
            throw new IllegalArgumentException();
        }
        Packet.Reader reader = new Packet.Reader(){
            private int position;

            @Override
            public int readByte() {
                return Byte.toUnsignedInt(packetBytes[this.position++]);
            }

            @Override
            public boolean isEndOfInput() {
                return this.position >= packetBytes.length;
            }
        };
        int length = reader.readInt();
        if (length != packetBytes.length) {
            throw new IllegalArgumentException();
        }
        this.id = reader.readInt();
        this.flags = (byte)reader.readByte();
        if (this.isReply()) {
            this.errorCode = reader.readShort();
            this.commandSet = 0;
            this.command = 0;
        } else {
            this.errorCode = 0;
            this.commandSet = (byte)reader.readByte();
            this.command = (byte)reader.readByte();
        }
        this.packetBytes = packetBytes;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public byte flags() {
        return this.flags;
    }

    @Override
    public short errorCode() {
        return this.errorCode;
    }

    @Override
    public byte commandSet() {
        return this.commandSet;
    }

    @Override
    public byte command() {
        return this.command;
    }

    @Override
    public int dataSize() {
        return this.packetBytes.length - 11;
    }

    @Override
    public byte data(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.packetBytes[index + 11];
    }
}

