/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge;

import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.meta.JavaKind;

public final class TagConstants {
    public static final byte ARRAY = 91;
    public static final byte BYTE = 66;
    public static final byte CHAR = 67;
    public static final byte OBJECT = 76;
    public static final byte FLOAT = 70;
    public static final byte DOUBLE = 68;
    public static final byte INT = 73;
    public static final byte LONG = 74;
    public static final byte SHORT = 83;
    public static final byte VOID = 86;
    public static final byte BOOLEAN = 90;
    public static final byte STRING = 115;
    public static final byte THREAD = 116;
    public static final byte THREAD_GROUP = 103;
    public static final byte CLASS_LOADER = 108;
    public static final byte CLASS_OBJECT = 99;

    private TagConstants() {
    }

    public static boolean isPrimitive(byte tag) {
        return tag != 76 && tag != 115 && tag != 91 && tag != 116 && tag != 103 && tag != 99 && tag != 108;
    }

    public static byte getTagFromPrimitive(Object boxed) {
        if (boxed instanceof Integer) {
            return 73;
        }
        if (boxed instanceof Float) {
            return 70;
        }
        if (boxed instanceof Double) {
            return 68;
        }
        if (boxed instanceof Long) {
            return 74;
        }
        if (boxed instanceof Byte) {
            return 66;
        }
        if (boxed instanceof Short) {
            return 83;
        }
        if (boxed instanceof Character) {
            return 67;
        }
        if (boxed instanceof Boolean) {
            return 90;
        }
        throw new RuntimeException("Boxed object: " + String.valueOf(boxed.getClass()) + " is not a primitive");
    }

    public static Class<?> getClassOfPrimitiveTag(int tag) {
        return switch (tag) {
            case 73 -> Integer.TYPE;
            case 70 -> Float.TYPE;
            case 68 -> Double.TYPE;
            case 74 -> Long.TYPE;
            case 66 -> Byte.TYPE;
            case 83 -> Short.TYPE;
            case 67 -> Character.TYPE;
            case 90 -> Boolean.TYPE;
            default -> throw new IllegalArgumentException(Integer.toString(tag));
        };
    }

    public static boolean isValidTag(byte tag) {
        return switch (tag) {
            case 66, 67, 68, 70, 73, 74, 76, 83, 86, 90, 91, 99, 103, 108, 115, 116 -> true;
            default -> false;
        };
    }

    public static byte getTagFromClass(Class<?> clazz) {
        if (clazz.isArray()) {
            return 91;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return 73;
            }
            if (clazz == Float.TYPE) {
                return 70;
            }
            if (clazz == Double.TYPE) {
                return 68;
            }
            if (clazz == Long.TYPE) {
                return 74;
            }
            if (clazz == Byte.TYPE) {
                return 66;
            }
            if (clazz == Short.TYPE) {
                return 83;
            }
            if (clazz == Character.TYPE) {
                return 67;
            }
            if (clazz == Boolean.TYPE) {
                return 90;
            }
            if (clazz == Void.TYPE) {
                return 86;
            }
            throw VMError.shouldNotReachHere("Unknown primitive class: " + clazz.getName());
        }
        if (clazz == String.class) {
            return 115;
        }
        if (clazz == Class.class) {
            return 99;
        }
        if (Thread.class.isAssignableFrom(clazz)) {
            return 116;
        }
        if (ThreadGroup.class.isAssignableFrom(clazz)) {
            return 103;
        }
        if (ClassLoader.class.isAssignableFrom(clazz)) {
            return 108;
        }
        return 76;
    }

    public static byte getTagFromReference(Object ref) {
        if (ref == null) {
            return 76;
        }
        return TagConstants.getTagFromClass(ref.getClass());
    }

    public static JavaKind tagToKind(byte tag) {
        return switch (tag) {
            case 66 -> JavaKind.Byte;
            case 67 -> JavaKind.Char;
            case 70 -> JavaKind.Float;
            case 68 -> JavaKind.Double;
            case 73 -> JavaKind.Int;
            case 74 -> JavaKind.Long;
            case 83 -> JavaKind.Short;
            case 86 -> JavaKind.Void;
            case 90 -> JavaKind.Boolean;
            case 76, 91, 99, 103, 108, 115, 116 -> JavaKind.Object;
            default -> throw VMError.shouldNotReachHere("unreachable");
        };
    }
}

