/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata.serialization;

import com.oracle.svm.core.FunctionPointerHolder;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.metadata.InterpreterConstantPool;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaField;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaType;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedObjectType;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedPrimitiveType;
import com.oracle.svm.interpreter.metadata.InterpreterUnresolvedSignature;
import com.oracle.svm.interpreter.metadata.ReferenceConstant;
import com.oracle.svm.interpreter.metadata.serialization.LEB128;
import com.oracle.svm.interpreter.metadata.serialization.SerializationContext;
import com.oracle.svm.interpreter.metadata.serialization.ValueReader;
import com.oracle.svm.interpreter.metadata.serialization.ValueSerializer;
import com.oracle.svm.interpreter.metadata.serialization.ValueWriter;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.ToLongFunction;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.UnresolvedJavaField;
import jdk.vm.ci.meta.UnresolvedJavaMethod;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;

public final class Serializers {
    public static final ValueSerializer<byte[]> BYTE_ARRAY = Serializers.createSerializer((context, in) -> {
        int length = LEB128.readUnsignedInt(in);
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        return bytes;
    }, (context, out, value) -> {
        LEB128.writeUnsignedInt(out, ((byte[])value).length);
        out.write((byte[])value);
    });
    public static final ValueSerializer<String> STRING = Serializers.createSerializer((context, in) -> {
        byte[] bytes = BYTE_ARRAY.getReader().read(context, in);
        return new String(bytes, StandardCharsets.UTF_8);
    }, (context, out, value) -> {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        BYTE_ARRAY.getWriter().write(context, out, bytes);
    });
    public static final ValueSerializer<Class<?>> CLASS_BY_NAME = Serializers.createSerializer((context, in) -> {
        boolean isPrimitive = in.readBoolean();
        if (isPrimitive) {
            return JavaKind.fromPrimitiveOrVoidTypeChar((char)in.readChar()).toJavaClass();
        }
        String name = STRING.getReader().read(context, in);
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }, (context, out, value) -> {
        boolean isPrimitive = value.isPrimitive();
        out.writeBoolean(isPrimitive);
        if (isPrimitive) {
            out.writeChar(JavaKind.fromJavaClass((Class)value).getTypeChar());
        } else {
            STRING.getWriter().write(context, out, value.getName());
        }
    });
    static final ValueSerializer<boolean[]> BOOLEAN_ARRAY = Serializers.createSerializer((context, in) -> {
        int length = LEB128.readUnsignedInt(in);
        boolean[] array = new boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = in.readBoolean();
        }
        return array;
    }, (context, out, value) -> {
        LEB128.writeUnsignedInt(out, ((boolean[])value).length);
        for (boolean e : value) {
            out.writeBoolean(e);
        }
    });
    static final ValueSerializer<int[]> INT_ARRAY = Serializers.createSerializer((context, in) -> {
        int length = LEB128.readUnsignedInt(in);
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = in.readInt();
        }
        return array;
    }, (context, out, value) -> {
        LEB128.writeUnsignedInt(out, ((int[])value).length);
        for (int e : value) {
            out.writeInt(e);
        }
    });
    static final ValueSerializer<short[]> SHORT_ARRAY = Serializers.createSerializer((context, in) -> {
        int length = LEB128.readUnsignedInt(in);
        short[] array = new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = in.readShort();
        }
        return array;
    }, (context, out, value) -> {
        LEB128.writeUnsignedInt(out, ((short[])value).length);
        for (short e : value) {
            out.writeShort(e);
        }
    });
    static final ValueSerializer<char[]> CHAR_ARRAY = Serializers.createSerializer((context, in) -> {
        int length = LEB128.readUnsignedInt(in);
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = in.readChar();
        }
        return array;
    }, (context, out, value) -> {
        LEB128.writeUnsignedInt(out, ((char[])value).length);
        for (char e : value) {
            out.writeChar(e);
        }
    });
    static final ValueSerializer<float[]> FLOAT_ARRAY = Serializers.createSerializer((context, in) -> {
        int length = LEB128.readUnsignedInt(in);
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = in.readFloat();
        }
        return array;
    }, (context, out, value) -> {
        LEB128.writeUnsignedInt(out, ((float[])value).length);
        for (float e : value) {
            out.writeFloat(e);
        }
    });
    static final ValueSerializer<double[]> DOUBLE_ARRAY = Serializers.createSerializer((context, in) -> {
        int length = LEB128.readUnsignedInt(in);
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = in.readDouble();
        }
        return array;
    }, (context, out, value) -> {
        LEB128.writeUnsignedInt(out, ((double[])value).length);
        for (double e : value) {
            out.writeDouble(e);
        }
    });
    static final ValueSerializer<long[]> LONG_ARRAY = Serializers.createSerializer((context, in) -> {
        int length = LEB128.readUnsignedInt(in);
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = in.readLong();
        }
        return array;
    }, (context, out, value) -> {
        LEB128.writeUnsignedInt(out, ((long[])value).length);
        for (long e : value) {
            out.writeLong(e);
        }
    });
    private static final ValueSerializer<?> AS_REFERENCE_CONSTANT = Serializers.createSerializer((context, in) -> {
        ReferenceConstant ref = context.readerFor(ReferenceConstant.class).read(context, in);
        return ref.getReferent();
    }, (context, out, value) -> context.writerFor(ReferenceConstant.class).write(context, out, ReferenceConstant.createFromNonNullReference(value)));
    public static final ValueReader<ReferenceConstant<?>> REFERENCE_CONSTANT_READER = (context, in) -> {
        boolean inNativeHeap = in.readBoolean();
        if (inNativeHeap) {
            long nativeHeapAddress = in.readLong();
            if (nativeHeapAddress == 0L) {
                return ReferenceConstant.nullReference();
            }
            Pointer heapBase = KnownIntrinsics.heapBase();
            Object ref = heapBase.add(Word.unsigned((long)nativeHeapAddress)).toObject();
            return ReferenceConstant.createFromNonNullReference(ref);
        }
        Object ref = context.readReference(in);
        return ReferenceConstant.createFromReference(ref);
    };
    static final ValueSerializer<JavaKind> JAVA_KIND = Serializers.ofEnum(JavaKind.class);
    static final ValueSerializer<UnresolvedJavaType> UNRESOLVED_TYPE = Serializers.createSerializer((context, in) -> {
        String name = (String)context.readReference(in);
        return UnresolvedJavaType.create((String)name);
    }, (context, out, value) -> context.writeReference(out, value.getName()));
    static final ValueSerializer<UnresolvedJavaMethod> UNRESOLVED_METHOD = Serializers.createSerializer((context, in) -> {
        String name = (String)context.readReference(in);
        InterpreterUnresolvedSignature signature = (InterpreterUnresolvedSignature)context.readReference(in);
        JavaType holder = (JavaType)context.readReference(in);
        assert (holder instanceof InterpreterResolvedPrimitiveType || holder instanceof UnresolvedJavaType);
        return new UnresolvedJavaMethod(name, (Signature)signature, holder);
    }, (context, out, value) -> {
        context.writeReference(out, value.getName());
        assert (value.getSignature() instanceof InterpreterUnresolvedSignature);
        context.writeReference(out, value.getSignature());
        context.writeReference(out, value.getDeclaringClass());
    });
    static final ValueSerializer<UnresolvedJavaField> UNRESOLVED_FIELD = Serializers.createSerializer((context, in) -> {
        JavaType holder = (JavaType)context.readReference(in);
        assert (holder instanceof InterpreterResolvedPrimitiveType || holder instanceof UnresolvedJavaType);
        String name = (String)context.readReference(in);
        JavaType type = (JavaType)context.readReference(in);
        assert (type instanceof InterpreterResolvedPrimitiveType || type instanceof UnresolvedJavaType);
        return new UnresolvedJavaField(holder, name, type);
    }, (context, out, value) -> {
        context.writeReference(out, value.getDeclaringClass());
        context.writeReference(out, value.getName());
        context.writeReference(out, value.getType());
    });
    static final ValueSerializer<InterpreterResolvedPrimitiveType> PRIMITIVE_TYPE = Serializers.createSerializer((context, in) -> {
        JavaKind kind = (JavaKind)context.readReference(in);
        return InterpreterResolvedPrimitiveType.fromKind(kind);
    }, (context, out, value) -> context.writeReference(out, value.getJavaKind()));
    static final ValueSerializer<InterpreterUnresolvedSignature> UNRESOLVED_SIGNATURE = Serializers.createSerializer((context, in) -> {
        JavaType returnType = (JavaType)context.readReference(in);
        int length = LEB128.readUnsignedInt(in);
        JavaType[] parameterTypes = new JavaType[length];
        for (int i = 0; i < length; ++i) {
            parameterTypes[i] = (JavaType)context.readReference(in);
        }
        return InterpreterUnresolvedSignature.create(returnType, parameterTypes);
    }, (context, out, value) -> {
        JavaType returnType = value.getReturnType(null);
        context.writeReference(out, returnType);
        int length = value.getParameterCount(false);
        LEB128.writeUnsignedInt(out, length);
        for (int i = 0; i < length; ++i) {
            JavaType parameterType = value.getParameterType(i, null);
            context.writeReference(out, parameterType);
        }
    });
    static final ValueSerializer<MethodType> METHOD_TYPE = Serializers.createSerializer((context, in) -> {
        Class returnType = (Class)context.readReference(in);
        int length = LEB128.readUnsignedInt(in);
        Class[] parameterTypes = new Class[length];
        for (int i = 0; i < length; ++i) {
            parameterTypes[i] = (Class)context.readReference(in);
        }
        return MethodType.methodType(returnType, parameterTypes);
    }, (context, out, value) -> {
        TypeDescriptor.OfField returnType = value.returnType();
        context.writeReference(out, returnType);
        int length = value.parameterCount();
        LEB128.writeUnsignedInt(out, length);
        for (int i = 0; i < length; ++i) {
            TypeDescriptor.OfField parameterType = value.parameterType(i);
            context.writeReference(out, parameterType);
        }
    });
    static final ValueSerializer<Local> LOCAL = Serializers.createSerializer((context, in) -> {
        String name = (String)context.readReference(in);
        JavaType type = (JavaType)context.readReference(in);
        int startBci = LEB128.readUnsignedInt(in);
        int endBci = LEB128.readUnsignedInt(in);
        int slot = LEB128.readUnsignedInt(in);
        return new Local(name, type, startBci, endBci, slot);
    }, (context, out, value) -> {
        context.writeReference(out, value.getName());
        context.writeReference(out, value.getType());
        LEB128.writeUnsignedInt(out, value.getStartBCI());
        LEB128.writeUnsignedInt(out, value.getEndBCI());
        LEB128.writeUnsignedInt(out, value.getSlot());
    });
    static final ValueSerializer<ExceptionHandler> EXCEPTION_HANDLER = Serializers.createSerializer((context, in) -> {
        int startBCI = LEB128.readUnsignedInt(in);
        int endBCI = LEB128.readUnsignedInt(in);
        int catchBCI = LEB128.readUnsignedInt(in);
        int catchTypeCPI = LEB128.readUnsignedInt(in);
        JavaType catchType = (JavaType)context.readReference(in);
        return new ExceptionHandler(startBCI, endBCI, catchBCI, catchTypeCPI, catchType);
    }, (context, out, value) -> {
        LEB128.writeUnsignedInt(out, value.getStartBCI());
        LEB128.writeUnsignedInt(out, value.getEndBCI());
        LEB128.writeUnsignedInt(out, value.getHandlerBCI());
        LEB128.writeUnsignedInt(out, value.catchTypeCPI());
        context.writeReference(out, value.getCatchType());
    });
    static final ValueSerializer<LocalVariableTable> LOCAL_VARIABLE_TABLE = Serializers.createSerializer((context, in) -> {
        Local[] locals = context.readerFor(Local[].class).read(context, in);
        return new LocalVariableTable(locals);
    }, (context, out, value) -> context.writerFor(Local[].class).write(context, out, value.getLocals()));
    static final int[] EMPTY_INT_ARRAY = new int[0];
    static final ValueSerializer<LineNumberTable> LINE_NUMBER_TABLE = Serializers.createSerializer((context, in) -> {
        int length = LEB128.readUnsignedInt(in);
        if (length == 0) {
            return new LineNumberTable(EMPTY_INT_ARRAY, EMPTY_INT_ARRAY);
        }
        int[] lineNumbers = new int[length];
        int[] bcis = new int[length];
        int lastLineNumber = 0;
        int lastBci = 0;
        for (int i = 0; i < length; ++i) {
            int curLineNumber = lastLineNumber + LEB128.readSignedInt(in);
            int curBci = lastBci + LEB128.readSignedInt(in);
            lineNumbers[i] = curLineNumber;
            bcis[i] = curBci;
            lastLineNumber = curLineNumber;
            lastBci = curBci;
        }
        return new LineNumberTable(lineNumbers, bcis);
    }, (context, out, value) -> {
        int[] bcis;
        int[] lines = value.getLineNumbers();
        VMError.guarantee(lines.length == (bcis = value.getBcis()).length);
        LEB128.writeUnsignedInt(out, lines.length);
        int lastLineNumber = 0;
        int lastBci = 0;
        for (int i = 0; i < lines.length; ++i) {
            LEB128.writeSignedInt(out, lines[i] - lastLineNumber);
            LEB128.writeSignedInt(out, bcis[i] - lastBci);
            lastLineNumber = lines[i];
            lastBci = bcis[i];
        }
    });
    static final ValueSerializer<PrimitiveConstant> PRIMITIVE_CONSTANT = Serializers.createSerializer((context, in) -> {
        JavaKind kind = (JavaKind)context.readReference(in);
        long rawValue = in.readLong();
        if (kind == JavaKind.Illegal) {
            return JavaConstant.forIllegal();
        }
        return JavaConstant.forPrimitive((JavaKind)kind, (long)rawValue);
    }, (context, out, value) -> {
        context.writeReference(out, value.getJavaKind());
        out.writeLong(value.getRawValue());
    });
    static final ValueSerializer<? extends JavaConstant> NULL_CONSTANT = Serializers.createSerializer((context, in) -> JavaConstant.NULL_POINTER, (context, out, value) -> {});
    static final ValueSerializer<InterpreterConstantPool> CONSTANT_POOL = Serializers.createSerializer((context, in) -> {
        InterpreterResolvedObjectType holder = (InterpreterResolvedObjectType)context.readReference(in);
        Object[] entries = context.readerFor(Object[].class).read(context, in);
        return InterpreterConstantPool.create(holder, entries);
    }, (context, out, value) -> {
        context.writeReference(out, value.getHolder());
        context.writerFor(Object[].class).write(context, out, value.getEntries());
    });
    static final ValueSerializer<InterpreterResolvedJavaField> RESOLVED_FIELD = Serializers.createSerializer((context, in) -> {
        String name = (String)context.readReference(in);
        InterpreterResolvedJavaType type = (InterpreterResolvedJavaType)context.readReference(in);
        InterpreterResolvedObjectType declaringClass = (InterpreterResolvedObjectType)context.readReference(in);
        int modifiers = LEB128.readUnsignedInt(in);
        int offset = LEB128.readUnsignedInt(in);
        JavaConstant constant = (JavaConstant)context.readReference(in);
        return InterpreterResolvedJavaField.create(name, modifiers, type, declaringClass, offset, constant);
    }, (context, out, value) -> {
        context.writeReference(out, value.getName());
        context.writeReference(out, value.getType());
        context.writeReference(out, value.getDeclaringClass());
        LEB128.writeUnsignedInt(out, value.getModifiers());
        LEB128.writeUnsignedInt(out, value.getOffset());
        if (value.isUnmaterializedConstant()) {
            JavaConstant constant = value.getUnmaterializedConstant();
            context.writeReference(out, constant);
        } else {
            context.writeReference(out, null);
        }
    });
    static final ValueSerializer<InterpreterResolvedObjectType> OBJECT_TYPE = Serializers.createSerializer((context, in) -> {
        String name = (String)context.readReference(in);
        int modifiers = LEB128.readUnsignedInt(in);
        InterpreterResolvedJavaType componentType = (InterpreterResolvedJavaType)context.readReference(in);
        InterpreterResolvedObjectType superclass = (InterpreterResolvedObjectType)context.readReference(in);
        InterpreterResolvedObjectType[] interfaces = (InterpreterResolvedObjectType[])context.readReference(in);
        InterpreterConstantPool constantPool = (InterpreterConstantPool)context.readReference(in);
        ReferenceConstant clazzConstant = (ReferenceConstant)context.readReference(in);
        boolean isWordType = in.readBoolean();
        String sourceFileName = (String)context.readReference(in);
        if (clazzConstant.isOpaque()) {
            return InterpreterResolvedObjectType.createWithOpaqueClass(name, modifiers, componentType, superclass, interfaces, constantPool, clazzConstant, isWordType, sourceFileName);
        }
        return InterpreterResolvedObjectType.createForInterpreter(name, modifiers, componentType, superclass, interfaces, constantPool, (Class)clazzConstant.getReferent(), isWordType);
    }, (context, out, value) -> {
        String name = value.getName();
        int modifiers = value.getModifiers();
        InterpreterResolvedJavaType componentType = value.getComponentType();
        InterpreterResolvedObjectType superclass = value.getSuperclass();
        InterpreterResolvedObjectType[] interfaces = value.getInterfaces();
        Object constantPool = null;
        Class<?> javaClass = value.getJavaClass();
        ReferenceConstant<Class<?>> clazzConstant = ReferenceConstant.createFromNonNullReference(javaClass);
        context.writeReference(out, name);
        LEB128.writeUnsignedInt(out, modifiers);
        context.writeReference(out, componentType);
        context.writeReference(out, superclass);
        context.writeReference(out, interfaces);
        context.writeReference(out, constantPool);
        context.writeReference(out, clazzConstant);
        out.writeBoolean(value.isWordType());
        context.writeReference(out, value.getSourceFileName());
    });
    static final ValueSerializer<InterpreterResolvedObjectType.VTableHolder> VTABLE_HOLDER = Serializers.createSerializer((context, in) -> {
        InterpreterResolvedObjectType holder = (InterpreterResolvedObjectType)context.readReference(in);
        InterpreterResolvedJavaMethod[] vtable = context.readerFor(InterpreterResolvedJavaMethod[].class).read(context, in);
        return new InterpreterResolvedObjectType.VTableHolder(holder, vtable);
    }, (context, out, value) -> {
        context.writeReference(out, value.holder);
        context.writerFor(InterpreterResolvedJavaMethod[].class).write(context, out, value.vtable);
    });
    static final ValueSerializer<InterpreterResolvedJavaMethod> RESOLVED_METHOD = Serializers.createSerializer((context, in) -> {
        String name = (String)context.readReference(in);
        int maxLocals = LEB128.readUnsignedInt(in);
        int maxStackSize = LEB128.readUnsignedInt(in);
        int modifiers = LEB128.readUnsignedInt(in);
        InterpreterResolvedObjectType declaringClass = (InterpreterResolvedObjectType)context.readReference(in);
        InterpreterUnresolvedSignature signature = (InterpreterUnresolvedSignature)context.readReference(in);
        byte[] code = (byte[])context.readReference(in);
        ExceptionHandler[] exceptionHandlers = (ExceptionHandler[])context.readReference(in);
        LineNumberTable lineNumberTable = (LineNumberTable)context.readReference(in);
        LocalVariableTable localVariableTable = (LocalVariableTable)context.readReference(in);
        ReferenceConstant nativeEntryPoint = (ReferenceConstant)context.readReference(in);
        int vtableIndex = LEB128.readUnsignedInt(in);
        int gotOffset = LEB128.readUnsignedInt(in);
        int enterStubOffset = LEB128.readUnsignedInt(in);
        int methodId = LEB128.readUnsignedInt(in);
        return InterpreterResolvedJavaMethod.create(name, maxLocals, maxStackSize, modifiers, declaringClass, signature, code, exceptionHandlers, lineNumberTable, localVariableTable, nativeEntryPoint, vtableIndex, gotOffset, enterStubOffset, methodId);
    }, (context, out, value) -> {
        String name = value.getName();
        int maxLocals = value.getMaxLocals();
        int maxStackSize = value.getMaxStackSize();
        int modifiers = value.getModifiers();
        InterpreterResolvedObjectType declaringClass = value.getDeclaringClass();
        InterpreterUnresolvedSignature signature = value.getSignature();
        byte[] code = value.getInterpretedCode();
        ExceptionHandler[] exceptionHandlers = value.getExceptionHandlers();
        LineNumberTable lineNumberTable = value.getLineNumberTable();
        LocalVariableTable localVariableTable = value.getLocalVariableTable();
        ReferenceConstant<FunctionPointerHolder> nativeEntryPointHolder = value.getNativeEntryPointHolderConstant();
        int vtableIndex = value.getVTableIndex();
        int gotOffset = value.getGotOffset();
        int enterStubOffset = value.getEnterStubOffset();
        int methodId = value.getMethodId();
        context.writeReference(out, name);
        LEB128.writeUnsignedInt(out, maxLocals);
        LEB128.writeUnsignedInt(out, maxStackSize);
        LEB128.writeUnsignedInt(out, modifiers);
        context.writeReference(out, declaringClass);
        context.writeReference(out, signature);
        context.writeReference(out, code);
        context.writeReference(out, exceptionHandlers);
        context.writeReference(out, lineNumberTable);
        context.writeReference(out, localVariableTable);
        context.writeReference(out, nativeEntryPointHolder);
        LEB128.writeUnsignedInt(out, vtableIndex);
        LEB128.writeUnsignedInt(out, gotOffset);
        LEB128.writeUnsignedInt(out, enterStubOffset);
        LEB128.writeUnsignedInt(out, methodId);
    });
    static final ValueSerializer<InterpreterResolvedJavaMethod.InlinedBy> INLINED_BY = Serializers.createSerializer((context, in) -> {
        InterpreterResolvedJavaMethod holder = (InterpreterResolvedJavaMethod)context.readReference(in);
        InterpreterResolvedJavaMethod.InlinedBy ret = new InterpreterResolvedJavaMethod.InlinedBy(holder, new HashSet<InterpreterResolvedJavaMethod>());
        for (int size = LEB128.readUnsignedInt(in); size > 0; --size) {
            ret.inliners.add((InterpreterResolvedJavaMethod)context.readReference(in));
        }
        return ret;
    }, (context, out, value) -> {
        InterpreterResolvedJavaMethod holder = value.holder;
        int size = value.inliners.size();
        context.writeReference(out, holder);
        LEB128.writeUnsignedInt(out, size);
        for (InterpreterResolvedJavaMethod m : value.inliners) {
            context.writeReference(out, m);
        }
    });
    public static final List<Class<?>> UNIVERSE_KNOWN_CLASSES = List.of(byte[].class, String.class, JavaKind.class, UnresolvedJavaType.class, UnresolvedJavaField.class, UnresolvedJavaMethod.class, InterpreterUnresolvedSignature.class, Local.class, Local[].class, LocalVariableTable.class, LineNumberTable.class, ExceptionHandler.class, ExceptionHandler[].class, PrimitiveConstant.class, JavaConstant.NULL_POINTER.getClass(), MethodType.class, InterpreterConstantPool.class, Object[].class, InterpreterResolvedObjectType[].class, InterpreterResolvedJavaMethod[].class, ReferenceConstant.class, InterpreterResolvedPrimitiveType.class, InterpreterResolvedObjectType.class, InterpreterResolvedObjectType.VTableHolder.class, InterpreterResolvedJavaField.class, FunctionPointerHolder.class, InterpreterResolvedJavaMethod.class, InterpreterResolvedJavaMethod.InlinedBy.class);

    public static <T> ValueSerializer<T> createSerializer(ValueReader<T> reader, ValueWriter<T> writer) {
        return new ValueSerializer<T>(reader, writer);
    }

    public static <E extends Enum<E>> ValueSerializer<E> ofEnum(Class<E> enumClass) {
        return Serializers.createSerializer((context, in) -> {
            String name = (String)context.readReference(in);
            return Enum.valueOf(enumClass, name);
        }, (context, out, value) -> context.writeReference(out, value.name()));
    }

    public static <T> ValueSerializer<T[]> ofReferenceArray(IntFunction<T[]> allocateArray) {
        return Serializers.createSerializer((context, in) -> {
            int length = LEB128.readUnsignedInt(in);
            Object[] array = (Object[])allocateArray.apply(length);
            for (int i = 0; i < length; ++i) {
                array[i] = context.readReference(in);
            }
            return array;
        }, (context, out, value) -> {
            int length = ((Object[])value).length;
            LEB128.writeUnsignedInt(out, length);
            for (Object e : value) {
                context.writeReference(out, e);
            }
        });
    }

    static <T> ValueSerializer<T> asReferenceConstant() {
        return AS_REFERENCE_CONSTANT;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static ValueWriter<ReferenceConstant<?>> newReferenceConstantWriter(ToLongFunction<Object> getImageHeapOffset) {
        return (context, out, value) -> {
            boolean inImageHeap;
            Object ref = value.getReferent();
            long imageHeapOffset = ref == null ? 0L : getImageHeapOffset.applyAsLong(ref);
            boolean bl = inImageHeap = ref == null || imageHeapOffset != 0L;
            assert (ref != null || inImageHeap);
            out.writeBoolean(inImageHeap);
            if (inImageHeap) {
                out.writeLong(imageHeapOffset);
            } else if (ref instanceof String) {
                context.writeReference(out, ref);
            } else {
                context.writeReference(out, null);
            }
        };
    }

    public static ValueSerializer<ReferenceConstant<?>> newReferenceConstantSerializer(ToLongFunction<Object> getNativeHeapAddress) {
        return Serializers.createSerializer(REFERENCE_CONSTANT_READER, Serializers.newReferenceConstantWriter(getNativeHeapAddress));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static SerializationContext.Builder newBuilderForInterpreterMetadata() {
        Class nullConstantClass = JavaConstant.NULL_POINTER.getClass();
        return SerializationContext.newBuilder().setKnownClasses(UNIVERSE_KNOWN_CLASSES).registerSerializer(byte[].class, BYTE_ARRAY).registerSerializer(String.class, STRING).registerSerializer(JavaKind.class, JAVA_KIND).registerSerializer(UnresolvedJavaType.class, UNRESOLVED_TYPE).registerSerializer(UnresolvedJavaField.class, UNRESOLVED_FIELD).registerSerializer(UnresolvedJavaMethod.class, UNRESOLVED_METHOD).registerSerializer(InterpreterUnresolvedSignature.class, UNRESOLVED_SIGNATURE).registerSerializer(Local.class, LOCAL).registerSerializer(Local[].class, Serializers.ofReferenceArray(Local[]::new)).registerSerializer(LocalVariableTable.class, LOCAL_VARIABLE_TABLE).registerSerializer(LineNumberTable.class, LINE_NUMBER_TABLE).registerSerializer(ExceptionHandler.class, EXCEPTION_HANDLER).registerSerializer(ExceptionHandler[].class, Serializers.ofReferenceArray(ExceptionHandler[]::new)).registerSerializer(PrimitiveConstant.class, PRIMITIVE_CONSTANT).registerSerializer(nullConstantClass, NULL_CONSTANT).registerSerializer(MethodType.class, METHOD_TYPE).registerSerializer(InterpreterConstantPool.class, CONSTANT_POOL).registerSerializer(Object[].class, Serializers.ofReferenceArray(Object[]::new)).registerSerializer(InterpreterResolvedObjectType[].class, Serializers.ofReferenceArray(InterpreterResolvedObjectType[]::new)).registerSerializer(InterpreterResolvedJavaMethod[].class, Serializers.ofReferenceArray(InterpreterResolvedJavaMethod[]::new)).registerSerializer(InterpreterResolvedPrimitiveType.class, PRIMITIVE_TYPE).registerSerializer(InterpreterResolvedObjectType.class, OBJECT_TYPE).registerSerializer(InterpreterResolvedObjectType.VTableHolder.class, VTABLE_HOLDER).registerSerializer(InterpreterResolvedJavaField.class, RESOLVED_FIELD).registerSerializer(FunctionPointerHolder.class, Serializers.asReferenceConstant()).registerSerializer(InterpreterResolvedJavaMethod.class, RESOLVED_METHOD).registerSerializer(InterpreterResolvedJavaMethod.InlinedBy.class, INLINED_BY).registerReader(ReferenceConstant.class, REFERENCE_CONSTANT_READER).registerWriter(ReferenceConstant.class, (context, out, value) -> {
            throw VMError.shouldNotReachHereAtRuntime();
        });
    }
}

