/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata.serialization;

import com.oracle.svm.interpreter.metadata.serialization.SerializationContext;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;

abstract class SerializationContextImpl
implements SerializationContext {
    protected final List<Object> indexToReference;
    protected final IdentityHashMap<Object, Integer> referenceToIndex;
    protected final List<Class<?>> knownClasses;

    protected SerializationContextImpl(List<Class<?>> knownClasses) {
        if (knownClasses.contains(Class.class)) {
            throw new IllegalArgumentException("Known classes cannot contain Class.class");
        }
        this.knownClasses = knownClasses;
        this.referenceToIndex = new IdentityHashMap();
        this.indexToReference = new ArrayList<Object>();
        this.indexToReference.add(null);
        int classIndex = this.recordReference(Class.class);
        assert (classIndex == 1);
        for (Class<?> clazz : knownClasses) {
            this.recordReference(clazz);
        }
    }

    @Override
    public <T> int recordReference(T value) {
        if (value == null) {
            return 0;
        }
        if (this.referenceToIndex.containsKey(value)) {
            throw new IllegalStateException("Duplicated reference: " + String.valueOf(value));
        }
        int refIndex = this.indexToReference.size();
        this.indexToReference.add(value);
        this.referenceToIndex.put(value, refIndex);
        return refIndex;
    }
}

