/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.metadata.BytecodeStream;
import com.oracle.svm.interpreter.metadata.TableSwitch;

public final class LookupSwitch {
    private static final int OFFSET_TO_NUMBER_PAIRS = 4;
    private static final int OFFSET_TO_FIRST_PAIR_MATCH = 8;
    private static final int OFFSET_TO_FIRST_PAIR_OFFSET = 12;
    private static final int PAIR_SIZE = 8;

    private LookupSwitch() {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public static int offsetAt(byte[] code, int bci, int i) {
        assert (BytecodeStream.opcode(code, bci) == 171);
        return BytecodeStream.readInt(code, TableSwitch.getAlignedBci(bci) + 12 + 8 * i);
    }

    public static int keyAt(byte[] code, int bci, int i) {
        assert (BytecodeStream.opcode(code, bci) == 171);
        return BytecodeStream.readInt(code, TableSwitch.getAlignedBci(bci) + 8 + 8 * i);
    }

    public static int numberOfCases(byte[] code, int bci) {
        assert (BytecodeStream.opcode(code, bci) == 171);
        return BytecodeStream.readInt(code, TableSwitch.getAlignedBci(bci) + 4);
    }

    public static int size(byte[] code, int bci) {
        assert (BytecodeStream.opcode(code, bci) == 171);
        return TableSwitch.getAlignedBci(bci) + 8 + 8 * LookupSwitch.numberOfCases(code, bci) - bci;
    }

    public static int targetAt(byte[] code, int bci, int i) {
        assert (BytecodeStream.opcode(code, bci) == 171);
        return bci + LookupSwitch.offsetAt(code, bci, i);
    }

    public static int defaultTarget(byte[] code, int bci) {
        assert (BytecodeStream.opcode(code, bci) == 171);
        return bci + LookupSwitch.defaultOffset(code, bci);
    }

    public static int defaultOffset(byte[] code, int bci) {
        assert (BytecodeStream.opcode(code, bci) == 171);
        return BytecodeStream.readInt(code, TableSwitch.getAlignedBci(bci));
    }
}

