/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

public final class ByteUtils {
    private static final VarHandle BYTE_ARRAY_VARHANDLE = MethodHandles.arrayElementVarHandle(byte[].class);

    public static int beS1(byte[] data, int bci) {
        return data[bci];
    }

    public static int beS2(byte[] data, int bci) {
        return data[bci] << 8 | data[bci + 1] & 0xFF;
    }

    public static int beU1(byte[] data, int bci) {
        return data[bci] & 0xFF;
    }

    public static int volatileBeU1(byte[] data, int bci) {
        return BYTE_ARRAY_VARHANDLE.getVolatile(data, bci) & 0xFF;
    }

    public static int opaqueBeU1(byte[] data, int bci) {
        return BYTE_ARRAY_VARHANDLE.getOpaque(data, bci) & 0xFF;
    }

    public static int beU2(byte[] data, int bci) {
        return (data[bci] & 0xFF) << 8 | data[bci + 1] & 0xFF;
    }

    public static int beS4(byte[] data, int bci) {
        return data[bci] << 24 | (data[bci + 1] & 0xFF) << 16 | (data[bci + 2] & 0xFF) << 8 | data[bci + 3] & 0xFF;
    }

    public static int beSVar(byte[] data, int bci, boolean fourByte) {
        if (fourByte) {
            return ByteUtils.beS4(data, bci);
        }
        return ByteUtils.beS2(data, bci);
    }

    public static void opaqueWrite(byte[] array, int index, byte value) {
        BYTE_ARRAY_VARHANDLE.setOpaque(array, index, value);
    }
}

