/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.classfile;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.classfile.OutStream;
import com.oracle.svm.interpreter.metadata.BytecodeStream;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaType;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedObjectType;
import com.oracle.svm.interpreter.metadata.InterpreterUniverse;
import com.oracle.svm.interpreter.metadata.MetadataUtil;
import com.oracle.svm.interpreter.metadata.ReferenceConstant;
import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ModifiersProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class ClassFile {
    public static final int MAGIC = -889275714;
    public static final int MAJOR_VERSION = 55;
    public static final int MINOR_VERSION = 0;
    public static final byte CONSTANT_Utf8 = 1;
    public static final byte CONSTANT_Integer = 3;
    public static final byte CONSTANT_Float = 4;
    public static final byte CONSTANT_Long = 5;
    public static final byte CONSTANT_Double = 6;
    public static final byte CONSTANT_Class = 7;
    public static final byte CONSTANT_String = 8;
    public static final byte CONSTANT_Fieldref = 9;
    public static final byte CONSTANT_Methodref = 10;
    public static final byte CONSTANT_InterfaceMethodref = 11;
    public static final byte CONSTANT_NameAndType = 12;
    public static final byte CONSTANT_MethodHandle = 15;
    public static final byte CONSTANT_MethodType = 16;
    public static final byte CONSTANT_Dynamic = 17;
    public static final byte CONSTANT_InvokeDynamic = 18;
    public static final byte CONSTANT_Module = 19;
    public static final byte CONSTANT_Package = 20;
    private final OutStream classFile = new OutStream();
    private final OutStream constantPool = new OutStream();
    private int constantPoolEntryCount;
    private final Map<String, Integer> fieldRefCache = new HashMap<String, Integer>();
    private final Map<Pair<String, String>, Integer> nameAndTypeCache = new HashMap<Pair<String, String>, Integer>();
    private final Map<String, Integer> utf8Cache = new HashMap<String, Integer>();
    private final Map<Integer, Integer> intCache = new HashMap<Integer, Integer>();
    private final Map<Long, Integer> longCache = new HashMap<Long, Integer>();
    private final Map<Integer, Integer> floatCache = new HashMap<Integer, Integer>();
    private final Map<Long, Integer> doubleCache = new HashMap<Long, Integer>();
    private final Map<String, Integer> stringCache = new HashMap<String, Integer>();
    private final Map<String, Integer> classCache = new HashMap<String, Integer>();
    private final Map<String, Integer> methodRefCache = new HashMap<String, Integer>();
    private final Map<String, Integer> interfaceMethodRefCache = new HashMap<String, Integer>();
    private final Map<String, Integer> methodTypeCache = new HashMap<String, Integer>();
    private final Map<Pair<Byte, Object>, Integer> methodHandleCache = new HashMap<Pair<Byte, Object>, Integer>();
    private final Map<String, Integer> moduleCache = new HashMap<String, Integer>();
    private final Map<String, Integer> packageCache = new HashMap<String, Integer>();
    public static final byte REF_NONE = 0;
    public static final byte REF_getField = 1;
    public static final byte REF_getStatic = 2;
    public static final byte REF_putField = 3;
    public static final byte REF_putStatic = 4;
    public static final byte REF_invokeVirtual = 5;
    public static final byte REF_invokeStatic = 6;
    public static final byte REF_invokeSpecial = 7;
    public static final byte REF_newInvokeSpecial = 8;
    public static final byte REF_invokeInterface = 9;
    public static final byte REF_LIMIT = 10;
    private final InterpreterUniverse universe;
    private final Function<Object, Object> extractConstantValue;
    private static final Function<Object, Object> EXTRACT_INTERPRETER_CONSTANT_VALUE = constant -> {
        if (constant instanceof JavaType) {
            return constant;
        }
        if (constant instanceof PrimitiveConstant) {
            PrimitiveConstant primitiveConstant = (PrimitiveConstant)constant;
            return primitiveConstant.asBoxedPrimitive();
        }
        if (constant instanceof ReferenceConstant) {
            return ((ReferenceConstant)constant).getReferent();
        }
        throw VMError.shouldNotReachHere("unexpected constant");
    };

    public ClassFile(InterpreterUniverse universe, Function<Object, Object> extractConstantValue) {
        this.universe = universe;
        this.extractConstantValue = extractConstantValue;
    }

    private int utf8(String str) {
        return this.utf8Cache.computeIfAbsent(str, key -> {
            this.constantPool.writeU1(1);
            this.constantPool.writeUTF(str);
            return ++this.constantPoolEntryCount;
        });
    }

    private int longConstant(long value) {
        return this.longCache.computeIfAbsent(value, key -> {
            this.constantPool.writeU1(5);
            this.constantPool.writeLong(value);
            ++this.constantPoolEntryCount;
            int entry = this.constantPoolEntryCount++;
            return entry;
        });
    }

    private int doubleConstant(double value) {
        return this.doubleCache.computeIfAbsent(Double.doubleToRawLongBits(value), key -> {
            this.constantPool.writeU1(6);
            this.constantPool.writeDouble(value);
            ++this.constantPoolEntryCount;
            int entry = this.constantPoolEntryCount++;
            return entry;
        });
    }

    private int intConstant(int value) {
        return this.intCache.computeIfAbsent(value, key -> {
            this.constantPool.writeU1(3);
            this.constantPool.writeInt(value);
            return ++this.constantPoolEntryCount;
        });
    }

    private int floatConstant(float value) {
        return this.floatCache.computeIfAbsent(Float.floatToRawIntBits(value), key -> {
            this.constantPool.writeU1(4);
            this.constantPool.writeFloat(value);
            return ++this.constantPoolEntryCount;
        });
    }

    private int string(String str) {
        return this.stringCache.computeIfAbsent(str, key -> {
            int stringIndex = this.utf8(str);
            this.constantPool.writeU1(8);
            this.constantPool.writeU2(stringIndex);
            return ++this.constantPoolEntryCount;
        });
    }

    private int ldcConstant(Object javaConstantOrType) {
        if (javaConstantOrType instanceof JavaConstant) {
            JavaConstant javaConstant = (JavaConstant)javaConstantOrType;
            switch (javaConstant.getJavaKind()) {
                case Int: {
                    return this.intConstant(javaConstant.asInt());
                }
                case Float: {
                    return this.floatConstant(javaConstant.asFloat());
                }
                case Long: {
                    return this.longConstant(javaConstant.asLong());
                }
                case Double: {
                    return this.doubleConstant(javaConstant.asDouble());
                }
                case Object: {
                    Object value = this.extractConstantValue(javaConstant);
                    if (value instanceof String) {
                        return this.string((String)value);
                    }
                    if (value instanceof MethodType) {
                        return this.methodType((MethodType)value);
                    }
                    throw VMError.unimplemented("LDC methodHandle constant");
                }
            }
            throw VMError.shouldNotReachHereAtRuntime();
        }
        if (javaConstantOrType instanceof JavaType) {
            return this.classConstant((JavaType)javaConstantOrType);
        }
        throw VMError.shouldNotReachHereAtRuntime();
    }

    private int nameAndTypeImpl(String name, String descriptor) {
        return this.nameAndTypeCache.computeIfAbsent((Pair<String, String>)Pair.create((Object)name, (Object)descriptor), key -> {
            int nameIndex = this.utf8(name);
            int descriptorIndex = this.utf8(descriptor);
            this.constantPool.writeU1(12);
            this.constantPool.writeU2(nameIndex);
            this.constantPool.writeU2(descriptorIndex);
            return ++this.constantPoolEntryCount;
        });
    }

    private int nameAndType(String name, JavaType fieldDescriptor) {
        String descriptor = fieldDescriptor.getName();
        return this.nameAndTypeImpl(name, descriptor);
    }

    private int nameAndType(String name, Signature methodDescriptor) {
        String descriptor = methodDescriptor.toMethodDescriptor();
        return this.nameAndTypeImpl(name, descriptor);
    }

    private int fieldRef(JavaField field) {
        return this.fieldRefCache.computeIfAbsent(MetadataUtil.toUniqueString(field), key -> {
            int classIndex = this.classConstant(field.getDeclaringClass());
            int nameAndTypeIndex = this.nameAndType(field.getName(), field.getType());
            this.constantPool.writeU1(9);
            this.constantPool.writeU2(classIndex);
            this.constantPool.writeU2(nameAndTypeIndex);
            return ++this.constantPoolEntryCount;
        });
    }

    private int classConstant(JavaType type) {
        return this.classCache.computeIfAbsent(MetadataUtil.toUniqueString(type), key -> {
            int nameIndex = this.utf8(ClassFile.toConstantPoolName(type));
            this.constantPool.writeU1(7);
            this.constantPool.writeU2(nameIndex);
            return ++this.constantPoolEntryCount;
        });
    }

    private int methodRef(JavaMethod method) {
        return this.methodRefCache.computeIfAbsent(MetadataUtil.toUniqueString(method), key -> {
            int classIndex = this.classConstant(method.getDeclaringClass());
            int nameAndTypeIndex = this.nameAndType(method.getName(), method.getSignature());
            this.constantPool.writeU1(10);
            this.constantPool.writeU2(classIndex);
            this.constantPool.writeU2(nameAndTypeIndex);
            return ++this.constantPoolEntryCount;
        });
    }

    private int interfaceMethodRef(JavaMethod method) {
        return this.interfaceMethodRefCache.computeIfAbsent(MetadataUtil.toUniqueString(method), key -> {
            assert (!(method instanceof ResolvedJavaMethod) || ((ResolvedJavaMethod)method).getDeclaringClass().isInterface()) : method;
            int classIndex = this.classConstant(method.getDeclaringClass());
            int nameAndTypeIndex = this.nameAndType(method.getName(), method.getSignature());
            this.constantPool.writeU1(11);
            this.constantPool.writeU2(classIndex);
            this.constantPool.writeU2(nameAndTypeIndex);
            return ++this.constantPoolEntryCount;
        });
    }

    private int module(String moduleName) {
        return this.moduleCache.computeIfAbsent(moduleName, key -> {
            int nameIndex = this.utf8(moduleName);
            this.constantPool.writeU1(19);
            this.constantPool.writeU2(nameIndex);
            return ++this.constantPoolEntryCount;
        });
    }

    private int packageConstant(String packageName) {
        return this.packageCache.computeIfAbsent(packageName, key -> {
            int nameIndex = this.utf8(packageName);
            this.constantPool.writeU1(20);
            this.constantPool.writeU2(nameIndex);
            return ++this.constantPoolEntryCount;
        });
    }

    private int methodType(MethodType methodType) {
        String descriptor = methodType.descriptorString();
        return this.methodTypeCache.computeIfAbsent(descriptor, key -> {
            int descriptorIndex = this.utf8(descriptor);
            this.constantPool.writeU1(16);
            this.constantPool.writeU2(descriptorIndex);
            return ++this.constantPoolEntryCount;
        });
    }

    private int methodHandle(byte referenceKind, JavaField referenceField) {
        VMError.guarantee(referenceKind == 1 || referenceKind == 2 || referenceKind == 3 || referenceKind == 4);
        return this.methodHandleCache.computeIfAbsent((Pair<Byte, Object>)Pair.create((Object)referenceKind, (Object)referenceField), key -> {
            int referenceIndex = this.fieldRef(referenceField);
            this.constantPool.writeU1(15);
            this.constantPool.writeU1(referenceKind);
            this.constantPool.writeU2(referenceIndex);
            return ++this.constantPoolEntryCount;
        });
    }

    private int methodHandle(byte referenceKind, ResolvedJavaMethod referenceMethod) {
        VMError.guarantee(referenceKind == 5 || referenceKind == 6 || referenceKind == 7 || referenceKind == 8 || referenceKind == 9);
        return this.methodHandleCache.computeIfAbsent((Pair<Byte, Object>)Pair.create((Object)referenceKind, (Object)referenceMethod), key -> {
            int referenceIndex = switch (referenceKind) {
                case 5, 8 -> this.methodRef((JavaMethod)referenceMethod);
                case 6, 7 -> {
                    if (referenceMethod.getDeclaringClass().isInterface()) {
                        yield this.interfaceMethodRef((JavaMethod)referenceMethod);
                    }
                    yield this.methodRef((JavaMethod)referenceMethod);
                }
                case 9 -> this.interfaceMethodRef((JavaMethod)referenceMethod);
                default -> throw VMError.shouldNotReachHere("invalid methodHandle ref kind");
            };
            this.constantPool.writeU1(15);
            this.constantPool.writeU1(referenceKind);
            this.constantPool.writeU2(referenceIndex);
            return ++this.constantPoolEntryCount;
        });
    }

    private Object extractConstantValue(Object constant) {
        return this.extractConstantValue.apply(constant);
    }

    private ResolvedJavaType getSuperclass(ResolvedJavaType type) {
        if (type instanceof InterpreterResolvedJavaType) {
            InterpreterResolvedJavaType interpreterResolvedJavaType = (InterpreterResolvedJavaType)type;
            Class<?> superclass = interpreterResolvedJavaType.getJavaClass().getSuperclass();
            if (superclass == null) {
                return null;
            }
            return this.universe.lookupType(superclass);
        }
        return type.getSuperclass();
    }

    private ResolvedJavaType[] getInterfaces(ResolvedJavaType type) {
        if (type instanceof InterpreterResolvedJavaType) {
            InterpreterResolvedJavaType interpreterResolvedJavaType = (InterpreterResolvedJavaType)type;
            Class<?>[] interfaces = interpreterResolvedJavaType.getJavaClass().getInterfaces();
            ResolvedJavaType[] result = new InterpreterResolvedObjectType[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                result[i] = this.universe.lookupType(interfaces[i]);
            }
            return result;
        }
        return type.getInterfaces();
    }

    private ResolvedJavaMethod getClassInitializer(ResolvedJavaType type) {
        if (type instanceof InterpreterResolvedJavaType) {
            return this.universe.getAllDeclaredMethods(type).stream().filter(ResolvedJavaMethod::isClassInitializer).findAny().orElse(null);
        }
        return type.getClassInitializer();
    }

    private ResolvedJavaMethod[] getDeclaredConstructors(ResolvedJavaType type) {
        if (type instanceof InterpreterResolvedJavaType) {
            return (ResolvedJavaMethod[])this.universe.getAllDeclaredMethods(type).stream().filter(ResolvedJavaMethod::isConstructor).toArray(InterpreterResolvedJavaMethod[]::new);
        }
        return type.getDeclaredConstructors();
    }

    private ResolvedJavaMethod[] getDeclaredMethods(ResolvedJavaType type) {
        if (type instanceof InterpreterResolvedJavaType) {
            return (ResolvedJavaMethod[])this.universe.getAllDeclaredMethods(type).stream().filter(method -> !method.isConstructor() && !method.isClassInitializer()).toArray(ResolvedJavaMethod[]::new);
        }
        return type.getDeclaredMethods();
    }

    private ResolvedJavaField[] getInstanceFields(ResolvedJavaType type, boolean includeSuperclasses) {
        if (type instanceof InterpreterResolvedJavaType) {
            if (includeSuperclasses) {
                throw VMError.unimplemented("getInstanceFields with includeSuperclasses=true");
            }
            return (ResolvedJavaField[])this.universe.getAllDeclaredFields(type).stream().filter(f -> !f.isStatic()).toArray(ResolvedJavaField[]::new);
        }
        return type.getInstanceFields(includeSuperclasses);
    }

    private ResolvedJavaField[] getStaticFields(ResolvedJavaType type) {
        if (type instanceof InterpreterResolvedJavaType) {
            return (ResolvedJavaField[])this.universe.getAllDeclaredFields(type).stream().filter(ModifiersProvider::isStatic).toArray(ResolvedJavaField[]::new);
        }
        return type.getStaticFields();
    }

    static byte[] dumpResolvedJavaTypeClassFile(InterpreterUniverse universe, ResolvedJavaType type, Function<Object, Object> extractConstantValue) {
        VMError.guarantee(!type.isPrimitive() && !type.isArray());
        ClassFile cf = new ClassFile(universe, extractConstantValue);
        cf.dumpClassFileImpl(type);
        OutStream ensemble = new OutStream();
        ensemble.writeInt(-889275714);
        ensemble.writeU2(0);
        ensemble.writeU2(55);
        ensemble.writeU2(cf.constantPoolEntryCount + 1);
        ensemble.writeBytes(cf.constantPool.toArray());
        ensemble.writeBytes(cf.classFile.toArray());
        return ensemble.toArray();
    }

    public static byte[] dumpInterpreterTypeClassFile(InterpreterUniverse universe, InterpreterResolvedJavaType type) {
        return ClassFile.dumpResolvedJavaTypeClassFile(universe, type, EXTRACT_INTERPRETER_CONSTANT_VALUE);
    }

    void dumpSourceFileAttribute(String sourceFileName) {
        if (sourceFileName == null) {
            return;
        }
        this.classFile.writeU2(this.utf8("SourceFile"));
        this.classFile.writeInt(2);
        this.classFile.writeU2(this.utf8(sourceFileName));
    }

    void dumpClassFileImpl(ResolvedJavaType type) {
        ArrayList<ResolvedJavaMethod> allDeclaredMethods = new ArrayList<ResolvedJavaMethod>();
        if (this.getClassInitializer(type) != null) {
            allDeclaredMethods.add(this.getClassInitializer(type));
        }
        allDeclaredMethods.addAll(Arrays.asList(this.getDeclaredConstructors(type)));
        allDeclaredMethods.addAll(Arrays.asList(this.getDeclaredMethods(type)));
        this.processLDC(allDeclaredMethods);
        this.classFile.writeU2(type.getModifiers() & Modifier.classModifiers());
        this.classFile.writeU2(this.classConstant((JavaType)type));
        if (this.getSuperclass(type) != null) {
            this.classFile.writeU2(this.classConstant((JavaType)this.getSuperclass(type)));
        } else {
            this.classFile.writeU2(0);
        }
        this.classFile.writeU2(this.getInterfaces(type).length);
        for (ResolvedJavaType i : this.getInterfaces(type)) {
            this.classFile.writeU2(this.classConstant((JavaType)i));
        }
        ArrayList<ResolvedJavaField> fields = new ArrayList<ResolvedJavaField>();
        fields.addAll(Arrays.asList(this.getStaticFields(type)));
        fields.addAll(Arrays.asList(this.getInstanceFields(type, false)));
        this.classFile.writeU2(fields.size());
        for (ResolvedJavaField f : fields) {
            this.dumpFieldInfo(f);
        }
        this.classFile.writeU2(allDeclaredMethods.size());
        for (ResolvedJavaMethod m : allDeclaredMethods) {
            this.dumpMethodInfo(m);
        }
        int attributeCount = 0;
        if (ClassFile.getSourceFileName(type) != null) {
            ++attributeCount;
        }
        this.classFile.writeU2(attributeCount);
        if (ClassFile.getSourceFileName(type) != null) {
            this.dumpSourceFileAttribute(ClassFile.getSourceFileName(type));
        }
    }

    private static String getSourceFileName(ResolvedJavaType type) {
        if (type instanceof InterpreterResolvedJavaType) {
            return ((InterpreterResolvedObjectType)type).getOriginalType().getSourceFileName();
        }
        return type.getSourceFileName();
    }

    private void processLDC(List<ResolvedJavaMethod> methods) {
        HashSet<ConstantWrapper> pending = new HashSet<ConstantWrapper>();
        for (ResolvedJavaMethod resolvedJavaMethod : methods) {
            byte[] byArray;
            if (!resolvedJavaMethod.hasBytecodes() || (byArray = resolvedJavaMethod.getCode()) == null || byArray.length == 0) continue;
            int bci = 0;
            while (bci < BytecodeStream.endBCI(byArray)) {
                char originalCPI;
                if (BytecodeStream.opcode(byArray, bci) == 18 && (originalCPI = BytecodeStream.readCPI(byArray, bci)) != '\u0000') {
                    Object constant = resolvedJavaMethod.getConstantPool().lookupConstant((int)originalCPI);
                    if (constant instanceof PrimitiveConstant) {
                        this.ldcConstant(constant);
                    } else {
                        pending.add(new ConstantWrapper(constant));
                    }
                }
                bci = BytecodeStream.nextBCI(byArray, bci);
            }
        }
        ArrayList<String> newEntries = new ArrayList<String>();
        for (ConstantWrapper constantWrapper : pending) {
            Object constant = constantWrapper.constant;
            Object value = this.extractConstantValue(constant);
            String utf8Entry = null;
            if (value instanceof JavaType) {
                utf8Entry = ClassFile.toConstantPoolName((JavaType)value);
            } else if (value instanceof String) {
                utf8Entry = (String)value;
            } else if (value instanceof MethodType) {
                MethodType methodType = (MethodType)value;
                utf8Entry = methodType.toMethodDescriptorString();
            } else {
                throw VMError.unimplemented("LDC methodHandle constant");
            }
            VMError.guarantee(utf8Entry != null);
            if (this.utf8Cache.containsKey(utf8Entry)) continue;
            newEntries.add(utf8Entry);
            this.utf8Cache.put(utf8Entry, this.constantPoolEntryCount + pending.size() + newEntries.size());
        }
        int n = this.constantPoolEntryCount;
        for (ConstantWrapper wrapper : pending) {
            this.ldcConstant(wrapper.constant);
        }
        int n2 = this.constantPoolEntryCount;
        VMError.guarantee(n2 - n == pending.size());
        for (String entry : newEntries) {
            this.constantPool.writeU1(1);
            this.constantPool.writeUTF(entry);
            ++this.constantPoolEntryCount;
        }
    }

    private static String toConstantPoolName(JavaType type) {
        return type.toJavaName().replace('.', '/');
    }

    private void dumpFieldInfo(ResolvedJavaField field) {
        int accessFlags = field.getModifiers() & Modifier.fieldModifiers();
        int nameIndex = this.utf8(field.getName());
        int descriptorIndex = this.utf8(field.getType().getName());
        this.classFile.writeU2(accessFlags);
        this.classFile.writeU2(nameIndex);
        this.classFile.writeU2(descriptorIndex);
        int attributeCount = 0;
        this.classFile.writeU2(attributeCount);
    }

    private void dumpMethodInfo(ResolvedJavaMethod method) {
        ResolvedJavaMethod.Parameter[] methodParameters;
        int accessFlags = method.getModifiers() & Modifier.methodModifiers();
        int nameIndex = this.utf8(method.getName());
        int descriptorIndex = this.utf8(method.getSignature().toMethodDescriptor());
        this.classFile.writeU2(accessFlags);
        this.classFile.writeU2(nameIndex);
        this.classFile.writeU2(descriptorIndex);
        int attributeCount = 0;
        if (method.hasBytecodes()) {
            ++attributeCount;
        }
        if ((methodParameters = method.getParameters()) != null) {
            ++attributeCount;
        }
        this.classFile.writeU2(attributeCount);
        if (method.hasBytecodes()) {
            this.dumpCodeAttribute(method);
        }
        if (methodParameters != null) {
            this.dumpMethodParameters(methodParameters);
        }
    }

    private void dumpMethodParameters(ResolvedJavaMethod.Parameter[] methodParameters) {
        if (methodParameters == null) {
            return;
        }
        this.classFile.writeU2(this.utf8("MethodParameters"));
        int attributeLength = 1 + methodParameters.length * 4;
        this.classFile.writeInt(attributeLength);
        this.classFile.writeU1(attributeLength);
        for (ResolvedJavaMethod.Parameter p : methodParameters) {
            this.classFile.writeU2(this.utf8(p.getName()));
            this.classFile.writeU2(p.getModifiers());
        }
    }

    private void dumpLineNumberTable(LineNumberTable lineNumberTable) {
        if (lineNumberTable == null) {
            return;
        }
        this.classFile.writeU2(this.utf8("LineNumberTable"));
        int[] lineNumbers = lineNumberTable.getLineNumbers();
        int[] bcis = lineNumberTable.getBcis();
        assert (lineNumbers.length == bcis.length);
        int entryCount = lineNumbers.length;
        int attributeLength = 2 + entryCount * 4;
        this.classFile.writeInt(attributeLength);
        this.classFile.writeU2(entryCount);
        for (int i = 0; i < entryCount; ++i) {
            this.classFile.writeU2(bcis[i]);
            this.classFile.writeU2(lineNumbers[i]);
        }
    }

    private void dumpLocalVariableTable(LocalVariableTable localVariableTable) {
        if (localVariableTable == null) {
            return;
        }
        this.classFile.writeU2(this.utf8("LocalVariableTable"));
        Local[] locals = localVariableTable.getLocals();
        int attributeLength = 2 + locals.length * 10;
        this.classFile.writeInt(attributeLength);
        this.classFile.writeU2(locals.length);
        for (Local local : locals) {
            this.classFile.writeU2(local.getStartBCI());
            this.classFile.writeU2(local.getEndBCI() - local.getStartBCI());
            this.classFile.writeU2(this.utf8(local.getName()));
            JavaType type = local.getType();
            if (type == null) {
                this.classFile.writeU2(0);
            } else {
                this.classFile.writeU2(this.utf8(type.getName()));
            }
            this.classFile.writeU2(local.getSlot());
        }
    }

    private void dumpCodeAttribute(ResolvedJavaMethod method) {
        LocalVariableTable localVariableTable;
        int startOffset = this.classFile.getOffset();
        this.classFile.writeU2(this.utf8("Code"));
        this.classFile.writeInt(-559038737);
        this.classFile.writeU2(method.getMaxStackSize());
        this.classFile.writeU2(method.getMaxLocals());
        byte[] code = method.getCode();
        if (code == null) {
            this.classFile.writeInt(0);
        } else {
            this.classFile.writeInt(code.length);
            this.classFile.writeBytes(this.recomputeConstantPoolIndices(method));
        }
        ExceptionHandler[] handlers = method.getExceptionHandlers();
        if (handlers == null || handlers.length == 0) {
            this.classFile.writeU2(0);
        } else {
            this.classFile.writeU2(handlers.length);
            for (ExceptionHandler eh : handlers) {
                this.classFile.writeU2(eh.getStartBCI());
                this.classFile.writeU2(eh.getEndBCI());
                this.classFile.writeU2(eh.getHandlerBCI());
                this.classFile.writeU2(eh.catchTypeCPI());
            }
        }
        int attributeCount = 0;
        LineNumberTable lineNumberTable = method.getLineNumberTable();
        if (lineNumberTable != null) {
            ++attributeCount;
        }
        if ((localVariableTable = method.getLocalVariableTable()) != null) {
            ++attributeCount;
        }
        this.classFile.writeU2(attributeCount);
        if (lineNumberTable != null) {
            this.dumpLineNumberTable(lineNumberTable);
        }
        if (localVariableTable != null) {
            this.dumpLocalVariableTable(localVariableTable);
        }
        int attributeLength = this.classFile.getOffset() - startOffset - 6;
        this.classFile.patchAtOffset(startOffset + 2, () -> this.classFile.writeInt(attributeLength));
    }

    private byte[] recomputeConstantPoolIndices(ResolvedJavaMethod method) {
        byte[] originalCode = method.getCode();
        if (originalCode == null || originalCode.length == 0) {
            return originalCode;
        }
        byte[] code = (byte[])originalCode.clone();
        ConstantPool originalConstantPool = method.getConstantPool();
        int bci = 0;
        while (bci < BytecodeStream.endBCI(code)) {
            int bytecode = BytecodeStream.currentBC(code, bci);
            switch (bytecode) {
                case 187: 
                case 189: 
                case 192: 
                case 193: 
                case 197: {
                    char originalCPI = BytecodeStream.readCPI(code, bci);
                    int newCPI = 0;
                    if (originalCPI != '\u0000') {
                        newCPI = this.classConstant(originalConstantPool.lookupType((int)originalCPI, bytecode));
                    }
                    BytecodeStream.patchCPI(code, bci, newCPI);
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    char originalCPI = BytecodeStream.readCPI(code, bci);
                    int newCPI = 0;
                    if (originalCPI != '\u0000') {
                        Object constant = originalConstantPool.lookupConstant((int)BytecodeStream.readCPI(code, bci));
                        newCPI = this.ldcConstant(constant);
                    }
                    BytecodeStream.patchCPI(code, bci, newCPI);
                    break;
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: {
                    char originalCPI = BytecodeStream.readCPI(code, bci);
                    int newCPI = 0;
                    if (originalCPI != '\u0000') {
                        newCPI = this.fieldRef(originalConstantPool.lookupField((int)originalCPI, method, bytecode));
                    }
                    BytecodeStream.patchCPI(code, bci, newCPI);
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    char originalCPI = BytecodeStream.readCPI(code, bci);
                    int newCPI = 0;
                    if (originalCPI != '\u0000') {
                        newCPI = this.methodRef(originalConstantPool.lookupMethod((int)originalCPI, bytecode));
                    }
                    BytecodeStream.patchCPI(code, bci, newCPI);
                    break;
                }
                case 186: {
                    BytecodeStream.patchCPI(code, bci, 0);
                    BytecodeStream.patchAppendixCPI(code, bci, 0);
                }
            }
            bci = BytecodeStream.nextBCI(code, bci);
        }
        return code;
    }

    final class ConstantWrapper {
        final Object constant;

        ConstantWrapper(Object constant) {
            this.constant = constant;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConstantWrapper)) {
                return false;
            }
            ConstantWrapper that = (ConstantWrapper)other;
            Object thisValue = ClassFile.this.extractConstantValue(this.constant);
            Object thatValue = ClassFile.this.extractConstantValue(that.constant);
            if (thisValue instanceof JavaType) {
                return thatValue instanceof JavaType && ((JavaType)thisValue).getName().equals(((JavaType)thatValue).getName());
            }
            return thisValue.equals(thatValue);
        }

        public int hashCode() {
            Object value = ClassFile.this.extractConstantValue(this.constant);
            if (value instanceof JavaType) {
                return ((JavaType)value).getName().hashCode();
            }
            return value.hashCode();
        }
    }
}

