/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.FrameSourceInfo;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.interpreter.InterpreterFrameSourceInfo;
import com.oracle.svm.core.interpreter.InterpreterSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.DebuggerSupport;
import com.oracle.svm.interpreter.Interpreter;
import com.oracle.svm.interpreter.InterpreterFrame;
import com.oracle.svm.interpreter.InterpreterOptions;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordBase;

public final class InterpreterSupportImpl
extends InterpreterSupport {
    private final int bciSlot;
    private final int interpretedMethodSlot;
    private final int interpretedFrameSlot;

    InterpreterSupportImpl(int bciSlot, int interpretedMethodSlot, int interpretedFrameSlot) {
        this.bciSlot = bciSlot;
        this.interpretedMethodSlot = interpretedMethodSlot;
        this.interpretedFrameSlot = interpretedFrameSlot;
    }

    @Override
    public boolean isInterpreterRoot(Class<?> clazz) {
        return Interpreter.Root.class.equals(clazz);
    }

    private static int readInt(Pointer addr, SignedWord offset) {
        return addr.readInt((WordBase)offset);
    }

    private static <T> T readObject(Pointer addr, SignedWord offset, boolean compressed) {
        Word p = ((Word)addr).add(offset);
        Object obj = ReferenceAccess.singleton().readObjectAt((Pointer)p, compressed);
        return (T)obj;
    }

    private InterpreterResolvedJavaMethod readInterpretedMethod(FrameInfoQueryResult frameInfo, Pointer sp) {
        FrameInfoQueryResult.ValueInfo valueInfo = frameInfo.getValueInfos()[this.interpretedMethodSlot];
        return (InterpreterResolvedJavaMethod)InterpreterSupportImpl.readObject(sp, Word.signed((long)valueInfo.getData()), valueInfo.isCompressedReference());
    }

    private int readBCI(FrameInfoQueryResult frameInfo, Pointer sp) {
        FrameInfoQueryResult.ValueInfo valueInfo = frameInfo.getValueInfos()[this.bciSlot];
        return InterpreterSupportImpl.readInt(sp, Word.signed((long)valueInfo.getData()));
    }

    private InterpreterFrame readInterpreterFrame(FrameInfoQueryResult frameInfo, Pointer sp) {
        FrameInfoQueryResult.ValueInfo valueInfo = frameInfo.getValueInfos()[this.interpretedFrameSlot];
        return (InterpreterFrame)InterpreterSupportImpl.readObject(sp, Word.signed((long)valueInfo.getData()), valueInfo.isCompressedReference());
    }

    @Override
    public FrameSourceInfo getInterpretedMethodFrameInfo(FrameInfoQueryResult frameInfo, Pointer sp) {
        if (!this.isInterpreterRoot(frameInfo.getSourceClass())) {
            throw VMError.shouldNotReachHereAtRuntime();
        }
        InterpreterResolvedJavaMethod interpretedMethod = this.readInterpretedMethod(frameInfo, sp);
        int bci = this.readBCI(frameInfo, sp);
        InterpreterFrame interpreterFrame = this.readInterpreterFrame(frameInfo, sp);
        Class<?> interpretedClass = interpretedMethod.getDeclaringClass().getJavaClass();
        String sourceMethodName = interpretedMethod.getName();
        LineNumberTable lineNumberTable = interpretedMethod.getLineNumberTable();
        int sourceLineNumber = -1;
        if (lineNumberTable != null) {
            sourceLineNumber = lineNumberTable.getLineNumber(bci);
        }
        return new InterpreterFrameSourceInfo(interpretedClass, sourceMethodName, sourceLineNumber, bci, interpretedMethod, interpreterFrame);
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void buildMethodIdMapping(ResolvedJavaMethod[] encodedMethods) {
        if (InterpreterOptions.DebuggerWithInterpreter.getValue().booleanValue()) {
            assert (ImageSingletons.contains(DebuggerSupport.class));
            ((DebuggerSupport)ImageSingletons.lookup(DebuggerSupport.class)).buildMethodIdMapping(encodedMethods);
        }
    }
}

