/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.objectfile.BasicProgbitsSectionImpl;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.SectionName;
import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.code.InterpreterAccessStubData;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.interpreter.DebuggerSupport;
import com.oracle.svm.interpreter.EspressoFrame;
import com.oracle.svm.interpreter.Interpreter;
import com.oracle.svm.interpreter.InterpreterFrame;
import com.oracle.svm.interpreter.SemanticJavaException;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedObjectType;
import com.oracle.svm.interpreter.metadata.InterpreterUnresolvedSignature;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;

@InternalVMMethod
public abstract class InterpreterStubSection {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final SectionName SVM_INTERP = new SectionName.ProgbitsSectionName("svm_interp");
    private static final CGlobalData<Pointer> BASE = CGlobalDataFactory.forSymbol(InterpreterStubSection.nameForVTableIndex(0));
    static final int MAX_VTABLE_STUBS = 2045;
    protected RegisterConfig registerConfig;
    protected SubstrateTargetDescription target;
    protected ValueKindFactory<LIRKind> valueKindFactory;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private ObjectFile.ProgbitsSectionImpl stubsBufferImpl;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final Map<InterpreterResolvedJavaMethod, Integer> enterTrampolineOffsets = new HashMap<InterpreterResolvedJavaMethod, Integer>();
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private int vTableStubBaseOffset = -1;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void createInterpreterEnterStubSection(AbstractImage image, Collection<InterpreterResolvedJavaMethod> methods) {
        ObjectFile objectFile = image.getObjectFile();
        byte[] stubsBlob = this.generateEnterStubs(methods);
        RelocatableBuffer stubsBuffer = new RelocatableBuffer(stubsBlob.length, objectFile.getByteOrder());
        this.stubsBufferImpl = new BasicProgbitsSectionImpl(stubsBuffer.getBackingArray());
        ObjectFile.Section stubsSection = objectFile.newProgbitsSection(SVM_INTERP.getFormatDependentName(objectFile.getFormat()), objectFile.getPageSize(), false, true, this.stubsBufferImpl);
        stubsBuffer.getByteBuffer().put(stubsBlob, 0, stubsBlob.length);
        boolean internalSymbolsAreGlobal = SubstrateOptions.InternalSymbolsAreGlobal.getValue();
        objectFile.createDefinedSymbol("interp_enter_trampoline", (ObjectFile.Element)stubsSection, 0L, 0, true, internalSymbolsAreGlobal);
        for (InterpreterResolvedJavaMethod method : this.enterTrampolineOffsets.keySet()) {
            int offset = this.enterTrampolineOffsets.get(method);
            objectFile.createDefinedSymbol(InterpreterStubSection.nameForInterpMethod(method), (ObjectFile.Element)stubsSection, (long)offset, ConfigurationValues.getTarget().wordSize, true, internalSymbolsAreGlobal);
        }
    }

    public static String nameForInterpMethod(InterpreterResolvedJavaMethod method) {
        return "interp_enter_" + NativeImage.localSymbolNameForMethod(method);
    }

    public static String nameForVTableIndex(int vTableIndex) {
        return "crema_enter_" + String.format("%04d", vTableIndex);
    }

    public static Pointer getCremaStubForVTableIndex(int vTableIndex) {
        VMError.guarantee(vTableIndex >= 0 && vTableIndex < 2045);
        return BASE.get().add(vTableIndex * ((InterpreterStubSection)ImageSingletons.lookup(InterpreterStubSection.class)).getVTableStubSize());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void createInterpreterVTableEnterStubSection(AbstractImage image) {
        ObjectFile objectFile = image.getObjectFile();
        byte[] stubsBlob = this.generateVTableEnterStubs(2045);
        RelocatableBuffer stubsBuffer = new RelocatableBuffer(stubsBlob.length, objectFile.getByteOrder());
        this.stubsBufferImpl = new BasicProgbitsSectionImpl(stubsBuffer.getBackingArray());
        ObjectFile.Section stubsSection = objectFile.newProgbitsSection(SVM_INTERP.getFormatDependentName(objectFile.getFormat()), objectFile.getPageSize(), false, true, this.stubsBufferImpl);
        stubsBuffer.getByteBuffer().put(stubsBlob, 0, stubsBlob.length);
        boolean internalSymbolsAreGlobal = SubstrateOptions.InternalSymbolsAreGlobal.getValue();
        objectFile.createDefinedSymbol("crema_enter_trampoline", (ObjectFile.Element)stubsSection, 0L, 0, true, internalSymbolsAreGlobal);
        assert (this.vTableStubBaseOffset != -1);
        for (int vTableIndex = 0; vTableIndex < 2045; ++vTableIndex) {
            int codeOffset = this.vTableStubBaseOffset + vTableIndex * this.getVTableStubSize();
            String symbolName = InterpreterStubSection.nameForVTableIndex(vTableIndex);
            objectFile.createDefinedSymbol(symbolName, (ObjectFile.Element)stubsSection, (long)codeOffset, ConfigurationValues.getTarget().wordSize, true, internalSymbolsAreGlobal);
        }
    }

    protected void recordVTableStubBaseOffset(int codeOffset) {
        assert (this.vTableStubBaseOffset == -1);
        this.vTableStubBaseOffset = codeOffset;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void recordEnterTrampoline(InterpreterResolvedJavaMethod m, int position) {
        this.enterTrampolineOffsets.put(m, position);
    }

    protected abstract byte[] generateEnterStubs(Collection<InterpreterResolvedJavaMethod> var1);

    protected abstract byte[] generateVTableEnterStubs(int var1);

    public abstract int getVTableStubSize();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void markEnterStubPatch(ResolvedJavaMethod enterStub) {
        this.markEnterStubPatch(this.stubsBufferImpl, enterStub);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected abstract void markEnterStubPatch(ObjectFile.ProgbitsSectionImpl var1, ResolvedJavaMethod var2);

    @Deoptimizer.DeoptStub(stubType=Deoptimizer.StubType.InterpreterEnterStub)
    @NeverInline(value="needs ABI boundary")
    public static Pointer enterMethodInterpreterStub(int interpreterMethodESTOffset, Pointer enterData) {
        DebuggerSupport interpreterSupport = (DebuggerSupport)ImageSingletons.lookup(DebuggerSupport.class);
        InterpreterResolvedJavaMethod interpreterMethod = (InterpreterResolvedJavaMethod)interpreterSupport.getUniverse().getMethodForESTOffset(interpreterMethodESTOffset);
        VMError.guarantee(interpreterMethod != null);
        return InterpreterStubSection.enterHelper(interpreterMethod, enterData);
    }

    @Deoptimizer.DeoptStub(stubType=Deoptimizer.StubType.InterpreterEnterStub)
    @NeverInline(value="needs ABI boundary")
    public static Pointer enterVTableInterpreterStub(int vTableIndex, Pointer enterData) {
        InterpreterAccessStubData accessHelper = (InterpreterAccessStubData)ImageSingletons.lookup(InterpreterAccessStubData.class);
        Object receiver = ((Pointer)Word.pointer((long)accessHelper.getGpArgumentAt(null, enterData, 0))).toObject();
        DynamicHub hub = DynamicHub.fromClass(receiver.getClass());
        InterpreterResolvedObjectType thisType = (InterpreterResolvedObjectType)hub.getInterpreterType();
        InterpreterResolvedJavaMethod interpreterMethod = thisType.getVtable()[vTableIndex];
        return InterpreterStubSection.enterHelper(interpreterMethod, enterData);
    }

    @AlwaysInline(value="helper")
    private static Pointer enterHelper(InterpreterResolvedJavaMethod interpreterMethod, Pointer enterData) {
        InterpreterAccessStubData accessHelper = (InterpreterAccessStubData)ImageSingletons.lookup(InterpreterAccessStubData.class);
        InterpreterStubSection stubSection = (InterpreterStubSection)ImageSingletons.lookup(InterpreterStubSection.class);
        InterpreterUnresolvedSignature signature = interpreterMethod.getSignature();
        VMError.guarantee(signature != null);
        int count = signature.getParameterCount(false);
        InterpreterResolvedObjectType accessingClass = interpreterMethod.getDeclaringClass();
        InterpreterResolvedObjectType thisType = interpreterMethod.hasReceiver() ? accessingClass : null;
        JavaType returnType = signature.getReturnType(accessingClass);
        SubstrateCallingConventionType kind = SubstrateCallingConventionKind.Java.toType(true);
        CallingConvention callingConvention = stubSection.registerConfig.getCallingConvention((CallingConvention.Type)kind, returnType, signature.toParameterTypes((JavaType)thisType), stubSection.valueKindFactory);
        InterpreterFrame frame = EspressoFrame.allocate(interpreterMethod.getMaxLocals(), interpreterMethod.getMaxStackSize(), new Object[0]);
        int interpSlot = 0;
        int gpIdx = 0;
        int fpIdx = 0;
        if (interpreterMethod.hasReceiver()) {
            Object receiver = ((Pointer)Word.pointer((long)accessHelper.getGpArgumentAt(callingConvention.getArgument(gpIdx), enterData, gpIdx))).toObject();
            EspressoFrame.setLocalObject(frame, 0, receiver);
            ++gpIdx;
            ++interpSlot;
        }
        for (int i = 0; i < count; ++i) {
            long arg;
            JavaKind argKind = signature.getParameterKind(i);
            AllocatableValue ccArg = callingConvention.getArgument(gpIdx + fpIdx);
            switch (argKind) {
                case Float: 
                case Double: {
                    arg = accessHelper.getFpArgumentAt(ccArg, enterData, fpIdx);
                    ++fpIdx;
                    break;
                }
                default: {
                    arg = accessHelper.getGpArgumentAt(ccArg, enterData, gpIdx);
                    ++gpIdx;
                }
            }
            switch (argKind) {
                case Boolean: {
                    EspressoFrame.setLocalInt(frame, interpSlot, (arg & 0xFFL) != 0L ? 1 : 0);
                    break;
                }
                case Byte: {
                    EspressoFrame.setLocalInt(frame, interpSlot, (byte)arg);
                    break;
                }
                case Short: {
                    EspressoFrame.setLocalInt(frame, interpSlot, (short)arg);
                    break;
                }
                case Char: {
                    EspressoFrame.setLocalInt(frame, interpSlot, (char)arg);
                    break;
                }
                case Int: {
                    EspressoFrame.setLocalInt(frame, interpSlot, (int)arg);
                    break;
                }
                case Long: {
                    EspressoFrame.setLocalLong(frame, interpSlot, arg);
                    ++interpSlot;
                    break;
                }
                case Float: {
                    EspressoFrame.setLocalFloat(frame, interpSlot, Float.intBitsToFloat((int)arg));
                    break;
                }
                case Double: {
                    EspressoFrame.setLocalDouble(frame, interpSlot, Double.longBitsToDouble(arg));
                    ++interpSlot;
                    break;
                }
                case Object: {
                    EspressoFrame.setLocalObject(frame, interpSlot, ((Pointer)Word.pointer((long)arg)).toObject());
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHereAtRuntime();
                }
            }
            ++interpSlot;
        }
        Object retVal = Interpreter.execute(interpreterMethod, frame);
        switch (returnType.getJavaKind()) {
            case Boolean: {
                assert (retVal instanceof Boolean);
                accessHelper.setGpReturn(enterData, (Boolean)retVal != false ? 1L : 0L);
                break;
            }
            case Byte: {
                assert (retVal instanceof Byte);
                accessHelper.setGpReturn(enterData, ((Byte)retVal).longValue());
                break;
            }
            case Short: {
                assert (retVal instanceof Short);
                accessHelper.setGpReturn(enterData, ((Short)retVal).longValue());
                break;
            }
            case Char: {
                assert (retVal instanceof Character);
                accessHelper.setGpReturn(enterData, ((Character)retVal).charValue());
                break;
            }
            case Int: {
                assert (retVal instanceof Integer);
                accessHelper.setGpReturn(enterData, ((Integer)retVal).longValue());
                break;
            }
            case Long: {
                assert (retVal instanceof Long);
                accessHelper.setGpReturn(enterData, (Long)retVal);
                break;
            }
            case Float: {
                assert (retVal instanceof Float);
                accessHelper.setFpReturn(enterData, Float.floatToRawIntBits(((Float)retVal).floatValue()));
                break;
            }
            case Double: {
                assert (retVal instanceof Double);
                accessHelper.setFpReturn(enterData, Double.doubleToRawLongBits((Double)retVal));
                break;
            }
            case Object: {
                accessHelper.setGpReturn(enterData, Word.objectToTrackedPointer((Object)retVal).rawValue());
                break;
            }
            case Void: {
                break;
            }
            default: {
                throw VMError.shouldNotReachHereAtRuntime();
            }
        }
        return enterData;
    }

    @Deoptimizer.DeoptStub(stubType=Deoptimizer.StubType.InterpreterLeaveStub)
    @NeverInline(value="needs ABI boundary")
    public static Pointer leaveInterpreterStub(CFunctionPointer entryPoint, Pointer leaveData, long stackSize, long gcReferenceMap) {
        return (Pointer)entryPoint;
    }

    public static Object leaveInterpreter(CFunctionPointer compiledEntryPoint, InterpreterResolvedJavaMethod seedMethod, ResolvedJavaType accessingClass, Object[] args) {
        InterpreterUnresolvedSignature targetSignature = seedMethod.getSignature();
        InterpreterStubSection stubSection = (InterpreterStubSection)ImageSingletons.lookup(InterpreterStubSection.class);
        InterpreterResolvedObjectType thisType = seedMethod.hasReceiver() ? seedMethod.getDeclaringClass() : null;
        SubstrateCallingConventionType kind = SubstrateCallingConventionKind.Java.toType(true);
        JavaType returnType = targetSignature.getReturnType(accessingClass);
        CallingConvention callingConvention = stubSection.registerConfig.getCallingConvention((CallingConvention.Type)kind, returnType, targetSignature.toParameterTypes((JavaType)thisType), stubSection.valueKindFactory);
        InterpreterAccessStubData accessHelper = (InterpreterAccessStubData)ImageSingletons.lookup(InterpreterAccessStubData.class);
        Pointer leaveData = (Pointer)StackValue.get((int)1, (int)accessHelper.allocateStubDataSize());
        long gcReferenceMap = 0L;
        int gpIdx = 0;
        int fpIdx = 0;
        if (seedMethod.hasReceiver()) {
            gcReferenceMap |= accessHelper.setGpArgumentAt(callingConvention.getArgument(gpIdx), leaveData, gpIdx, Word.objectToTrackedPointer((Object)args[0]).rawValue());
            ++gpIdx;
        }
        int stackSize = NumUtil.roundUp((int)callingConvention.getStackSize(), (int)stubSection.target.stackAlignment);
        Pointer stackBuffer = (Pointer)Word.nullPointer();
        if (stackSize > 0) {
            stackBuffer = (Pointer)((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).malloc(Word.unsigned((int)stackSize));
            accessHelper.setSp(leaveData, stackSize, stackBuffer);
        }
        int argCount = targetSignature.getParameterCount(false);
        block28: for (int i = 0; i < argCount; ++i) {
            Object arg = args[i + (seedMethod.hasReceiver() ? 1 : 0)];
            AllocatableValue ccArg = callingConvention.getArgument(gpIdx + fpIdx);
            JavaType type = targetSignature.getParameterType(i, accessingClass);
            switch (type.getJavaKind()) {
                case Boolean: {
                    accessHelper.setGpArgumentAt(ccArg, leaveData, gpIdx, (Boolean)arg != false ? 1L : 0L);
                    ++gpIdx;
                    continue block28;
                }
                case Byte: {
                    accessHelper.setGpArgumentAt(ccArg, leaveData, gpIdx, ((Byte)arg).byteValue());
                    ++gpIdx;
                    continue block28;
                }
                case Short: {
                    accessHelper.setGpArgumentAt(ccArg, leaveData, gpIdx, ((Short)arg).shortValue());
                    ++gpIdx;
                    continue block28;
                }
                case Char: {
                    accessHelper.setGpArgumentAt(ccArg, leaveData, gpIdx, ((Character)arg).charValue());
                    ++gpIdx;
                    continue block28;
                }
                case Int: {
                    accessHelper.setGpArgumentAt(ccArg, leaveData, gpIdx, ((Integer)arg).intValue());
                    ++gpIdx;
                    continue block28;
                }
                case Long: {
                    accessHelper.setGpArgumentAt(ccArg, leaveData, gpIdx, (Long)arg);
                    ++gpIdx;
                    continue block28;
                }
                case Object: {
                    gcReferenceMap |= accessHelper.setGpArgumentAt(ccArg, leaveData, gpIdx, Word.objectToTrackedPointer((Object)arg).rawValue());
                    ++gpIdx;
                    continue block28;
                }
                case Float: {
                    accessHelper.setFpArgumentAt(ccArg, leaveData, fpIdx, Float.floatToRawIntBits(((Float)arg).floatValue()));
                    ++fpIdx;
                    continue block28;
                }
                case Double: {
                    accessHelper.setFpArgumentAt(ccArg, leaveData, fpIdx, Double.doubleToRawLongBits((Double)arg));
                    ++fpIdx;
                    continue block28;
                }
                default: {
                    throw VMError.shouldNotReachHereAtRuntime();
                }
            }
        }
        VMError.guarantee(compiledEntryPoint.isNonNull());
        try {
            InterpreterStubSection.leaveInterpreterStub(compiledEntryPoint, leaveData, stackSize, gcReferenceMap);
        }
        catch (Throwable e) {
            throw SemanticJavaException.raise(e);
        }
        finally {
            if (stackSize > 0) {
                VMError.guarantee(stackBuffer.isNonNull());
                ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)stackBuffer);
            }
        }
        return switch (returnType.getJavaKind()) {
            case JavaKind.Boolean -> (accessHelper.getGpReturn(leaveData) & 0xFFL) != 0L;
            case JavaKind.Byte -> (byte)accessHelper.getGpReturn(leaveData);
            case JavaKind.Short -> (short)accessHelper.getGpReturn(leaveData);
            case JavaKind.Char -> Character.valueOf((char)accessHelper.getGpReturn(leaveData));
            case JavaKind.Int -> (int)accessHelper.getGpReturn(leaveData);
            case JavaKind.Long -> accessHelper.getGpReturn(leaveData);
            case JavaKind.Float -> Float.valueOf(Float.intBitsToFloat((int)accessHelper.getFpReturn(leaveData)));
            case JavaKind.Double -> Double.longBitsToDouble(accessHelper.getFpReturn(leaveData));
            case JavaKind.Object -> ((Pointer)Word.pointer((long)accessHelper.getGpReturn(leaveData))).toObject();
            case JavaKind.Void -> null;
            default -> throw VMError.shouldNotReachHereAtRuntime();
        };
    }
}

