/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.InterpreterFrame;
import com.oracle.svm.interpreter.ReturnAddress;
import com.oracle.svm.interpreter.metadata.InterpreterUnresolvedSignature;
import jdk.vm.ci.meta.JavaKind;

public final class EspressoFrame {
    private EspressoFrame() {
        throw VMError.shouldNotReachHere("private constructor");
    }

    public static InterpreterFrame allocate(int maxLocals, int maxStackSize, Object ... arguments) {
        return InterpreterFrame.create(maxLocals + maxStackSize, arguments);
    }

    public static void dup1(InterpreterFrame frame, int top) {
        EspressoFrame.copyStatic(frame, top - 1, top);
    }

    public static void dupx1(InterpreterFrame frame, int top) {
        EspressoFrame.copyStatic(frame, top - 1, top);
        EspressoFrame.copyStatic(frame, top - 2, top - 1);
        EspressoFrame.copyStatic(frame, top, top - 2);
    }

    public static void dupx2(InterpreterFrame frame, int top) {
        EspressoFrame.copyStatic(frame, top - 1, top);
        EspressoFrame.copyStatic(frame, top - 2, top - 1);
        EspressoFrame.copyStatic(frame, top - 3, top - 2);
        EspressoFrame.copyStatic(frame, top, top - 3);
    }

    public static void dup2(InterpreterFrame frame, int top) {
        EspressoFrame.copyStatic(frame, top - 2, top);
        EspressoFrame.copyStatic(frame, top - 1, top + 1);
    }

    public static void swapSingle(InterpreterFrame frame, int top) {
        EspressoFrame.swapStatic(frame, top);
    }

    public static void dup2x1(InterpreterFrame frame, int top) {
        EspressoFrame.copyStatic(frame, top - 2, top);
        EspressoFrame.copyStatic(frame, top - 1, top + 1);
        EspressoFrame.copyStatic(frame, top - 3, top - 1);
        EspressoFrame.copyStatic(frame, top, top - 3);
        EspressoFrame.copyStatic(frame, top + 1, top - 2);
    }

    public static void dup2x2(InterpreterFrame frame, int top) {
        EspressoFrame.copyStatic(frame, top - 1, top + 1);
        EspressoFrame.copyStatic(frame, top - 2, top);
        EspressoFrame.copyStatic(frame, top - 3, top - 1);
        EspressoFrame.copyStatic(frame, top - 4, top - 2);
        EspressoFrame.copyStatic(frame, top, top - 4);
        EspressoFrame.copyStatic(frame, top + 1, top - 3);
    }

    private static void swapStatic(InterpreterFrame frame, int top) {
        frame.swapStatic(top - 1, top - 2);
    }

    private static void copyStatic(InterpreterFrame frame, int src, int dst) {
        frame.copyStatic(src, dst);
    }

    public static int popInt(InterpreterFrame frame, int slot) {
        int result = frame.getIntStatic(slot);
        EspressoFrame.clearPrimitive(frame, slot);
        return result;
    }

    public static Object peekObject(InterpreterFrame frame, int slot) {
        Object result = frame.getObjectStatic(slot);
        return result;
    }

    public static long peekPrimitive(InterpreterFrame frame, int slot) {
        return frame.getLongStatic(slot);
    }

    public static Object popObject(InterpreterFrame frame, int slot) {
        Object result = frame.getObjectStatic(slot);
        EspressoFrame.clearReference(frame, slot);
        assert (!(result instanceof ReturnAddress));
        return result;
    }

    public static float popFloat(InterpreterFrame frame, int slot) {
        float result = frame.getFloatStatic(slot);
        EspressoFrame.clearPrimitive(frame, slot);
        return result;
    }

    public static long popLong(InterpreterFrame frame, int slot) {
        long result = frame.getLongStatic(slot);
        EspressoFrame.clearPrimitive(frame, slot);
        return result;
    }

    public static double popDouble(InterpreterFrame frame, int slot) {
        double result = frame.getDoubleStatic(slot);
        EspressoFrame.clearPrimitive(frame, slot);
        return result;
    }

    static Object popReturnAddressOrObject(InterpreterFrame frame, int slot) {
        Object result = frame.getObjectStatic(slot);
        EspressoFrame.clearReference(frame, slot);
        return result;
    }

    static void putReturnAddress(InterpreterFrame frame, int slot, int targetBCI) {
        frame.setObjectStatic(slot, ReturnAddress.create(targetBCI));
    }

    public static void putObject(InterpreterFrame frame, int slot, Object value) {
        frame.setObjectStatic(slot, value);
    }

    public static void putInt(InterpreterFrame frame, int slot, int value) {
        frame.setIntStatic(slot, value);
    }

    public static void putFloat(InterpreterFrame frame, int slot, float value) {
        frame.setFloatStatic(slot, value);
    }

    public static void putLong(InterpreterFrame frame, int slot, long value) {
        frame.setLongStatic(slot + 1, value);
    }

    public static void putDouble(InterpreterFrame frame, int slot, double value) {
        frame.setDoubleStatic(slot + 1, value);
    }

    private static void clearReference(InterpreterFrame frame, int slot) {
        frame.clearObjectStatic(slot);
    }

    private static void clearPrimitive(InterpreterFrame frame, int slot) {
        frame.clearPrimitiveStatic(slot);
    }

    public static void clear(InterpreterFrame frame, int slot) {
        frame.clearStatic(slot);
    }

    public static void clearLocal(InterpreterFrame frame, int localSlot) {
        EspressoFrame.clear(frame, localSlot);
    }

    public static void setLocalObject(InterpreterFrame frame, int localSlot, Object value) {
        assert (!(value instanceof ReturnAddress));
        frame.setObjectStatic(localSlot, value);
    }

    static void setLocalObjectOrReturnAddress(InterpreterFrame frame, int localSlot, Object value) {
        frame.setObjectStatic(localSlot, value);
    }

    public static void setLocalInt(InterpreterFrame frame, int localSlot, int value) {
        frame.setIntStatic(localSlot, value);
    }

    public static void setLocalFloat(InterpreterFrame frame, int localSlot, float value) {
        frame.setFloatStatic(localSlot, value);
    }

    public static void setLocalLong(InterpreterFrame frame, int localSlot, long value) {
        frame.setLongStatic(localSlot, value);
    }

    public static void setLocalDouble(InterpreterFrame frame, int localSlot, double value) {
        frame.setDoubleStatic(localSlot, value);
    }

    public static int getLocalInt(InterpreterFrame frame, int localSlot) {
        return frame.getIntStatic(localSlot);
    }

    public static Object getLocalObject(InterpreterFrame frame, int localSlot) {
        Object result = frame.getObjectStatic(localSlot);
        return result;
    }

    public static Object getThis(InterpreterFrame frame) {
        return EspressoFrame.getLocalObject(frame, 0);
    }

    static int getLocalReturnAddress(InterpreterFrame frame, int localSlot) {
        Object result = frame.getObjectStatic(localSlot);
        assert (result != null);
        return ((ReturnAddress)result).bci();
    }

    public static float getLocalFloat(InterpreterFrame frame, int localSlot) {
        return frame.getFloatStatic(localSlot);
    }

    public static long getLocalLong(InterpreterFrame frame, int localSlot) {
        return frame.getLongStatic(localSlot);
    }

    public static double getLocalDouble(InterpreterFrame frame, int localSlot) {
        return frame.getDoubleStatic(localSlot);
    }

    public static int startingStackOffset(int maxLocals) {
        return maxLocals;
    }

    public static Object[] popArguments(InterpreterFrame frame, int top, boolean hasReceiver, InterpreterUnresolvedSignature signature) {
        int argCount = signature.getParameterCount(false);
        int extraParam = hasReceiver ? 1 : 0;
        Object[] args = new Object[argCount + extraParam];
        int argAt = top - 1;
        for (int i = argCount - 1; i >= 0; --i) {
            JavaKind argKind = signature.getParameterKind(i);
            switch (argKind) {
                case Boolean: {
                    args[i + extraParam] = EspressoFrame.popInt(frame, argAt) != 0;
                    break;
                }
                case Byte: {
                    args[i + extraParam] = (byte)EspressoFrame.popInt(frame, argAt);
                    break;
                }
                case Short: {
                    args[i + extraParam] = (short)EspressoFrame.popInt(frame, argAt);
                    break;
                }
                case Char: {
                    args[i + extraParam] = Character.valueOf((char)EspressoFrame.popInt(frame, argAt));
                    break;
                }
                case Int: {
                    args[i + extraParam] = EspressoFrame.popInt(frame, argAt);
                    break;
                }
                case Float: {
                    args[i + extraParam] = Float.valueOf(EspressoFrame.popFloat(frame, argAt));
                    break;
                }
                case Long: {
                    args[i + extraParam] = EspressoFrame.popLong(frame, argAt);
                    --argAt;
                    break;
                }
                case Double: {
                    args[i + extraParam] = EspressoFrame.popDouble(frame, argAt);
                    --argAt;
                    break;
                }
                case Object: {
                    args[i + extraParam] = EspressoFrame.popObject(frame, argAt);
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere("implement me: " + String.valueOf(argKind));
                }
            }
            --argAt;
        }
        if (hasReceiver) {
            args[0] = EspressoFrame.popObject(frame, argAt);
        }
        return args;
    }

    public static int putKind(InterpreterFrame frame, int top, Object value, JavaKind returnKind) {
        switch (returnKind) {
            case Boolean: {
                EspressoFrame.putInt(frame, top, (Boolean)value != false ? 1 : 0);
                break;
            }
            case Byte: {
                EspressoFrame.putInt(frame, top, ((Byte)value).byteValue());
                break;
            }
            case Short: {
                EspressoFrame.putInt(frame, top, ((Short)value).shortValue());
                break;
            }
            case Char: {
                EspressoFrame.putInt(frame, top, ((Character)value).charValue());
                break;
            }
            case Int: {
                EspressoFrame.putInt(frame, top, (Integer)value);
                break;
            }
            case Float: {
                EspressoFrame.putFloat(frame, top, ((Float)value).floatValue());
                break;
            }
            case Long: {
                EspressoFrame.putLong(frame, top, (Long)value);
                break;
            }
            case Double: {
                EspressoFrame.putDouble(frame, top, (Double)value);
                break;
            }
            case Object: {
                EspressoFrame.putObject(frame, top, value);
                break;
            }
            case Void: {
                break;
            }
            default: {
                throw VMError.shouldNotReachHereAtRuntime();
            }
        }
        return returnKind.getSlotCount();
    }
}

