/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.FunctionPointerHolder;
import com.oracle.svm.core.InvalidMethodPointerHandler;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.hosted.DeoptimizationFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.pltgot.GOTEntryAllocator;
import com.oracle.svm.hosted.pltgot.HostedPLTGOTConfiguration;
import com.oracle.svm.hosted.pltgot.IdentityMethodAddressResolverFeature;
import com.oracle.svm.hosted.pltgot.PLTGOTOptions;
import com.oracle.svm.hosted.snippets.SubstrateGraphBuilderPlugins;
import com.oracle.svm.hosted.substitute.SubstitutionMethod;
import com.oracle.svm.interpreter.BuildTimeInterpreterUniverse;
import com.oracle.svm.interpreter.DebuggerSupport;
import com.oracle.svm.interpreter.InterpreterDirectives;
import com.oracle.svm.interpreter.InterpreterFeature;
import com.oracle.svm.interpreter.InterpreterMethodPointerHolder;
import com.oracle.svm.interpreter.InterpreterOptions;
import com.oracle.svm.interpreter.InterpreterStubSection;
import com.oracle.svm.interpreter.InterpreterStubTable;
import com.oracle.svm.interpreter.InterpreterToVM;
import com.oracle.svm.interpreter.InterpreterUtil;
import com.oracle.svm.interpreter.classfile.ClassFile;
import com.oracle.svm.interpreter.metadata.BytecodeStream;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaField;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaType;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedObjectType;
import com.oracle.svm.interpreter.metadata.InterpreterUniverseImpl;
import com.oracle.svm.interpreter.metadata.MetadataUtil;
import com.oracle.svm.interpreter.metadata.ReferenceConstant;
import com.oracle.svm.interpreter.metadata.serialization.SerializationContext;
import com.oracle.svm.interpreter.metadata.serialization.Serializers;
import com.oracle.svm.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.Pointer;

@Platforms(value={Platform.HOSTED_ONLY.class})
@AutomaticallyRegisteredFeature
public class DebuggerFeature
implements InternalFeature {
    private Method enterInterpreterMethod;
    private InterpreterStubTable enterStubTable = null;
    private final List<Class<?>> classesUsedByInterpreter = new ArrayList();
    private Set<AnalysisMethod> methodsProcessedDuringAnalysis;
    private InvocationPlugins invocationPlugins;
    private static final String SYNTHETIC_ASSERTIONS_DISABLED_FIELD_NAME = "$assertionsDisabled";

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return InterpreterOptions.DebuggerWithInterpreter.getValue();
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(DeoptimizationFeature.class, InterpreterFeature.class, IdentityMethodAddressResolverFeature.class);
    }

    private static Class<?> getArgumentClass(GraphBuilderContext b, ResolvedJavaMethod targetMethod, int parameterIndex, ValueNode arg) {
        SubstrateGraphBuilderPlugins.checkParameterUsage(arg.isConstant(), b, targetMethod, parameterIndex, "parameter is not a compile time constant");
        return OriginalClassProvider.getJavaClass((JavaType)b.getConstantReflection().asJavaType((Constant)arg.asJavaConstant()));
    }

    @Override
    public void registerInvocationPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        this.invocationPlugins = plugins.getInvocationPlugins();
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(this.invocationPlugins, InterpreterDirectives.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("markKlass", new Type[]{Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1) {
                Class<?> targetKlass = DebuggerFeature.getArgumentClass(b, targetMethod, 1, arg1);
                InterpreterUtil.log("[invocation plugin] Adding %s", targetKlass);
                DebuggerFeature.this.classesUsedByInterpreter.add(targetKlass);
                return true;
            }
        });
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        this.enterStubTable = new InterpreterStubTable();
        VMError.guarantee(PLTGOTOptions.EnablePLTGOT.getValue());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl accessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        try {
            this.enterInterpreterMethod = InterpreterStubSection.class.getMethod("enterMethodInterpreterStub", Integer.TYPE, Pointer.class);
            accessImpl.registerAsRoot(this.enterInterpreterMethod, true, "stub for interpreter", new MultiMethod.MultiMethodKey[0]);
            access.registerAsAccessed(DebuggerSupport.class.getDeclaredField("referencesInImage"));
            access.registerAsAccessed(DebuggerSupport.class.getDeclaredField("methodPointersInImage"));
            accessImpl.registerAsRoot(System.class.getDeclaredMethod("arraycopy", Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE), true, "Allow interpreting methods that call System.arraycopy", new MultiMethod.MultiMethodKey[0]);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            throw VMError.shouldNotReachHere(e);
        }
        DebuggerFeature.registerStringConcatenation(accessImpl);
        try {
            access.registerAsAccessed(Integer.class.getField("TYPE"));
        }
        catch (NoSuchFieldException e) {
            throw VMError.shouldNotReachHere(e);
        }
        this.methodsProcessedDuringAnalysis = new HashSet<AnalysisMethod>();
        ImageSingletons.add(DebuggerSupport.class, (Object)new DebuggerSupport());
    }

    private static void registerStringConcatenation(FeatureImpl.BeforeAnalysisAccessImpl accessImpl) {
        try {
            List appendMethods = Arrays.stream(StringBuilder.class.getDeclaredMethods()).filter(m -> "append".equals(m.getName())).collect(Collectors.toList());
            for (Method m2 : appendMethods) {
                accessImpl.registerAsRoot(m2, false, "string concat in interpreter", new MultiMethod.MultiMethodKey[0]);
            }
            for (Constructor<?> c : StringBuilder.class.getDeclaredConstructors()) {
                accessImpl.registerAsRoot(c, true, "string concat in interpreter", new MultiMethod.MultiMethodKey[0]);
            }
            accessImpl.registerAsRoot(StringBuilder.class.getConstructor(new Class[0]), true, "string concat in interpreter", new MultiMethod.MultiMethodKey[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isReachable(AnalysisMethod m) {
        return m.isReachable() || m.isDirectRootMethod() || m.isVirtualRootMethod();
    }

    private static boolean isInvokeSpecial(AnalysisMethod method) {
        boolean invokeSpecial = method.isConstructor();
        if (!invokeSpecial) {
            invokeSpecial = Modifier.isPrivate(method.getModifiers());
        }
        return invokeSpecial;
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        FeatureImpl.DuringAnalysisAccessImpl accessImpl = (FeatureImpl.DuringAnalysisAccessImpl)access;
        AnalysisMetaAccess metaAccessProvider = accessImpl.getMetaAccess();
        boolean addedIndyHelper = false;
        for (AnalysisMethod analysisMethod : accessImpl.getUniverse().getMethods()) {
            if (DebuggerFeature.isReachable(analysisMethod) || !analysisMethod.getName().startsWith("invoke") || !analysisMethod.getDeclaringClass().getName().equals("Ljava/lang/invoke/MethodHandle;")) continue;
            accessImpl.registerAsRoot(analysisMethod, true, "method handle for interpreter", new MultiMethod.MultiMethodKey[0]);
            SubstrateCompilationDirectives.singleton().registerForcedCompilation((ResolvedJavaMethod)analysisMethod);
            InterpreterUtil.log("[during analysis] Force entry point for %s and mark as reachable", analysisMethod);
            addedIndyHelper = true;
        }
        if (addedIndyHelper) {
            access.requireAnalysisIteration();
            return;
        }
        if (!this.classesUsedByInterpreter.isEmpty()) {
            access.requireAnalysisIteration();
            for (Class clazz : this.classesUsedByInterpreter) {
                accessImpl.registerAsUsed(clazz);
                Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.getName().startsWith("test")).forEach(m -> {
                    AnalysisMethod aMethod = accessImpl.getMetaAccess().lookupJavaMethod((Executable)m);
                    VMError.guarantee(!aMethod.isConstructor());
                    accessImpl.registerAsRoot(aMethod, aMethod.isConstructor(), "reached due to interpreter directive", new MultiMethod.MultiMethodKey[0]);
                    InterpreterUtil.log("[during analysis] Adding method %s", m);
                });
            }
            this.classesUsedByInterpreter.clear();
            return;
        }
        DebuggerSupport supportImpl = DebuggerSupport.singleton();
        SnippetReflectionProvider snippetReflectionProvider = accessImpl.getUniverse().getSnippetReflection();
        for (AnalysisMethod method : accessImpl.getUniverse().getMethods()) {
            InvocationPlugin invocationPlugin;
            SubstitutionMethod subMethod;
            SubstrateCompilationDirectives.singleton().registerFrameInformationRequired(method);
            if (!method.isReachable() || this.methodsProcessedDuringAnalysis.contains(method)) continue;
            this.methodsProcessedDuringAnalysis.add(method);
            ResolvedJavaMethod resolvedJavaMethod = method.wrapped;
            if (resolvedJavaMethod instanceof SubstitutionMethod && (subMethod = (SubstitutionMethod)resolvedJavaMethod).isUserSubstitution() && subMethod.getOriginal().isNative()) {
                accessImpl.registerAsRoot(method, DebuggerFeature.isInvokeSpecial(method), "compiled entry point of substitution needed for interpreter", new MultiMethod.MultiMethodKey[0]);
                continue;
            }
            byte[] code = method.getCode();
            if (code == null || !InterpreterFeature.callableByInterpreter((ResolvedJavaMethod)method, (MetaAccessProvider)metaAccessProvider)) continue;
            AnalysisType declaringClass = method.getDeclaringClass();
            if (!declaringClass.isReachable() && !declaringClass.getName().toLowerCase(Locale.ROOT).contains("hosted")) {
                InterpreterUtil.log("[during analysis] declaring class %s of method %s is not reachable, force it as root", declaringClass, method);
                accessImpl.registerAsUsed(declaringClass, (Object)"interpreter needs dynamic hub at runtime for this class");
                access.requireAnalysisIteration();
            }
            if ((invocationPlugin = accessImpl.getBigBang().getProviders(method).getGraphBuilderPlugins().getInvocationPlugins().lookupInvocation((ResolvedJavaMethod)method, accessImpl.getBigBang().getOptions())) != null) continue;
            boolean analyzeCallees = true;
            int bci = 0;
            while (bci < BytecodeStream.endBCI(code)) {
                int bytecode = BytecodeStream.currentBC(code, bci);
                if (bytecode == 186) {
                    JavaConstant appendixConstant;
                    int targetMethodCPI = BytecodeStream.readCPI4(code, bci);
                    AnalysisMethod analysisMethod = DebuggerFeature.getAnalysisMethodAt(method.getConstantPool(), targetMethodCPI, bytecode);
                    if (analysisMethod != null) {
                        accessImpl.registerAsRoot(analysisMethod, false, "forced for indy support in interpreter", new MultiMethod.MultiMethodKey[0]);
                        InterpreterUtil.log("[during analysis] force %s mark as reachable", analysisMethod);
                    }
                    if ((appendixConstant = method.getConstantPool().lookupAppendix(targetMethodCPI, bytecode)) instanceof ImageHeapConstant) {
                        ImageHeapConstant imageHeapConstant = (ImageHeapConstant)appendixConstant;
                        supportImpl.ensureConstantIsInImageHeap(snippetReflectionProvider, imageHeapConstant);
                    }
                }
                if (analyzeCallees) {
                    switch (bytecode) {
                        case 182: 
                        case 183: 
                        case 184: 
                        case 185: {
                            char originalCPI = BytecodeStream.readCPI(code, bci);
                            try {
                                AnalysisMethod calleeMethod = DebuggerFeature.getAnalysisMethodAt(method.getConstantPool(), originalCPI, bytecode);
                                if (calleeMethod == null || !calleeMethod.isReachable() || InterpreterFeature.callableByInterpreter((ResolvedJavaMethod)calleeMethod, (MetaAccessProvider)metaAccessProvider)) break;
                                InterpreterUtil.log("[process invokes] cannot execute %s due to call-site (%s) @ bci=%s is not callable by interpreter%n", method.getName(), bci, calleeMethod);
                                if (method.getAnalyzedGraph() == null) {
                                    accessImpl.registerAsRoot(method, DebuggerFeature.isInvokeSpecial(method), "method handle for interpreter", new MultiMethod.MultiMethodKey[0]);
                                    accessImpl.registerAsUsed(method.getDeclaringClass().getJavaClass());
                                    access.requireAnalysisIteration();
                                }
                                if (method.reachableInCurrentLayer()) {
                                    SubstrateCompilationDirectives.singleton().registerForcedCompilation((ResolvedJavaMethod)method);
                                }
                                analyzeCallees = false;
                                break;
                            }
                            catch (UnsupportedFeatureException | UserError.UserException e) {
                                InterpreterUtil.log("[process invokes] lookup in method %s failed due to:", method);
                                InterpreterUtil.log(e);
                            }
                        }
                    }
                }
                bci = BytecodeStream.nextBCI(code, bci);
            }
        }
        supportImpl.trimForcedReferencesInImageHeap();
    }

    private static AnalysisMethod getAnalysisMethodAt(ConstantPool constantPool, int targetMethodCPI, int bytecode) {
        JavaMethod targetMethod = constantPool.lookupMethod(targetMethodCPI, bytecode);
        if (targetMethod instanceof UnresolvedJavaMethod) {
            constantPool.loadReferencedType(targetMethodCPI, bytecode);
            targetMethod = constantPool.lookupMethod(targetMethodCPI, bytecode);
        }
        if (targetMethod instanceof AnalysisMethod) {
            AnalysisMethod analysisMethod = (AnalysisMethod)targetMethod;
            return analysisMethod;
        }
        return null;
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        VMError.guarantee(InterpreterToVM.wordJavaKind() == JavaKind.Long || InterpreterToVM.wordJavaKind() == JavaKind.Int);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        FeatureImpl.BeforeCompilationAccessImpl accessImpl = (FeatureImpl.BeforeCompilationAccessImpl)access;
        HostedUniverse hUniverse = accessImpl.getUniverse();
        HostedMetaAccess hMetaAccess = accessImpl.getMetaAccess();
        MetaAccessProvider aMetaAccess = hMetaAccess.getWrapped();
        BuildTimeInterpreterUniverse iUniverse = BuildTimeInterpreterUniverse.singleton();
        for (HostedType hostedType : hUniverse.getTypes()) {
            AnalysisType analysisType = hostedType.getWrapped();
            if (!analysisType.isReachable()) continue;
            iUniverse.getOrCreateType((ResolvedJavaType)analysisType);
            for (ResolvedJavaField staticField : analysisType.getStaticFields()) {
                AnalysisField analysisStaticField;
                if (!(staticField instanceof AnalysisField) || (analysisStaticField = (AnalysisField)staticField).isWritten() || !staticField.isStatic() || !staticField.isSynthetic() || !staticField.getName().startsWith(SYNTHETIC_ASSERTIONS_DISABLED_FIELD_NAME)) continue;
                Class declaringClass = analysisType.getJavaClass();
                boolean value = !RuntimeAssertionsSupport.singleton().desiredAssertionStatus(declaringClass);
                InterpreterResolvedJavaField field = iUniverse.getOrCreateField(staticField);
                JavaConstant javaConstant = iUniverse.constant((JavaConstant)JavaConstant.forBoolean((boolean)value));
                BuildTimeInterpreterUniverse.setUnmaterializedConstantValue(field, javaConstant);
                field.markAsArtificiallyReachable();
            }
        }
        OptionValues invocationLookupOptions = new OptionValues((UnmodifiableEconomicMap)EconomicMap.create());
        for (HostedMethod hostedMethod : hUniverse.getMethods()) {
            SubstitutionMethod subMethod;
            ResolvedJavaMethod resolvedJavaMethod;
            boolean needsMethodBody;
            AnalysisMethod aMethod = hostedMethod.getWrapped();
            if (!DebuggerFeature.isReachable(aMethod)) continue;
            boolean bl = needsMethodBody = InterpreterFeature.executableByInterpreter(aMethod) && InterpreterFeature.callableByInterpreter(hostedMethod, (MetaAccessProvider)hMetaAccess);
            if (aMethod.getAnalyzedGraph() != null && ((resolvedJavaMethod = aMethod.wrapped) instanceof SubstitutionMethod && (subMethod = (SubstitutionMethod)resolvedJavaMethod).isUserSubstitution() || this.invocationPlugins.lookupInvocation((ResolvedJavaMethod)aMethod, invocationLookupOptions) != null)) {
                SubstrateCompilationDirectives.singleton().registerForcedCompilation(hostedMethod);
                needsMethodBody = false;
            }
            if (needsMethodBody) {
                BuildTimeInterpreterUniverse.singleton().getOrCreateMethodWithMethodBody((ResolvedJavaMethod)aMethod, aMetaAccess);
                continue;
            }
            BuildTimeInterpreterUniverse.singleton().getOrCreateMethod((ResolvedJavaMethod)aMethod);
        }
        for (HostedField hostedField : accessImpl.getUniverse().getFields()) {
            AnalysisField aField = hostedField.getWrapped();
            if (!aField.isReachable()) continue;
            BuildTimeInterpreterUniverse.singleton().getOrCreateField((ResolvedJavaField)aField);
        }
        iUniverse.purgeUnreachable((MetaAccessProvider)hMetaAccess);
        Field field = ReflectionUtil.lookupField(InterpreterResolvedObjectType.class, (String)"vtableHolder");
        for (HostedType hostedType : hUniverse.getTypes()) {
            iUniverse.mirrorSVMVTable(hostedType, objectType -> accessImpl.getHeapScanner().rescanField(objectType, vtableHolderField));
        }
        HostedMethod hostedMethod = hMetaAccess.lookupJavaMethod(InvalidMethodPointerHandler.METHOD_POINTER_NOT_COMPILED_HANDLER_METHOD);
        InterpreterMethodPointerHolder.setMethodNotCompiledHandler(new MethodPointer(hostedMethod));
        try {
            HostedMethod arraycopy = hMetaAccess.lookupJavaMethod(System.class.getDeclaredMethod("arraycopy", Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE));
            SubstrateCompilationDirectives.singleton().registerForcedCompilation(arraycopy);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        FeatureImpl.AfterCompilationAccessImpl accessImpl = (FeatureImpl.AfterCompilationAccessImpl)access;
        BuildTimeInterpreterUniverse.singleton().createConstantPools(accessImpl.getUniverse());
        int estOffset = 0;
        for (InterpreterResolvedJavaMethod interpreterResolvedJavaMethod : BuildTimeInterpreterUniverse.singleton().getMethods()) {
            ResolvedJavaMethod[] inlinedMethods;
            HostedMethod hostedMethod = accessImpl.getUniverse().optionalLookup((JavaMethod)interpreterResolvedJavaMethod.getOriginalMethod());
            CompileQueue.CompileTask compileTask = accessImpl.getCompilations().get(hostedMethod);
            ResolvedJavaMethod[] resolvedJavaMethodArray = inlinedMethods = compileTask == null ? null : compileTask.result.getMethods();
            if (inlinedMethods == null) {
                InterpreterUtil.log("[inlinedeps] Method %s doesn't have any inlinees", hostedMethod);
            } else if (interpreterResolvedJavaMethod.isInterpreterExecutable()) {
                InterpreterUtil.log("[inlinedeps] Inlined methods for %s: %s", hostedMethod, inlinedMethods.length);
                for (ResolvedJavaMethod inlinee : inlinedMethods) {
                    AnalysisMethod analysisMethod = ((HostedMethod)inlinee).getWrapped();
                    JavaMethod inlineeJavaMethod = BuildTimeInterpreterUniverse.singleton().methodOrUnresolved((JavaMethod)analysisMethod);
                    if (inlineeJavaMethod instanceof InterpreterResolvedJavaMethod) {
                        InterpreterResolvedJavaMethod inlineeInterpreterMethod = (InterpreterResolvedJavaMethod)inlineeJavaMethod;
                        if (inlineeInterpreterMethod.equals(interpreterResolvedJavaMethod)) {
                            InterpreterUtil.log("[inlinedeps] \t%s includes itself as an inlining dependency", interpreterResolvedJavaMethod);
                            continue;
                        }
                        inlineeInterpreterMethod.addInliner(interpreterResolvedJavaMethod);
                        InterpreterUtil.log("[inlinedeps] \t%s", inlinee);
                        continue;
                    }
                    InterpreterUtil.log("[inlinedeps] \tWarning: did not find interp method for %s", inlinee);
                }
            }
            if (!hostedMethod.isCompiled()) {
                InterpreterUtil.log("[got] after compilation: %s is not compiled, nulling it out", hostedMethod);
                interpreterResolvedJavaMethod.setVTableIndex(-1);
                interpreterResolvedJavaMethod.setNativeEntryPoint(null);
            } else {
                if (interpreterResolvedJavaMethod.hasBytecodes()) {
                    interpreterResolvedJavaMethod.setEnterStubOffset(estOffset++);
                }
                interpreterResolvedJavaMethod.setNativeEntryPoint(new MethodPointer(interpreterResolvedJavaMethod.getOriginalMethod()));
            }
            if (interpreterResolvedJavaMethod.isStatic() || interpreterResolvedJavaMethod.isConstructor()) continue;
            if (hostedMethod.getImplementations().length > 1) {
                if (!hostedMethod.hasVTableIndex()) {
                    InterpreterUtil.log("[vtable assignment] %s has multiple implementations but no vtable slot. This is not supported.%n", hostedMethod);
                    continue;
                }
                InterpreterUtil.log("[vtable assignment] Setting to Index %s for methods %s <> %s%n", hostedMethod.getVTableIndex(), interpreterResolvedJavaMethod, hostedMethod);
                interpreterResolvedJavaMethod.setVTableIndex(hostedMethod.getVTableIndex());
                continue;
            }
            if (hostedMethod.getImplementations().length == 1) {
                InterpreterUtil.log("[vtable assignment] Only one implementation available for %s%n", hostedMethod);
                interpreterResolvedJavaMethod.setVTableIndex(-2);
                InterpreterResolvedJavaMethod oneImpl = (InterpreterResolvedJavaMethod)BuildTimeInterpreterUniverse.singleton().methodOrUnresolved((JavaMethod)hostedMethod.getImplementations()[0]);
                interpreterResolvedJavaMethod.setOneImplementation(oneImpl);
                InterpreterUtil.log("[vtable assignment]  set oneImpl to -> %s%n", oneImpl);
                continue;
            }
            InterpreterUtil.log("[vtable assignment] No implementation available: %s%n", hostedMethod);
            interpreterResolvedJavaMethod.setVTableIndex(-1);
        }
        NativeImageHeap heap = accessImpl.getHeap();
        for (InterpreterResolvedJavaField field : BuildTimeInterpreterUniverse.singleton().getFields()) {
            HostedField hostedField = accessImpl.getUniverse().optionalLookup((JavaField)field.getOriginalField());
            if (!hostedField.isReachable()) {
                VMError.guarantee(field.isArtificiallyReachable());
                VMError.guarantee(field.isUnmaterializedConstant());
                VMError.guarantee(field.getUnmaterializedConstant() != null);
                continue;
            }
            if (hostedField.isUnmaterialized()) {
                AnalysisField analysisField = (AnalysisField)field.getOriginalField();
                if (hostedField.getType().isWordType() || analysisField.getJavaKind().isPrimitive()) {
                    JavaConstant constant = heap.hConstantReflection.readFieldValue(hostedField, null);
                    assert (constant instanceof PrimitiveConstant);
                    BuildTimeInterpreterUniverse.setUnmaterializedConstantValue(field, constant);
                } else if (analysisField.isRead() || analysisField.isFolded()) {
                    assert (analysisField.getJavaKind().isObject());
                    JavaConstant constantValue = heap.hConstantReflection.readFieldValue(hostedField, null);
                    BuildTimeInterpreterUniverse.setUnmaterializedConstantValue(field, constantValue);
                } else {
                    BuildTimeInterpreterUniverse.setUnmaterializedConstantValue(field, (JavaConstant)JavaConstant.forIllegal());
                }
                VMError.guarantee(field.isUnmaterializedConstant());
                continue;
            }
            if (!hostedField.hasLocation()) {
                InterpreterUtil.log("Found materialized field without location: %s", hostedField);
                BuildTimeInterpreterUniverse.setUnmaterializedConstantValue(field, (JavaConstant)JavaConstant.forIllegal());
                continue;
            }
            int fieldOffset = hostedField.getOffset();
            field.setOffset(fieldOffset);
        }
        DebuggerSupport debuggerSupport = DebuggerSupport.singleton();
        for (InterpreterResolvedJavaMethod method : BuildTimeInterpreterUniverse.singleton().getMethods()) {
            ReferenceConstant<FunctionPointerHolder> nativeEntryPointHolderConstant = method.getNativeEntryPointHolderConstant();
            if (nativeEntryPointHolderConstant == null) continue;
            debuggerSupport.ensureMethodPointerIsInImage(nativeEntryPointHolderConstant.getReferent());
        }
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess access) {
        FeatureImpl.AfterHeapLayoutAccessImpl accessImpl = (FeatureImpl.AfterHeapLayoutAccessImpl)access;
        NativeImageHeap heap = accessImpl.getHeap();
        for (InterpreterResolvedJavaField field : BuildTimeInterpreterUniverse.singleton().getFields()) {
            if (field.isArtificiallyReachable()) {
                JavaConstant value = field.getUnmaterializedConstant();
                VMError.guarantee(value != null && value != JavaConstant.ILLEGAL);
                continue;
            }
            HostedField hostedField = accessImpl.getMetaAccess().getUniverse().optionalLookup((JavaField)field.getOriginalField());
            if (!hostedField.isUnmaterialized()) continue;
            AnalysisField analysisField = (AnalysisField)field.getOriginalField();
            if (hostedField.getType().isWordType() || !analysisField.isFolded() || !analysisField.getJavaKind().isObject()) continue;
            JavaConstant constantValue = heap.hConstantReflection.readFieldValue(hostedField, null);
            BuildTimeInterpreterUniverse.setUnmaterializedConstantValue(field, constantValue);
        }
        GOTEntryAllocator gotEntryAllocator = HostedPLTGOTConfiguration.singleton().getGOTEntryAllocator();
        for (InterpreterResolvedJavaMethod interpreterMethod : BuildTimeInterpreterUniverse.singleton().getMethods()) {
            HostedMethod hostedMethod = accessImpl.getMetaAccess().getUniverse().optionalLookup((JavaMethod)interpreterMethod.getOriginalMethod());
            int gotOffset = -2;
            if (interpreterMethod.isInterpreterExecutable()) {
                gotOffset = gotEntryAllocator.queryGotEntry(hostedMethod);
            }
            if (gotOffset == -2) {
                InterpreterUtil.log("[got] Missing GOT offset for %s", interpreterMethod);
            } else {
                InterpreterUtil.log("[got] Got GOT offset=%s for %s", gotOffset, interpreterMethod);
            }
            interpreterMethod.setGOTOffset(gotOffset);
        }
    }

    @Override
    public void afterAbstractImageCreation(InternalFeature.AfterAbstractImageCreationAccess access) {
        FeatureImpl.AfterAbstractImageCreationAccessImpl accessImpl = (FeatureImpl.AfterAbstractImageCreationAccessImpl)access;
        List<InterpreterResolvedJavaMethod> includedMethods = BuildTimeInterpreterUniverse.singleton().getMethods().stream().filter(m -> m.getEnterStubOffset() != -5).collect(Collectors.toList());
        InterpreterStubSection stubSection = (InterpreterStubSection)ImageSingletons.lookup(InterpreterStubSection.class);
        stubSection.createInterpreterEnterStubSection(accessImpl.getImage(), includedMethods);
        this.enterStubTable.installAdditionalInfoIntoImageObjectFile(accessImpl.getImage(), includedMethods);
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess access) {
        int crc32;
        FeatureImpl.BeforeImageWriteAccessImpl accessImpl = (FeatureImpl.BeforeImageWriteAccessImpl)access;
        NativeImageHeap heap = accessImpl.getImage().getHeap();
        IdentityHashMap classToHub = new IdentityHashMap();
        for (NativeImageHeap.ObjectInfo info : heap.getObjects()) {
            Object object = info.getObject();
            if (!(object instanceof DynamicHub)) continue;
            DynamicHub hub = (DynamicHub)object;
            classToHub.put(hub.getHostedJavaClass(), hub);
        }
        DebuggerSupport supportImpl = DebuggerSupport.singleton();
        SerializationContext.Builder builder = supportImpl.getUniverseSerializerBuilder().registerWriter(true, ReferenceConstant.class, Serializers.newReferenceConstantWriter(ref -> {
            NativeImageHeap.ObjectInfo info = null;
            if (ref instanceof Class) {
                DynamicHub hub = (DynamicHub)classToHub.get(ref);
                info = heap.getObjectInfo(hub);
            } else if (ref instanceof ImageHeapConstant) {
                ImageHeapConstant imageHeapConstant = (ImageHeapConstant)ref;
                info = heap.getConstantInfo((JavaConstant)imageHeapConstant);
            } else {
                info = heap.getObjectInfo(ref);
            }
            if (info == null) {
                String purgedObject = Objects.toIdentityString(ref);
                InterpreterUtil.log("Constant not serialized in the image: %s", purgedObject);
                return 0L;
            }
            return info.getOffset();
        }));
        Path destDir = NativeImageGenerator.generatedFiles(HostedOptionValues.singleton());
        String metadataFileName = MetadataUtil.metadataFileName(accessImpl.getOutputFilename());
        Path metadataPath = destDir.resolve(metadataFileName);
        InterpreterUniverseImpl snapshot = BuildTimeInterpreterUniverse.singleton().snapshot();
        try {
            snapshot.saveTo(builder, metadataPath);
            crc32 = InterpreterUniverseImpl.computeCRC32(metadataPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.DEBUG_INFO, metadataPath);
        String hashString = "crc32:" + InterpreterUniverseImpl.toHexString(crc32);
        String dumpInterpreterClassFiles = InterpreterOptions.InterpreterDumpClassFiles.getValue();
        if (!dumpInterpreterClassFiles.isEmpty()) {
            try {
                DebuggerFeature.dumpInterpreterMetadataAsClassFiles(snapshot, dumpInterpreterClassFiles);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        InterpreterStubSection stubSection = (InterpreterStubSection)ImageSingletons.lookup(InterpreterStubSection.class);
        stubSection.markEnterStubPatch(accessImpl.getHostedMetaAccess().lookupJavaMethod(this.enterInterpreterMethod));
        this.enterStubTable.writeMetadataHashString(hashString.getBytes(StandardCharsets.UTF_8));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="path.getParent() is never null")
    private static void dumpInterpreterMetadataAsClassFiles(InterpreterUniverseImpl universe, String outputFolder) throws IOException {
        for (InterpreterResolvedJavaType type : universe.getTypes()) {
            if (type.isPrimitive() || type.isArray()) continue;
            String typeName = type.getName();
            String separator = FileSystems.getDefault().getSeparator();
            assert (typeName.startsWith("L") && typeName.endsWith(";"));
            String relativeFilePath = typeName.substring(1, typeName.length() - 1).replace("/", separator) + ".class";
            Path path = Path.of(outputFolder, relativeFilePath);
            if (!Files.exists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            byte[] bytes = ClassFile.dumpInterpreterTypeClassFile(universe, type);
            Files.write(path, bytes, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
    }
}

